/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.binding.config.ui.dialogs;

import com.ibm.ast.ws.binding.config.ui.dialogs.BindingConfigurationDialog;
import com.ibm.ast.ws.binding.config.ui.dialogs.PolicyTypesComposite;
import com.ibm.ast.ws.binding.config.ui.messages.Messages;
import com.ibm.ast.ws.binding.config.ui.plugin.Activator;
import com.ibm.ast.ws.jaxws.emitter.collector.ClientData;
import com.ibm.ast.ws.jaxws.emitter.collector.ServiceData;
import com.ibm.ast.ws.policyset.ui.common.CommonPolicyUtils;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class EditBindingConfigurationDialog
extends BindingConfigurationDialog {
    private UIUtils uiUtils = Activator.getUiUtils();
    private Combo bindingNameCombo;
    private PolicyTypesComposite policyTypesComposite;
    private IProject application;
    private Image titleImage;

    public EditBindingConfigurationDialog(Shell parentShell, Object initialSelection) {
        super(parentShell);
        if (initialSelection instanceof ServiceData) {
            this.application = ((ServiceData)initialSelection).getProject();
        } else if (initialSelection instanceof ClientData) {
            this.application = ((ClientData)initialSelection).getProject();
        } else {
            throw new IllegalArgumentException(Messages.ERROR_INITIAL_EXCEPTION);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.titleImage = Activator.imageDescriptorFromPlugin((String)"com.ibm.ast.ws.binding.config.ui", (String)"icons/banners/binding_wiz.gif").createImage();
        this.setTitle(Messages.EDIT_BINDING_DIALOG_TITLE);
        this.setTitleImage(this.titleImage);
        this.setMessage(Messages.EDIT_BINDING_DIALOG_MSG);
        Composite dialog = (Composite)super.createDialogArea(parent);
        dialog.setLayoutData((Object)new GridData(1808));
        Composite bgComp = this.uiUtils.createComposite(dialog, 1, 0, 0);
        bgComp.setLayoutData((Object)new GridData(1808));
        Composite comp1 = this.uiUtils.createComposite(bgComp, 2, 10, 10);
        this.bindingNameCombo = this.uiUtils.createCombo(comp1, Messages.BINDING_NAME_LABEL, Messages.EDIT_BINDING_NAME_TOOLTIP, null, 12);
        this.policyTypesComposite = new PolicyTypesComposite(bgComp, 0);
        this.policyTypesComposite.setLayout((Layout)new GridLayout(1, false));
        this.policyTypesComposite.setLayoutData(new GridData(1808));
        this.initBindingCombo();
        return parent;
    }

    private IFolder getPolicyTypesFolder() {
        return CommonPolicyUtils.getOutputFolder((IProject)this.application, (boolean)true).getFolder(this.bindingNameCombo.getText().trim()).getFolder("PolicyTypes");
    }

    private void updatePolicyTable() {
        ArrayList<String> policyTypes = new ArrayList<String>(6);
        IFolder policyTypesFolder = this.getPolicyTypesFolder();
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = policyTypesFolder.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                if (r.getType() == 2) {
                    policyTypes.add(r.getFullPath().lastSegment());
                }
                ++n2;
            }
            if (policyTypes.size() == 0) {
                this.setErrorMessage(Messages.bind((String)Messages.NOTHING_TO_CONFIGURE_ERROR, (Object)policyTypesFolder.getFullPath()));
            } else {
                this.setErrorMessage(null);
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "com.ibm.ast.ws.binding.config.ui", e.getLocalizedMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        this.policyTypesComposite.updatePolicyTable(policyTypes);
    }

    private void initBindingCombo() {
        String[] bindings = CommonPolicyUtils.getApplicationBindings((IProject)CommonPolicyUtils.getContaingEarProject((IProject)this.application));
        if (bindings.length == 0) {
            this.setErrorMessage(Messages.NO_BINDINGS_CONFIGURED_ERROR);
            return;
        }
        this.bindingNameCombo.setItems(bindings);
        this.bindingNameCombo.select(0);
        this.updatePolicyTable();
        this.bindingNameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                EditBindingConfigurationDialog.this.updatePolicyTable();
            }
        });
    }

    protected void okPressed() {
        TableItem[] policyTypeTableItems;
        IFolder policyTypesFolder = this.getPolicyTypesFolder();
        TableItem[] tableItemArray = policyTypeTableItems = this.policyTypesComposite.getTable().getItems();
        int n = policyTypeTableItems.length;
        int n2 = 0;
        while (n2 < n) {
            String policyType;
            IFile bindingFile;
            TableItem s = tableItemArray[n2];
            if (s.getChecked() && (bindingFile = policyTypesFolder.getFolder(policyType = s.getText()).getFile("bindings.xml")).exists()) {
                this.openEditor(bindingFile);
            }
            ++n2;
        }
        super.okPressed();
    }

    public boolean close() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
        }
        return super.close();
    }
}

