/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.binding.config.ui.dialogs;

import com.ibm.ast.ws.binding.config.ui.messages.Messages;
import com.ibm.ast.ws.binding.config.ui.plugin.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public abstract class BindingConfigurationDialog
extends TitleAreaDialog {
    protected static final String BINDING_FILENAME = "bindings.xml";
    protected static final String BINDING_DEFINITION_FILENAME = "bindingDefinition.xml";
    protected static final String POLICY_TYPES_FOLDER = "PolicyTypes";

    public BindingConfigurationDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(0x10870 | BindingConfigurationDialog.getDefaultOrientation());
        this.setHelpAvailable(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CONFIGURE_BINDINGS_TITLE);
    }

    protected void openEditor(final IFile bindingFile) {
        if (bindingFile != null && bindingFile.exists()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbench workbench = PlatformUI.getWorkbench();
                        IEditorDescriptor desc = workbench.getEditorRegistry().getDefaultEditor(bindingFile.getName(), bindingFile.getContentDescription().getContentType());
                        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
                        workbenchWindow.getActivePage().openEditor((IEditorInput)new FileEditorInput(bindingFile), desc.getId());
                    }
                    catch (Exception e) {
                        Status status = new Status(4, "com.ibm.ast.ws.binding.config.ui", Messages.ERROR_OPENING_EDITOR, (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)status);
                    }
                }
            });
        }
    }
}

