/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.binding.config.ui.dialogs;

import com.ibm.ast.ws.binding.config.ui.dialogs.BindingConfigurationDialog;
import com.ibm.ast.ws.binding.config.ui.dialogs.DelayedModifyListener;
import com.ibm.ast.ws.binding.config.ui.dialogs.EventTimer;
import com.ibm.ast.ws.binding.config.ui.dialogs.PolicyTypesComposite;
import com.ibm.ast.ws.binding.config.ui.messages.Messages;
import com.ibm.ast.ws.binding.config.ui.plugin.Activator;
import com.ibm.ast.ws.binding.config.ui.templates.BindinConfigurationTemplate;
import com.ibm.ast.ws.binding.config.ui.templates.BindingConfigurationTemplateRegistry;
import com.ibm.ast.ws.jaxws.emitter.collector.ClientData;
import com.ibm.ast.ws.jaxws.emitter.collector.ServiceData;
import com.ibm.ast.ws.policyset.ui.common.CommonPolicyUtils;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class AddBindingConfigurationDialog
extends BindingConfigurationDialog {
    private UIUtils uiUtils;
    private BindingConfigurationTemplateRegistry registry;
    private IProject project;
    private Text bindingNameTextField;
    private Combo templateCombo;
    private PolicyTypesComposite policyTypesComposite;
    private Image titleImage;

    public AddBindingConfigurationDialog(Shell parentShell, Object initialSelection) {
        super(parentShell);
        if (!(initialSelection instanceof ServiceData) && !(initialSelection instanceof ClientData)) {
            throw new IllegalArgumentException(Messages.ERROR_INITIAL_EXCEPTION);
        }
        this.uiUtils = Activator.getUiUtils();
        if (initialSelection instanceof ServiceData) {
            this.project = ((ServiceData)initialSelection).getProject();
            this.registry = new BindingConfigurationTemplateRegistry("provider");
        } else {
            this.project = ((ClientData)initialSelection).getProject();
            this.registry = new BindingConfigurationTemplateRegistry("client");
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.titleImage = Activator.imageDescriptorFromPlugin((String)"com.ibm.ast.ws.binding.config.ui", (String)"icons/banners/binding_wiz.gif").createImage();
        this.setTitle(Messages.ADD_BINDING_CONFIG_DIALOG_TITLE);
        this.setTitleImage(this.titleImage);
        this.setMessage(Messages.ADD_BINDING_CONFIG_DIALOG_MSG);
        Composite dialog = (Composite)super.createDialogArea(parent);
        dialog.setLayoutData((Object)new GridData(1808));
        Composite bgComp = this.uiUtils.createComposite(dialog, 1, 0, 0);
        bgComp.setLayoutData((Object)new GridData(1808));
        Composite comp1 = this.uiUtils.createComposite(bgComp, 2);
        comp1.setLayoutData((Object)new GridData(768));
        this.bindingNameTextField = this.uiUtils.createText(comp1, Messages.BINDING_NAME_LABEL, Messages.ADD_BINDING_NAME_TOOLTIP, null, 2052);
        this.templateCombo = this.uiUtils.createCombo(comp1, Messages.TEMPLATE_LABEL, Messages.ADD_BINDING_TEMPLATE_TOOLTIP, null, 12);
        String defaultName = "Binding";
        IFolder outputFolder = CommonPolicyUtils.getOutputFolder((IProject)this.project, (boolean)false);
        int i = 1;
        while (i < 100) {
            IFolder bindingsFolder;
            defaultName = "Binding" + i;
            if (outputFolder == null || !outputFolder.exists() || (bindingsFolder = outputFolder.getFolder(defaultName)) == null || !bindingsFolder.exists()) break;
            ++i;
        }
        this.bindingNameTextField.setText(defaultName);
        this.bindingNameTextField.selectAll();
        this.policyTypesComposite = new PolicyTypesComposite(bgComp, 0);
        this.policyTypesComposite.setLayout((Layout)new GridLayout(1, false));
        this.policyTypesComposite.setLayoutData(new GridData(1808));
        this.initTemplateCombo();
        this.templateCombo.setText(Messages.SKELETON_BINDING_CONFIG_NAME);
        EventTimer timer = EventTimer.acquireTimer();
        DelayedModifyListener modifyListener = new DelayedModifyListener(timer, new Runnable(){

            @Override
            public void run() {
                AddBindingConfigurationDialog.this.checkBindingField();
                AddBindingConfigurationDialog.this.updatePolicyTypesChecked();
            }
        });
        this.bindingNameTextField.addModifyListener((ModifyListener)modifyListener);
        this.policyTypesComposite.getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AddBindingConfigurationDialog.this.checkPolicyTable();
            }
        });
        return parent;
    }

    private void setWarningMessage(String message) {
        if (message != null) {
            this.setMessage(message, 2);
        } else {
            this.setMessage(Messages.ADD_BINDING_CONFIG_DIALOG_MSG);
        }
    }

    private void checkPolicyTable() {
        IFolder outputFolder = CommonPolicyUtils.getOutputFolder((IProject)this.project, (boolean)false);
        if (outputFolder == null || !outputFolder.exists()) {
            return;
        }
        IFolder bindingsFolder = outputFolder.getFolder(this.bindingNameTextField.getText().trim());
        if (bindingsFolder == null || !bindingsFolder.exists()) {
            return;
        }
        IFolder policyTypesFolder = bindingsFolder.getFolder("PolicyTypes");
        this.setWarningMessage(null);
        if (policyTypesFolder.exists()) {
            TableItem[] tableItems = this.policyTypesComposite.getTable().getItems();
            ArrayList<String> l = new ArrayList<String>(10);
            TableItem[] tableItemArray = tableItems;
            int n = tableItems.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem ti = tableItemArray[n2];
                if (ti.getChecked() && policyTypesFolder.getFolder(ti.getText()).exists()) {
                    l.add(ti.getText());
                }
                ++n2;
            }
            if (l.size() > 0) {
                StringBuilder sb = new StringBuilder();
                Iterator iter = l.iterator();
                while (iter.hasNext()) {
                    String policyType = (String)iter.next();
                    sb.append(policyType);
                    if (!iter.hasNext()) continue;
                    sb.append(", ");
                }
                this.setWarningMessage(Messages.bind((String)Messages.OVERWRITE_BINDINGS_WARNING, (Object)sb.toString()));
            }
        }
    }

    private void checkBindingField() {
        if (this.bindingNameTextField == null || this.bindingNameTextField.getText().trim().equals("")) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(Messages.ENTER_BINDING_NAME);
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
        }
    }

    private void updatePolicyTypesChecked() {
        TableItem[] tableItems = this.policyTypesComposite.getTable().getItems();
        IFolder outputFolder = CommonPolicyUtils.getOutputFolder((IProject)this.project, (boolean)false);
        if (outputFolder == null || !outputFolder.exists()) {
            return;
        }
        IFolder bindingsFolder = outputFolder.getFolder(this.bindingNameTextField.getText().trim());
        if (bindingsFolder == null || !bindingsFolder.exists()) {
            return;
        }
        IFolder policyTypesFolder = bindingsFolder.getFolder("PolicyTypes");
        TableItem[] tableItemArray = tableItems;
        int n = tableItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            if (policyTypesFolder.getFolder(ti.getText()).exists()) {
                ti.setChecked(false);
            }
            ++n2;
        }
        this.checkPolicyTable();
    }

    private void initTemplateCombo() {
        for (String t : this.registry.getTemplates().keySet()) {
            this.templateCombo.add(t);
        }
        this.templateCombo.select(0);
        this.updatePolicyTable();
        this.templateCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                AddBindingConfigurationDialog.this.updatePolicyTable();
            }
        });
    }

    private void updatePolicyTable() {
        String sourceURL = null;
        BindinConfigurationTemplate template = this.registry.getTemplates().get(this.templateCombo.getText());
        this.templateCombo.setToolTipText(template.getDescription());
        sourceURL = template.getBindingURL();
        sourceURL = String.valueOf(sourceURL) + File.separator + "PolicyTypes";
        File policyTypesDir = new File(sourceURL);
        if (policyTypesDir.exists()) {
            List<String> policyTypes = Arrays.asList(policyTypesDir.list());
            this.policyTypesComposite.updatePolicyTable(policyTypes);
            this.updatePolicyTypesChecked();
        }
    }

    private IFile copyFile(IFolder policyTypesFolder, String policyName, File sourceFile) {
        URI destinationURI = null;
        try {
            IFolder destinationFolder = policyTypesFolder.getFolder(policyName);
            if (!destinationFolder.exists()) {
                destinationFolder = CommonPolicyUtils.createIFolder((IContainer)policyTypesFolder, (String)policyName);
            }
            destinationURI = destinationFolder.getFile("bindings.xml").getLocationURI();
            CommonPolicyUtils.copy((File)sourceFile, (File)new File(destinationURI));
            destinationFolder.refreshLocal(1, null);
            return destinationFolder.getFile("bindings.xml");
        }
        catch (Exception e) {
            Status status = new Status(4, "com.ibm.ast.ws.binding.config.ui", Messages.bind((String)Messages.ERROR_COPYING, (Object)sourceFile.getPath(), destinationURI), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }

    protected void okPressed() {
        TableItem[] policyTypeTableItems;
        String sourceURL = this.registry.getTemplates().get(this.templateCombo.getText()).getBindingURL();
        IFolder destinationFolder = CommonPolicyUtils.getOutputFolder((IProject)this.project, (boolean)true).getFolder(this.bindingNameTextField.getText().trim());
        IFolder policyTypesFolder = null;
        try {
            if (!destinationFolder.exists()) {
                destinationFolder.create(true, true, null);
            }
            if (!(policyTypesFolder = destinationFolder.getFolder("PolicyTypes")).exists()) {
                policyTypesFolder.create(true, true, null);
            }
        }
        catch (CoreException e) {
            Status status = new Status(4, "com.ibm.ast.ws.binding.config.ui", null, (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        File sourceFile = null;
        File destinationFile = null;
        try {
            sourceFile = new File(String.valueOf(sourceURL) + File.separator + "bindingDefinition.xml");
            destinationFile = new File(destinationFolder.getFile("bindingDefinition.xml").getLocation().toOSString());
            CommonPolicyUtils.copy((File)sourceFile, (File)destinationFile);
            destinationFolder.refreshLocal(1, null);
        }
        catch (Exception e) {
            Status status = new Status(4, "com.ibm.ast.ws.binding.config.ui", Messages.bind((String)Messages.ERROR_COPYING, (Object)sourceFile.getPath(), (Object)destinationFile.getPath()), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        TableItem[] tableItemArray = policyTypeTableItems = this.policyTypesComposite.getTable().getItems();
        int n = policyTypeTableItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem s = tableItemArray[n2];
            if (s.getChecked()) {
                String policyType = s.getText();
                IFile bindingFile = this.copyFile(policyTypesFolder, policyType, new File(String.valueOf(sourceURL) + File.separator + "PolicyTypes" + File.separator + policyType + File.separator + "bindings.xml"));
                this.openEditor(bindingFile);
            }
            ++n2;
        }
        super.okPressed();
    }

    public boolean close() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
        }
        EventTimer.releaseTimer();
        return super.close();
    }
}

