/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.pli.spi.properties;

import com.ibm.adapter.pli.PliMessageResource;
import com.ibm.adapter.pli.spi.properties.PliBaseProperty;
import com.ibm.adapter.pli.spi.properties.PliPlatformProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.PropertyVetoException;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PliCodepageProperty
extends PliBaseProperty {
    public PliCodepageProperty() throws CoreException {
        super(PliMessageResource.CODEPAGE_PROP_NAME, PliMessageResource.CODEPAGE_PROP_DISPLAY_NAME, PliMessageResource.CODEPAGE_PROP_DESC);
        this.initializeProperty();
    }

    private Object[] findCodePages() {
        SortedMap<String, Charset> csMap = Charset.availableCharsets();
        Set<String> keySet = csMap.keySet();
        TreeSet<String> allCodepages = new TreeSet<String>();
        allCodepages.addAll(keySet);
        for (String canonicalCP : keySet) {
            Charset aCs = Charset.forName(canonicalCP);
            Set<String> aliasSet = aCs.aliases();
            if (aliasSet.isEmpty()) continue;
            for (String aliasCP : aliasSet) {
                allCodepages.add(aliasCP);
            }
        }
        return allCodepages.toArray(new String[allCodepages.size()]);
    }

    private void initializeProperty() throws CoreException {
        try {
            Object[] validValuesArray = (String[])this.findCodePages();
            this.pliKey = "com.ibm.ccl.pli.PLI_CODEPAGE";
            if (validValuesArray != null) {
                super.setValidValues(validValuesArray);
            }
            this.setDefaultValue("ISO-8859-1");
            this.setValue("ISO-8859-1");
        }
        catch (CoreException ex) {
            this.envStatus = new Status(4, "com.ibm.adapter.pli", 4, ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof PliPlatformProperty) {
            if (((String)evt.getNewValue()).equalsIgnoreCase("z/OS")) {
                try {
                    this.setValue("IBM-037");
                    this.setDefaultValue("IBM-037");
                }
                catch (CoreException e) {
                    this.envStatus = new Status(4, "com.ibm.adapter.pli", 4, e.getMessage(), (Throwable)e);
                }
            } else if (((String)evt.getNewValue()).equalsIgnoreCase("Win32")) {
                try {
                    this.setValue("ISO-8859-1");
                    this.setDefaultValue("ISO-8859-1");
                }
                catch (CoreException e) {
                    this.envStatus = new Status(4, "com.ibm.adapter.pli", 4, e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    public void setValidValues(Object[] values) throws CoreException {
        Status status = new Status(4, ((Object)((Object)this)).getClass().getName(), 4, PliMessageResource.ERROR_METHOD_NOT_IMPLEMENTED, (Throwable)new Exception(PliMessageResource.ERROR_METHOD_NOT_IMPLEMENTED));
        throw new CoreException((IStatus)status);
    }
}

