/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.pli;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IDiscoveryAgent;
import com.ibm.adapter.framework.IDiscoveryAgentMetaData;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IImportResult;
import com.ibm.adapter.framework.IResultNodeSelection;
import com.ibm.adapter.framework.ISearchTree;
import com.ibm.adapter.framework.spi.BaseDiscoveryAgent;
import com.ibm.adapter.pli.MPOPliDiscoveryAgentMetaData;
import com.ibm.adapter.pli.MPOPliImportResult;
import com.ibm.adapter.pli.PliDiscoveryAgent;
import com.ibm.adapter.pli.PliImportResult;
import com.ibm.adapter.pli.PliMessageResource;
import com.ibm.adapter.pli.spi.properties.PliFileProperty;
import com.ibm.ccl.pli.PLIElement;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;

public class MPOPliDiscoveryAgent
extends BaseDiscoveryAgent {
    private URI filePathURI;
    private File filePath;
    private MPOPliImportResult importResult;
    private PliDiscoveryAgent discoveryAgent;
    private boolean isJava = false;
    private boolean isInitialized = false;
    private static String[] fileExt = new String[]{"pli", "inc", "mac"};

    public IDiscoveryAgent newInstance() {
        return new MPOPliDiscoveryAgent();
    }

    public MPOPliDiscoveryAgent() {
        this.setMetaData((IDiscoveryAgentMetaData)new MPOPliDiscoveryAgentMetaData());
    }

    public String[] getConfiguration() {
        return new String[]{"SUPPORTS_ITERATION"};
    }

    public void initializeContext(Object[] context) throws BaseException {
        this.importResult = (MPOPliImportResult)((Object)context[0]);
    }

    public IPropertyGroup getInitializeProperties() throws BaseException {
        if (this.discoveryAgent == null) {
            this.discoveryAgent = new PliDiscoveryAgent();
        }
        if (this.initializeProperties == null) {
            try {
                BasePropertyGroup propertyGroup = new BasePropertyGroup(PliMessageResource.PLI_FILE_PROP_GROUP_NAME, PliMessageResource.PLI_FILE_PROP_GROUP_DISPLAY_NAME, PliMessageResource.PLI_FILE_PROP_GROUP_DESC);
                PliFileProperty fileProperty = new PliFileProperty(PliMessageResource.PLI_FILE_PROP_NAME, PliMessageResource.MPO_FILE_PROP_DISPLAY_NAME, PliMessageResource.MPO_FILE_PROP_DESC, propertyGroup, fileExt);
                fileProperty.setRequired(true);
                this.initializeProperties = propertyGroup;
            }
            catch (CoreException e) {
                throw new BaseException(e.getStatus());
            }
        }
        this.discoveryAgent.setInitializeProperties(this.initializeProperties);
        this.isInitialized = true;
        return this.discoveryAgent.getInitializeProperties();
    }

    public void initialize(IEnvironment environment, IPropertyGroup initializeProperties) throws BaseException {
        if (!this.isInitialized) {
            this.throwException();
        }
        PliFileProperty fileProperty = (PliFileProperty)initializeProperties.getProperty(PliMessageResource.PLI_FILE_PROP_NAME);
        this.filePathURI = (URI)fileProperty.getValue();
        if (this.filePathURI.toString().toLowerCase().endsWith(".java")) {
            if (this.filePathURI.toString().endsWith(".java")) {
                this.filePath = new File(this.filePathURI.toFileString());
                if (!this.filePath.exists()) {
                    String message = NLS.bind((String)PliMessageResource.FILE_NOT_FOUND, (Object[])new String[]{this.filePathURI.toString()});
                    Status newStatus = new Status(4, "com.ibm.adapter.pli", 4, message, null);
                    throw new BaseException((IStatus)newStatus);
                }
            }
            this.isJava = true;
        } else {
            this.isJava = false;
        }
        this.discoveryAgent.initialize(environment, initializeProperties);
    }

    public void initialize(IEnvironment environment, IPropertyGroup initializeProperties, IImportResult previousResult) throws BaseException {
        if (!this.isInitialized) {
            this.throwException();
        }
        this.importResult = (MPOPliImportResult)previousResult;
        PliFileProperty fileProperty = (PliFileProperty)initializeProperties.getProperty(PliMessageResource.PLI_FILE_PROP_NAME);
        this.filePathURI = (URI)fileProperty.getValue();
        if (this.filePathURI.toString().toLowerCase().endsWith(".java")) {
            if (this.filePathURI.toString().endsWith(".java")) {
                this.filePath = new File(this.filePathURI.toFileString());
                if (!this.filePath.exists()) {
                    String message = NLS.bind((String)PliMessageResource.FILE_NOT_FOUND, (Object[])new String[]{this.filePathURI.toString()});
                    Status newStatus = new Status(4, "com.ibm.adapter.pli", 4, message, null);
                    throw new BaseException((IStatus)newStatus);
                }
            }
            this.isJava = true;
        } else {
            this.isJava = false;
        }
        this.discoveryAgent.initialize(environment, initializeProperties);
    }

    public ISearchTree getSearchTree() throws BaseException {
        if (!this.isInitialized) {
            this.throwException();
        }
        return this.discoveryAgent.getSearchTree();
    }

    public IImportResult performImport(IEnvironment environment, IResultNodeSelection selectedNodes) throws BaseException {
        PliImportResult result;
        if (!this.isInitialized) {
            this.throwException();
        }
        if (this.isJava) {
            result = new PliImportResult(this.filePathURI);
            result.setImportFile(this.filePath);
        } else {
            result = (PliImportResult)this.discoveryAgent.performImport(environment, selectedNodes);
        }
        if (this.importResult == null) {
            this.importResult = new MPOPliImportResult();
        }
        this.checkIfImported(result);
        this.importResult.setImportData((Object)result);
        return this.importResult;
    }

    public void close() throws BaseException {
        this.discoveryAgent = null;
        this.isInitialized = false;
    }

    private void throwException() throws BaseException {
        Status newStatus = new Status(4, "com.ibm.adapter.pli", 4, PliMessageResource.INITIALIZATION_REQUIRED, null);
        throw new BaseException((IStatus)newStatus);
    }

    private void checkIfImported(PliImportResult newResult) throws BaseException {
        Object newImportData = newResult.getImportData();
        ArrayList resultList = (ArrayList)this.importResult.getImportData();
        int i = 0;
        while (i < resultList.size()) {
            File newFile;
            boolean theSameImportFile = false;
            boolean theSameSelectedElement = false;
            PliImportResult oldResult = (PliImportResult)((Object)resultList.get(i));
            File oldFile = oldResult.getImportFile();
            if (oldFile.compareTo(newFile = newResult.getImportFile()) == 0) {
                theSameImportFile = true;
            }
            Object oldImportData = oldResult.getImportData();
            if (newImportData instanceof URI && oldImportData instanceof URI) {
                if (theSameImportFile) {
                    String message = NLS.bind((String)PliMessageResource.RESOURCE_ALREADY_IMPORTED, (Object[])new String[]{oldFile.getName()});
                    Status newStatus = new Status(4, "com.ibm.adapter.pli", 4, message, null);
                    throw new BaseException((IStatus)newStatus);
                }
            } else if (newImportData instanceof PLIElement && oldImportData instanceof PLIElement) {
                String newElementName;
                String oldElementName = ((PLIElement)oldImportData).getName();
                if (oldElementName.equals(newElementName = ((PLIElement)newImportData).getName())) {
                    theSameSelectedElement = true;
                }
                if (theSameImportFile && theSameSelectedElement) {
                    String message = NLS.bind((String)PliMessageResource.TYPE_ALREADY_IMPORTED, (Object[])new String[]{oldElementName});
                    Status newStatus = new Status(4, "com.ibm.adapter.pli", 4, message, null);
                    throw new BaseException((IStatus)newStatus);
                }
            }
            ++i;
        }
    }
}

