/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2ca.spi.util;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.j2ca.internal.LogFacility;
import com.ibm.adapter.j2ca.internal.MessageResource;
import com.ibm.ws.ast.st.core.WASRuntimeLocator;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.j2ee.componentcore.util.EARVirtualComponent;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.facet.UtilityFacetInstallDataModelProvider;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.project.facet.ProductManager;
import org.eclipse.wst.server.core.IRuntime;

public class ProjectUtils {
    public static void addProjectToClassPath(IJavaProject javaProject, IProject aProject, IEnvironment environment) throws BaseException {
        ProjectUtils.addProjectToClassPath(javaProject, aProject, environment, false);
    }

    public static void addProjectToClassPath(IJavaProject javaProject, IProject aProject, IEnvironment environment, boolean isExported) throws BaseException {
        try {
            if (!javaProject.getProject().equals((Object)aProject) && !javaProject.isOnClasspath((IResource)aProject)) {
                IClasspathEntry[] classPath = javaProject.getRawClasspath();
                IClasspathEntry entry = JavaCore.newProjectEntry((IPath)aProject.getFullPath(), (boolean)isExported);
                IClasspathEntry[] newClasspath = new IClasspathEntry[classPath.length + 1];
                System.arraycopy(classPath, 0, newClasspath, 0, classPath.length);
                newClasspath[classPath.length] = entry;
                javaProject.setRawClasspath(newClasspath, null);
                IJavaProject tempJavaProject = JavaCore.create((IProject)aProject);
                if (tempJavaProject.exists()) {
                    classPath = tempJavaProject.getRawClasspath();
                    int i = 0;
                    while (i < classPath.length) {
                        if (classPath[i].getEntryKind() == 2) {
                            IClasspathEntry resolvedEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)classPath[i]);
                            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                            IProject tempProject = workspaceRoot.getProject(resolvedEntry.getPath().lastSegment());
                            if (tempProject.exists()) {
                                ProjectUtils.addProjectToClassPath(javaProject, tempProject, environment);
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        catch (JavaModelException exc) {
            String message = NLS.bind((String)MessageResource.ERR_ADDING_PROJECT_TO_CP, (Object)aProject.getName(), (Object)javaProject.getProject().getName());
            Status status = new Status(4, "com.ibm.adapter.j2ca", 4, message, (Throwable)exc);
            LogFacility.logErrorMessage((IStatus)status);
            throw new BaseException((IStatus)status);
        }
    }

    public static void addContainerToClassPath(IJavaProject javaProject, String containerPath, IEnvironment environment) throws BaseException {
        try {
            IClasspathEntry[] classPath = javaProject.getRawClasspath();
            IClasspathEntry entry = JavaCore.newContainerEntry((IPath)new Path(containerPath));
            boolean alreadyExists = false;
            int i = 0;
            while (i < classPath.length) {
                if (classPath[i].getEntryKind() == entry.getEntryKind() && classPath[i].getPath().equals((Object)entry.getPath())) {
                    alreadyExists = true;
                }
                ++i;
            }
            if (!alreadyExists) {
                IClasspathEntry[] newClasspath = new IClasspathEntry[classPath.length + 1];
                System.arraycopy(classPath, 0, newClasspath, 0, classPath.length);
                newClasspath[classPath.length] = entry;
                javaProject.setRawClasspath(newClasspath, null);
            }
        }
        catch (JavaModelException exc) {
            String message = NLS.bind((String)MessageResource.ERR_ADDING_PROJECT_TO_CP, (Object)containerPath, (Object)javaProject.getProject().getName());
            Status status = new Status(4, "com.ibm.adapter.j2ca", 4, message, (Throwable)exc);
            LogFacility.logErrorMessage((IStatus)status);
            throw new BaseException((IStatus)status);
        }
    }

    public static boolean addClasspathEntriesToClassPath(IJavaProject javaProject, List<IClasspathEntry> entries, IEnvironment environment) throws BaseException {
        try {
            IClasspathEntry[] classPath = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> entriesToAdd = new ArrayList<IClasspathEntry>();
            for (IClasspathEntry entry : entries) {
                boolean found = false;
                int i = 0;
                while (i < classPath.length) {
                    if (classPath[i].getEntryKind() == entry.getEntryKind() && classPath[i].getPath().equals((Object)entry.getPath())) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (found) continue;
                entriesToAdd.add(entry);
            }
            if (!entriesToAdd.isEmpty()) {
                int entrySize = entriesToAdd.size();
                IClasspathEntry[] newClasspath = new IClasspathEntry[classPath.length + entrySize];
                System.arraycopy(classPath, 0, newClasspath, 0, classPath.length);
                int i = 0;
                while (i < entrySize) {
                    newClasspath[i + classPath.length] = (IClasspathEntry)entriesToAdd.get(i);
                    ++i;
                }
                javaProject.setRawClasspath(newClasspath, null);
            }
            return !entriesToAdd.isEmpty();
        }
        catch (JavaModelException exc) {
            String message = NLS.bind((String)MessageResource.ERR_ADDING_PROJECT_TO_CP, (Object)entries.toString(), (Object)javaProject.getProject().getName());
            Status status = new Status(4, "com.ibm.adapter.j2ca", 4, message, (Throwable)exc);
            LogFacility.logErrorMessage((IStatus)status);
            throw new BaseException((IStatus)status);
        }
    }

    public static boolean removeClasspathEntriesFromClassPath(IJavaProject javaProject, List<IClasspathEntry> entries) throws BaseException {
        try {
            IClasspathEntry[] classPath = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> entriesToRemain = new ArrayList<IClasspathEntry>(Arrays.asList(classPath));
            block2: for (IClasspathEntry entry : entries) {
                int i = 0;
                while (i < classPath.length) {
                    if (classPath[i].getEntryKind() == entry.getEntryKind() && classPath[i].getPath().equals((Object)entry.getPath())) {
                        entriesToRemain.remove(entry);
                        continue block2;
                    }
                    ++i;
                }
            }
            boolean cpModified = false;
            if (entriesToRemain.size() != classPath.length) {
                IClasspathEntry[] newClasspath = entriesToRemain.toArray(new IClasspathEntry[entriesToRemain.size()]);
                javaProject.setRawClasspath(newClasspath, null);
                cpModified = true;
            }
            return cpModified;
        }
        catch (JavaModelException exc) {
            String message = NLS.bind((String)MessageResource.ERR_ADDING_PROJECT_TO_CP, (Object)entries.toString(), (Object)javaProject.getProject().getName());
            Status status = new Status(4, "com.ibm.adapter.j2ca", 4, message, (Throwable)exc);
            LogFacility.logErrorMessage((IStatus)status);
            throw new BaseException((IStatus)status);
        }
    }

    public static void addBuilderToProject(IProject project, String builderID, IEnvironment environment) throws BaseException {
        try {
            IProjectDescription desc = project.getProject().getDescription();
            ICommand[] commands = desc.getBuildSpec();
            boolean found = false;
            int i = 0;
            while (i < commands.length) {
                if (commands[i].getBuilderName().equals(builderID)) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                ICommand command = desc.newCommand();
                command.setBuilderName(builderID);
                ICommand[] newCommands = new ICommand[commands.length + 1];
                System.arraycopy(commands, 0, newCommands, 1, commands.length);
                newCommands[0] = command;
                desc.setBuildSpec(newCommands);
                project.getProject().setDescription(desc, null);
            }
        }
        catch (CoreException exc) {
            String message = NLS.bind((String)MessageResource.ERR_ADDING_BUILDER_TO_PROJECT, (Object)builderID, (Object)project.getName());
            LogFacility.logErrorMessage((String)message, (Throwable)exc);
            throw new BaseException(exc.getStatus());
        }
    }

    public static void addWebsphereContainerToClasspath(IJavaProject project, IEnvironment environment) throws BaseException {
        ProjectUtils.addWebsphereContainerToClasspath(project, null, environment);
    }

    public static void addWebsphereContainerToClasspath(IJavaProject project, org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtimeToSet, IEnvironment environment) throws BaseException {
        try {
            IProjectFacet utilityFacet;
            IProgressMonitor monitor = environment.getProgressMonitor();
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project.getProject(), (boolean)true, (IProgressMonitor)monitor);
            boolean runtimeSet = false;
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime currentRuntime = null;
            if (facetedProject != null && (currentRuntime = facetedProject.getPrimaryRuntime()) != null) {
                runtimeSet = true;
            }
            if (runtimeSet && runtimeToSet != null && !runtimeToSet.getName().equals(currentRuntime.getName()) && (utilityFacet = ProjectFacetsManager.getProjectFacet((String)"jst.utility")) != null && facetedProject.hasProjectFacet(utilityFacet)) {
                IVirtualComponent component = ComponentCore.createComponent((IProject)project.getProject());
                IVirtualComponent[] referencingComponents = component.getReferencingComponents();
                if (referencingComponents == null || referencingComponents.length == 0) {
                    runtimeSet = false;
                } else {
                    boolean earFound = false;
                    int i = 0;
                    while (i < referencingComponents.length) {
                        if (referencingComponents[i] instanceof EARVirtualComponent) {
                            earFound = true;
                            break;
                        }
                        ++i;
                    }
                    if (!earFound) {
                        runtimeSet = false;
                    }
                }
            }
            if (!runtimeSet) {
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime;
                Object object = runtime = runtimeToSet != null ? runtimeToSet : null;
                if (runtime == null) {
                    List defaultRuntimes = ProductManager.getDefaultRuntimes();
                    if (defaultRuntimes != null && !defaultRuntimes.isEmpty()) {
                        runtime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)defaultRuntimes.iterator().next();
                    } else {
                        Set runtimes = RuntimeManager.getRuntimes();
                        if (!runtimes.isEmpty()) {
                            runtime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtimes.iterator().next();
                        }
                    }
                }
                if (runtime != null) {
                    ProjectUtils.removeJREContainerFromClasspath(project, environment);
                    List versionList = JavaFacetUtils.JAVA_FACET.getSortedVersions(true);
                    IProjectFacetVersion versionToInstall = null;
                    int i = versionList.size() - 1;
                    while (i >= 0) {
                        IProjectFacetVersion element = (IProjectFacetVersion)versionList.get(i);
                        if (runtime.supports(element)) {
                            versionToInstall = element;
                            break;
                        }
                        --i;
                    }
                    if (versionToInstall != null) {
                        HashSet<IFacetedProject.Action> actionSet = new HashSet<IFacetedProject.Action>();
                        IFacetedProject.Action.Type type = facetedProject.hasProjectFacet(JavaFacetUtils.JAVA_FACET) ? IFacetedProject.Action.Type.VERSION_CHANGE : IFacetedProject.Action.Type.INSTALL;
                        IFacetedProject.Action action = new IFacetedProject.Action(type, versionToInstall, null);
                        actionSet.add(action);
                        boolean hasJ2EEFacet = false;
                        IProjectFacet ejbFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
                        IProjectFacet webFacet = ProjectFacetsManager.getProjectFacet((String)"jst.web");
                        IProjectFacet connectorFacet = ProjectFacetsManager.getProjectFacet((String)"jst.connector");
                        IProjectFacet appClientFacet = ProjectFacetsManager.getProjectFacet((String)"jst.appclient");
                        IProjectFacet utilityFacet2 = ProjectFacetsManager.getProjectFacet((String)"jst.utility");
                        if (facetedProject.hasProjectFacet(ejbFacet) || facetedProject.hasProjectFacet(webFacet) || facetedProject.hasProjectFacet(connectorFacet) || facetedProject.hasProjectFacet(appClientFacet) || facetedProject.hasProjectFacet(utilityFacet2)) {
                            hasJ2EEFacet = true;
                        }
                        if (!hasJ2EEFacet && utilityFacet2 != null) {
                            List utilityVersionList = utilityFacet2.getSortedVersions(true);
                            IProjectFacetVersion utilityVersionToInstall = null;
                            int i2 = utilityVersionList.size() - 1;
                            while (i2 >= 0) {
                                IProjectFacetVersion element = (IProjectFacetVersion)utilityVersionList.get(i2);
                                if (runtime.supports(element)) {
                                    utilityVersionToInstall = element;
                                    break;
                                }
                                --i2;
                            }
                            if (utilityVersionToInstall != null) {
                                type = facetedProject.hasProjectFacet(utilityFacet2) ? IFacetedProject.Action.Type.VERSION_CHANGE : IFacetedProject.Action.Type.INSTALL;
                                IDataModel utilityConfig = DataModelFactory.createDataModel((IDataModelProvider)new UtilityFacetInstallDataModelProvider());
                                utilityConfig.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
                                action = new IFacetedProject.Action(type, utilityVersionToInstall, (Object)utilityConfig);
                                actionSet.add(action);
                            }
                        }
                        if (!actionSet.isEmpty()) {
                            facetedProject.modify(actionSet, monitor);
                        }
                        facetedProject.setTargetedRuntimes(Collections.singleton(runtime), monitor);
                    }
                }
            }
        }
        catch (CoreException exc) {
            String message = NLS.bind((String)MessageResource.ERR_ADDING_WAS_CONTAINER_TO_CP, (Object)project.getProject().getName());
            IStatus s = exc.getStatus();
            if (!s.isMultiStatus()) {
                MultiStatus ms = new MultiStatus(s.getPlugin(), s.getCode(), s.getChildren(), s.getMessage(), s.getException());
                s = ms;
            }
            Status status = new Status(4, "com.ibm.adapter.j2ca", 4, message, (Throwable)exc);
            ((MultiStatus)s).add((IStatus)status);
            environment.getLog().log(Level.SEVERE, message);
            throw new BaseException(s);
        }
        catch (Exception exc) {
            String message = NLS.bind((String)MessageResource.ERR_ADDING_WAS_CONTAINER_TO_CP, (Object)project.getProject().getName());
            Status status = new Status(4, "com.ibm.adapter.j2ca", 4, message, (Throwable)exc);
            environment.getLog().log(Level.SEVERE, message);
            throw new BaseException((IStatus)status);
        }
    }

    public static void removeJREContainerFromClasspath(IJavaProject javaProject, IEnvironment environment) throws BaseException {
        try {
            IClasspathEntry[] classPath = javaProject.getRawClasspath();
            int jreIndex = -1;
            int i = 0;
            while (i < classPath.length) {
                if (classPath[i].getEntryKind() == 5 && classPath[i].getPath().segment(0).equals(JavaRuntime.JRE_CONTAINER)) {
                    jreIndex = i;
                    break;
                }
                ++i;
            }
            if (jreIndex == -1) {
                return;
            }
            ArrayList<IClasspathEntry> classPathEntries = new ArrayList<IClasspathEntry>(Arrays.asList(classPath));
            classPathEntries.remove(jreIndex);
            IClasspathEntry[] newClasspath = new IClasspathEntry[classPathEntries.size()];
            newClasspath = classPathEntries.toArray(newClasspath);
            javaProject.setRawClasspath(newClasspath, environment.getProgressMonitor());
        }
        catch (JavaModelException exc) {
            String message = NLS.bind((String)MessageResource.ERR_ADDING_PROJECT_TO_CP, (Object)javaProject.getProject().getName(), (Object)javaProject.getProject().getName());
            Status status = new Status(4, "com.ibm.adapter.j2ca", 4, message, (Throwable)exc);
            LogFacility.logErrorMessage((IStatus)status);
            throw new BaseException((IStatus)status);
        }
    }

    public static IPackageFragmentRoot getSourcePackage(IJavaProject javaProject) throws JavaModelException {
        if (javaProject == null) {
            return null;
        }
        IPackageFragmentRoot[] fragmentRoots = javaProject.getPackageFragmentRoots();
        int i = 0;
        while (i < fragmentRoots.length) {
            if (fragmentRoots[i].getKind() == 1) {
                return fragmentRoots[i];
            }
            ++i;
        }
        return javaProject.getPackageFragmentRoot(javaProject.getCorrespondingResource());
    }

    public static IPackageFragmentRoot getSourcePackage(IJavaProject javaProject, IEnvironment environment) throws BaseException {
        try {
            IPackageFragmentRoot fragmentRoot = ProjectUtils.getSourcePackage(javaProject);
            return fragmentRoot;
        }
        catch (JavaModelException exc) {
            String message = NLS.bind((String)MessageResource.ERR_GETTING_SOURCE_DIR, (Object)javaProject.getProject().getName());
            Status status = new Status(4, "com.ibm.adapter.j2ca", 4, message, (Throwable)exc);
            LogFacility.logErrorMessage((IStatus)status);
            throw new BaseException((IStatus)status);
        }
    }

    public static IClasspathEntry[] getJAXBLocation(IProject project) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, null);
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = facetedProject.getPrimaryRuntime();
            return ProjectUtils.getJAXBLocation(runtime);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IClasspathEntry[] getJAXBLocation(org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        IPath tpath;
        IClasspathEntry[] cpEntry2 = null;
        IRuntime rt = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime);
        if (runtime != null) {
            if (runtime.getName().equals("was.base.v61")) {
                IPath newPath1 = WASRuntimeLocator.getRuntimeLocation((byte)29, (boolean)true);
                boolean ejb3installed = WASRuntimeUtil.isFeaturePackInstalled((IRuntime)rt, (String)"EJB3");
                if (ejb3installed && newPath1 != null) {
                    cpEntry2 = new IClasspathEntry[]{JavaCore.newLibraryEntry((IPath)new Path(String.valueOf(newPath1.toString()) + "/plugins/com.ibm.jaxb.tools_6.1.0.jar"), null, null, (boolean)false)};
                }
            } else if (runtime.getName().equals("was.base.v7")) {
                IPath newPath2 = WASRuntimeLocator.getRuntimeLocation((byte)35, (boolean)true);
                if (newPath2 != null) {
                    cpEntry2 = new IClasspathEntry[]{JavaCore.newLibraryEntry((IPath)new Path(String.valueOf(newPath2.toString()) + "/plugins/com.ibm.jaxb.tools.jar"), null, null, (boolean)false)};
                } else {
                    return null;
                }
            }
        }
        if (cpEntry2 == null && (tpath = WASRuntimeLocator.getRuntimeStubLocation((byte)33)) != null) {
            cpEntry2 = new IClasspathEntry[]{JavaCore.newLibraryEntry((IPath)new Path(String.valueOf(tpath.toString()) + "/adapterJars/jaxb-api-2.0.jar"), null, null, (boolean)false), JavaCore.newLibraryEntry((IPath)new Path(String.valueOf(tpath.toString()) + "/adapterJars/jaxb-impl-2.0.5.jar"), null, null, (boolean)false), JavaCore.newLibraryEntry((IPath)new Path(String.valueOf(tpath.toString()) + "/runtimes/wsfp_api.jar"), null, null, (boolean)false)};
        }
        return cpEntry2;
    }

    public static IClasspathEntry[] getJavaClasspath(IProject project) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                IClasspathEntry[] classpathEntries = javaProject.getRawClasspath();
                return classpathEntries;
            }
        }
        catch (JavaModelException javaModelException) {}
        return new IClasspathEntry[0];
    }

    public static IWorkspace getWorkspace() {
        IWorkspace workspace = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (root != null) {
            workspace = root.getWorkspace();
        }
        return workspace;
    }

    public static Vector<IProject> getConnectorProjectsOnClassPath(IProject project) {
        IClasspathEntry[] classPathEntries = ProjectUtils.getJavaClasspath(project);
        Vector<IProject> dependentProjects = new Vector<IProject>();
        int i = 0;
        while (classPathEntries.length > i) {
            if (classPathEntries[i].getEntryKind() == 2) {
                IProject depProj;
                String sPath = classPathEntries[i].getPath().toString();
                int indx = sPath.lastIndexOf("/");
                String projectName = sPath;
                if (indx != -1) {
                    projectName = projectName.substring(indx + 1);
                }
                if ((depProj = ProjectUtils.getWorkspace().getRoot().getProject(projectName)).exists() && JavaEEProjectUtilities.isJCAProject((IProject)depProj)) {
                    dependentProjects.add(depProj);
                }
            }
            ++i;
        }
        return dependentProjects;
    }
}

