/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2ca.spi.util;

import com.ibm.adapter.j2ca.internal.LogFacility;
import com.ibm.adapter.j2ca.internal.MessageResource;
import com.ibm.adapter.j2ca.spi.util.JarURLHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.emf.common.util.URI;

public class InMemoryClassLoader
extends ClassLoader {
    private static JarURLHandler jarHandler = new JarURLHandler();
    private Collection classPath = Collections.synchronizedCollection(new ArrayList());
    private Map openJars = Collections.synchronizedMap(new HashMap());
    private long creationTime;
    private ArrayList loadedClasses = new ArrayList();
    private boolean cacheJarsMode = false;

    public InMemoryClassLoader() {
        if (LogFacility.traceClassLoder) {
            LogFacility.TrcEntry();
        }
        this.creationTime = System.currentTimeMillis();
        if (LogFacility.traceClassLoder) {
            LogFacility.Trace((String)new StringBuffer("Created InMemoryClassLoader:").append(this.toString()).toString(), (short)10);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public InMemoryClassLoader(ClassLoader _parent) {
        super(_parent);
        if (LogFacility.traceClassLoder) {
            LogFacility.TrcEntry();
        }
        this.creationTime = System.currentTimeMillis();
        if (LogFacility.traceClassLoder) {
            LogFacility.Trace((String)new StringBuffer("Created InMemoryClassLoader:").append(this.toString()).toString(), (short)10);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public InMemoryClassLoader(URL[] aurl) {
        if (LogFacility.traceClassLoder) {
            LogFacility.TrcEntry();
        }
        int i = aurl.length;
        while (--i >= 0) {
            this.addURL(aurl[i]);
        }
        this.creationTime = System.currentTimeMillis();
        if (LogFacility.traceClassLoder) {
            LogFacility.Trace((String)new StringBuffer("Created InMemoryClassLoader:").append(this.toString()).toString(), (short)10);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public InMemoryClassLoader(URL[] aurl, ClassLoader _parent) {
        super(_parent);
        if (LogFacility.traceClassLoder) {
            LogFacility.TrcEntry();
        }
        int i = aurl.length;
        while (--i >= 0) {
            this.addURL(aurl[i]);
        }
        this.creationTime = System.currentTimeMillis();
        if (LogFacility.traceClassLoder) {
            LogFacility.Trace((String)new StringBuffer("Created InMemoryClassLoader:").append(this.toString()).toString(), (short)10);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public void purgeClassPath() {
        if (LogFacility.traceClassLoder) {
            LogFacility.TrcEntry();
            LogFacility.Trace((String)new StringBuffer("Memory before class path purge:").append(Runtime.getRuntime().totalMemory()).toString(), (short)10);
        }
        this.classPath.clear();
        this.loadedClasses.clear();
        this.closeOpenJars();
        System.runFinalization();
        System.gc();
        if (LogFacility.traceClassLoder) {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            LogFacility.Trace((String)new StringBuffer("Memory after class path purge:").append(Runtime.getRuntime().totalMemory()).toString(), (short)10);
        }
    }

    public String toString() {
        Iterator i = this.classPath.iterator();
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(super.toString()) + '#' + this.creationTime + '-');
        while (i.hasNext()) {
            File f = (File)i.next();
            buf.append(String.valueOf(f.getAbsolutePath()) + ':');
        }
        return buf.toString();
    }

    protected void addURL(URL newURL) {
        String s = newURL.getFile().replace('/', File.separatorChar);
        File file = new File(URI.decode((String)s));
        if (file.exists() && !this.classPath.contains(file)) {
            this.classPath.add(file);
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> cl;
        if (LogFacility.traceClassLoder) {
            LogFacility.TrcEntry();
        }
        if ((cl = this.findLoadedClass(name)) == null) {
            String className;
            byte[] b;
            if (LogFacility.traceClassLoder) {
                LogFacility.Trace((String)new StringBuffer("Attempting to load ").append(name).append(" from CP of InMemoryClassLoader:").append(super.toString()).toString(), (short)10);
            }
            if ((b = this.getBytes(className = String.valueOf(name.replace('.', File.separatorChar)) + ".class")) != null) {
                if (LogFacility.traceClassLoder) {
                    LogFacility.Trace((String)new StringBuffer("Found the bytecodes for ").append(name).append(" from CP of InMemoryClassLoader:").append(super.toString()).toString(), (short)10);
                }
                try {
                    Class<?> clazz = this.defineClass(name, b, 0, b.length);
                    if (clazz != null) {
                        this.loadedClasses.add(clazz);
                    }
                    if (LogFacility.traceClassLoder && LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    return clazz;
                }
                catch (ClassFormatError e) {
                    LogFacility.logErrorMessage((String)MessageResource.bind((String)MessageResource.MSG_ERROR__COULD_NOT_LOAD_CLASS_FILE, (Object)className), (Throwable)e);
                    if (LogFacility.traceClassLoder && LogFacility.trace) {
                        LogFacility.TrcExit();
                    }
                    throw new ClassNotFoundException(name, e);
                }
            }
            if (LogFacility.traceClassLoder) {
                LogFacility.Trace((String)new StringBuffer("Could not find the bytecodes for ").append(name).append(" from CP of InMemoryClassLoader:").append(super.toString()).toString(), (short)60);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
            throw new ClassNotFoundException(name);
        }
        return cl;
    }

    @Override
    protected URL findResource(String name) {
        URL result;
        if (LogFacility.traceClassLoder) {
            LogFacility.TrcEntry();
        }
        if ((result = super.findResource(name)) == null) {
            if (LogFacility.traceClassLoder) {
                LogFacility.Trace((String)new StringBuffer("Attempting to load ").append(name).append(" from CP of InMemoryClassLoader:").append(super.toString()).toString(), (short)10);
            }
            for (File aFile : this.classPath) {
                if (aFile.isDirectory()) {
                    File newFile = new File(aFile, name);
                    if (!newFile.exists()) continue;
                    try {
                        if (LogFacility.traceClassLoder) {
                            LogFacility.Trace((String)new StringBuffer("Found  ").append(name).toString(), (short)10);
                            if (LogFacility.trace) {
                                LogFacility.TrcExit();
                            }
                        }
                        return newFile.toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (LogFacility.traceClassLoder) {
                            LogFacility.Trace((String)new StringBuffer("Could not find  ").append(name).toString(), (short)60);
                            if (LogFacility.trace) {
                                LogFacility.TrcExit();
                            }
                        }
                        return null;
                    }
                }
                if (!aFile.getAbsolutePath().toLowerCase().endsWith(".jar") && !aFile.getAbsolutePath().toLowerCase().endsWith(".zip")) continue;
                JarFile jFile = null;
                try {
                    URL returnURL;
                    JarEntry jarEntry;
                    jFile = (JarFile)this.openJars.get(aFile);
                    if (jFile == null) {
                        jFile = new JarFile(aFile);
                        this.openJars.put(aFile, jFile);
                    }
                    if ((jarEntry = jFile.getJarEntry(name)) == null) {
                        String alternateName = name.replace('\\', '/');
                        jarEntry = jFile.getJarEntry(alternateName);
                    }
                    if (jarEntry == null) continue;
                    if (LogFacility.traceClassLoder) {
                        LogFacility.Trace((String)new StringBuffer("Found  ").append(name).append("in the jar:").append(jFile.getName()).toString(), (short)10);
                    }
                    URL jarFileURL = aFile.toURL();
                    URL uRL = returnURL = new URL(null, "jar:" + jarFileURL.toString() + "!/" + jarEntry.getName(), jarHandler);
                    return uRL;
                }
                catch (IOException e) {
                    if (!LogFacility.traceClassLoder) continue;
                    LogFacility.Trace((String)e.getLocalizedMessage(), (short)60);
                }
                finally {
                    block31: {
                        if (!this.cacheJarsMode && jFile != null) {
                            try {
                                jFile.close();
                                this.openJars.remove(aFile);
                            }
                            catch (IOException e) {
                                if (!LogFacility.traceClassLoder) break block31;
                                LogFacility.Trace((String)e.getLocalizedMessage(), (short)60);
                            }
                        }
                    }
                }
            }
            if (LogFacility.traceClassLoder) {
                LogFacility.Trace((String)new StringBuffer("Could not find  ").append(name).toString(), (short)30);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
            return null;
        }
        if (LogFacility.traceClassLoder && LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return result;
    }

    protected byte[] getBytes(String name) {
        if (LogFacility.traceClassLoder) {
            LogFacility.TrcEntry();
        }
        Iterator i = this.classPath.iterator();
        byte[] iStream = null;
        while (i.hasNext() && iStream == null) {
            int length;
            byte[] buf;
            BufferedOutputStream bos;
            ByteArrayOutputStream out;
            File aFile = (File)i.next();
            if (aFile.isDirectory()) {
                File newFile = new File(aFile, name);
                if (!newFile.exists()) continue;
                FileInputStream fileStream = null;
                try {
                    if (LogFacility.traceClassLoder) {
                        LogFacility.Trace((String)new StringBuffer("Located the resource in file:").append(newFile.getAbsolutePath()).toString(), (short)10);
                    }
                    fileStream = new FileInputStream(newFile);
                    BufferedInputStream bis = new BufferedInputStream(fileStream);
                    out = new ByteArrayOutputStream();
                    bos = new BufferedOutputStream(out);
                    buf = new byte[10240];
                    length = 0;
                    length = bis.read(buf);
                    while (length > 0) {
                        bos.write(buf, 0, length);
                        length = bis.read(buf);
                    }
                    bos.flush();
                    bis.close();
                    iStream = out.toByteArray();
                    bos.close();
                }
                catch (IOException iOException) {
                    if (LogFacility.traceClassLoder) {
                        LogFacility.Trace((String)new StringBuffer("Error reading file:").append(newFile.getAbsolutePath()).toString(), (short)60);
                    }
                    if (fileStream == null) continue;
                    try {
                        fileStream.close();
                    }
                    catch (IOException iOException2) {}
                }
                continue;
            }
            if (!aFile.getAbsolutePath().toLowerCase().endsWith(".jar") && !aFile.getAbsolutePath().toLowerCase().endsWith(".zip")) continue;
            JarFile jFile = null;
            try {
                try {
                    JarEntry jarEntry;
                    jFile = (JarFile)this.openJars.get(aFile);
                    if (jFile == null) {
                        jFile = new JarFile(aFile);
                        this.openJars.put(aFile, jFile);
                    }
                    if ((jarEntry = jFile.getJarEntry(name)) == null) {
                        String alternateName = name.replace('\\', '/');
                        jarEntry = jFile.getJarEntry(alternateName);
                    }
                    if (jarEntry != null) {
                        if (LogFacility.traceClassLoder) {
                            LogFacility.Trace((String)new StringBuffer("Located the resource in jar:").append(jFile.getName()).toString(), (short)10);
                        }
                        BufferedInputStream jarStream = null;
                        try {
                            jarStream = new BufferedInputStream(jFile.getInputStream(jarEntry));
                            out = new ByteArrayOutputStream();
                            bos = new BufferedOutputStream(out);
                            buf = new byte[10240];
                            length = 0;
                            length = jarStream.read(buf);
                            while (length > 0) {
                                bos.write(buf, 0, length);
                                length = jarStream.read(buf);
                            }
                            bos.flush();
                            jarStream.close();
                            iStream = out.toByteArray();
                            bos.close();
                        }
                        catch (IOException iOException) {
                            if (LogFacility.traceClassLoder) {
                                LogFacility.Trace((String)new StringBuffer("Error reading the resource in jar:").append(jFile.getName()).toString(), (short)60);
                            }
                            if (jarStream != null) {
                                jarStream.close();
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    if (LogFacility.traceClassLoder) {
                        LogFacility.Trace((String)new StringBuffer("Error opening jar:").append(aFile.getName()).toString(), (short)60);
                    }
                    if (this.cacheJarsMode || jFile == null) continue;
                    try {
                        jFile.close();
                        this.openJars.remove(aFile);
                    }
                    catch (IOException iOException3) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (!this.cacheJarsMode && jFile != null) {
                    try {
                        jFile.close();
                        this.openJars.remove(aFile);
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (this.cacheJarsMode || jFile == null) continue;
            try {
                jFile.close();
                this.openJars.remove(aFile);
            }
            catch (IOException iOException) {}
        }
        if (LogFacility.traceClassLoder && LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return iStream;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Enumeration findResources(String name) throws IOException {
        if (LogFacility.traceClassLoder) {
            LogFacility.TrcEntry();
        }
        Vector<URL> results = new Vector<URL>();
        try {
            if (LogFacility.traceClassLoder) {
                LogFacility.Trace((String)new StringBuffer("Attempting to load ").append(name).append(" from CP of InMemoryClassLoader:").append(super.toString()).toString(), (short)10);
            }
            for (File aFile : this.classPath) {
                if (aFile.isDirectory()) {
                    File newFile = new File(aFile, name);
                    if (!newFile.exists()) continue;
                    try {
                        if (LogFacility.traceClassLoder) {
                            LogFacility.Trace((String)new StringBuffer("Found  ").append(name).toString(), (short)10);
                            if (LogFacility.trace) {
                                LogFacility.TrcExit();
                            }
                        }
                        results.add(newFile.toURL());
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (LogFacility.traceClassLoder) {
                            LogFacility.Trace((String)new StringBuffer("Could not find  ").append(name).toString(), (short)60);
                            if (LogFacility.trace) {
                                LogFacility.TrcExit();
                            }
                        }
                        if (!LogFacility.trace) return null;
                        LogFacility.TrcExit();
                        return null;
                    }
                }
                if (!aFile.getAbsolutePath().toLowerCase().endsWith(".jar") && !aFile.getAbsolutePath().toLowerCase().endsWith(".zip")) continue;
                JarFile jFile = null;
                try {
                    try {
                        JarEntry jarEntry;
                        jFile = (JarFile)this.openJars.get(aFile);
                        if (jFile == null) {
                            jFile = new JarFile(aFile);
                            this.openJars.put(aFile, jFile);
                        }
                        if ((jarEntry = jFile.getJarEntry(name)) == null) {
                            String alternateName = name.replace('\\', '/');
                            jarEntry = jFile.getJarEntry(alternateName);
                        }
                        if (jarEntry != null) {
                            if (LogFacility.traceClassLoder) {
                                LogFacility.Trace((String)new StringBuffer("Found  ").append(name).append("in the jar:").append(jFile.getName()).toString(), (short)10);
                            }
                            URL jarFileURL = aFile.toURL();
                            URL returnURL = new URL(null, "jar:" + jarFileURL.toString() + "!/" + jarEntry.getName(), jarHandler);
                            results.add(returnURL);
                        }
                    }
                    catch (IOException e) {
                        if (LogFacility.traceClassLoder) {
                            LogFacility.Trace((String)e.getLocalizedMessage(), (short)60);
                        }
                        if (this.cacheJarsMode || jFile == null) continue;
                        try {
                            jFile.close();
                            this.openJars.remove(aFile);
                        }
                        catch (IOException e2) {
                            if (!LogFacility.traceClassLoder) continue;
                            LogFacility.Trace((String)e2.getLocalizedMessage(), (short)60);
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (this.cacheJarsMode) throw throwable;
                    if (jFile == null) throw throwable;
                    try {
                        jFile.close();
                        this.openJars.remove(aFile);
                        throw throwable;
                    }
                    catch (IOException e) {
                        if (!LogFacility.traceClassLoder) throw throwable;
                        LogFacility.Trace((String)e.getLocalizedMessage(), (short)60);
                    }
                    throw throwable;
                }
                if (this.cacheJarsMode || jFile == null) continue;
                try {
                    jFile.close();
                    this.openJars.remove(aFile);
                }
                catch (IOException e) {
                    if (!LogFacility.traceClassLoder) continue;
                    LogFacility.Trace((String)e.getLocalizedMessage(), (short)60);
                }
            }
        }
        catch (Throwable throwable) {
            if (!LogFacility.trace) throw throwable;
            LogFacility.TrcExit();
            throw throwable;
        }
        {
            catch (Throwable e) {
                if (LogFacility.traceClassLoder) {
                    LogFacility.Trace((String)e.getLocalizedMessage(), (short)60);
                }
                if (!LogFacility.trace) return results.elements();
                LogFacility.TrcExit();
                return results.elements();
                break;
            }
        }
        if (!LogFacility.trace) return results.elements();
        LogFacility.TrcExit();
        return results.elements();
    }

    public void closeOpenJars() {
        ArrayList entries = new ArrayList();
        Iterator iter = this.openJars.entrySet().iterator();
        while (iter.hasNext()) {
            entries.add(iter.next());
        }
        for (Map.Entry entry : entries) {
            File abstractFile = (File)entry.getKey();
            JarFile jFile = (JarFile)entry.getValue();
            this.openJars.remove(abstractFile);
            try {
                jFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void setCacheJarsMode(boolean cacheJarsMode) {
        this.cacheJarsMode = cacheJarsMode;
        if (!cacheJarsMode) {
            this.closeOpenJars();
        }
    }

    public boolean isCacheJarsMode() {
        return this.cacheJarsMode;
    }
}

