/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2ca.spi.util;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.j2ca.internal.LogFacility;
import com.ibm.adapter.j2ca.internal.MessageResource;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.jca.ConfigProperty;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.modulecore.util.ConnectorArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class ConnectorProjectHelper {
    private static final String CONNECTION_SPEC_INTERFACE = "javax.resource.cci.ConnectionSpec";
    private static final String FILE_URL_PROTOCOL = "file";
    private static final String INTERACTION_SPEC_INTERFACE = "javax.resource.cci.InteractionSpec";

    public static IPropertyGroup createPropertyGroupFromConfigElements(String propertyGroupName, List<ConfigProperty> configProperties, ClassLoader classLoader) {
        BasePropertyGroup propertyGroup;
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            propertyGroup = new BasePropertyGroup(propertyGroupName, null, propertyGroupName);
        }
        catch (CoreException e1) {
            LogFacility.logErrorMessage((String)MessageResource.MSG_ERROR__RA_PROPS, (Throwable)e1);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return null;
        }
        if (configProperties != null) {
            ArrayList<BaseSingleValuedProperty> propertyDescriptors = new ArrayList<BaseSingleValuedProperty>(configProperties.size());
            for (ConfigProperty property : configProperties) {
                try {
                    Class<?> propertyTypeClass = classLoader.loadClass(property.getType());
                    BaseSingleValuedProperty propertyDescriptor = new BaseSingleValuedProperty(property.getName(), null, property.getDescription(), propertyTypeClass, propertyGroup);
                    String defaultValue = property.getValue();
                    if (defaultValue != null && defaultValue.length() > 0) {
                        if (propertyTypeClass.equals(String.class)) {
                            propertyDescriptor.setDefaultValue((Object)defaultValue);
                        } else if (propertyTypeClass.equals(Integer.class)) {
                            propertyDescriptor.setDefaultValue((Object)new Integer(defaultValue));
                        } else if (propertyTypeClass.equals(Boolean.class)) {
                            propertyDescriptor.setDefaultValue((Object)new Boolean(defaultValue));
                        } else if (propertyTypeClass.equals(Byte.class)) {
                            propertyDescriptor.setDefaultValue((Object)new Byte(defaultValue));
                        } else if (propertyTypeClass.equals(Character.class)) {
                            int ch = UTF16.charAt((String)defaultValue, (int)0);
                            propertyDescriptor.setDefaultValue((Object)new Character(UCharacter.toChars((int)ch)[0]));
                        } else if (propertyTypeClass.equals(Double.class)) {
                            propertyDescriptor.setDefaultValue((Object)new Double(defaultValue));
                        } else if (propertyTypeClass.equals(Float.class)) {
                            propertyDescriptor.setDefaultValue((Object)new Float(defaultValue));
                        } else if (propertyTypeClass.equals(Long.class)) {
                            propertyDescriptor.setDefaultValue((Object)new Long(defaultValue));
                        } else if (propertyTypeClass.equals(Short.class)) {
                            propertyDescriptor.setDefaultValue((Object)new Short(defaultValue));
                        }
                    }
                    propertyDescriptors.add(propertyDescriptor);
                }
                catch (ClassNotFoundException e) {
                    LogFacility.logErrorMessage((String)MessageResource.MSG_ERROR__RA_PROPS, (Throwable)e);
                }
                catch (CoreException e2) {
                    LogFacility.logErrorMessage((String)MessageResource.MSG_ERROR__RA_PROPS, (Throwable)e2);
                }
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return propertyGroup;
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return null;
    }

    public static Class<?>[] findClassesForType(IProject aConnectorProject, String type, ClassLoader classLoader) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        ArrayList classes = new ArrayList();
        try {
            IJavaProject javaProject = JavaCore.create((IProject)aConnectorProject);
            IType javaType = javaProject.findType(type);
            if (javaType == null) {
                String message = MessageResource.bind((String)MessageResource.MSG_ERROR__RA_TYPE_NOT_FOUND, (Object)type, (Object)aConnectorProject.getName());
                LogFacility.logErrorMessage((String)message, null);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                throw BaseException.createException((String)message, null);
            }
            ITypeHierarchy typeHierarchy = javaType.newTypeHierarchy(javaProject, (IProgressMonitor)new NullProgressMonitor());
            IType[] subTypes = typeHierarchy.getAllSubtypes(javaType);
            IPath containerPath = javaProject.getProject().getFullPath();
            int i = subTypes.length;
            while (--i >= 0) {
                if (Flags.isAbstract((int)subTypes[i].getFlags())) continue;
                try {
                    IPath typePath = subTypes[i].getPath();
                    if (typePath == null || typePath.matchingFirstSegments(containerPath) != containerPath.segmentCount()) continue;
                    Class<?> clazz = classLoader.loadClass(subTypes[i].getFullyQualifiedName());
                    classes.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    String message = MessageResource.bind((String)MessageResource.MSG_ERROR__RA_TYPE_NOT_FOUND, (Object)subTypes[i].getFullyQualifiedName(), (Object)aConnectorProject.getName());
                    LogFacility.logErrorMessage((String)message, (Throwable)e);
                }
            }
            Class[] returnValues = new Class[classes.size()];
            returnValues = classes.toArray(returnValues);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            Class[] classArray = returnValues;
            return classArray;
        }
        catch (JavaModelException e) {
            String message = MessageResource.bind((String)MessageResource.MSG_ERROR__RA_TYPE_NOT_FOUND, (Object)type, (Object)aConnectorProject.getName());
            LogFacility.logErrorMessage((String)message, (Throwable)e);
            return null;
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public static Class<?>[] findConnectionSpecs(IProject aConnectorProject, ClassLoader classLoader) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        Class<?>[] classes = ConnectorProjectHelper.findClassesForType(aConnectorProject, CONNECTION_SPEC_INTERFACE, classLoader);
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return classes;
    }

    public static Class<?>[] findInteractionSpecs(IProject aConnectorProject, ClassLoader classLoader) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        Class<?>[] classes = ConnectorProjectHelper.findClassesForType(aConnectorProject, INTERACTION_SPEC_INTERFACE, classLoader);
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return classes;
    }

    public static IProject[] getAllConnectorProjects() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> connectorProjects = new ArrayList<IProject>(projects.length);
        int i = projects.length;
        while (--i >= 0) {
            if (ConnectorProjectHelper.isConnectorProject(projects[i]) == null) continue;
            connectorProjects.add(projects[i]);
        }
        IProject[] returnedProjects = new IProject[connectorProjects.size()];
        connectorProjects.toArray(returnedProjects);
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return returnedProjects;
    }

    public static Connector getConnector(IProject aConnectorProject) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            IVirtualComponent component = ConnectorProjectHelper.isConnectorProject(aConnectorProject);
            if (component != null) {
                ConnectorArtifactEdit artifactEdit = ConnectorArtifactEdit.getConnectorArtifactEditForRead((IVirtualComponent)component);
                Connector connector = artifactEdit.getConnector();
                return connector;
            }
            return null;
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    private static URL[] getURLsFromClasspathEntries(IClasspathEntry[] entries, IProject project, List<Object> visitedProjects) throws JavaModelException, MalformedURLException, CoreException {
        return ConnectorProjectHelper.getURLsFromClasspathEntries(entries, project, visitedProjects, false);
    }

    private static URL[] getURLsFromClasspathEntries(IClasspathEntry[] entries, IProject project, List<Object> visitedProjects, boolean ignoreJREJars) throws JavaModelException, MalformedURLException, CoreException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            ArrayList<URL> resourceURLs = new ArrayList<URL>();
            int i = entries.length;
            block15: while (--i >= 0) {
                URL url = null;
                IClasspathEntry entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entries[i]);
                IPath path = entry.getPath();
                switch (entry.getEntryKind()) {
                    case 1: {
                        File f = path.toFile();
                        if (f.exists()) {
                            url = f.toURL();
                        } else {
                            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                            if (file.exists()) {
                                path = file.getRawLocation();
                            }
                            url = new URL(FILE_URL_PROTOCOL, null, -1, path.toOSString());
                        }
                        resourceURLs.add(url);
                        break;
                    }
                    case 3: {
                        IProject referencedProject;
                        IPath outputLocation;
                        IProject referencedProject2;
                        Object srcContainer = null;
                        if (path.segmentCount() > 0 && (srcContainer = (referencedProject2 = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0))) != null && referencedProject2.exists() && path.segmentCount() > 1 ? referencedProject2.getFolder(path.removeFirstSegments(1)) : referencedProject2) != null && srcContainer.exists()) {
                            url = new URL(FILE_URL_PROTOCOL, null, -1, String.valueOf(srcContainer.getLocation().toOSString()) + '/');
                            resourceURLs.add(url);
                        }
                        if ((outputLocation = entry.getOutputLocation()) == null) break;
                        Object outputContainer = null;
                        if (outputLocation.segmentCount() <= 0 || (outputContainer = (referencedProject = ResourcesPlugin.getWorkspace().getRoot().getProject(outputLocation.segment(0))) != null && referencedProject.exists() && outputLocation.segmentCount() > 1 ? referencedProject.getFolder(outputLocation.removeFirstSegments(1)) : referencedProject) == null || !outputContainer.exists()) continue block15;
                        url = new URL(FILE_URL_PROTOCOL, null, -1, String.valueOf(outputContainer.getLocation().toOSString()) + '/');
                        resourceURLs.add(url);
                        break;
                    }
                    case 2: {
                        IProject javaProject = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                        if (!javaProject.exists()) break;
                        if (visitedProjects != null && visitedProjects.contains(javaProject.getProject())) {
                            Status status = new Status(4, "com.ibm.adapter.j2ca", 4, MessageResource.MSG_ERROR_CYCLE_IN_CLASSPATH, null);
                            throw new CoreException((IStatus)status);
                        }
                        URL[] urls = ConnectorProjectHelper.getProjectClasspath(javaProject, visitedProjects, ignoreJREJars);
                        List<URL> newURLs = Arrays.asList(urls);
                        resourceURLs.addAll(newURLs);
                        break;
                    }
                    case 5: {
                        IPath containerPath;
                        IClasspathContainer container;
                        if (ignoreJREJars && entry.getPath().segment(0).equals("org.eclipse.jdt.launching.JRE_CONTAINER") || (container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)JavaCore.create((IProject)project))) == null || visitedProjects.contains(containerPath = container.getPath())) continue block15;
                        visitedProjects.add(containerPath);
                        URL[] urls = ConnectorProjectHelper.getURLsFromClasspathEntries(container.getClasspathEntries(), project, visitedProjects);
                        List<URL> newURLs = Arrays.asList(urls);
                        resourceURLs.addAll(newURLs);
                        break;
                    }
                    case 4: {
                        url = new URL(FILE_URL_PROTOCOL, null, -1, path.toOSString());
                        resourceURLs.add(url);
                    }
                }
            }
            URL[] urls = new URL[resourceURLs.size()];
            resourceURLs.toArray(urls);
            URL[] uRLArray = urls;
            return uRLArray;
        }
        catch (MalformedURLException e) {
            String message = MessageResource.bind((String)MessageResource.MSG_ERROR__RA_CLASSPATH, (Object)project.getName());
            LogFacility.logErrorMessage((String)message, (Throwable)e);
            throw e;
        }
        catch (JavaModelException e) {
            String message = MessageResource.bind((String)MessageResource.MSG_ERROR__RA_CLASSPATH, (Object)project.getName());
            LogFacility.logErrorMessage((String)message, (Throwable)e);
            throw e;
        }
        catch (CoreException e) {
            String message = MessageResource.bind((String)MessageResource.MSG_ERROR__RA_CLASSPATH, (Object)project.getName());
            LogFacility.logErrorMessage((String)message, (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            String message = MessageResource.bind((String)MessageResource.MSG_ERROR__RA_CLASSPATH, (Object)project.getName());
            LogFacility.logErrorMessage((String)message, (Throwable)e);
            throw e;
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public static URL[] getURLsFromProject(IProject connectorProject) throws JavaModelException, MalformedURLException, CoreException {
        return ConnectorProjectHelper.getProjectClasspath(connectorProject, new ArrayList<Object>());
    }

    private static URL[] getProjectClasspath(IProject connectorProject, List<Object> visitedProjects) throws JavaModelException, MalformedURLException, CoreException {
        return ConnectorProjectHelper.getProjectClasspath(connectorProject, visitedProjects, false);
    }

    private static URL[] getProjectClasspath(IProject connectorProject, List<Object> visitedProjects, boolean ignoreJREJars) throws JavaModelException, MalformedURLException, CoreException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            ArrayList<URL> resourceURLs = new ArrayList<URL>();
            IJavaProject connectorJavaProject = JavaCore.create((IProject)connectorProject);
            if (connectorJavaProject.exists()) {
                IProject referencedProject;
                if (visitedProjects == null) {
                    visitedProjects = new ArrayList<Object>();
                }
                if (visitedProjects.contains(connectorProject)) {
                    Status status = new Status(4, "com.ibm.adapter.j2ca", 4, MessageResource.MSG_ERROR_CYCLE_IN_CLASSPATH, null);
                    throw new CoreException((IStatus)status);
                }
                visitedProjects.add(connectorJavaProject);
                IClasspathEntry[] entries = connectorJavaProject.getRawClasspath();
                URL[] projectUrls = ConnectorProjectHelper.getURLsFromClasspathEntries(entries, connectorProject, visitedProjects, ignoreJREJars);
                List<URL> newURLs = Arrays.asList(projectUrls);
                resourceURLs.addAll(newURLs);
                IPath outputPath = connectorJavaProject.getOutputLocation();
                Object outputContainer = null;
                if (outputPath.segmentCount() > 0 && (outputContainer = (referencedProject = ResourcesPlugin.getWorkspace().getRoot().getProject(outputPath.segment(0))) != null && referencedProject.exists() && outputPath.segmentCount() > 1 ? referencedProject.getFolder(outputPath.removeFirstSegments(1)) : referencedProject) != null && outputContainer.exists()) {
                    URL outputURL = new URL(FILE_URL_PROTOCOL, null, -1, String.valueOf(outputContainer.getLocation().toOSString()) + '/');
                    resourceURLs.add(outputURL);
                }
                URL outputURL = new URL(FILE_URL_PROTOCOL, null, -1, String.valueOf(connectorJavaProject.getProject().getLocation().toOSString()) + '/');
                resourceURLs.add(outputURL);
            }
            URL[] urls = new URL[resourceURLs.size()];
            urls = resourceURLs.toArray(urls);
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            URL[] uRLArray = urls;
            return uRLArray;
        }
        catch (JavaModelException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        catch (MalformedURLException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        catch (CoreException e) {
            LogFacility.logErrorMessage((IStatus)e.getStatus());
            throw e;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            Status status = new Status(4, "com.ibm.adapter.j2ca", 4, e.getLocalizedMessage() == null ? "" : e.getLocalizedMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public static final IVirtualComponent isConnectorProject(IProject project) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            if (ConnectorArtifactEdit.isValidConnectorModule((IVirtualComponent)component)) {
                IVirtualComponent iVirtualComponent = component;
                return iVirtualComponent;
            }
            return null;
        }
        catch (UnresolveableURIException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public static URL[] getURLsFromProject(IProject connectorProject, boolean ignoreJREJars) throws JavaModelException, MalformedURLException, CoreException {
        return ConnectorProjectHelper.getProjectClasspath(connectorProject, new ArrayList<Object>(), ignoreJREJars);
    }
}

