/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.j2ca;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.j2ca.internal.LogFacility;
import com.ibm.adapter.j2ca.spi.util.ProjectUtils;
import java.io.File;
import java.io.FileInputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConnectorProjectDescriptor {
    public static final String CONFIG_FILE_NAME = "com.ibm.adapter.j2ca.conf.xml";
    public static final String SETTINGS_DIR = ".settings";
    public static final String CONNECTOR_MODULE_PATH = "connectorModule";
    public static final String CONFIGURATION_ELEMENT_NAME = "configuration";
    public static final String APPLICATION_ENTRY_ELEMENT_NAME = "applicationEntry";
    public static final String SYSTEM_ENTRY_ELEMENT_NAME = "systemEntry";
    public static final String URI_ATTRIBUTE_NAME = "uri";
    public static final String TARGET_NS = "http://j2ca.adapter.ibm.com";
    public static final String JAVA_LIBRARY_PATH = "java.library.path";
    public static final String JAVA_PATH_SEPARATOR = "path.separator";
    public static final String CONNECTOR_MODULE_DIR = "connectorModule";
    private IJavaProject connectorProject_ = null;
    private String pathSeparator_ = null;
    private String configFileName_ = null;

    public ConnectorProjectDescriptor(IProject connectorProject) {
        this.connectorProject_ = JavaCore.create((IProject)connectorProject);
        this.pathSeparator_ = System.getProperty(JAVA_PATH_SEPARATOR);
        this.configFileName_ = this.getConfigFileName();
    }

    public boolean isConfigured() {
        File configFile = new File(this.configFileName_);
        if (!configFile.exists()) {
            return false;
        }
        if (!this.validateContent()) {
            try {
                this.removeExistingCopiedEntries();
                this.removeExistingReferencedEntries();
            }
            catch (BaseException baseException) {}
            configFile.delete();
            return false;
        }
        return true;
    }

    private boolean configurationFileExists() {
        File configFile = new File(this.configFileName_);
        return configFile.exists();
    }

    public java.net.URI[] getCopiedClasspathEntries() {
        ArrayList<java.net.URI> entries = new ArrayList<java.net.URI>();
        try {
            Element rootElement = this.getConfigFileRootElement();
            if (rootElement != null) {
                NodeList nodes = rootElement.getElementsByTagNameNS(TARGET_NS, APPLICATION_ENTRY_ELEMENT_NAME);
                int i = 0;
                while (i < nodes.getLength()) {
                    Element elementNode = (Element)nodes.item(i);
                    String relativeURI = elementNode.getAttribute(URI_ATTRIBUTE_NAME);
                    if (relativeURI != null && !"".equals(relativeURI)) {
                        if (relativeURI.startsWith("connectorModule")) {
                            IPath projectPath = this.connectorProject_.getProject().getLocation();
                            IPath filePath = projectPath.append(relativeURI);
                            relativeURI = filePath.toString();
                        }
                        String uriString = URI.createFileURI((String)relativeURI).toString();
                        java.net.URI aURI = new java.net.URI(uriString);
                        entries.add(aURI);
                    }
                    ++i;
                }
            }
        }
        catch (Exception exc) {
            Status status = new Status(4, "com.ibm.adapter.j2ca", 4, exc.getLocalizedMessage() == null ? "" : exc.getLocalizedMessage(), (Throwable)exc);
            LogFacility.logErrorMessage((IStatus)status);
        }
        return entries.toArray(new java.net.URI[entries.size()]);
    }

    private Element getConfigFileRootElement() {
        if (!this.configurationFileExists()) {
            return null;
        }
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setIgnoringElementContentWhitespace(true);
            docFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            FileInputStream is = new FileInputStream(this.configFileName_);
            Document doc = docBuilder.parse(is);
            is.close();
            Element rootElement = doc.getDocumentElement();
            return rootElement;
        }
        catch (Exception exc) {
            Status status = new Status(4, "com.ibm.adapter.j2ca", 4, exc.getLocalizedMessage() == null ? "" : exc.getLocalizedMessage(), (Throwable)exc);
            LogFacility.logErrorMessage((IStatus)status);
            return null;
        }
    }

    private String getConfigFileName() {
        String fileName = this.connectorProject_.getProject().getLocation().append(SETTINGS_DIR).append(CONFIG_FILE_NAME).toOSString();
        return fileName;
    }

    public boolean copyClasspathEntries(java.net.URI[] classpathEntries) throws BaseException {
        Element rootElement = this.removeExistingCopiedEntries();
        ArrayList<String> entriesAdded = new ArrayList<String>();
        ArrayList<IClasspathEntry> jarsToAdd = new ArrayList<IClasspathEntry>();
        HashSet<IPath> directoriesToAdd = new HashSet<IPath>();
        int i = 0;
        while (i < classpathEntries.length) {
            File jFile = new File(classpathEntries[i]);
            if (jFile.exists()) {
                IPath libaryPath;
                String fileName = jFile.getName();
                Path fp = new Path("connectorModule");
                fp = fp.append(fileName);
                String fileExt = Path.fromOSString((String)jFile.getAbsolutePath()).getFileExtension();
                if ("jar".equalsIgnoreCase(fileExt) || "zip".equalsIgnoreCase(fileExt)) {
                    libaryPath = Path.fromOSString((String)jFile.getAbsolutePath());
                    IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)libaryPath, (IPath)libaryPath, null, (boolean)true);
                    jarsToAdd.add(entry);
                    entriesAdded.add(jFile.getAbsolutePath());
                } else {
                    libaryPath = Path.fromOSString((String)jFile.getAbsolutePath());
                    if (!directoriesToAdd.contains(libaryPath)) {
                        directoriesToAdd.add(libaryPath);
                        String str = libaryPath.toOSString();
                        entriesAdded.add(str);
                    }
                }
            }
            ++i;
        }
        boolean classpathModified = false;
        if (!jarsToAdd.isEmpty()) {
            classpathModified = ProjectUtils.addClasspathEntriesToClassPath(this.connectorProject_, jarsToAdd, null);
        }
        this.serializeCopiedEntries(entriesAdded.toArray(new String[entriesAdded.size()]), rootElement);
        return classpathModified;
    }

    public java.net.URI[] getReferencedClasspathEntries() {
        ArrayList<java.net.URI> entries = new ArrayList<java.net.URI>();
        try {
            Element rootElement = this.getConfigFileRootElement();
            if (rootElement != null) {
                NodeList nodes = rootElement.getElementsByTagNameNS(TARGET_NS, SYSTEM_ENTRY_ELEMENT_NAME);
                int i = 0;
                while (i < nodes.getLength()) {
                    Element elementNode = (Element)nodes.item(i);
                    String absoluteURI = elementNode.getAttribute(URI_ATTRIBUTE_NAME);
                    if (absoluteURI != null && !"".equals(absoluteURI)) {
                        String uriString = URI.createFileURI((String)absoluteURI).toString();
                        java.net.URI aURI = new java.net.URI(uriString);
                        entries.add(aURI);
                    }
                    ++i;
                }
            }
        }
        catch (Exception exc) {
            Status status = new Status(4, "com.ibm.adapter.j2ca", 4, exc.getLocalizedMessage() == null ? "" : exc.getLocalizedMessage(), (Throwable)exc);
            LogFacility.logErrorMessage((IStatus)status);
        }
        return entries.toArray(new java.net.URI[entries.size()]);
    }

    public boolean referenceClasspathEntries(java.net.URI[] classpathEntries) throws BaseException {
        Element rootElement = this.removeExistingReferencedEntries();
        ArrayList<java.net.URI> entriesAdded = new ArrayList<java.net.URI>();
        HashSet<String> directoriesToAdd = new HashSet<String>();
        ArrayList<IClasspathEntry> jarsToAdd = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < classpathEntries.length) {
            File jFile = new File(classpathEntries[i]);
            if (jFile.exists()) {
                String fileExt = Path.fromOSString((String)jFile.getAbsolutePath()).getFileExtension();
                if ("dll".equalsIgnoreCase(fileExt) || "so".equalsIgnoreCase(fileExt)) {
                    directoriesToAdd.add(jFile.getParent());
                } else {
                    IPath libaryPath = Path.fromOSString((String)jFile.getAbsolutePath());
                    IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)libaryPath, (IPath)libaryPath, null, (boolean)true);
                    jarsToAdd.add(entry);
                }
                entriesAdded.add(classpathEntries[i]);
            }
            ++i;
        }
        boolean classpathModified = false;
        if (!jarsToAdd.isEmpty()) {
            classpathModified = ProjectUtils.addClasspathEntriesToClassPath(this.connectorProject_, jarsToAdd, null);
        }
        if (!directoriesToAdd.isEmpty()) {
            this.addDirectoriesToLibraryPath(directoriesToAdd);
        }
        this.serializeReferencedEntries(entriesAdded.toArray(new java.net.URI[entriesAdded.size()]), rootElement);
        return classpathModified;
    }

    private void addDirectoriesToLibraryPath(HashSet<String> directoriesToAdd) {
        if (!directoriesToAdd.isEmpty()) {
            String libPath = System.getProperty(JAVA_LIBRARY_PATH);
            String regex = "[" + this.pathSeparator_ + "]";
            String[] libs = libPath.split(regex);
            ArrayList<String> libraryList = new ArrayList<String>(libs.length);
            int i = 0;
            while (i < libs.length) {
                libraryList.add(libs[i]);
                ++i;
            }
            StringBuffer sb = new StringBuffer();
            for (String element : directoriesToAdd) {
                if (libraryList.contains(element)) continue;
                sb.append(element);
                sb.append(this.pathSeparator_);
            }
            if (libPath != null) {
                sb.append(libPath);
            }
            System.setProperty(JAVA_LIBRARY_PATH, sb.toString());
        }
    }

    private void removeDirectoriesFromLibraryPath(HashSet<String> directoriesToRemove) {
        String libPath = System.getProperty(JAVA_LIBRARY_PATH);
        StringBuffer sb = new StringBuffer();
        String regex = "[" + this.pathSeparator_ + "]";
        String[] libs = libPath.split(regex);
        int i = 0;
        while (i < libs.length) {
            String path = libs[i];
            if (!directoriesToRemove.contains(path) && !"".equals(path)) {
                sb.append(path);
                sb.append(this.pathSeparator_);
            }
            ++i;
        }
        if (sb.charAt(sb.length() - 1) == this.pathSeparator_.charAt(0)) {
            sb.deleteCharAt(sb.length() - 1);
        }
        System.setProperty(JAVA_LIBRARY_PATH, sb.toString());
    }

    private Element removeExistingCopiedEntries() throws BaseException {
        ArrayList<String> entriesToRemove = new ArrayList<String>();
        Element rootElement = this.removeNamedElements(APPLICATION_ENTRY_ELEMENT_NAME, entriesToRemove);
        ArrayList<IClasspathEntry> cpEntriesToRemove = new ArrayList<IClasspathEntry>();
        for (String element : entriesToRemove) {
            Path fp = new Path(element);
            String fileExt = fp.getFileExtension();
            if (element.startsWith("connectorModule")) {
                IFile jarFile = this.connectorProject_.getProject().getFile((IPath)fp);
                fp = jarFile.getFullPath();
            }
            if (!"jar".equalsIgnoreCase(fileExt) && !"zip".equalsIgnoreCase(fileExt)) continue;
            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)fp, (IPath)fp, null, (boolean)true);
            cpEntriesToRemove.add(entry);
        }
        if (!cpEntriesToRemove.isEmpty()) {
            ProjectUtils.removeClasspathEntriesFromClassPath(this.connectorProject_, cpEntriesToRemove);
        }
        return rootElement;
    }

    private Element removeNamedElements(String elementName, ArrayList<String> cpEntriesToRemove) {
        Element rootElement = null;
        rootElement = !this.configurationFileExists() ? this.createNewConfigFile() : this.getConfigFileRootElement();
        if (rootElement != null) {
            NodeList nodes = rootElement.getElementsByTagNameNS(TARGET_NS, elementName);
            ArrayList<Element> nodesToRemove = new ArrayList<Element>();
            int i = 0;
            while (i < nodes.getLength()) {
                nodesToRemove.add((Element)nodes.item(i));
                ++i;
            }
            for (Element element : nodesToRemove) {
                rootElement.removeChild(element);
                String uri = element.getAttribute(URI_ATTRIBUTE_NAME);
                if (uri == null) continue;
                cpEntriesToRemove.add(uri);
            }
            if (cpEntriesToRemove.size() > 0) {
                this.serializeConfigFile(rootElement.getOwnerDocument());
            }
        }
        return rootElement;
    }

    private Element removeExistingReferencedEntries() throws BaseException {
        ArrayList<String> entriesToRemove = new ArrayList<String>();
        Element rootElement = this.removeNamedElements(SYSTEM_ENTRY_ELEMENT_NAME, entriesToRemove);
        ArrayList<IClasspathEntry> cpEntriesToRemove = new ArrayList<IClasspathEntry>();
        HashSet<String> directoriesToRemove = new HashSet<String>();
        for (String uriString : entriesToRemove) {
            java.net.URI aURI = null;
            try {
                uriString = URI.createFileURI((String)uriString).toString();
                aURI = new java.net.URI(uriString);
            }
            catch (URISyntaxException exc) {
                Status status = new Status(4, "com.ibm.adapter.j2ca", 4, exc.getLocalizedMessage() == null ? "" : exc.getLocalizedMessage(), (Throwable)exc);
                LogFacility.logErrorMessage((IStatus)status);
                continue;
            }
            File aFile = new File(aURI);
            if (uriString.endsWith(".dll") || uriString.endsWith(".so")) {
                directoriesToRemove.add(aFile.getParent());
                continue;
            }
            IPath libaryPath = Path.fromOSString((String)aFile.getAbsolutePath());
            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)libaryPath, (IPath)libaryPath, null, (boolean)true);
            cpEntriesToRemove.add(entry);
        }
        if (!cpEntriesToRemove.isEmpty()) {
            ProjectUtils.removeClasspathEntriesFromClassPath(this.connectorProject_, cpEntriesToRemove);
        }
        if (!directoriesToRemove.isEmpty()) {
            this.removeDirectoriesFromLibraryPath(directoriesToRemove);
        }
        return rootElement;
    }

    private Element createNewConfigFile() {
        DocumentBuilder docBuilder;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setIgnoringElementContentWhitespace(true);
        docFactory.setNamespaceAware(true);
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException exc) {
            Status status = new Status(4, "com.ibm.adapter.j2ca", 4, exc.getLocalizedMessage() == null ? "" : exc.getLocalizedMessage(), (Throwable)exc);
            LogFacility.logErrorMessage((IStatus)status);
            return null;
        }
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElementNS(TARGET_NS, CONFIGURATION_ELEMENT_NAME);
        doc.appendChild(rootElement);
        this.serializeConfigFile(doc);
        return rootElement;
    }

    private void serializeCopiedEntries(String[] copiedEntries, Element rootElement) {
        Document doc = rootElement.getOwnerDocument();
        int i = 0;
        while (i < copiedEntries.length) {
            Element element = doc.createElementNS(TARGET_NS, APPLICATION_ENTRY_ELEMENT_NAME);
            File file = new File(copiedEntries[i]);
            element.setAttribute(URI_ATTRIBUTE_NAME, file.getAbsolutePath());
            rootElement.appendChild(element);
            ++i;
        }
        this.serializeConfigFile(doc);
    }

    private void serializeConfigFile(Document doc) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            File configFile = new File(this.configFileName_);
            StreamResult result = new StreamResult(configFile);
            transformer.transform(new DOMSource(doc), result);
            if (result.getOutputStream() != null) {
                result.getOutputStream().close();
            }
        }
        catch (Exception exc) {
            Status status = new Status(4, "com.ibm.adapter.j2ca", 4, exc.getLocalizedMessage() == null ? "" : exc.getLocalizedMessage(), (Throwable)exc);
            LogFacility.logErrorMessage((IStatus)status);
        }
    }

    private void serializeReferencedEntries(java.net.URI[] referencedEntries, Element rootElement) {
        Document doc = rootElement.getOwnerDocument();
        int i = 0;
        while (i < referencedEntries.length) {
            Element element = doc.createElementNS(TARGET_NS, SYSTEM_ENTRY_ELEMENT_NAME);
            File file = new File(referencedEntries[i]);
            element.setAttribute(URI_ATTRIBUTE_NAME, file.getAbsolutePath());
            rootElement.appendChild(element);
            ++i;
        }
        this.serializeConfigFile(doc);
    }

    public void addSystemLibrariesToLibraryPath() {
        if (!this.configurationFileExists()) {
            return;
        }
        HashSet<String> directoriesToAdd = new HashSet<String>();
        java.net.URI[] classpathEntries = this.getReferencedClasspathEntries();
        int i = 0;
        while (i < classpathEntries.length) {
            String fileExt;
            File jFile = new File(classpathEntries[i]);
            if (jFile.exists() && ((fileExt = Path.fromOSString((String)jFile.getAbsolutePath()).getFileExtension()).equalsIgnoreCase("dll") || fileExt.equalsIgnoreCase("so"))) {
                directoriesToAdd.add(jFile.getParent());
            }
            ++i;
        }
        if (!directoriesToAdd.isEmpty()) {
            this.addDirectoriesToLibraryPath(directoriesToAdd);
        }
    }

    private boolean validateContent() {
        File file;
        java.net.URI[] copiedEntries = this.getCopiedClasspathEntries();
        java.net.URI[] referencedEntries = this.getReferencedClasspathEntries();
        int i = 0;
        while (i < referencedEntries.length) {
            try {
                file = new File(referencedEntries[i]);
                if (!file.exists()) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < copiedEntries.length) {
            try {
                file = new File(copiedEntries[i]);
                if (!file.exists()) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

