@setlocal
@echo off
:
: Set the defaults for eclipse_root and workspace
:
IF .%eclipse_root%.==.. set eclipse_root=C:\Program Files\IBM\WebSphere Studio\eclipse
IF .%workspace%.==..    set workspace=%eclipse_root%\workspace

IF .%1.==.. GOTO promptuser

:setOptions
IF .%1.==.-f. (SET import_file=%2) & (SHIFT /1) & (SHIFT /1) & (GOTO setOptions)
IF .%1.==.-s. (SET generation_style=%2) & (SHIFT /1) & (SHIFT /1) & (GOTO setOptions)
IF .%1.==.-d. (SET workspace=%2) & (SHIFT /1) & (SHIFT /1) & (GOTO setOptions)
IF .%1.==.-e. (SET eclipse_root=%2) & (SHIFT /1) & (SHIFT /1) & (GOTO setOptions)
IF NOT .%1.==.. (SHIFT /1) & (GOTO setOptions)

IF .%import_file%.==.. GOTO promptuser
:======================
:Get the console codepage
:======================
FOR /F "tokens=2 delims=/:" %%i in ('chcp') do set currentCodepage=%%i

:======================
:Run the plugin
:======================
echo %~n0 begins...:
"%eclipse_root%\jre\bin\java" -Xmx256M -verify -Dimport.batch.cp="%currentCodepage%" -cp "%eclipse_root%\startup.jar" org.eclipse.core.launcher.Main -clean -data "%workspace%" -application com.ibm.adapter.j2c.command.BatchImport -file=%import_file% -style=%generation_style%
echo %~n0 complete.
goto outtahere

:promptuser
echo Usage: %~n0 -f importFile [-s generationStyle] [-e eclipseRoot] [-d workspace]
echo        importFile: the container file (full file system path is required)
echo     The following are optional, defaults are provided in %0
echo     or in environment variables %%workspace%% and %%eclipse_root%%
echo        generationStyle: 0 = (default)Does not try to match any VAJ generation style
echo                         1 = Match VAJ gen options: Direct, no notification, no inner class, no shorten names, no primitive type arrays
echo                         2 = Match VAJ gen options: Direct, no notification, no inner class, shorten names,    no primitive type arrays
echo        workspace: the name of the workspace directory
echo        eclipseRoot: the base Eclipse directory
:outtahere
endlocal