/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.util;

import com.ibm.adapter.emd.extension.properties.MultiValuedPropertyImpl;
import com.ibm.adapter.emd.extension.properties.PropertyGroupImpl;
import com.ibm.adapter.emd.extension.properties.SingleValuedPropertyImpl;
import com.ibm.adapter.emd.internal.EmdPlugin;
import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.internal.discovery.EMDDescriptor;
import com.ibm.adapter.emd.internal.properties.j2c.ResourceAdapterDescriptorPropertiesImpl;
import com.ibm.adapter.emd.properties.j2c.spi.ResourceAdapterDescriptorProperties;
import com.ibm.adapter.emd.properties.j2c.spi.ResourceAdapterDescriptorPropertiesCustomization;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.internal.build.registry.IBuildConfiguration;
import com.ibm.adapter.framework.registry.Configuration;
import com.ibm.adapter.framework.registry.IRegistry;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.RegistryFactory;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import commonj.connector.metadata.BindingConfigurationEdit;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.build.MetadataType;
import commonj.connector.metadata.description.SchemaDefinition;
import commonj.connector.metadata.discovery.EditableType;
import commonj.connector.metadata.discovery.MetadataEdit;
import commonj.connector.metadata.discovery.connection.InboundConnectionType;
import commonj.connector.metadata.discovery.connection.OutboundConnectionType;
import commonj.connector.metadata.discovery.properties.MultiValuedProperty;
import commonj.connector.metadata.discovery.properties.PropertyGroup;
import commonj.connector.metadata.discovery.properties.SingleValuedProperty;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jst.j2ee.jca.ConfigProperty;
import org.eclipse.osgi.util.NLS;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDResourceImpl;

public class EMDUtil {
    static final IPath UNCLASSIFIED = new Path("UNCLASSIFIED");
    static final IPath[] UNCLASSIFIED_PATH = new IPath[]{UNCLASSIFIED};
    private static final String configurationSuffix = "Configuration";

    public static MetadataType[] getAllMetadataTypes() throws MetadataException {
        ArrayList<MetadataType> mdTypes = new ArrayList<MetadataType>();
        IResourceAdapterDescriptor[] descriptors = null;
        try {
            descriptors = RegistryFactory.getFactory().getAPIResourceAdapterRegistry().getAllResourceAdapters();
        }
        catch (BaseException e) {
            throw new MetadataException(e.getLocalizedMessage());
        }
        int i = 0;
        while (i < descriptors.length) {
            EMDDescriptor emdDescriptor = (EMDDescriptor)descriptors[i].getExtendedData().get("EMD_DESCRIPTOR");
            if (emdDescriptor != null) {
                mdTypes.add(emdDescriptor.getMetadataType());
            }
            ++i;
        }
        return (MetadataType[])mdTypes.toArray();
    }

    public static MetadataType getMetadataType(IResourceAdapterDescriptor descriptior) {
        EMDDescriptor emdDescriptor = (EMDDescriptor)descriptior.getExtendedData().get("EMD_DESCRIPTOR");
        if (emdDescriptor != null) {
            return emdDescriptor.getMetadataType();
        }
        return null;
    }

    public static IResourceAdapterDescriptor getDefiningResourceAdapterDescriptor(String className, int type) throws MetadataException {
        IResourceAdapterDescriptor[] descriptors = null;
        try {
            descriptors = RegistryFactory.getFactory().getAPIResourceAdapterRegistry().getAllResourceAdapters();
        }
        catch (Exception e) {
            throw new MetadataException(e.getLocalizedMessage());
        }
        if (descriptors != null) {
            int i = 0;
            while (i < descriptors.length) {
                IResourceAdapterDescriptor descriptor = descriptors[i];
                switch (type) {
                    case 2: {
                        if (!EMDUtil.containsValue(className, descriptor.getConnectionSpecNames())) break;
                        return descriptor;
                    }
                    case 1: {
                        if (!EMDUtil.containsValue(className, descriptor.getInteractionSpecNames())) break;
                        return descriptor;
                    }
                    case 4: {
                        IResourceAdapterDescriptor.IAdminObjectDescriptor[] adminObjects = descriptor.getAdminObjects();
                        if (adminObjects == null) break;
                        int j = 0;
                        while (j < adminObjects.length) {
                            if (className.equals(adminObjects[j].getImplClassName())) {
                                return descriptor;
                            }
                            ++j;
                        }
                        break;
                    }
                    case 8: {
                        if (!EMDUtil.containsValue(className, descriptor.getManagedConnectionFactoryNames())) break;
                        return descriptor;
                    }
                    case 16: {
                        IResourceAdapterDescriptor.IMessageListenerDescriptor[] messageListeners = descriptor.getMessageListeners();
                        if (messageListeners == null) break;
                        int j = 0;
                        while (j < messageListeners.length) {
                            if (className.equals(messageListeners[j].getActivationSpecName())) {
                                return descriptor;
                            }
                            ++j;
                        }
                        break;
                    }
                    case 32: 
                    case 64: {
                        if (!className.equals(descriptor.getResouceAdapterBeanName())) break;
                        return descriptor;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private static boolean containsValue(String value, String[] values) {
        if (value != null && values != null) {
            int i = 0;
            while (i < values.length) {
                if (values[i] != null && values[i].equals(value)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static PropertyGroup getInteractionSpecTypePropertyGroup(String beanName) throws MetadataException {
        return EMDUtil.getInteractionSpecTypePropertyGroup(beanName, EMDUtil.getDefiningResourceAdapterDescriptor(beanName, 1));
    }

    public static PropertyGroup getConnectionSpecTypePropertyGroup(String beanName) throws MetadataException {
        return EMDUtil.getConnectionSpecTypePropertyGroup(beanName, EMDUtil.getDefiningResourceAdapterDescriptor(beanName, 2));
    }

    public static PropertyGroup getAdministeredObjectTypePropertyGroup(String beanName) throws MetadataException {
        return EMDUtil.getAdministeredObjectTypePropertyGroup(beanName, EMDUtil.getDefiningResourceAdapterDescriptor(beanName, 4));
    }

    public static PropertyGroup getOutboundConnectionTypePropertyGroup(String beanName) throws MetadataException {
        return EMDUtil.getOutboundConnectionTypePropertyGroup(beanName, EMDUtil.getDefiningResourceAdapterDescriptor(beanName, 8));
    }

    public static PropertyGroup getOutboundResourceAdapterPropertyGroup(String raBeanName) throws MetadataException {
        return EMDUtil.getOutboundResourceAdapterPropertyGroup(raBeanName, EMDUtil.getDefiningResourceAdapterDescriptor(raBeanName, 32));
    }

    public static PropertyGroup getInboundConnectionTypePropertyGroup(String beanName) throws MetadataException {
        return EMDUtil.getInboundConnectionTypePropertyGroup(beanName, EMDUtil.getDefiningResourceAdapterDescriptor(beanName, 16));
    }

    public static PropertyGroup getInboundResourceAdapterPropertyGroup(String raBeanName) throws MetadataException {
        return EMDUtil.getInboundResourceAdapterPropertyGroup(raBeanName, EMDUtil.getDefiningResourceAdapterDescriptor(raBeanName, 64));
    }

    public static PropertyGroup getInteractionSpecTypePropertyGroup(String beanName, IResourceAdapterDescriptor resourceAdapter) throws MetadataException {
        PropertyGroup pg = null;
        if (resourceAdapter != null) {
            EMDDescriptor emdDescriptor = (EMDDescriptor)resourceAdapter.getExtendedData().get("EMD_DESCRIPTOR");
            if (emdDescriptor != null && emdDescriptor.getMetadataEdit() != null) {
                EditableType result;
                MetadataEdit metadataEdit = emdDescriptor.getMetadataEdit();
                if (metadataEdit != null && (result = metadataEdit.getInteractionSpecType(beanName)) != null) {
                    pg = result.createProperties();
                }
            } else {
                ResourceAdapterDescriptorPropertiesCustomization customization = ResourceAdapterDescriptorPropertiesCustomization.getInstance();
                ResourceAdapterDescriptorProperties resourceAdapterDescriptorProperties = customization.getResourceAdapterDescriptorProperties(resourceAdapter);
                if (resourceAdapterDescriptorProperties == null) {
                    resourceAdapterDescriptorProperties = new ResourceAdapterDescriptorPropertiesImpl();
                    resourceAdapterDescriptorProperties.setResourceAdapterDescriptor(resourceAdapter);
                }
                return resourceAdapterDescriptorProperties.getInteractionSpecProperties(beanName);
            }
        }
        return pg;
    }

    public static PropertyGroup getConnectionSpecTypePropertyGroup(String beanName, IResourceAdapterDescriptor resourceAdapter) throws MetadataException {
        PropertyGroup pg = null;
        if (resourceAdapter != null) {
            EMDDescriptor emdDescriptor = (EMDDescriptor)resourceAdapter.getExtendedData().get("EMD_DESCRIPTOR");
            if (emdDescriptor != null && emdDescriptor.getMetadataEdit() != null) {
                EditableType result;
                MetadataEdit metadataEdit = emdDescriptor.getMetadataEdit();
                if (metadataEdit != null && (result = metadataEdit.getConnectionSpecType(beanName)) != null) {
                    pg = result.createProperties();
                }
            } else {
                ResourceAdapterDescriptorPropertiesCustomization customization = ResourceAdapterDescriptorPropertiesCustomization.getInstance();
                ResourceAdapterDescriptorProperties resourceAdapterDescriptorProperties = customization.getResourceAdapterDescriptorProperties(resourceAdapter);
                if (resourceAdapterDescriptorProperties == null) {
                    resourceAdapterDescriptorProperties = new ResourceAdapterDescriptorPropertiesImpl();
                    resourceAdapterDescriptorProperties.setResourceAdapterDescriptor(resourceAdapter);
                }
                return resourceAdapterDescriptorProperties.getConnectionSpecProperties(beanName);
            }
        }
        return pg;
    }

    public static PropertyGroup getAdministeredObjectTypePropertyGroup(String beanName, IResourceAdapterDescriptor resourceAdapter) throws MetadataException {
        PropertyGroup pg = null;
        if (resourceAdapter != null) {
            EMDDescriptor emdDescriptor = (EMDDescriptor)resourceAdapter.getExtendedData().get("EMD_DESCRIPTOR");
            if (emdDescriptor != null && emdDescriptor.getMetadataEdit() != null) {
                EditableType result;
                MetadataEdit metadataEdit = emdDescriptor.getMetadataEdit();
                if (metadataEdit != null && (result = metadataEdit.getAdministeredObjectType(beanName)) != null) {
                    pg = result.createProperties();
                }
            } else {
                IResourceAdapterDescriptor.IAdminObjectDescriptor[] adminObjects = resourceAdapter.getAdminObjects();
                int i = 0;
                while (i < adminObjects.length) {
                    if (adminObjects[i].getImplClassName().equals(beanName)) {
                        ResourceAdapterDescriptorPropertiesCustomization customization = ResourceAdapterDescriptorPropertiesCustomization.getInstance();
                        ResourceAdapterDescriptorProperties resourceAdapterDescriptorProperties = customization.getResourceAdapterDescriptorProperties(resourceAdapter);
                        if (resourceAdapterDescriptorProperties == null) {
                            resourceAdapterDescriptorProperties = new ResourceAdapterDescriptorPropertiesImpl();
                            resourceAdapterDescriptorProperties.setResourceAdapterDescriptor(resourceAdapter);
                        }
                        return resourceAdapterDescriptorProperties.getAdminObjectDescriptorProperties(adminObjects[i]);
                    }
                    ++i;
                }
            }
        }
        return pg;
    }

    public static PropertyGroup getOutboundConnectionTypePropertyGroup(String beanName, IResourceAdapterDescriptor resourceAdapter) throws MetadataException {
        return EMDUtil.getOutboundConnectionTypePropertyGroup(beanName, resourceAdapter, true);
    }

    public static PropertyGroup getOutboundConnectionTypePropertyGroup(String beanName, IResourceAdapterDescriptor resourceAdapter, boolean security) throws MetadataException {
        PropertyGroup pg = null;
        if (resourceAdapter != null) {
            EMDDescriptor emdDescriptor = (EMDDescriptor)resourceAdapter.getExtendedData().get("EMD_DESCRIPTOR");
            if (emdDescriptor != null && emdDescriptor.getMetadataEdit() != null) {
                OutboundConnectionType result;
                MetadataEdit metadataEdit = emdDescriptor.getMetadataEdit();
                if (metadataEdit != null && (result = metadataEdit.getOutboundConnectionType(beanName)) != null) {
                    pg = EMDDescriptor.EMD_SPEC_VERSION_1_2.equals(emdDescriptor.getSpecVersion()) ? result.createOutboundConnectionConfiguration().createManagedConnectionFactoryProperties(security) : result.createOutboundConnectionConfiguration().createManagedConnectionFactoryProperties();
                }
            } else {
                ResourceAdapterDescriptorPropertiesCustomization customization = ResourceAdapterDescriptorPropertiesCustomization.getInstance();
                ResourceAdapterDescriptorProperties resourceAdapterDescriptorProperties = customization.getResourceAdapterDescriptorProperties(resourceAdapter);
                if (resourceAdapterDescriptorProperties == null) {
                    resourceAdapterDescriptorProperties = new ResourceAdapterDescriptorPropertiesImpl();
                    resourceAdapterDescriptorProperties.setResourceAdapterDescriptor(resourceAdapter);
                }
                return resourceAdapterDescriptorProperties.getManagedConnectionFactoryProperties(beanName);
            }
        }
        return pg;
    }

    public static PropertyGroup getOutboundResourceAdapterPropertyGroup(String beanName, IResourceAdapterDescriptor resourceAdapter) throws MetadataException {
        PropertyGroup pg = null;
        if (resourceAdapter != null) {
            EMDDescriptor emdDescriptor = (EMDDescriptor)resourceAdapter.getExtendedData().get("EMD_DESCRIPTOR");
            if (emdDescriptor != null && emdDescriptor.getMetadataEdit() != null) {
                OutboundConnectionType result;
                MetadataEdit metadataEdit = emdDescriptor.getMetadataEdit();
                if (metadataEdit != null && (result = metadataEdit.getOutboundConnectionType(beanName)) != null) {
                    pg = result.createOutboundConnectionConfiguration().createResourceAdapterProperties();
                }
            } else {
                ResourceAdapterDescriptorPropertiesCustomization customization = ResourceAdapterDescriptorPropertiesCustomization.getInstance();
                ResourceAdapterDescriptorProperties resourceAdapterDescriptorProperties = customization.getResourceAdapterDescriptorProperties(resourceAdapter);
                if (resourceAdapterDescriptorProperties == null) {
                    resourceAdapterDescriptorProperties = new ResourceAdapterDescriptorPropertiesImpl();
                    resourceAdapterDescriptorProperties.setResourceAdapterDescriptor(resourceAdapter);
                }
                return resourceAdapterDescriptorProperties.getResourceAdapterBeanProperties();
            }
        }
        return pg;
    }

    public static PropertyGroup getInboundConnectionTypePropertyGroup(String beanName, IResourceAdapterDescriptor resourceAdapter) throws MetadataException {
        PropertyGroup pg = null;
        if (resourceAdapter != null) {
            EMDDescriptor emdDescriptor = (EMDDescriptor)resourceAdapter.getExtendedData().get("EMD_DESCRIPTOR");
            if (emdDescriptor != null && emdDescriptor.getMetadataEdit() != null) {
                InboundConnectionType result;
                MetadataEdit metadataEdit = emdDescriptor.getMetadataEdit();
                if (metadataEdit != null && (result = metadataEdit.getInboundConnectionType(beanName)) != null) {
                    pg = result.createInboundConnectionConfiguration().createActivationSpecProperties();
                }
            } else {
                IResourceAdapterDescriptor.IMessageListenerDescriptor[] messageListeners = resourceAdapter.getMessageListeners();
                int i = 0;
                while (i < messageListeners.length) {
                    if (messageListeners[i].getActivationSpecName().equals(beanName)) {
                        ResourceAdapterDescriptorPropertiesCustomization customization = ResourceAdapterDescriptorPropertiesCustomization.getInstance();
                        ResourceAdapterDescriptorProperties resourceAdapterDescriptorProperties = customization.getResourceAdapterDescriptorProperties(resourceAdapter);
                        if (resourceAdapterDescriptorProperties == null) {
                            resourceAdapterDescriptorProperties = new ResourceAdapterDescriptorPropertiesImpl();
                            resourceAdapterDescriptorProperties.setResourceAdapterDescriptor(resourceAdapter);
                        }
                        return resourceAdapterDescriptorProperties.getMessageListenerProperties(messageListeners[i]);
                    }
                    ++i;
                }
            }
        }
        return pg;
    }

    public static PropertyGroup getInboundResourceAdapterPropertyGroup(String asBeanName, IResourceAdapterDescriptor resourceAdapter) throws MetadataException {
        PropertyGroup pg = null;
        if (resourceAdapter != null) {
            EMDDescriptor emdDescriptor = (EMDDescriptor)resourceAdapter.getExtendedData().get("EMD_DESCRIPTOR");
            if (emdDescriptor != null && emdDescriptor.getMetadataEdit() != null) {
                InboundConnectionType result;
                MetadataEdit metadataEdit = emdDescriptor.getMetadataEdit();
                if (metadataEdit != null && (result = metadataEdit.getInboundConnectionType(asBeanName)) != null) {
                    pg = result.createInboundConnectionConfiguration().createResourceAdapterProperties();
                }
            } else {
                ResourceAdapterDescriptorPropertiesCustomization customization = ResourceAdapterDescriptorPropertiesCustomization.getInstance();
                ResourceAdapterDescriptorProperties resourceAdapterDescriptorProperties = customization.getResourceAdapterDescriptorProperties(resourceAdapter);
                if (resourceAdapterDescriptorProperties == null) {
                    resourceAdapterDescriptorProperties = new ResourceAdapterDescriptorPropertiesImpl();
                    resourceAdapterDescriptorProperties.setResourceAdapterDescriptor(resourceAdapter);
                }
                return resourceAdapterDescriptorProperties.getResourceAdapterBeanProperties();
            }
        }
        return pg;
    }

    public static void copyValues(PropertyGroup fromPropertyGroup, PropertyGroup toPropertyGroup) throws MetadataException {
        commonj.connector.metadata.discovery.properties.PropertyDescriptor[] descriptors = fromPropertyGroup.getProperties();
        int i = 0;
        while (i < descriptors.length) {
            commonj.connector.metadata.discovery.properties.PropertyDescriptor descriptor = descriptors[i];
            if (descriptor instanceof PropertyGroup) {
                EMDUtil.copyValues((PropertyGroup)descriptor, toPropertyGroup);
            } else {
                EMDUtil.copyValueToPropertyGroup(descriptor, toPropertyGroup);
            }
            ++i;
        }
    }

    private static void copyValueToPropertyGroup(commonj.connector.metadata.discovery.properties.PropertyDescriptor descriptor, PropertyGroup toPropertyGroup) throws MetadataException {
        commonj.connector.metadata.discovery.properties.PropertyDescriptor[] descriptors = toPropertyGroup.getProperties();
        int i = 0;
        while (i < descriptors.length) {
            commonj.connector.metadata.discovery.properties.PropertyDescriptor toDescriptor = descriptors[i];
            if (toDescriptor.isEnabled()) {
                if (toDescriptor instanceof PropertyGroup) {
                    EMDUtil.copyValueToPropertyGroup(descriptor, (PropertyGroup)toDescriptor);
                } else if (descriptor.getName().equals(toDescriptor.getName())) {
                    if (descriptor instanceof SingleValuedProperty && toDescriptor instanceof SingleValuedProperty) {
                        SingleValuedPropertyImpl singlePropertyFrom = (SingleValuedPropertyImpl)descriptor;
                        SingleValuedPropertyImpl singlePropertyTo = (SingleValuedPropertyImpl)toDescriptor;
                        if (singlePropertyFrom.getPropertyType().getClass() == singlePropertyTo.getPropertyType().getClass()) {
                            singlePropertyTo.setValue(singlePropertyFrom.getValue());
                        }
                    }
                    if (descriptor instanceof MultiValuedProperty && toDescriptor instanceof MultiValuedProperty) {
                        MultiValuedPropertyImpl multiPropertyFrom = (MultiValuedPropertyImpl)descriptor;
                        MultiValuedPropertyImpl multiPropertyTo = (MultiValuedPropertyImpl)toDescriptor;
                        Object[] objects = multiPropertyFrom.getValues();
                        int j = 0;
                        while (j < objects.length) {
                            multiPropertyTo.addValue(objects[j]);
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
    }

    public static void synchronizeFromBeanToPropertyGroup(Object bean, PropertyGroup propertyGroup) throws MetadataException {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] beanProperties = beanInfo.getPropertyDescriptors();
            int i = 0;
            while (i < beanProperties.length) {
                if (beanProperties[i].getReadMethod() != null && beanProperties[i].getWriteMethod() != null) {
                    String propertyName = beanProperties[i].getName();
                    commonj.connector.metadata.discovery.properties.PropertyDescriptor propertyDescriptor = propertyGroup.getProperty(propertyName);
                    if (propertyDescriptor == null) {
                        propertyDescriptor = propertyGroup.getProperty(EMDUtil.reverseCasing(propertyName));
                    }
                    if ((propertyDescriptor == null || propertyDescriptor.isEnabled()) && propertyDescriptor instanceof SingleValuedProperty) {
                        SingleValuedProperty property = (SingleValuedProperty)propertyDescriptor;
                        Object obj = beanProperties[i].getReadMethod().invoke(bean, new Object[0]);
                        if (obj != null) {
                            property.setValue(obj);
                        }
                    }
                }
                ++i;
            }
            commonj.connector.metadata.discovery.properties.PropertyDescriptor[] descriptors = propertyGroup.getProperties();
            int i2 = 0;
            while (i2 < descriptors.length) {
                commonj.connector.metadata.discovery.properties.PropertyDescriptor descriptor = descriptors[i2];
                if (descriptor instanceof PropertyGroup) {
                    EMDUtil.synchronizeFromBeanToPropertyGroup(bean, (PropertyGroup)descriptor);
                }
                ++i2;
            }
        }
        catch (Exception e) {
            String msg = NLS.bind((String)MessageResource.MSG_ERROR_UNABLE_TO_COPY_FROM_JAVA_BEAN_TO_PROPERTY_GROUP, (Object)bean.getClass().getName());
            throw new MetadataException(msg, (Throwable)e);
        }
    }

    public static Object getBean(Object bean, PropertyGroup propertyGroup) throws MetadataException {
        String propertyName = null;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            int i = 0;
            while (i < propertyDescriptors.length) {
                if (propertyDescriptors[i].getReadMethod() != null && propertyDescriptors[i].getWriteMethod() != null) {
                    propertyName = propertyDescriptors[i].getName();
                    SingleValuedProperty property = (SingleValuedProperty)propertyGroup.getProperty(propertyName);
                    if (property == null) {
                        property = (SingleValuedProperty)propertyGroup.getProperty(EMDUtil.reverseCasing(propertyName));
                    }
                    if (property != null) {
                        if (!property.isSet()) {
                            Object defaultValue = property.getPropertyType().getDefaultValue();
                            try {
                                propertyDescriptors[i].getWriteMethod().invoke(bean, defaultValue);
                            }
                            catch (Exception exception) {}
                        } else {
                            Object value = property.getValue();
                            propertyDescriptors[i].getWriteMethod().invoke(bean, value);
                        }
                    }
                }
                ++i;
            }
            commonj.connector.metadata.discovery.properties.PropertyDescriptor[] descriptors = propertyGroup.getProperties();
            int i2 = 0;
            while (i2 < descriptors.length) {
                commonj.connector.metadata.discovery.properties.PropertyDescriptor descriptor = descriptors[i2];
                if (descriptor instanceof PropertyGroup) {
                    EMDUtil.getBean(bean, (PropertyGroup)descriptor);
                }
                ++i2;
            }
        }
        catch (Exception e) {
            String msg = NLS.bind((String)MessageResource.MSG_ERROR_UNABLE_TO_COPY_FROM_PROPERTY_GROUP_TO_JAVA_BEAN, propertyName, (Object)bean.getClass().getName());
            throw new MetadataException(msg, (Throwable)e);
        }
        return bean;
    }

    public static Object getBeanPropertyDefaultValue(Object bean, String propertyName) {
        Status status;
        PropertyDescriptor[] beanProperties;
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(bean.getClass());
            beanProperties = beanInfo.getPropertyDescriptors();
            int i = 0;
            while (i < beanProperties.length) {
                if (beanProperties[i].getReadMethod() != null && beanProperties[i].getWriteMethod() != null && beanProperties[i].getName().equalsIgnoreCase(propertyName)) {
                    return beanProperties[i].getReadMethod().invoke(bean, new Object[0]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            status = new Status(4, "com.ibm.adapter.emd", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
            ILog logger = EmdPlugin.getDefault().getLog();
            logger.log((IStatus)status);
        }
        try {
            beanInfo = Introspector.getBeanInfo(bean.getClass(), 3);
            beanProperties = beanInfo.getPropertyDescriptors();
            int i = 0;
            while (i < beanProperties.length) {
                if (beanProperties[i].getReadMethod() != null && beanProperties[i].getWriteMethod() != null && beanProperties[i].getName().equalsIgnoreCase(propertyName)) {
                    return beanProperties[i].getReadMethod().invoke(bean, new Object[0]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            status = new Status(4, "com.ibm.adapter.emd", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
            ILog logger = EmdPlugin.getDefault().getLog();
            logger.log((IStatus)status);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static PropertyGroup createPropertyGroupFromConfigElements(String className, List configProperties, ClassLoader classLoader) {
        block30: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                propertyGroup = new PropertyGroupImpl(className);
            }
            catch (MetadataException e1) {
                LogFacility.logErrorMessage((String)MessageResource.MSG_ERROR__RA_PROPS, (Throwable)e1);
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
                return null;
            }
            if (configProperties == null) break block30;
            propertyDescriptors = new ArrayList<SingleValuedPropertyImpl>(configProperties.size());
            i = configProperties.iterator();
            bean = null;
            try {
                beanClass = classLoader.loadClass(className);
                bean = beanClass.newInstance();
                if (true) ** GOTO lbl68
            }
            catch (Exception e) {
                status = new Status(4, "com.ibm.adapter.emd", 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
                logger = EmdPlugin.getDefault().getLog();
                logger.log((IStatus)status);
                return null;
            }
            do {
                property = (ConfigProperty)i.next();
                try {
                    propertyTypeClass = classLoader.loadClass(property.getType());
                    propertyDescriptor = new SingleValuedPropertyImpl(property.getName(), propertyTypeClass);
                    propertyDescriptor.setDescription(property.getDescription());
                    propertyGroup.addProperty(propertyDescriptor);
                    value = EMDUtil.getBeanPropertyDefaultValue(bean, property.getName());
                    if (value != null) {
                        defaultValue = value.toString();
                        if (propertyTypeClass.equals(String.class)) {
                            propertyDescriptor.setDefaultValue(defaultValue);
                        }
                        if (defaultValue.length() > 0) {
                            if (propertyTypeClass.equals(Integer.class)) {
                                propertyDescriptor.setDefaultValue(new Integer(defaultValue));
                            } else if (propertyTypeClass.equals(Boolean.class)) {
                                propertyDescriptor.setDefaultValue(new Boolean(defaultValue));
                            } else if (propertyTypeClass.equals(Byte.class)) {
                                propertyDescriptor.setDefaultValue(new Byte(defaultValue));
                            } else if (propertyTypeClass.equals(Character.class)) {
                                propertyDescriptor.setDefaultValue(new Character(defaultValue.charAt(0)));
                            } else if (propertyTypeClass.equals(Double.class)) {
                                propertyDescriptor.setDefaultValue(new Double(defaultValue));
                            } else if (propertyTypeClass.equals(Float.class)) {
                                propertyDescriptor.setDefaultValue(new Float(defaultValue));
                            } else if (propertyTypeClass.equals(Long.class)) {
                                propertyDescriptor.setDefaultValue(new Long(defaultValue));
                            } else if (propertyTypeClass.equals(Short.class)) {
                                propertyDescriptor.setDefaultValue(new Short(defaultValue));
                            }
                        }
                    }
                    propertyDescriptors.add(propertyDescriptor);
                }
                catch (ClassNotFoundException e) {
                    LogFacility.logErrorMessage((String)MessageResource.MSG_ERROR__RA_PROPS, (Throwable)e);
                }
                catch (MetadataException e2) {
                    LogFacility.logErrorMessage((String)MessageResource.MSG_ERROR__RA_PROPS, (Throwable)e2);
                }
lbl68:
                // 4 sources

            } while (i.hasNext());
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
            return propertyGroup;
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return null;
    }

    private static String reverseCasing(String str) {
        int firstChar = UTF16.charAt((String)str, (int)0);
        firstChar = UCharacter.isLowerCase((int)firstChar) ? UCharacter.toUpperCase((int)firstChar) : UCharacter.toLowerCase((int)firstChar);
        return String.valueOf(UCharacter.toString((int)firstChar)) + str.substring(1);
    }

    public static Configuration[] getSupportedDataConfigurations(IResourceAdapterDescriptor resourceAdapter, IPath[] classifiers, boolean exactMatch) {
        ResourceAdapterDescriptorPropertiesImpl resourceAdapterDescriptorProperties = new ResourceAdapterDescriptorPropertiesImpl();
        resourceAdapterDescriptorProperties.setResourceAdapterDescriptor(resourceAdapter);
        Configuration[] supportedConfigurations = resourceAdapterDescriptorProperties.getSupportedDataConfigurations();
        ArrayList<Configuration> desiredConfigurations = new ArrayList<Configuration>();
        if (supportedConfigurations != null) {
            if (classifiers == null) {
                classifiers = UNCLASSIFIED_PATH;
            }
            int i = 0;
            while (i < supportedConfigurations.length) {
                boolean found = true;
                Configuration c = supportedConfigurations[i];
                int filtersIndex = classifiers.length;
                while (--filtersIndex >= 0 && found) {
                    if (c.containsClassifier(classifiers[filtersIndex], exactMatch)) continue;
                    found = false;
                    break;
                }
                if (found) {
                    desiredConfigurations.add(c);
                }
                ++i;
            }
        }
        if (!desiredConfigurations.isEmpty()) {
            return desiredConfigurations.toArray(new Configuration[0]);
        }
        return null;
    }

    public static Configuration[] getAllSupportedConfigurations(IResourceAdapterDescriptor resourceAdapter) {
        IRegistry registry = com.ibm.adapter.framework.registry.RegistryFactory.getFactory().getRegistry();
        registry.waitForRegistryProcessing();
        try {
            Configuration[] registeredConfigurations = registry.getAllConfigurations();
            ArrayList<Configuration> supportedConfigurations = new ArrayList<Configuration>();
            if (registeredConfigurations != null) {
                int i = 0;
                while (i < registeredConfigurations.length) {
                    if (resourceAdapter.hasDiscoveryAgent() && !(registeredConfigurations[i] instanceof IBuildConfiguration) && registeredConfigurations[i].createDiscoveryAgent().equals(resourceAdapter.getDiscoveryAgent())) {
                        supportedConfigurations.add(registeredConfigurations[i]);
                    }
                    ++i;
                }
            }
            if (!supportedConfigurations.isEmpty()) {
                return supportedConfigurations.toArray(new Configuration[0]);
            }
        }
        catch (BaseException baseException) {}
        return null;
    }

    public static Configuration[] getAllSupportedConfigurations(IResourceAdapterDescriptor resourceAdapter, IPath[] classifiers, boolean exactMatch) {
        IRegistry registry = com.ibm.adapter.framework.registry.RegistryFactory.getFactory().getRegistry();
        registry.waitForRegistryProcessing();
        try {
            Configuration[] registeredConfigurations = registry.getAllConfigurations(classifiers, exactMatch);
            ArrayList<Configuration> supportedConfigurations = new ArrayList<Configuration>();
            if (registeredConfigurations != null) {
                int i = 0;
                while (i < registeredConfigurations.length) {
                    if (resourceAdapter.hasDiscoveryAgent() && !(registeredConfigurations[i] instanceof IBuildConfiguration) && registeredConfigurations[i].createDiscoveryAgent().equals(resourceAdapter.getDiscoveryAgent())) {
                        supportedConfigurations.add(registeredConfigurations[i]);
                    }
                    ++i;
                }
            }
            if (!supportedConfigurations.isEmpty()) {
                return supportedConfigurations.toArray(new Configuration[0]);
            }
        }
        catch (BaseException baseException) {}
        return null;
    }

    public static List getBeanValidProperties(Object changedBean) {
        return EMDUtil.getBeanValidProperties(changedBean, 1);
    }

    public static List getBeanValidProperties(Object changedBean, int control) {
        ArrayList<BeanProperty> list = new ArrayList<BeanProperty>();
        try {
            Object defaultBean = changedBean.getClass().newInstance();
            BeanInfo bi = Introspector.getBeanInfo(changedBean.getClass(), control);
            PropertyDescriptor[] descriptor = bi.getPropertyDescriptors();
            int i = 0;
            while (i < descriptor.length) {
                Class<?> propertyType;
                if (descriptor[i].getReadMethod() != null && descriptor[i].getWriteMethod() != null && (propertyType = descriptor[i].getPropertyType()) != null && (propertyType.isPrimitive() || propertyType.equals(String.class) || propertyType.equals(Integer.class) || propertyType.equals(Boolean.class) || propertyType.equals(Byte.class) || propertyType.equals(Character.class) || propertyType.equals(Double.class) || propertyType.equals(Float.class) || propertyType.equals(Long.class) || propertyType.equals(Short.class))) {
                    boolean isSet = false;
                    String propertyName = descriptor[i].getName();
                    Method method = descriptor[i].getReadMethod();
                    Object changedValue = method.invoke(changedBean, null);
                    Object defaultValue = method.invoke(defaultBean, null);
                    if (changedValue != null) {
                        if (!changedValue.equals(defaultValue)) {
                            isSet = true;
                        }
                    } else if (defaultValue != null) {
                        isSet = true;
                    }
                    BeanProperty bp = new BeanProperty(propertyName, propertyType, isSet ? changedValue : defaultValue, isSet);
                    list.add(bp);
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
        }
        return list;
    }

    public static String getEMDSpecVersion(IResourceAdapterDescriptor descriptor) {
        EMDDescriptor emdDescriptor;
        if (descriptor != null && (emdDescriptor = (EMDDescriptor)descriptor.getExtendedData().get("EMD_DESCRIPTOR")) != null) {
            return emdDescriptor.getSpecVersion();
        }
        return null;
    }

    public static SchemaDefinition getSchemaDefinitionContainingType(QName xsdQName, SchemaDefinition[] schemaDefinitions) {
        SchemaDefinition foundSchemaDefinition = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        if (xsdQName != null && schemaDefinitions != null) {
            int i = 0;
            while (i < schemaDefinitions.length) {
                boolean found;
                block8: {
                    java.net.URI uri = schemaDefinitions[i].getLocation();
                    found = false;
                    if (uri != null) {
                        URI emfURI = URI.createURI((String)uri.toString());
                        Resource res = resourceSet.getResource(emfURI, true);
                        try {
                            XSDResourceImpl xsdResource = (XSDResourceImpl)res;
                            XSDSchema schema = xsdResource.getSchema();
                            if (schema == null || !schema.getTargetNamespace().equals(xsdQName.getNamespaceURI())) break block8;
                            EList globalElements = schema.getElementDeclarations();
                            for (XSDElementDeclaration declaration : globalElements) {
                                if (!declaration.getName().equals(xsdQName.getLocalPart())) continue;
                                found = true;
                                break;
                            }
                            EList globalTypes = schema.getTypeDefinitions();
                            for (XSDTypeDefinition definition : globalTypes) {
                                if (!definition.getName().equals(xsdQName.getLocalPart())) continue;
                                found = true;
                                break;
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                if (found) {
                    foundSchemaDefinition = schemaDefinitions[i];
                    break;
                }
                ++i;
            }
        }
        return foundSchemaDefinition;
    }

    public static boolean isConfigurationOptional(ClassLoader classLoader, String bindingName) throws Exception {
        String configurationClassName = String.valueOf(bindingName) + configurationSuffix;
        Class<?> configurationClass = classLoader.loadClass(configurationClassName);
        BindingConfigurationEdit configurationEdit = (BindingConfigurationEdit)configurationClass.newInstance();
        return configurationEdit.isOptional();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isType(QName xsdQName, SchemaDefinition[] schemaDefinitions) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        if (xsdQName != null && schemaDefinitions != null) {
            int i = 0;
            while (i < schemaDefinitions.length) {
                java.net.URI uri = schemaDefinitions[i].getLocation();
                if (uri != null) {
                    URI emfURI = URI.createURI((String)uri.toString());
                    Resource res = resourceSet.getResource(emfURI, true);
                    try {
                        XSDResourceImpl xsdResource = (XSDResourceImpl)res;
                        XSDSchema schema = xsdResource.getSchema();
                        if (schema != null && schema.getTargetNamespace().equals(xsdQName.getNamespaceURI())) {
                            EList globalTypes = schema.getTypeDefinitions();
                            for (XSDTypeDefinition definition : globalTypes) {
                                if (!definition.getName().equals(xsdQName.getLocalPart())) continue;
                                return true;
                            }
                            EList globalElements = schema.getElementDeclarations();
                            for (XSDElementDeclaration declaration : globalElements) {
                                if (!declaration.getName().equals(xsdQName.getLocalPart())) continue;
                                return false;
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
        }
        return true;
    }

    public static class BeanProperty {
        String propertyName;
        Class propertyType;
        Object propertyValue;
        boolean isSet;

        public BeanProperty(String propertyName, Class propertyType, Object propertyValue, boolean isSet) {
            this.propertyName = propertyName;
            this.propertyType = propertyType;
            this.propertyValue = propertyValue;
            this.isSet = isSet;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Class getPropertyType() {
            return this.propertyType;
        }

        public Object getPropertyValue() {
            return this.propertyValue;
        }

        public boolean isSet() {
            return this.isSet;
        }
    }
}

