/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.properties;

import com.ibm.adapter.emd.internal.discovery.MessageUtil;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.IVetoableChangeListener;
import com.ibm.propertygroup.spi.PropertyVetoException;
import com.ibm.propertygroup.spi.common.FileProperty;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;

public class LogFileProperty
extends FileProperty
implements IVetoableChangeListener {
    public static final String LOG_FILE_LOCATION = "logFileLocation";
    public static final String LOG_FILE_EXTENSION = "log";
    private MessageUtil messageUtil;

    public LogFileProperty(String loggingFileName, MessageUtil messageUtil) throws CoreException {
        this(loggingFileName, null, messageUtil);
    }

    public LogFileProperty(String loggingFileName, BasePropertyGroup parentGroup, MessageUtil messageUtil) throws CoreException {
        super(LOG_FILE_LOCATION, messageUtil.getMessage("LOG_FILE_DISPLAY_NAME"), messageUtil.getMessage("LOG_FILE_DESCRIPTION"), parentGroup, new String[]{LOG_FILE_EXTENSION}, false);
        this.messageUtil = messageUtil;
        this.addVetoablePropertyChangeListener(this);
        String className = loggingFileName;
        int index = className.lastIndexOf(46);
        if (index > 0) {
            className = className.substring(index + 1);
        }
        String defaultLogFileLocation = Platform.getLogFileLocation().removeLastSegments(1).append(String.valueOf(className) + ".log").toOSString();
        this.setDefaultValue(URI.createFileURI((String)defaultLogFileLocation));
        this.setValue(this.getPropertyType().getDefaultValue());
        this.setExpert(false);
        this.setEnabled(true);
        this.setRequired(true);
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (evt.getNewValue() != null) {
            URI uri = (URI)evt.getNewValue();
            File f = new File(uri.toFileString());
            boolean created = false;
            try {
                created = f.createNewFile();
            }
            catch (IOException iOException) {
                throw new PropertyVetoException(this.messageUtil.getMessage("MSG_ERROR_CANNOT_WRITE_LOG_FILE"), (java.beans.PropertyChangeEvent)evt);
            }
            boolean canWrite = f.canWrite();
            if (created) {
                f.delete();
            }
            if (!canWrite) {
                throw new PropertyVetoException(this.messageUtil.getMessage("MSG_ERROR_CANNOT_WRITE_LOG_FILE"), (java.beans.PropertyChangeEvent)evt);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        LogFileProperty clone = (LogFileProperty)((Object)super.clone());
        clone.addVetoablePropertyChangeListener(clone);
        return clone;
    }
}

