/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.properties;

import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.discovery.EMDDescriptor;
import com.ibm.adapter.emd.internal.discovery.MessageUtil;
import com.ibm.adapter.emd.internal.properties.AdapterTypeConnectionTypePropertyGroup;
import com.ibm.adapter.emd.internal.properties.BuildServiceLevelPropertyGroup;
import com.ibm.adapter.emd.internal.properties.ConnectionTypeProperty;
import com.ibm.adapter.emd.internal.properties.JNDITargetProperty;
import com.ibm.adapter.emd.internal.properties.LogFileProperty;
import com.ibm.adapter.emd.internal.properties.LoggingLevelProperty;
import com.ibm.adapter.emd.properties.wrapper.PropertyGroupWrapper;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import commonj.connector.metadata.build.MetadataBuild;
import commonj.connector.metadata.discovery.connection.ConnectionConfiguration;
import commonj.connector.metadata.discovery.connection.ConnectionType;
import commonj.connector.metadata.discovery.connection.InboundConnectionType;
import commonj.connector.metadata.discovery.connection.OutboundConnectionType;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;

public class BuildConnectionPropertyGroup
extends BasePropertyGroup {
    public static final String CONNECTION_PROPERTY_GROUP = "Configuration Properties";
    public static final String CONNECTION_CONFIGURATION_PROPERTIES = "connectionProperties";
    public static final String CONNECTION_CHOICE = "ConnectionChoice";
    public static final String DEPLOY_CONNECTOR_PROJECT = "DeployConnectorProject";
    public static final String SERVICE_LEVEL_PROPERTY_GROUP = "ServiceLevelPG";
    private static final String LOGGING_CHOICE = "LOGGING_CHOICE";
    private AdapterTypeConnectionTypePropertyGroup adapterTypeConnectionTypePG = null;
    private PropertyGroupWrapper connectionConfigurationProperties = null;
    private ConnectionConfiguration connectionConfiguration;
    private JNDITargetProperty jndiTargetProperty = null;
    private BaseSingleValuedProperty connectionChoice;
    private MetadataBuild build;
    boolean isOutboundFlow = true;
    private IPropertyChangeListener metadataBuildConnectionTypeSetterListener = new MetadataBuildConnectionTypeSetter();
    private BaseSingleValuedProperty deployConnectorProjectChoice;
    private BaseSingleValuedProperty loggingChoiceProperty = null;
    private LogFileProperty logFileProperty = null;
    private LoggingLevelProperty loggingLevelProperty = null;
    private MessageUtil messageUtil;
    private BuildServiceLevelPropertyGroup serviceLevelPG = null;

    public BuildConnectionPropertyGroup(String groupName, String displayName, String groupDescription, final EMDDescriptor emdDescriptor, boolean isOutboundFlow, MessageUtil messageUtil) throws CoreException {
        super(groupName, displayName, groupDescription);
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        this.build = emdDescriptor.getMetadataBuild();
        this.messageUtil = messageUtil;
        this.isOutboundFlow = isOutboundFlow;
        this.adapterTypeConnectionTypePG = new AdapterTypeConnectionTypePropertyGroup(this.build, isOutboundFlow, messageUtil);
        this.addProperty((IPropertyDescriptor)this.adapterTypeConnectionTypePG);
        this.deployConnectorProjectChoice = new BaseSingleValuedProperty(DEPLOY_CONNECTOR_PROJECT, messageUtil.getMessage("DEPLOY_CONNECTOR_PROJECT_DISPLAY_NAME"), messageUtil.getMessage("DEPLOY_CONNECTOR_PROJECT_DESCRIPTION"), String.class, (BasePropertyGroup)this);
        this.deployConnectorProjectChoice.setValidValues((Object[])new String[]{messageUtil.getMessage("DEPLOY_CONNECTOR_PROJECT_WITH_MODULE"), messageUtil.getMessage("DEPLOY_CONNECTOR_PROJECT_ON_SERVER")});
        this.deployConnectorProjectChoice.setValidValuesEditable(false);
        this.deployConnectorProjectChoice.addPropertyChangeListener((IPropertyChangeListener)this);
        this.connectionChoice = new BaseSingleValuedProperty(CONNECTION_CHOICE, messageUtil.getMessage("CONNECTION_CHOICE_DISP_NAME"), messageUtil.getMessage("CONFIGURATION_PROPERTIES_DESCRIPTION"), String.class, (BasePropertyGroup)this);
        this.connectionChoice.setValidValues((Object[])new String[]{messageUtil.getMessage("CONNECTION_CHOICE_CREATE_CONNECTION_PROPERTIES"), messageUtil.getMessage("CONNECTION_CHOICE_USE_PREDEFINED_CONNECTION")});
        this.connectionChoice.setValidValuesEditable(false);
        this.connectionChoice.addPropertyChangeListener((IPropertyChangeListener)this);
        this.jndiTargetProperty = new JNDITargetProperty(this, messageUtil.getMessage("JNDI_TARGET_PROPERTY_DISPLAY_NAME"), isOutboundFlow ? messageUtil.getMessage("JNDI_TARGET_PROPERTY_MCF_DESCRIPTION") : messageUtil.getMessage("JNDI_TARGET_PROPERTY_AS_DESCRIPTION"));
        this.connectionConfigurationProperties = new PropertyGroupWrapper(CONNECTION_CONFIGURATION_PROPERTIES, messageUtil.getMessage("CONNECTION_PROPS_DISPLAY_NAME"), messageUtil.getMessage("CONNECTION_PROPS_DESCRIPTION"), emdDescriptor.getSpecVersion()){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() instanceof ConnectionTypeProperty && evt.getPropertyChangeType() == 0 && evt.getNewValue() != null) {
                    this.removeAll();
                    this.setEnabled(true);
                    if (BuildConnectionPropertyGroup.this.isOutboundFlow()) {
                        BuildConnectionPropertyGroup.this.connectionConfiguration = (ConnectionConfiguration)((OutboundConnectionType)evt.getNewValue()).createOutboundConnectionConfiguration();
                    } else {
                        BuildConnectionPropertyGroup.this.connectionConfiguration = (ConnectionConfiguration)((InboundConnectionType)evt.getNewValue()).createInboundConnectionConfiguration();
                    }
                    if (emdDescriptor.getSpecVersion().equals(EMDDescriptor.EMD_SPEC_VERSION_1_2)) {
                        try {
                            this.addPropertiesToPropertyGroup(BuildConnectionPropertyGroup.this.connectionConfiguration.createUnifiedProperties(false));
                        }
                        catch (AbstractMethodError abstractMethodError) {
                            this.addPropertiesToPropertyGroup(BuildConnectionPropertyGroup.this.connectionConfiguration.createUnifiedProperties());
                        }
                    } else {
                        this.addPropertiesToPropertyGroup(BuildConnectionPropertyGroup.this.connectionConfiguration.createUnifiedProperties());
                    }
                }
            }
        };
        this.connectionConfigurationProperties.setEnabled(false);
        this.connectionConfigurationProperties.assignID("com.ibm.propertygroup.ui.PropertyUINestedLayoutID");
        this.addProperty((IPropertyDescriptor)this.connectionConfigurationProperties);
        this.adapterTypeConnectionTypePG.addPropertyChangeListener(this.metadataBuildConnectionTypeSetterListener);
        this.adapterTypeConnectionTypePG.addPropertyChangeListener((IPropertyChangeListener)this.connectionConfigurationProperties);
        this.adapterTypeConnectionTypePG.adapterTypeProperty.setValue(this.adapterTypeConnectionTypePG.adapterTypeProperty.getPropertyType().getDefaultValue());
        if (this.connectionConfiguration == null) {
            ConnectionType ct = (ConnectionType)this.adapterTypeConnectionTypePG.connectionTypeProperty.getPropertyType().getDefaultValue();
            this.connectionConfiguration = this.isOutboundFlow() ? ((OutboundConnectionType)ct).createOutboundConnectionConfiguration() : ((InboundConnectionType)ct).createInboundConnectionConfiguration();
        }
        this.serviceLevelPG = new BuildServiceLevelPropertyGroup(SERVICE_LEVEL_PROPERTY_GROUP, messageUtil.getMessage("SERVICE_LEVEL_DISPLAY_NAME"), null, emdDescriptor, isOutboundFlow, messageUtil, this.connectionConfiguration);
        this.addProperty((IPropertyDescriptor)this.serviceLevelPG);
        if (!this.isOutboundFlow()) {
            this.adapterTypeConnectionTypePG.addPropertyChangeListener(this.serviceLevelPG.listenerUpdaterListener);
        }
        MetadataBuildContext c = new MetadataBuildContext();
        c.defaultDataBindingClassName = emdDescriptor.getMetadataBuild().getDefaultDataBinding();
        c.defaultFunctionSelectorClassName = emdDescriptor.getMetadataBuild().getDefaultFunctionSelector();
        this.setPropertyGroupContext(new Object[]{emdDescriptor.getConnectorProject(), c});
        this.loggingChoiceProperty = new BaseSingleValuedProperty(LOGGING_CHOICE, messageUtil.getMessage("LOG_LEVEL_DESCRIPTION"), messageUtil.getMessage("LOG_LEVEL_DESCRIPTION"), Boolean.class, (BasePropertyGroup)this);
        this.loggingChoiceProperty.setDefaultValue((Object)Boolean.FALSE);
        this.loggingChoiceProperty.setValue((Object)Boolean.FALSE);
        this.loggingChoiceProperty.addPropertyChangeListener((IPropertyChangeListener)this);
        this.logFileProperty = new LogFileProperty(this.build.getClass().getName(), messageUtil);
        this.loggingLevelProperty = new LoggingLevelProperty(messageUtil);
        this.adapterTypeConnectionTypePG.adapterTypeProperty.setValue(null);
        this.adapterTypeConnectionTypePG.adapterTypeProperty.setValue(this.adapterTypeConnectionTypePG.adapterTypeProperty.getPropertyType().getDefaultValue());
        this.connectionChoice.setValue((Object)messageUtil.getMessage("CONNECTION_CHOICE_CREATE_CONNECTION_PROPERTIES"));
        this.deployConnectorProjectChoice.setValue((Object)messageUtil.getMessage("DEPLOY_CONNECTOR_PROJECT_WITH_MODULE"));
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            BuildConnectionPropertyGroup clone = (BuildConnectionPropertyGroup)((Object)super.clone());
            clone.adapterTypeConnectionTypePG = (AdapterTypeConnectionTypePropertyGroup)clone.getProperty("adapterTypePG");
            clone.connectionConfigurationProperties = (PropertyGroupWrapper)clone.getProperty(CONNECTION_CONFIGURATION_PROPERTIES);
            clone.connectionChoice = (BaseSingleValuedProperty)clone.getProperty(CONNECTION_CHOICE);
            clone.deployConnectorProjectChoice = (BaseSingleValuedProperty)clone.getProperty(DEPLOY_CONNECTOR_PROJECT);
            clone.jndiTargetProperty = (JNDITargetProperty)clone.getProperty(JNDITargetProperty.JNDI_TARGET_PROPERTY_NAME) != null ? (JNDITargetProperty)clone.getProperty(JNDITargetProperty.JNDI_TARGET_PROPERTY_NAME) : (JNDITargetProperty)((Object)this.jndiTargetProperty.clone());
            clone.serviceLevelPG = (BuildServiceLevelPropertyGroup)clone.getProperty(SERVICE_LEVEL_PROPERTY_GROUP);
            clone.loggingChoiceProperty = (BaseSingleValuedProperty)clone.getProperty(LOGGING_CHOICE);
            clone.logFileProperty = (LogFileProperty)clone.getProperty("logFileLocation");
            if (clone.logFileProperty == null) {
                clone.logFileProperty = new LogFileProperty(this.build.getClass().getName(), this.messageUtil);
            }
            clone.loggingLevelProperty = (LoggingLevelProperty)clone.getProperty("loggingLevel");
            if (clone.loggingLevelProperty == null) {
                clone.loggingLevelProperty = new LoggingLevelProperty(this.messageUtil);
            }
            clone.metadataBuildConnectionTypeSetterListener = new MetadataBuildConnectionTypeSetter();
            clone.adapterTypeConnectionTypePG.addPropertyChangeListener(clone.metadataBuildConnectionTypeSetterListener);
            if (!this.isOutboundFlow) {
                clone.adapterTypeConnectionTypePG.addPropertyChangeListener(clone.serviceLevelPG.listenerUpdaterListener);
            }
            clone.adapterTypeConnectionTypePG.addPropertyChangeListener((IPropertyChangeListener)clone.connectionConfigurationProperties);
            clone.connectionChoice.addPropertyChangeListener((IPropertyChangeListener)clone);
            clone.loggingChoiceProperty.addPropertyChangeListener((IPropertyChangeListener)clone);
            clone.deployConnectorProjectChoice.addPropertyChangeListener((IPropertyChangeListener)clone);
            clone.deployConnectorProjectChoice.setValue((Object)this.messageUtil.getMessage("DEPLOY_CONNECTOR_PROJECT_WITH_MODULE"));
            return clone;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    private boolean isOutboundFlow() {
        return this.isOutboundFlow;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyChangeType() == 0) {
            if (evt.getSource() == this.loggingChoiceProperty) {
                Boolean choice = (Boolean)evt.getNewValue();
                if (choice.booleanValue()) {
                    this.addProperty((IPropertyDescriptor)this.logFileProperty);
                    this.addProperty((IPropertyDescriptor)this.loggingLevelProperty);
                } else {
                    this.remove((IPropertyDescriptor)this.logFileProperty);
                    this.remove((IPropertyDescriptor)this.loggingLevelProperty);
                }
            } else if (this.messageUtil.getMessage("CONNECTION_CHOICE_USE_PREDEFINED_CONNECTION").equals(evt.getNewValue()) || this.messageUtil.getMessage("CONNECTION_CHOICE_CREATE_CONNECTION_PROPERTIES").equals(evt.getNewValue())) {
                this.remove((IPropertyDescriptor)this.serviceLevelPG);
                this.remove((IPropertyDescriptor)this.loggingChoiceProperty);
                if ((Boolean)this.loggingChoiceProperty.getValue() == Boolean.TRUE) {
                    this.remove((IPropertyDescriptor)this.logFileProperty);
                    this.remove((IPropertyDescriptor)this.loggingLevelProperty);
                }
                if (this.messageUtil.getMessage("CONNECTION_CHOICE_USE_PREDEFINED_CONNECTION").equals(evt.getNewValue())) {
                    this.remove((IPropertyDescriptor)this.connectionConfigurationProperties);
                    this.addProperty((IPropertyDescriptor)this.jndiTargetProperty);
                    if (this.serviceLevelPG.getSecurityPropertyGroup() != null) {
                        this.serviceLevelPG.getSecurityPropertyGroup().disableSecuritySection();
                    }
                } else if (this.messageUtil.getMessage("CONNECTION_CHOICE_CREATE_CONNECTION_PROPERTIES").equals(evt.getNewValue())) {
                    this.remove((IPropertyDescriptor)this.jndiTargetProperty);
                    this.addProperty((IPropertyDescriptor)this.connectionConfigurationProperties);
                    if (this.serviceLevelPG.getSecurityPropertyGroup() != null) {
                        this.serviceLevelPG.getSecurityPropertyGroup().enableSecuritySection();
                    }
                }
                this.addProperty((IPropertyDescriptor)this.serviceLevelPG);
                this.addProperty((IPropertyDescriptor)this.loggingChoiceProperty);
                if ((Boolean)this.loggingChoiceProperty.getValue() == Boolean.TRUE) {
                    this.addProperty((IPropertyDescriptor)this.logFileProperty);
                    this.addProperty((IPropertyDescriptor)this.loggingLevelProperty);
                }
            } else if (this.messageUtil.getMessage("DEPLOY_CONNECTOR_PROJECT_WITH_MODULE").equals(evt.getNewValue()) || this.messageUtil.getMessage("DEPLOY_CONNECTOR_PROJECT_ON_SERVER").equals(evt.getNewValue())) {
                if (this.messageUtil.getMessage("DEPLOY_CONNECTOR_PROJECT_WITH_MODULE").equals(evt.getNewValue())) {
                    try {
                        this.connectionChoice.setValue((Object)this.messageUtil.getMessage("CONNECTION_CHOICE_CREATE_CONNECTION_PROPERTIES"));
                    }
                    catch (CoreException coreException) {}
                    this.connectionChoice.setEnabled(false);
                } else {
                    this.connectionChoice.setEnabled(true);
                }
                this.connectionChoice.setEnabled(!this.messageUtil.getMessage("DEPLOY_CONNECTOR_PROJECT_WITH_MODULE").equals(evt.getNewValue()));
            }
        }
    }

    public String getLogFileLocation() {
        return this.logFileProperty.getFileLocation();
    }

    public Level getLoggingLevel() {
        String levelName = this.loggingLevelProperty.getValueAsString();
        Level level = Level.parse(levelName);
        return level;
    }

    public String getMessageListener() {
        if (this.serviceLevelPG != null && this.serviceLevelPG.listenerProperty != null) {
            return this.serviceLevelPG.listenerProperty.getValueAsString();
        }
        return null;
    }

    class MetadataBuildConnectionTypeSetter
    implements IPropertyChangeListener {
        MetadataBuildConnectionTypeSetter() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof ConnectionTypeProperty && evt.getPropertyChangeType() == 0 && evt.getNewValue() != null) {
                BuildConnectionPropertyGroup.this.build.setConnectionType(BuildConnectionPropertyGroup.this.isOutboundFlow ? ((OutboundConnectionType)evt.getNewValue()).getId() : ((InboundConnectionType)evt.getNewValue()).getId());
            }
        }
    }

    public static class MetadataBuildContext {
        public String defaultDataBindingClassName;
        public String defaultFunctionSelectorClassName;
    }
}

