/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.extension.discovery.connection;

import com.ibm.adapter.emd.extension.discovery.connection.spi.InboundConnectionConfiguration;
import com.ibm.adapter.emd.extension.discovery.spi.AdapterType;
import com.ibm.adapter.emd.extension.properties.PropertyGroupImpl;
import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.util.EMDUtil;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.connection.ConnectionType;
import commonj.connector.metadata.discovery.connection.InboundConnectionType;
import commonj.connector.metadata.discovery.properties.PropertyDescriptor;
import commonj.connector.metadata.discovery.properties.PropertyGroup;
import java.util.List;

public class InboundConnectionConfigurationImpl
implements InboundConnectionConfiguration {
    private com.ibm.adapter.emd.extension.discovery.connection.spi.InboundConnectionType inboundConnectionType;
    private PropertyGroup asPG;
    private String name;
    private String description;
    private PropertyGroup raPG;
    private PropertyGroup pg;

    @Override
    public void setInboundConnectionType(com.ibm.adapter.emd.extension.discovery.connection.spi.InboundConnectionType inboundConnectionType) {
        this.inboundConnectionType = inboundConnectionType;
    }

    public InboundConnectionType getInboundConnectionType() {
        return this.inboundConnectionType;
    }

    public boolean applyActivationSpecProperties(PropertyGroup propertyGroup) {
        this.asPG = propertyGroup;
        return true;
    }

    public PropertyGroup createActivationSpecProperties() {
        try {
            AdapterType adapterType = (AdapterType)this.inboundConnectionType.getAdapterType();
            PropertyGroup propertyGroup = EMDUtil.getInboundConnectionTypePropertyGroup(this.inboundConnectionType.getActivationSpecName(), adapterType.getResourceAdapterDescriptor());
            if (this.asPG != null) {
                EMDUtil.copyValues(this.asPG, propertyGroup);
            }
            return propertyGroup;
        }
        catch (MetadataException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean applyResourceAdapterProperties(PropertyGroup propertyGroup) {
        this.raPG = propertyGroup;
        return true;
    }

    public PropertyGroup createResourceAdapterProperties() {
        try {
            AdapterType adapterType = (AdapterType)this.inboundConnectionType.getAdapterType();
            PropertyGroup propertyGroup = EMDUtil.getOutboundResourceAdapterPropertyGroup(this.inboundConnectionType.getActivationSpecName(), adapterType.getResourceAdapterDescriptor());
            if (this.raPG != null) {
                EMDUtil.copyValues(this.raPG, propertyGroup);
            }
            return propertyGroup;
        }
        catch (MetadataException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public PropertyGroup createUnifiedProperties() {
        try {
            AdapterType adapterType = (AdapterType)this.inboundConnectionType.getAdapterType();
            StringBuffer pgName = new StringBuffer().append(adapterType.getDisplayName()).append(" ").append(adapterType.getVendor()).append(" ").append(adapterType.getVersion()).append(" ").append(MessageResource.ADAPTER_UNIFIED_PROPERTIES);
            PropertyGroupImpl propertyGroup = new PropertyGroupImpl(pgName.toString());
            propertyGroup.setDisplayName(pgName.toString());
            propertyGroup.setDescription(pgName.toString());
            PropertyGroup asProperties = this.createActivationSpecProperties();
            propertyGroup.addProperty((PropertyDescriptor)asProperties);
            PropertyGroup raProp = this.createResourceAdapterProperties();
            propertyGroup.addProperty((PropertyDescriptor)raProp);
            if (this.pg != null) {
                EMDUtil.copyValues(this.pg, propertyGroup);
            }
            return propertyGroup;
        }
        catch (MetadataException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean applyUnifiedProperties(PropertyGroup propertyGroup) {
        try {
            this.pg = propertyGroup;
            if (this.raPG != null) {
                EMDUtil.copyValues(this.pg, this.raPG);
            }
            if (this.asPG != null) {
                EMDUtil.copyValues(this.pg, this.asPG);
            }
        }
        catch (Exception e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        return true;
    }

    public ConnectionType getConnectionType() {
        return this.inboundConnectionType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void applyActivationSpecPropertiesToSecurityProperties(PropertyGroup activationSpecProperties, List securityProperties) {
    }

    public void applySecurityPropertiesToActivationSpecProperties(List securityProperties, PropertyGroup activationSpecProperties) {
    }

    public PropertyGroup createActivationSpecProperties(boolean security) {
        return null;
    }

    public List createActivationSpecSecurityProperties(boolean required) {
        return null;
    }

    public void applySecurityPropertiesToUnifiedProperties(List securityProperties, PropertyGroup unifiedProperties) {
    }

    public void applyUnifiedPropertiesToSecurityProperties(PropertyGroup unifiedProperties, List securityProperties) {
    }

    public List createSecurityProperties(boolean required) {
        return null;
    }

    public PropertyGroup createUnifiedProperties(boolean security) {
        return null;
    }
}

