/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.discovery;

import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.internal.discovery.EMDNodeProperties;
import com.ibm.adapter.emd.internal.discovery.EMDResponse;
import com.ibm.adapter.emd.internal.discovery.EMDToolContext;
import com.ibm.adapter.emd.properties.wrapper.PropertyGroupWrapper;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IResultNode;
import com.ibm.adapter.framework.IResultNodeResponse;
import com.ibm.adapter.framework.spi.BaseResultNode;
import com.ibm.propertygroup.IPropertyGroup;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.MetadataImportConfiguration;
import commonj.connector.metadata.discovery.MetadataObject;
import commonj.connector.metadata.discovery.MetadataObjectResponse;
import commonj.connector.metadata.discovery.properties.PropertyGroup;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class EMDResultNode
extends BaseResultNode {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private MetadataImportConfiguration emdConfiguration;
    private EMDToolContext activeContext;
    private String emdVersion = null;

    public EMDResultNode(MetadataObject metadata, EMDToolContext context, String emdVersion) {
        try {
            PropertyGroup objProps;
            PropertyGroup filterProps;
            this.setName(metadata.getDisplayName());
            this.setDescription(metadata.getDescription());
            if (metadata.isSelectableForImport()) {
                this.setSelectable(true);
            }
            if ((filterProps = metadata.createFilteringProperties()) != null) {
                PropertyGroupWrapper wrapper = new PropertyGroupWrapper(filterProps.getName(), filterProps.getDisplayName(), filterProps.getDescription(), emdVersion);
                wrapper.addPropertiesToPropertyGroup(filterProps);
                this.setFilteringProperties((IPropertyGroup)wrapper);
            }
            if ((objProps = metadata.getObjectProperties()) != null) {
                PropertyGroupWrapper wrapper = new PropertyGroupWrapper(objProps.getName(), objProps.getDisplayName(), objProps.getDescription(), emdVersion);
                wrapper.addPropertiesToPropertyGroup(objProps);
                this.setDisplayProperties((IPropertyGroup)wrapper);
            }
            this.setData(metadata);
            MetadataObject.MetadataObjectType type = metadata.getType();
            if (type == MetadataObject.MetadataObjectType.FOLDER) {
                this.setType(IResultNode.IResultNodeType.FOLDER);
            } else if (type == MetadataObject.MetadataObjectType.IN_OUT_PARAMETER) {
                this.setType(IResultNode.IResultNodeType.IN_OUT_PARAMETER);
            } else if (type == MetadataObject.MetadataObjectType.IN_PARAMETER) {
                this.setType(IResultNode.IResultNodeType.IN_PARAMETER);
            } else if (type == MetadataObject.MetadataObjectType.OBJECT) {
                this.setType(IResultNode.IResultNodeType.OBJECT);
            } else if (type == MetadataObject.MetadataObjectType.OPERATION) {
                this.setType(IResultNode.IResultNodeType.OPERATION);
            } else if (type == MetadataObject.MetadataObjectType.OUT_PARAMETER) {
                this.setType(IResultNode.IResultNodeType.OUT_PARAMETER);
            } else if (type == MetadataObject.MetadataObjectType.PROPERTY) {
                this.setType(IResultNode.IResultNodeType.PROPERTY);
            }
            this.activeContext = context;
            this.emdVersion = emdVersion;
        }
        catch (CoreException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void applyConfigurationParameters(IPropertyGroup parameteres) throws BaseException {
        block4: {
            try {
                if (parameteres == null) break block4;
                if (parameteres instanceof EMDNodeProperties) {
                    MetadataImportConfiguration configuration = ((EMDNodeProperties)parameteres).getMetadataConfiguration();
                    configuration.applyConfigurationProperties(((EMDNodeProperties)parameteres).getWrappedPropertyGroup());
                    super.applyConfigurationParameters(parameteres);
                    this.setEmdConfiguration(configuration);
                    break block4;
                }
                BaseException e = BaseException.createException((String)MessageResource.MSG_ERROR_INVALID_RESULT_NODE_PROPS, null);
                LogFacility.logErrorMessage((IStatus)e.getStatus());
                throw e;
            }
            catch (MetadataException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (BaseException e) {
                LogFacility.logErrorMessage((IStatus)e.getStatus());
            }
        }
    }

    public IPropertyGroup createConfigurationParameters() {
        try {
            MetadataImportConfiguration configuration = ((MetadataObject)this.data).createImportConfiguration();
            this.setEmdConfiguration(configuration);
            PropertyGroup group = configuration.createConfigurationProperties();
            if (group != null) {
                EMDNodeProperties parameters = new EMDNodeProperties(group, this.emdVersion);
                parameters.setMetadataConfiguration(configuration);
                return parameters;
            }
            return null;
        }
        catch (MetadataException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    public IResultNodeResponse getChildren(IPropertyGroup filterParameters, IEnvironment environment) throws BaseException {
        try {
            this.activeContext.setImportEnvironment(environment);
            if (filterParameters != null) {
                this.setAppliedFilter(filterParameters);
                MetadataObjectResponse emdResponse = ((MetadataObject)this.data).getChildren(((PropertyGroupWrapper)filterParameters).getWrappedPropertyGroup());
                EMDResponse response = new EMDResponse(emdResponse, this.activeContext, this.emdVersion);
                return response;
            }
            this.setAppliedFilter(null);
            MetadataObjectResponse emdResponse = ((MetadataObject)this.data).getChildren(null);
            EMDResponse response = new EMDResponse(emdResponse, this.activeContext, this.emdVersion);
            return response;
        }
        catch (MetadataException e) {
            BaseException ex = BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_ANNONYMOUS_EMD_ERROR, (Object)e.getLocalizedMessage()), (Throwable)e);
            LogFacility.logErrorMessage((IStatus)ex.getStatus());
            throw ex;
        }
        catch (RuntimeException e) {
            BaseException ex = BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
            LogFacility.logErrorMessage((IStatus)ex.getStatus());
            throw ex;
        }
        catch (Throwable e) {
            BaseException ex = BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
            LogFacility.logErrorMessage((IStatus)ex.getStatus());
            throw ex;
        }
    }

    public MetadataImportConfiguration getEmdConfiguration() {
        return this.emdConfiguration;
    }

    public String getLocation() {
        return ((MetadataObject)this.data).getLocation();
    }

    public MetadataObject getMetadataObject() {
        return (MetadataObject)this.data;
    }

    public String getParentLocation() {
        return ((MetadataObject)this.data).getParentLocation();
    }

    public boolean hasChildren() {
        return ((MetadataObject)this.data).hasChildren();
    }

    public void setEmdConfiguration(MetadataImportConfiguration emdConfiguration) {
        this.emdConfiguration = emdConfiguration;
    }
}

