/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.discovery;

import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.internal.discovery.EMDResultNode;
import com.ibm.adapter.emd.internal.discovery.EMDToolContext;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IResultNode;
import com.ibm.adapter.framework.IResultNodeIterator;
import commonj.connector.metadata.discovery.MetadataObjectIterator;
import org.eclipse.core.runtime.IStatus;

public class EMDIterator
implements IResultNodeIterator {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private MetadataObjectIterator emdIterator;
    private EMDToolContext activeContext;
    private String emdVersion = null;

    public EMDIterator(MetadataObjectIterator iterator, EMDToolContext context, String emdVersion) throws BaseException {
        if (iterator == null) {
            BaseException e = BaseException.createException((String)MessageResource.MSG_ERROR_ITER_NULL, null);
            LogFacility.logErrorMessage((IStatus)e.getStatus());
            throw e;
        }
        this.emdIterator = iterator;
        this.activeContext = context;
        this.emdVersion = emdVersion;
    }

    public boolean hasNext() {
        return this.emdIterator.hasNext();
    }

    public Object next() {
        return this.emdIterator.next();
    }

    public IResultNode nextResultNode() {
        return new EMDResultNode(this.emdIterator.nextMetaDataObject(), this.activeContext, this.emdVersion);
    }

    public void remove() {
        this.emdIterator.remove();
    }
}

