/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.discovery;

import com.ibm.adapter.emd.extension.description.spi.J2CServiceDescription;
import com.ibm.adapter.emd.extension.description.spi.ServiceDescriptionFactory;
import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.internal.discovery.EMDDescriptor;
import com.ibm.adapter.emd.internal.discovery.EMDResultNodeSelection;
import com.ibm.adapter.emd.internal.discovery.EMDSearchTree;
import com.ibm.adapter.emd.internal.discovery.EMDToolContext;
import com.ibm.adapter.emd.internal.discovery.MessageUtil;
import com.ibm.adapter.emd.internal.properties.DiscoveryConnectionPropertyGroup;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IDiscoveryAgent;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IImportResult;
import com.ibm.adapter.framework.IResultNodeSelection;
import com.ibm.adapter.framework.ISearchTree;
import com.ibm.adapter.framework.spi.BaseDiscoveryAgent;
import com.ibm.adapter.framework.spi.BaseDiscoveryAgentMetaData;
import com.ibm.adapter.framework.spi.ImportResult;
import com.ibm.adapter.framework.util.QNameHelper;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.RegistryFactory;
import com.ibm.propertygroup.IPropertyGroup;
import commonj.connector.metadata.MetadataConfigurationType;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.description.ServiceDescription;
import commonj.connector.metadata.discovery.MetadataDiscovery;
import commonj.connector.metadata.discovery.MetadataSelection;
import commonj.connector.metadata.discovery.MetadataTree;
import commonj.connector.metadata.discovery.connection.MetadataConnection;
import commonj.connector.metadata.discovery.connection.OutboundConnectionConfiguration;
import commonj.connector.metadata.discovery.connection.OutboundConnectionType;
import commonj.connector.tool.ToolContext;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class EMDDiscoveryAgent
extends BaseDiscoveryAgent {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private EMDDescriptor emdDescriptor;
    private MetadataConnection metadataConnection;
    private EMDToolContext activeContext;
    private MessageUtil messageUtil;

    public EMDDiscoveryAgent(EMDDescriptor emdDetails, IResourceAdapterDescriptor resourceAdapter) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            try {
                if (emdDetails == null) {
                    throw BaseException.createException((String)MessageResource.MSG_ERROR_EMD_NULL, null);
                }
                if (resourceAdapter == null) {
                    throw BaseException.createException((String)MessageResource.MSG_ERROR_RAR_NULL, null);
                }
                this.emdDescriptor = emdDetails;
                String name = NLS.bind((String)MessageResource.DA_DISPLAY_NAME, (Object[])new String[]{this.emdDescriptor.getDisplayName(), this.emdDescriptor.getVersion(), this.emdDescriptor.getConnectorProject().getName()});
                String projectName = this.emdDescriptor.getConnectorProject().getName().replace(' ', '_');
                String fixedName = this.emdDescriptor.getDisplayName().replace(' ', '_');
                String version = this.emdDescriptor.getVersion().replace(' ', '_');
                String vendor = this.emdDescriptor.getVendorName().replace(' ', '_');
                String adapterNamespace = new StringBuffer().append(projectName).append('/').append(fixedName).append('/').append(version).append('/').append(vendor).toString();
                QName adapterQName = QNameHelper.createQName((String)adapterNamespace, (String)name);
                this.metaData = new BaseDiscoveryAgentMetaData(adapterQName, null, null, 0){

                    public String getDisplayName() {
                        return NLS.bind((String)MessageResource.DA_DISPLAY_NAME, (Object[])new String[]{EMDDiscoveryAgent.this.emdDescriptor.getDisplayName(), EMDDiscoveryAgent.this.emdDescriptor.getVersion(), EMDDiscoveryAgent.this.emdDescriptor.getConnectorProject().getName()});
                    }

                    public String getAgentDescription() {
                        return EMDDiscoveryAgent.this.emdDescriptor.getDescription();
                    }
                };
                this.emdDescriptor.setDiscoveryAgent(this);
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    private EMDDiscoveryAgent() {
    }

    public void close() throws BaseException {
        try {
            if (this.metadataConnection != null) {
                this.metadataConnection.close();
            }
            if (this.activeContext != null) {
                this.activeContext.close();
            }
            this.messageUtil = null;
        }
        catch (MetadataException e) {
            BaseException ex = BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_EMD_ERROR, (Object)this.emdDescriptor.getDisplayName(), (Object)e.getLocalizedMessage()), (Throwable)e);
            LogFacility.logErrorMessage((IStatus)ex.getStatus());
            throw ex;
        }
    }

    public EMDDescriptor getEmdDescriptor() {
        return this.emdDescriptor;
    }

    public ISearchTree getSearchTree() throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            EMDSearchTree tree;
            MetadataTree metadataTree = this.emdDescriptor.getDiscoveryService().getMetadataTree(this.metadataConnection);
            EMDSearchTree eMDSearchTree = tree = new EMDSearchTree(metadataTree, this.activeContext, this.emdDescriptor.getSpecVersion());
            return eMDSearchTree;
        }
        catch (MetadataException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_EMD_ERROR, (Object)this.emdDescriptor.getDisplayName(), (Object)e.getLocalizedMessage()), (Throwable)e);
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public void initialize(IEnvironment environment, IPropertyGroup initializeProperties) throws BaseException {
        block15: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                try {
                    if (initializeProperties == null) {
                        throw BaseException.createException((String)MessageResource.MSG_ERROR_NO_CONFIG_PROPS, null);
                    }
                    if (initializeProperties instanceof DiscoveryConnectionPropertyGroup) {
                        OutboundConnectionConfiguration connectionConfiguration = ((DiscoveryConnectionPropertyGroup)initializeProperties).getConnectionConfiguration();
                        try {
                            if (connectionConfiguration == null) {
                                throw BaseException.createException((String)MessageResource.MSG_ERROR_INVALID_CONFIG_PROPS, null);
                            }
                            String logFile = ((DiscoveryConnectionPropertyGroup)initializeProperties).getLogFileLocation();
                            Level level = ((DiscoveryConnectionPropertyGroup)initializeProperties).getLoggingLevel();
                            this.activeContext = new EMDToolContext(logFile, this.emdDescriptor.getDiscoveryServiceClass(), level);
                            this.activeContext.setImportEnvironment(environment);
                            this.emdDescriptor.getDiscoveryService().setToolContext((ToolContext)this.activeContext);
                            this.metadataConnection = ((OutboundConnectionType)connectionConfiguration.getConnectionType()).openMetadataConnection(connectionConfiguration);
                            this.metadataConnection.setToolContext((ToolContext)this.activeContext);
                            break block15;
                        }
                        catch (MetadataException e) {
                            throw BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_EMD_ERROR, (Object)this.emdDescriptor.getDisplayName(), (Object)e.getLocalizedMessage()), (Throwable)e);
                        }
                        catch (RuntimeException e) {
                            throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    throw BaseException.createException((String)MessageResource.MSG_ERROR_INVALID_CONFIG_PROPS, null);
                }
                catch (BaseException e) {
                    LogFacility.logErrorMessage((IStatus)e.getStatus());
                    throw e;
                }
                catch (RuntimeException e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (Throwable e) {
                    LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            finally {
                if (LogFacility.trace) {
                    LogFacility.TrcExit();
                }
            }
        }
    }

    public void initialize(IEnvironment environment, IPropertyGroup initializeProperties, IImportResult importResult) throws BaseException {
        throw BaseException.createException((String)MessageResource.MSG_ERROR_ITER_NOT_SUPPORTED, null);
    }

    public IDiscoveryAgent newInstance() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            EMDDiscoveryAgent agent = new EMDDiscoveryAgent();
            agent.emdDescriptor = this.emdDescriptor;
            agent.initializeProperties = this.initializeProperties;
            agent.metaData = this.metaData;
            EMDDiscoveryAgent eMDDiscoveryAgent = agent;
            return eMDDiscoveryAgent;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
        return null;
    }

    public IImportResult performImport(IEnvironment environment, IResultNodeSelection selectedNodes) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            this.activeContext.setImportEnvironment(environment);
            if (selectedNodes instanceof EMDResultNodeSelection) {
                MetadataSelection selection = ((EMDResultNodeSelection)selectedNodes).getMetadataSelection();
                ServiceDescription description = this.emdDescriptor.getDiscoveryService().createServiceDescription(selection);
                IResourceAdapterDescriptor resourceAdapter = RegistryFactory.getFactory().getAPIResourceAdapterRegistry().getResourceAdapterForProject(this.emdDescriptor.getConnectorProject());
                J2CServiceDescription importData = ServiceDescriptionFactory.getFactory().createJ2CServiceDescription();
                importData.setResourceAdapterDescriptor(resourceAdapter);
                importData.setServiceDescription(description);
                ImportResult result = new ImportResult();
                result.setImportData((Object)importData);
                ImportResult importResult = result;
                return importResult;
            }
            try {
                BaseException e = BaseException.createException((String)MessageResource.MSG_ERROR_INVALID_SELECTION, null);
                LogFacility.logErrorMessage((IStatus)e.getStatus());
                throw e;
            }
            catch (MetadataException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                throw BaseException.createException((String)NLS.bind((String)MessageResource.MSG_ERROR_EMD_ERROR, (Object)this.emdDescriptor.getDisplayName(), (Object)e.getLocalizedMessage()), (Throwable)e);
            }
            catch (BaseException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                throw e;
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public IPropertyGroup getInitializeProperties() throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        try {
            if (this.activeContext == null) {
                this.activeContext = EMDDescriptor.defaultContext;
            }
            IPropertyGroup iPropertyGroup = this.initializeProperties = new DiscoveryConnectionPropertyGroup(MessageResource.CONFIGURATION_PROPERTIES_DISPLAY_NAME, null, MessageResource.CONFIGURATION_PROPERTIES_DESCRIPTION, this.emdDescriptor, this.getMessageUtil());
            return iPropertyGroup;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public String[] getSupportedConfiguration() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        if (EMDDescriptor.EMD_SPEC_VERSION_1_0.equals(this.getEmdDescriptor().getSpecVersion())) {
            return null;
        }
        String[] supportedConfiguration = null;
        MetadataDiscovery discovery = this.emdDescriptor.getDiscoveryService();
        MetadataConfigurationType[] configurationTypes = discovery.getSupportedConfiguration();
        supportedConfiguration = EMDDiscoveryAgent.serializeFromMetaDataConfiguration(configurationTypes);
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return supportedConfiguration;
    }

    public String[] getConfiguration() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        String[] configuration = null;
        if (!EMDDescriptor.EMD_SPEC_VERSION_1_0.equals(this.getEmdDescriptor().getSpecVersion())) {
            try {
                MetadataDiscovery discovery = this.emdDescriptor.getDiscoveryService();
                MetadataConfigurationType[] configurationTypes = discovery.getConfiguration();
                configuration = EMDDiscoveryAgent.serializeFromMetaDataConfiguration(configurationTypes);
            }
            catch (Throwable throwable) {}
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return configuration;
    }

    public void setConfiguration(String[] capabilities) throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        if (EMDDescriptor.EMD_SPEC_VERSION_1_0.equals(this.getEmdDescriptor().getSpecVersion())) {
            return;
        }
        MetadataDiscovery discovery = this.emdDescriptor.getDiscoveryService();
        MetadataConfigurationType[] configurationTypes = EMDDiscoveryAgent.serializeToMetaDataConfiguration(capabilities, discovery.getSupportedConfiguration());
        try {
            try {
                if (configurationTypes != null) {
                    discovery.setConfiguration(configurationTypes);
                    this.initializeProperties = null;
                }
            }
            catch (MetadataException e) {
                LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
                throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    private static MetadataConfigurationType getConfigurationTypeFor(String name, MetadataConfigurationType[] supportedTypes) {
        if (MetadataConfigurationType.GENERATED_DATA_BINDING.toString().equals(name)) {
            return MetadataConfigurationType.GENERATED_DATA_BINDING;
        }
        if (MetadataConfigurationType.GENERATED_RECORDS.toString().equals(name)) {
            return MetadataConfigurationType.GENERATED_RECORDS;
        }
        if (MetadataConfigurationType.GENERIC_DATA_BINDING.toString().equals(name)) {
            return MetadataConfigurationType.GENERIC_DATA_BINDING;
        }
        if (MetadataConfigurationType.GENERIC_RECORDS.toString().equals(name)) {
            return MetadataConfigurationType.GENERIC_RECORDS;
        }
        if (MetadataConfigurationType.INBOUND_SERVICE.toString().equals(name)) {
            return MetadataConfigurationType.INBOUND_SERVICE;
        }
        if (MetadataConfigurationType.OUTBOUND_SERVICE.toString().equals(name)) {
            return MetadataConfigurationType.OUTBOUND_SERVICE;
        }
        if (supportedTypes != null) {
            int i = 0;
            while (i < supportedTypes.length) {
                if (supportedTypes[i].toString().equals(name)) {
                    return supportedTypes[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static String[] serializeFromMetaDataConfiguration(MetadataConfigurationType[] configurationTypes) {
        String[] configuration = null;
        if (configurationTypes != null) {
            configuration = new String[configurationTypes.length];
            int i = 0;
            while (i < configurationTypes.length) {
                configuration[i] = configurationTypes[i].toString();
                ++i;
            }
        }
        return configuration;
    }

    public static MetadataConfigurationType[] serializeToMetaDataConfiguration(String[] capabilities, MetadataConfigurationType[] supportedTypes) {
        MetadataConfigurationType[] configurationTypes = null;
        if (capabilities != null && capabilities.length > 0) {
            configurationTypes = new MetadataConfigurationType[capabilities.length];
            int i = 0;
            while (i < capabilities.length) {
                MetadataConfigurationType type;
                configurationTypes[i] = type = EMDDiscoveryAgent.getConfigurationTypeFor(capabilities[i], supportedTypes);
                ++i;
            }
        }
        return configurationTypes;
    }

    public void initializeContext(Object[] context) throws BaseException {
        this.initMessageUtil(context);
    }

    private void initMessageUtil(Object[] context) {
        this.messageUtil = null;
        if (context != null) {
            int i = 0;
            while (i < context.length) {
                if (context[i] instanceof MessageUtil) {
                    this.messageUtil = (MessageUtil)context[i];
                    break;
                }
                ++i;
            }
        }
    }

    private MessageUtil getMessageUtil() {
        if (this.messageUtil == null) {
            this.messageUtil = new MessageUtil(null);
        }
        return this.messageUtil;
    }

    public void setEditing(boolean editing) {
        if (EMDDescriptor.EMD_SPEC_VERSION_1_2.equals(this.getEmdDescriptor().getSpecVersion())) {
            MetadataDiscovery discovery = this.emdDescriptor.getDiscoveryService();
            try {
                discovery.setEditing(editing);
            }
            catch (AbstractMethodError abstractMethodError) {}
        } else {
            super.setEditing(editing);
        }
    }
}

