/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.build.j2c;

import com.ibm.adapter.emd.extension.description.J2CServiceDescription;
import com.ibm.adapter.emd.extension.description.spi.InboundFunctionDescription;
import com.ibm.adapter.emd.extension.description.spi.OutboundFunctionDescription;
import com.ibm.adapter.emd.extension.description.spi.ServiceDescription;
import com.ibm.adapter.emd.extension.description.spi.ServiceDescriptionFactory;
import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.build.j2c.J2CBuildContext;
import com.ibm.adapter.emd.internal.build.j2c.J2COperation;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IImportResult;
import com.ibm.adapter.framework.internal.build.IOperation;
import com.ibm.adapter.framework.internal.build.spi.OperationContainer;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import commonj.connector.metadata.description.FunctionDescription;
import commonj.connector.metadata.discovery.MetadataEdit;
import javax.resource.cci.InteractionSpec;

public class J2COperationContainer
extends OperationContainer {
    IImportResult result;
    MetadataEdit metadataEdit;
    IResourceAdapterDescriptor resourceAdapterDescriptor;
    J2CBuildContext context;

    public J2COperationContainer(J2CBuildContext context) {
        this.context = context;
        this.result = context.result;
        this.metadataEdit = context.metadataEdit;
        this.resourceAdapterDescriptor = context.resourceAdapterDescriptor;
        this.initializeList();
    }

    public IOperation createOperation() {
        try {
            if (this.context.isOutboundFlow) {
                OutboundFunctionDescription description = ServiceDescriptionFactory.getFactory().createOutboundFunctionDescription();
                description.setInteractionSpec((InteractionSpec)this.resourceAdapterDescriptor.getInteractionSpecClass(this.resourceAdapterDescriptor.getInteractionSpecNames()[0]).newInstance());
                return new J2COperation(this.resourceAdapterDescriptor, this.metadataEdit, this.getServiceDescriptionModel(), description);
            }
            InboundFunctionDescription description = ServiceDescriptionFactory.getFactory().createInboundFunctionDescription();
            return new J2COperation(this.resourceAdapterDescriptor, this.metadataEdit, this.getServiceDescriptionModel(), description);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private ServiceDescription getServiceDescriptionModel() {
        Object data = this.result.getImportData();
        return (ServiceDescription)((J2CServiceDescription)data).getServiceDescription();
    }

    private void initializeList() {
        FunctionDescription[] f_Descriptions = this.getServiceDescriptionModel().getFunctionDescriptions();
        int i = 0;
        while (i < f_Descriptions.length) {
            J2COperation operation = new J2COperation(this.resourceAdapterDescriptor, this.metadataEdit, this.getServiceDescriptionModel(), (com.ibm.adapter.emd.extension.description.spi.FunctionDescription)f_Descriptions[i]);
            this.operations.add(operation);
            ++i;
        }
    }

    public void add(IOperation operation) throws BaseException {
        super.add(operation);
        this.getServiceDescriptionModel().addFunctionDescription(((J2COperation)operation).getFunctionDescription());
    }

    public void remove(IOperation operation) throws BaseException {
        super.remove(operation);
        this.getServiceDescriptionModel().removeFunctionDescription(((J2COperation)operation).getFunctionDescription());
    }

    public boolean isComplete() {
        return !this.context.isWIDBased && this.context.isOutboundFlow || this.getOperations().length > 0;
    }
}

