/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.build.j2c;

import com.ibm.adapter.emd.extension.description.J2CParameterDescription;
import com.ibm.adapter.emd.extension.description.ParameterDescription;
import com.ibm.adapter.emd.extension.description.spi.DataDescription;
import com.ibm.adapter.emd.extension.description.spi.DataFile;
import com.ibm.adapter.emd.extension.description.spi.FunctionDescription;
import com.ibm.adapter.emd.extension.description.spi.InboundFunctionDescription;
import com.ibm.adapter.emd.extension.description.spi.InboundServiceDescription;
import com.ibm.adapter.emd.extension.description.spi.OutboundFunctionDescription;
import com.ibm.adapter.emd.extension.description.spi.OutboundServiceDescription;
import com.ibm.adapter.emd.extension.description.spi.ServiceDescription;
import com.ibm.adapter.emd.extension.description.spi.ServiceDescriptionFactory;
import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.internal.build.j2c.NonGeneratedDataFile;
import com.ibm.adapter.emd.properties.wrapper.PropertyGroupWrapper;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IPublishingSet;
import com.ibm.adapter.framework.IResourceWriter;
import com.ibm.adapter.framework.internal.build.spi.Operation;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.propertygroup.IMultiValuedProperty;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.IPropertyType;
import com.ibm.propertygroup.ISingleTypedProperty;
import com.ibm.propertygroup.ISingleValuedProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BasePropertyType;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.build.FunctionType;
import commonj.connector.metadata.discovery.EditableType;
import commonj.connector.metadata.discovery.MetadataEdit;
import commonj.connector.metadata.discovery.properties.PropertyGroup;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.InteractionSpec;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

public class J2COperation
extends Operation {
    public static final String OPERATION_BINDINGS_GROUP_NAME = "OPERATION_BINDINGS_PG";
    public static final String INTERACTION_SPEC_NAME = "INTERACTION_SPEC_PROPERTY";
    public static final String INTERACTION_SPEC_PG_NAME = "INTERACTION_SPEC_PROPERTY_PG";
    public static final String CONNECTION_SPEC_NAME = "CONNECTION_SPEC_PROPERTY";
    public static final String CONNECTION_SPEC_PG_NAME = "CONNECTION_SPEC_PROPERTY_PG";
    private static final String J2C_BUSINESS_METHOD_PROPERTY_GROUP = "BusinessMethodPropertyGroup";
    private static final String J2C_BUSINESS_METHOD_NAME_PROPERTY = "Name";
    private static final String J2C_BUSINESS_METHOD_INPUT_PROPERTY = "InputType";
    private static final String J2C_BUSINESS_METHOD_INPUT_AS_OUTPUT_PROPERTY = "InputAsOutput";
    private static final String J2C_BUSINESS_METHOD_OUTPUT_PROPERTY = "OutputType";
    private static final String J2C_BUSINESS_METHOD_INPUT_MODEL_PROPERTY_GROUP = "InputTypeModelPropertyGroup";
    private static final String J2C_BUSINESS_METHOD_OUTPUT_MODEL_PROPERTY_GROUP = "OutputTypeModelPropertyGroup";
    private static final String J2C_MODEL_PUBLISHING_SET = "PublishingSet";
    private static final String J2C_MODEL_RESOURCE_WRITER = "ResourceWriter";
    private static final String J2C_MODEL_PARAMETER_DESCRIPTIONS = "ParameterDescriptios";
    private static final String J2C_BUSINESS_METHOD_QNAME = "QueueName";
    private static final String J2C_BUSINESS_METHOD_MAP_NAME = "MapName";
    private FunctionDescription functionDescription;
    private MetadataEdit metadataEdit;
    private IResourceAdapterDescriptor resourceAdapterDescriptor;
    private ServiceDescription serviceDescription;

    public J2COperation(IResourceAdapterDescriptor resourceAdapterDescriptor, MetadataEdit metadataEdit, ServiceDescription serviceDescription, FunctionDescription functionDescription) {
        this.functionDescription = functionDescription;
        this.metadataEdit = metadataEdit;
        this.resourceAdapterDescriptor = resourceAdapterDescriptor;
        this.serviceDescription = serviceDescription;
    }

    public String getDisplayName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        buffer.append("( ");
        commonj.connector.metadata.description.DataDescription dataDescription = this.getFunctionDescription().getInputDataDescription();
        if (dataDescription != null && dataDescription.getDataFiles() != null) {
            commonj.connector.metadata.description.DataFile dataFile = dataDescription.getDataFiles()[0];
            String dataName = null;
            String uri = dataFile.getLocation().toString();
            dataName = dataFile instanceof NonGeneratedDataFile ? uri.substring(uri.lastIndexOf("/") + 1) : uri.substring(uri.lastIndexOf("/") + 1, uri.indexOf("."));
            buffer.append(dataName);
        }
        buffer.append(" ) : ");
        commonj.connector.metadata.description.DataDescription outDataDescription = this.getFunctionDescription().getOutputDataDescription();
        if (outDataDescription != null && outDataDescription.getDataFiles() != null) {
            commonj.connector.metadata.description.DataFile dataFile = outDataDescription.getDataFiles()[0];
            String dataName = null;
            String uri = dataFile.getLocation().toString();
            dataName = dataFile instanceof NonGeneratedDataFile ? uri.substring(uri.lastIndexOf("/") + 1) : uri.substring(uri.lastIndexOf("/") + 1, uri.indexOf("."));
            buffer.append(dataName);
        } else {
            buffer.append("void");
        }
        return buffer.toString();
    }

    public String getName() {
        return this.getFunctionDescription().getName();
    }

    public FunctionDescription getFunctionDescription() {
        return this.functionDescription;
    }

    void finalizeOperation() throws BaseException {
        if (this.currentBindingGroup == null) {
            return;
        }
        if (this.getFunctionDescription() instanceof OutboundFunctionDescription) {
            try {
                String isName = ((ISingleValuedProperty)this.currentBindingGroup.getProperty(INTERACTION_SPEC_NAME)).getValueAsString();
                PropertyGroup pg = ((PropertyGroupWrapper)this.currentBindingGroup.getProperty(INTERACTION_SPEC_PG_NAME)).getWrappedPropertyGroup();
                EditableType isEditableType = this.metadataEdit.getInteractionSpecType(isName);
                Class isClass = this.resourceAdapterDescriptor.getInteractionSpecClass(isName);
                Object isBean = isClass.newInstance();
                isEditableType.synchronizeFromPropertyGroupToBean(pg, isBean);
                ((OutboundFunctionDescription)this.getFunctionDescription()).setInteractionSpec((InteractionSpec)isBean);
                String csName = ((ISingleValuedProperty)this.currentBindingGroup.getProperty(CONNECTION_SPEC_NAME)).getValueAsString();
                ((PropertyGroupWrapper)this.currentBindingGroup.getProperty(CONNECTION_SPEC_PG_NAME)).getWrappedPropertyGroup();
                this.metadataEdit.getConnectionSpecType(csName);
                Class csClass = this.resourceAdapterDescriptor.getConnectionSpecClass(csName);
                Object csBean = csClass.newInstance();
                ((OutboundServiceDescription)this.serviceDescription).setConnectionSpec((ConnectionSpec)csBean);
            }
            catch (MetadataException e) {
                throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (InstantiationException e) {
                throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public void applyDefinitionPropertyGroup(IPropertyGroup defProperties) throws BaseException {
        if (defProperties != null && J2C_BUSINESS_METHOD_PROPERTY_GROUP.equals(defProperties.getName())) {
            java.net.URI netURI;
            URI uri;
            if (this.definitionGroup == null) {
                try {
                    String currentName = this.getFunctionDescription().getName();
                    if (currentName != null) {
                        ((ISingleValuedProperty)defProperties.getProperty(J2C_BUSINESS_METHOD_NAME_PROPERTY)).setValueAsString(currentName);
                    }
                    ParameterDescription[] parameterDescriptions = this.getFunctionDescription().getParameterDescriptions();
                    int i = 0;
                    while (i < parameterDescriptions.length) {
                        String uriString;
                        commonj.connector.metadata.description.DataDescription dataDescription;
                        if (parameterDescriptions[i] instanceof J2CParameterDescription) {
                            ((IMultiValuedProperty)defProperties.getProperty((IPath)new Path("InputTypeModelPropertyGroup/ParameterDescriptios"))).addValue((Object)parameterDescriptions[i]);
                        } else if (parameterDescriptions[i] instanceof commonj.connector.metadata.description.DataDescription && (dataDescription = (commonj.connector.metadata.description.DataDescription)parameterDescriptions[i]) != null && dataDescription.getDataFiles() != null && (uriString = this.getDataName(dataDescription.getDataFiles()[0])) != null) {
                            if (1 == parameterDescriptions[i].getStyle()) {
                                ((ISingleValuedProperty)defProperties.getProperty(J2C_BUSINESS_METHOD_INPUT_PROPERTY)).setValueAsString(uriString);
                            } else if (2 == parameterDescriptions[i].getStyle()) {
                                ((ISingleValuedProperty)defProperties.getProperty(J2C_BUSINESS_METHOD_OUTPUT_PROPERTY)).setValueAsString(uriString);
                            } else if (parameterDescriptions[i].getStyle() == 0) {
                                ((ISingleValuedProperty)defProperties.getProperty(J2C_BUSINESS_METHOD_OUTPUT_PROPERTY)).setValueAsString(uriString);
                                ((ISingleValuedProperty)defProperties.getProperty(J2C_BUSINESS_METHOD_INPUT_PROPERTY)).setValueAsString(uriString);
                            }
                        }
                        ++i;
                    }
                    this.definitionGroup = defProperties;
                }
                catch (Throwable e) {
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
                return;
            }
            String name = ((ISingleValuedProperty)defProperties.getProperty(J2C_BUSINESS_METHOD_NAME_PROPERTY)).getValueAsString();
            String inTypeName = ((ISingleValuedProperty)defProperties.getProperty(J2C_BUSINESS_METHOD_INPUT_PROPERTY)).getValueAsString();
            IResourceWriter inputResourceWriter = (IResourceWriter)((ISingleValuedProperty)defProperties.getProperty((IPath)new Path("InputTypeModelPropertyGroup/ResourceWriter"))).getValue();
            IPublishingSet inputPublishingSet = (IPublishingSet)((ISingleValuedProperty)defProperties.getProperty((IPath)new Path("InputTypeModelPropertyGroup/PublishingSet"))).getValue();
            Object[] j2cParameterDescriptions = ((IMultiValuedProperty)defProperties.getProperty((IPath)new Path("InputTypeModelPropertyGroup/ParameterDescriptios"))).getValues();
            String outTypeName = ((ISingleValuedProperty)defProperties.getProperty(J2C_BUSINESS_METHOD_OUTPUT_PROPERTY)).getValueAsString();
            IResourceWriter outputResourceWriter = (IResourceWriter)((ISingleValuedProperty)defProperties.getProperty((IPath)new Path("OutputTypeModelPropertyGroup/ResourceWriter"))).getValue();
            IPublishingSet outputPublishingSet = (IPublishingSet)((ISingleValuedProperty)defProperties.getProperty((IPath)new Path("OutputTypeModelPropertyGroup/PublishingSet"))).getValue();
            Boolean useInAsOut = (Boolean)((ISingleValuedProperty)defProperties.getProperty(J2C_BUSINESS_METHOD_INPUT_AS_OUTPUT_PROPERTY)).getValue();
            ParameterDescription[] parameterDescriptions = this.getFunctionDescription().getParameterDescriptions();
            int i = 0;
            while (i < parameterDescriptions.length) {
                this.getFunctionDescription().removeParameterDescription(parameterDescriptions[i]);
                ++i;
            }
            if (name != null) {
                FunctionDescription fd = this.getFunctionDescription();
                if (this.functionDescription instanceof OutboundFunctionDescription) {
                    ((OutboundFunctionDescription)fd).setName(name);
                } else if (this.functionDescription instanceof InboundFunctionDescription) {
                    ((InboundFunctionDescription)fd).setName(name);
                    if ("IMS TM".equals(this.resourceAdapterDescriptor.getConnector().getEisType())) {
                        ISingleValuedProperty QNameProp = (ISingleValuedProperty)defProperties.getProperty(J2C_BUSINESS_METHOD_QNAME);
                        ISingleValuedProperty mapNameProp = (ISingleValuedProperty)defProperties.getProperty(J2C_BUSINESS_METHOD_MAP_NAME);
                        String qName = QNameProp.getValueAsString();
                        String mapName = null;
                        if (mapNameProp != null) {
                            mapName = mapNameProp.getValueAsString();
                        }
                        StringBuffer sb = new StringBuffer("imsMethod");
                        sb.append(qName);
                        if (mapName != null) {
                            sb.append(mapName);
                        }
                        ((InboundFunctionDescription)fd).setEISFunctionName(sb.toString());
                    }
                }
            }
            DataDescription dataDescription = ServiceDescriptionFactory.getFactory().createDataDescription();
            dataDescription.setStyle(1);
            DataDescription outDataDescription = ServiceDescriptionFactory.getFactory().createDataDescription();
            outDataDescription.setStyle(2);
            if (inTypeName != null) {
                DataFile in = null;
                uri = URI.createPlatformResourceURI((String)inTypeName);
                netURI = null;
                try {
                    netURI = new java.net.URI(URLEncoder.encode(uri.toString(), "UTF-8"));
                }
                catch (Throwable e) {
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
                in = inputResourceWriter != null ? new NonGeneratedDataFile(inputPublishingSet, inputResourceWriter) : ServiceDescriptionFactory.getFactory().createDataFile();
                in.setLocation(netURI);
                dataDescription.addDataFile(in);
                if (useInAsOut.booleanValue()) {
                    outDataDescription.addDataFile(in);
                }
            }
            if (outTypeName != null && !useInAsOut.booleanValue()) {
                DataFile out = null;
                uri = URI.createPlatformResourceURI((String)outTypeName);
                netURI = null;
                try {
                    netURI = new java.net.URI(URLEncoder.encode(uri.toString(), "UTF-8"));
                }
                catch (Throwable e) {
                    throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
                }
                out = outputResourceWriter != null ? new NonGeneratedDataFile(outputPublishingSet, outputResourceWriter) : ServiceDescriptionFactory.getFactory().createDataFile();
                out.setLocation(netURI);
                outDataDescription.addDataFile(out);
            }
            if (inTypeName != null) {
                this.getFunctionDescription().addParameterDescription(dataDescription);
            }
            if (outTypeName != null) {
                this.getFunctionDescription().addParameterDescription(outDataDescription);
            }
            if (j2cParameterDescriptions != null) {
                int i2 = 0;
                while (i2 < j2cParameterDescriptions.length) {
                    this.getFunctionDescription().addParameterDescription((J2CParameterDescription)j2cParameterDescriptions[i2]);
                    ++i2;
                }
            }
            super.applyDefinitionPropertyGroup(defProperties);
        }
    }

    public IPropertyGroup createBindingPropertyGroup() throws BaseException {
        if (this.bindingGroup == null) {
            try {
                this.setBindingPropertyGroup(this.defineBindingsPropertyGroup());
            }
            catch (CoreException e) {
                BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return super.createBindingPropertyGroup();
    }

    public IPropertyGroup createDefinitionPropertyGroup() throws BaseException {
        return super.createDefinitionPropertyGroup();
    }

    public static boolean containsFunctionType(FunctionType[] functionTypes, FunctionType type) {
        ArrayList functionTypesList = new ArrayList();
        Collections.addAll(functionTypesList, functionTypes);
        return functionTypesList.contains(type);
    }

    private IPropertyGroup defineBindingsPropertyGroup() throws CoreException {
        if (this.serviceDescription instanceof InboundServiceDescription) {
            BasePropertyGroup propertyGroup = new BasePropertyGroup(OPERATION_BINDINGS_GROUP_NAME, MessageResource.OPERATION_BINDINGS_DISP_NAME, MessageResource.OPERATION_BINDINGS_DESC);
            return propertyGroup;
        }
        BasePropertyGroup propertyGroup = new BasePropertyGroup(OPERATION_BINDINGS_GROUP_NAME, MessageResource.OPERATION_BINDINGS_DISP_NAME, MessageResource.OPERATION_BINDINGS_DESC){

            public Object clone() throws CloneNotSupportedException {
                try {
                    BasePropertyGroup clone = (BasePropertyGroup)super.clone();
                    clone.getProperty(J2COperation.INTERACTION_SPEC_NAME).addPropertyChangeListener((IPropertyChangeListener)clone);
                    IPropertyDescriptor csDesc = clone.getProperty(J2COperation.CONNECTION_SPEC_NAME);
                    if (csDesc != null) {
                        csDesc.addPropertyChangeListener((IPropertyChangeListener)clone);
                    }
                    return clone;
                }
                catch (Exception exception) {
                    return null;
                }
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if (J2COperation.INTERACTION_SPEC_NAME.equals(((IPropertyDescriptor)evt.getSource()).getName()) && evt.getPropertyChangeType() == 0) {
                    try {
                        PropertyGroupWrapper wrapper = (PropertyGroupWrapper)this.getProperty(J2COperation.INTERACTION_SPEC_PG_NAME);
                        String isName = evt.getNewValue().toString();
                        EditableType isEditableType = J2COperation.this.metadataEdit.getInteractionSpecType(isName);
                        PropertyGroup emdISPG = isEditableType.createProperties();
                        InteractionSpec isBean = ((OutboundFunctionDescription)J2COperation.this.getFunctionDescription()).getInteractionSpec();
                        if (isBean != null) {
                            isEditableType.synchronizeFromBeanToPropertyGroup((Object)isBean, emdISPG);
                        }
                        wrapper.addPropertiesToPropertyGroup(emdISPG);
                        wrapper.setEnabled(true);
                    }
                    catch (MetadataException e) {
                        LogFacility.logErrorMessage((String)e.getMessage(), (Throwable)e);
                    }
                } else if (J2COperation.CONNECTION_SPEC_NAME.equals(((IPropertyDescriptor)evt.getSource()).getName()) && evt.getPropertyChangeType() == 0) {
                    try {
                        PropertyGroupWrapper wrapper = (PropertyGroupWrapper)this.getProperty(J2COperation.CONNECTION_SPEC_PG_NAME);
                        String csName = evt.getNewValue().toString();
                        EditableType isEditableType = J2COperation.this.metadataEdit.getConnectionSpecType(csName);
                        PropertyGroup emdCSPG = isEditableType.createProperties();
                        ConnectionSpec csBean = ((OutboundServiceDescription)J2COperation.this.serviceDescription).getConnectionSpec();
                        if (csBean != null) {
                            isEditableType.synchronizeFromBeanToPropertyGroup((Object)csBean, emdCSPG);
                        }
                        wrapper.addPropertiesToPropertyGroup(emdCSPG);
                        wrapper.setEnabled(true);
                        J2COperation.this.hideProperty(wrapper.getProperties());
                    }
                    catch (MetadataException e) {
                        LogFacility.logErrorMessage((String)e.getMessage(), (Throwable)e);
                    }
                }
            }
        };
        BaseSingleValuedProperty interactionSpecProperty = new BaseSingleValuedProperty(INTERACTION_SPEC_NAME, MessageResource.bind((String)MessageResource.INTERACTION_SPEC_DISP_NAME, (Object)this.getName()), MessageResource.bind((String)MessageResource.INTERACTION_SPEC_DESC, (Object)this.getName()), String.class, propertyGroup);
        Object[] validValues = this.resourceAdapterDescriptor.getInteractionSpecNames();
        interactionSpecProperty.setValidValues(validValues);
        interactionSpecProperty.setRequired(true);
        interactionSpecProperty.setValidValuesEditable(false);
        PropertyGroupWrapper isProperties = new PropertyGroupWrapper(INTERACTION_SPEC_PG_NAME, MessageResource.bind((String)MessageResource.INTERACTION_SPEC_PG_DISP_NAME, (Object)this.getFunctionDescription().getName()), MessageResource.bind((String)MessageResource.INTERACTION_SPEC_PG_DESC, (Object)this.getFunctionDescription().getName()));
        isProperties.setEnabled(true);
        propertyGroup.addProperty((IPropertyDescriptor)isProperties);
        interactionSpecProperty.addPropertyChangeListener((IPropertyChangeListener)propertyGroup);
        FunctionDescription fd = this.getFunctionDescription();
        if (fd instanceof OutboundFunctionDescription) {
            interactionSpecProperty.setValue((Object)((OutboundFunctionDescription)fd).getInteractionSpec().getClass().getName());
        }
        if (validValues.length == 1) {
            interactionSpecProperty.setEnabled(false);
        } else {
            interactionSpecProperty.setEnabled(true);
        }
        BaseSingleValuedProperty connectionSpecProperty = new BaseSingleValuedProperty(CONNECTION_SPEC_NAME, MessageResource.bind((String)MessageResource.CONNECTION_SPEC_DISP_NAME, (Object)this.getName()), MessageResource.bind((String)MessageResource.CONNECTION_SPEC_DESC, (Object)this.getName()), String.class, propertyGroup);
        Object[] csValidValues = this.resourceAdapterDescriptor.getConnectionSpecNames();
        connectionSpecProperty.setValidValues(csValidValues);
        connectionSpecProperty.setRequired(true);
        connectionSpecProperty.setValidValuesEditable(false);
        PropertyGroupWrapper csProperties = new PropertyGroupWrapper(CONNECTION_SPEC_PG_NAME, MessageResource.bind((String)MessageResource.CONNECTION_SPEC_PG_DISP_NAME, (Object)this.getFunctionDescription().getName()), MessageResource.bind((String)MessageResource.CONNECTION_SPEC_PG_DESC, (Object)this.getFunctionDescription().getName()), true);
        csProperties.setEnabled(false);
        propertyGroup.addProperty((IPropertyDescriptor)csProperties);
        connectionSpecProperty.addPropertyChangeListener((IPropertyChangeListener)propertyGroup);
        connectionSpecProperty.setHidden(true);
        connectionSpecProperty.setValue((Object)((OutboundServiceDescription)this.serviceDescription).getConnectionSpec().getClass().getName());
        if (csValidValues.length == 1) {
            connectionSpecProperty.setEnabled(false);
        } else {
            connectionSpecProperty.setEnabled(true);
        }
        return propertyGroup;
    }

    private void hideProperty(IPropertyDescriptor[] propertyDescriptor) {
        int i = 0;
        while (i < propertyDescriptor.length) {
            if (propertyDescriptor[i] instanceof ISingleTypedProperty) {
                IPropertyType type = ((ISingleTypedProperty)propertyDescriptor[i]).getPropertyType();
                if (type instanceof BasePropertyType) {
                    ((BasePropertyType)type).setHidden(true);
                }
            } else if (propertyDescriptor[i] instanceof IPropertyGroup) {
                this.hideProperty(((IPropertyGroup)propertyDescriptor[i]).getProperties());
            }
            ++i;
        }
    }

    private String getDataName(commonj.connector.metadata.description.DataFile dataFile) throws Exception {
        java.net.URI netURI;
        if (dataFile != null && (netURI = dataFile.getLocation()) != null) {
            return URLDecoder.decode(netURI.toString(), "UTF-8");
        }
        return null;
    }
}

