/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.internal.build.j2c;

import com.ibm.adapter.emd.extension.description.spi.J2CServiceDescription;
import com.ibm.adapter.emd.extension.description.spi.ServiceDescription;
import com.ibm.adapter.emd.extension.description.spi.ServiceDescriptionFactory;
import com.ibm.adapter.emd.extension.discovery.spi.ServiceDiscoveryFactory;
import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.adapter.emd.internal.build.j2c.J2CBuildContext;
import com.ibm.adapter.emd.internal.build.j2c.J2CServiceBuilder;
import com.ibm.adapter.emd.internal.extension.discovery.AdapterTypeImpl;
import com.ibm.adapter.emd.internal.extension.discovery.connection.InboundConnectionConfigurationImpl;
import com.ibm.adapter.emd.internal.extension.discovery.connection.InboundConnectionTypeImpl;
import com.ibm.adapter.emd.properties.wrapper.PropertyGroupWrapper;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IImportResult;
import com.ibm.adapter.framework.internal.build.IBuildAgent;
import com.ibm.adapter.framework.internal.build.IServiceBuilder;
import com.ibm.adapter.framework.internal.build.spi.BaseBuildAgent;
import com.ibm.adapter.framework.spi.ImportResult;
import com.ibm.adapter.framework.util.QNameHelper;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ISingleValuedProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import commonj.connector.metadata.MetadataConfigurationType;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.MetadataEdit;
import commonj.connector.metadata.discovery.connection.OutboundConnectionConfiguration;
import commonj.connector.metadata.discovery.connection.OutboundConnectionType;
import commonj.connector.metadata.discovery.properties.PropertyGroup;
import java.util.Arrays;
import java.util.List;
import javax.resource.cci.ConnectionSpec;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;

public class J2CBuildAgent
extends BaseBuildAgent {
    public static final String MANAGED_CONNECTION_FACTORY_PG = "MANAGED_CONNECTION_FACTORY_PG";
    public static final String MANAGED_CONNECTION_FACTORY_CLASS_PROPERTY = "MANAGED_CONNECTION_FACTORY_CLASS_PROPERTY";
    public static final String MANAGED_CONNECTION_FACTORY_PROPERTIES = "MANAGED_CONNECTION_FACTORY_CLASS_PROPERTIES";
    public static final String INBOUND_CONNECTION_GROUP_NAME = "INBOUND_CONNECTION_GROUP_NAME";
    public static final String ACTIVATION_SPEC_TYPE = "ACTIVATION_SPEC_TYPE";
    public static final String MESSAGE_LISTENER_TYPE = "MESSAGE_LISTENER_TYPE";
    public static final String ACTIVATION_SPEC_JNDI_NAME = "ACTIVATION_SPEC_JNDI_NAME";
    public static final String JAAS_AUTHENTICATION_ALIAS = "JAAS_AUTHENTICATION_ALIAS";
    public static final String J2C_CAPABILITY_WID_BASED = "J2C_Capability_WID_Based";
    IResourceAdapterDescriptor resourceAdapterDescriptor;
    public String[] supportedCapabilities = null;
    protected String[] configuredCapabilities;
    MetadataEdit metadataEdit;
    private boolean isOutboundFlow = true;
    private J2CServiceDescription importData;
    public static final String[] baseAdapterFS = new String[]{"com.ibm.j2ca.extension.emd.runtime.StructuredDataFunctionSelector", "com.ibm.j2ca.extension.emd.runtime.EmbeddedNameFunctionSelector", "com.ibm.j2ca.extension.emd.runtime.WBIFunctionSelectorImpl", "com.ibm.j2ca.extension.emd.runtime.FilenameFunctionSelector"};

    public J2CBuildAgent(IResourceAdapterDescriptor resourceAdapterDescriptor) {
        this.resourceAdapterDescriptor = resourceAdapterDescriptor;
        this.importData = ServiceDescriptionFactory.getFactory().createJ2CServiceDescription();
        this.importData.setResourceAdapterDescriptor(resourceAdapterDescriptor);
        this.metadataEdit = ServiceDiscoveryFactory.getFactory().createMetadataEdit(resourceAdapterDescriptor);
        String name = NLS.bind((String)MessageResource.DA_DISPLAY_NAME, (Object[])new String[]{resourceAdapterDescriptor.getConnector().getDisplayName() != null ? resourceAdapterDescriptor.getConnector().getDisplayName() : "", resourceAdapterDescriptor.getConnector().getVersion(), resourceAdapterDescriptor.getConnectorProject().getName()});
        String projectName = resourceAdapterDescriptor.getConnectorProject().getName().replace(' ', '_');
        String fixedName = resourceAdapterDescriptor.getConnector().getDisplayName() != null ? resourceAdapterDescriptor.getConnector().getDisplayName() : "".replace(' ', '_');
        String version = resourceAdapterDescriptor.getConnector().getVersion().replace(' ', '_');
        String vendor = resourceAdapterDescriptor.getConnector().getVendorName().replace(' ', '_');
        String adapterNamespace = new StringBuffer().append(projectName).append('/').append(fixedName).append('/').append(version).append('/').append(vendor).toString();
        QName adapterQName = QNameHelper.createQName((String)adapterNamespace, (String)name);
        this.setName(adapterQName);
        this.setDisplayName(name);
        this.setDescription(name);
    }

    private J2CBuildAgent() {
    }

    public IServiceBuilder getServiceBuilder(IImportResult result) throws BaseException {
        J2CBuildContext context = new J2CBuildContext();
        context.result = result;
        context.resourceAdapterDescriptor = this.resourceAdapterDescriptor;
        context.metadataEdit = this.metadataEdit;
        context.isWIDBased = this.isSupportedConfiguration(J2C_CAPABILITY_WID_BASED);
        context.isOutboundFlow = !this.isSupportedConfiguration(MetadataConfigurationType.INBOUND_SERVICE.toString());
        return new J2CServiceBuilder(context);
    }

    public IImportResult initialize(IEnvironment environment, IPropertyGroup initializeProperties) throws BaseException {
        try {
            ServiceDescription serviceDescription;
            IProgressMonitor monitor = null;
            if (environment != null) {
                monitor = environment.getProgressMonitor();
            }
            if (monitor != null) {
                monitor.beginTask(MessageResource.MSG_INITIALIZING_BUILD_AGENT, 1);
            }
            ServiceDescription description = null;
            if (this.isOutboundFlow) {
                serviceDescription = ServiceDescriptionFactory.getFactory().createOutboundServiceDescription();
                serviceDescription.setConnectionSpec((ConnectionSpec)this.resourceAdapterDescriptor.getConnectionSpecClass(this.resourceAdapterDescriptor.getConnectionSpecNames()[0]).newInstance());
                String mcfName = ((ISingleValuedProperty)initializeProperties.getProperty(MANAGED_CONNECTION_FACTORY_CLASS_PROPERTY)).getValueAsString();
                PropertyGroup mcfPG = ((PropertyGroupWrapper)initializeProperties.getProperty(MANAGED_CONNECTION_FACTORY_PROPERTIES)).getWrappedPropertyGroup();
                OutboundConnectionType type = this.metadataEdit.getOutboundConnectionType(mcfName);
                OutboundConnectionConfiguration connectionConfiguration = type.createOutboundConnectionConfiguration();
                connectionConfiguration.applyManagedConnectionFactoryProperties(mcfPG);
                serviceDescription.setOutboundConnectionAdvancedConfiguration(connectionConfiguration);
                description = serviceDescription;
            } else {
                serviceDescription = ServiceDescriptionFactory.getFactory().createInboundServiceDescription();
                IJavaProject javaProject = JavaCore.create((IProject)this.resourceAdapterDescriptor.getConnectorProject());
                IType type = javaProject.findType("commonj.connector.runtime.FunctionSelector");
                ITypeHierarchy hierarchy = type.newTypeHierarchy(javaProject, (IProgressMonitor)new NullProgressMonitor());
                IType[] impls = hierarchy.getImplementingClasses(type);
                List<String> baseList = Arrays.asList(baseAdapterFS);
                String fsName = "com.ibm.connector2.ims.ico.inbound.IMSFunctionSelector";
                if (impls != null) {
                    int i = 0;
                    while (i < impls.length) {
                        if (!baseList.contains(impls[i].getFullyQualifiedName())) {
                            fsName = impls[i].getFullyQualifiedName();
                            break;
                        }
                        ++i;
                    }
                }
                serviceDescription.setFunctionSelectorClassName(fsName);
                serviceDescription.setListenerClassName(((ISingleValuedProperty)initializeProperties.getProperty(MESSAGE_LISTENER_TYPE)).getValueAsString());
                InboundConnectionConfigurationImpl iccf = new InboundConnectionConfigurationImpl();
                InboundConnectionTypeImpl ict = new InboundConnectionTypeImpl();
                ict.setActivationSpecName(((ISingleValuedProperty)initializeProperties.getProperty(ACTIVATION_SPEC_TYPE)).getValueAsString());
                AdapterTypeImpl adapterType = new AdapterTypeImpl();
                adapterType.setResourceAdapterDescriptor(this.resourceAdapterDescriptor);
                ict.setAdapterType(adapterType);
                iccf.setInboundConnectionType(ict);
                serviceDescription.setInboundConnectionAdvancedConfiguration(iccf);
                description = serviceDescription;
            }
            this.importData.setServiceDescription(description);
            this.importData.setJ2CBuild(true);
            ImportResult result = new ImportResult();
            result.setImportData((Object)this.importData);
            if (monitor != null) {
                monitor.worked(1);
            }
            ImportResult importResult = result;
            return importResult;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }
    }

    public IBuildAgent newInstance() throws BaseException {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        J2CBuildAgent agent = new J2CBuildAgent();
        agent.resourceAdapterDescriptor = this.resourceAdapterDescriptor;
        agent.metadataEdit = this.metadataEdit;
        agent.setName(this.getName());
        agent.setDisplayName(this.getDisplayName());
        agent.setDescription(this.getDescription());
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return agent;
    }

    public IPropertyGroup getInitializeProperties() throws BaseException {
        if (this.initializeProperties == null) {
            try {
                this.initializeProperties = this.isOutboundFlow ? this.defineInitializePropertyGroup() : this.defineInboundInitializePropertyGroup();
            }
            catch (CoreException e) {
                throw BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return super.getInitializeProperties();
    }

    private IPropertyGroup defineInitializePropertyGroup() throws CoreException {
        BasePropertyGroup propertyGroup = new BasePropertyGroup(MANAGED_CONNECTION_FACTORY_PG, MessageResource.MANAGED_CONNECTION_FACTORY_PG_DISP_NAME, MessageResource.MANAGED_CONNECTION_FACTORY_PG_DESC){

            public Object clone() throws CloneNotSupportedException {
                try {
                    BasePropertyGroup clone = (BasePropertyGroup)super.clone();
                    clone.getProperty(J2CBuildAgent.MANAGED_CONNECTION_FACTORY_CLASS_PROPERTY).addPropertyChangeListener((IPropertyChangeListener)clone);
                    return clone;
                }
                catch (Exception exception) {
                    return null;
                }
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if (J2CBuildAgent.MANAGED_CONNECTION_FACTORY_CLASS_PROPERTY.equals(((IPropertyDescriptor)evt.getSource()).getName()) && evt.getPropertyChangeType() == 0) {
                    try {
                        PropertyGroupWrapper wrapper = (PropertyGroupWrapper)this.getProperty(J2CBuildAgent.MANAGED_CONNECTION_FACTORY_PROPERTIES);
                        String mcfName = evt.getNewValue().toString();
                        PropertyGroup mcfProperties = null;
                        OutboundConnectionType type = J2CBuildAgent.this.metadataEdit.getOutboundConnectionType(mcfName);
                        mcfProperties = type.createOutboundConnectionConfiguration().createManagedConnectionFactoryProperties();
                        wrapper.addPropertiesToPropertyGroup(mcfProperties);
                        wrapper.setEnabled(true);
                    }
                    catch (MetadataException e) {
                        LogFacility.logErrorMessage((String)e.getMessage(), (Throwable)e);
                    }
                }
            }
        };
        BaseSingleValuedProperty managedConnectionFactoryProperty = new BaseSingleValuedProperty(MANAGED_CONNECTION_FACTORY_CLASS_PROPERTY, MessageResource.MANAGED_CONNECTION_FACTORY_CLASS_PROPERTY_DISP_NAME, MessageResource.MANAGED_CONNECTION_FACTORY_CLASS_PROPERTY_DESC, String.class, propertyGroup);
        Object[] validValues = this.resourceAdapterDescriptor.getManagedConnectionFactoryNames();
        managedConnectionFactoryProperty.setValidValues(validValues);
        managedConnectionFactoryProperty.setRequired(true);
        managedConnectionFactoryProperty.setValidValuesEditable(false);
        PropertyGroupWrapper mcfProperties = new PropertyGroupWrapper(MANAGED_CONNECTION_FACTORY_PROPERTIES, MessageResource.MANAGED_CONNECTION_FACTORY_PROPERTIES_DISP_NAME, MessageResource.MANAGED_CONNECTION_FACTORY_PROPERTIES_DESC);
        mcfProperties.setEnabled(true);
        propertyGroup.addProperty((IPropertyDescriptor)mcfProperties);
        managedConnectionFactoryProperty.addPropertyChangeListener((IPropertyChangeListener)propertyGroup);
        managedConnectionFactoryProperty.setValue(validValues[0]);
        if (validValues.length == 1) {
            managedConnectionFactoryProperty.setEnabled(false);
        } else {
            managedConnectionFactoryProperty.setEnabled(true);
        }
        return propertyGroup;
    }

    private IPropertyGroup defineInboundInitializePropertyGroup() throws CoreException {
        BasePropertyGroup propertyGroup = new BasePropertyGroup(INBOUND_CONNECTION_GROUP_NAME, MessageResource.INBOUND_CONNECTION_GROUP_DISPLAY_NAME, MessageResource.INBOUND_CONNECTION_GROUP_DESCRIPTION){

            public Object clone() throws CloneNotSupportedException {
                BasePropertyGroup clone = (BasePropertyGroup)super.clone();
                BaseSingleValuedProperty messageListenerType = (BaseSingleValuedProperty)this.getProperty(J2CBuildAgent.MESSAGE_LISTENER_TYPE);
                clone.addProperty((IPropertyDescriptor)messageListenerType);
                BaseSingleValuedProperty activationSpecType = (BaseSingleValuedProperty)this.getProperty(J2CBuildAgent.ACTIVATION_SPEC_TYPE);
                clone.addProperty((IPropertyDescriptor)activationSpecType);
                BaseSingleValuedProperty jndiTarget = (BaseSingleValuedProperty)this.getProperty(J2CBuildAgent.ACTIVATION_SPEC_JNDI_NAME);
                if (jndiTarget != null) {
                    clone.addProperty((IPropertyDescriptor)jndiTarget);
                } else {
                    clone.addProperty((IPropertyDescriptor)((BaseSingleValuedProperty)this.getProperty(J2CBuildAgent.ACTIVATION_SPEC_JNDI_NAME).clone()));
                }
                BaseSingleValuedProperty authenticationAlias = (BaseSingleValuedProperty)this.getProperty(J2CBuildAgent.JAAS_AUTHENTICATION_ALIAS);
                if (authenticationAlias != null) {
                    clone.addProperty((IPropertyDescriptor)authenticationAlias);
                } else {
                    clone.addProperty((IPropertyDescriptor)((BaseSingleValuedProperty)this.getProperty(J2CBuildAgent.JAAS_AUTHENTICATION_ALIAS).clone()));
                }
                clone.getProperty(J2CBuildAgent.ACTIVATION_SPEC_JNDI_NAME).addPropertyChangeListener((IPropertyChangeListener)clone);
                clone.getProperty(J2CBuildAgent.JAAS_AUTHENTICATION_ALIAS).addPropertyChangeListener((IPropertyChangeListener)clone);
                return clone;
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyChangeType() == 0) {
                    if (evt.getSource() == this.getProperty(J2CBuildAgent.ACTIVATION_SPEC_JNDI_NAME)) {
                        String jndi = ((BaseSingleValuedProperty)this.getProperty(J2CBuildAgent.ACTIVATION_SPEC_JNDI_NAME)).getValueAsString();
                        J2CBuildAgent.this.importData.setJNDILookupName(jndi);
                    }
                    if (evt.getSource() == this.getProperty(J2CBuildAgent.JAAS_AUTHENTICATION_ALIAS)) {
                        String jaasAlias = ((BaseSingleValuedProperty)this.getProperty(J2CBuildAgent.JAAS_AUTHENTICATION_ALIAS)).getValueAsString();
                        J2CBuildAgent.this.importData.setJAASAlias(jaasAlias);
                    }
                }
            }
        };
        BaseSingleValuedProperty activationSpecType = new BaseSingleValuedProperty(ACTIVATION_SPEC_TYPE, MessageResource.ACTIVATION_SPEC_TYPE_DISPLAY_NAME, MessageResource.ACTIVATION_SPEC_TYPE_DISPLAY_NAME, String.class, propertyGroup);
        IResourceAdapterDescriptor.IMessageListenerDescriptor messageListener = this.resourceAdapterDescriptor.getMessageListeners()[0];
        String activationSpecClassName = messageListener.getActivationSpecName();
        activationSpecType.setValue((Object)activationSpecClassName);
        activationSpecType.setReadOnly(true);
        BaseSingleValuedProperty messageListenerType = new BaseSingleValuedProperty(MESSAGE_LISTENER_TYPE, MessageResource.MESSAGE_LISTENER_TYPE_DISPLAY_NAME, MessageResource.MESSAGE_LISTENER_TYPE_DESCRIPTION, String.class, propertyGroup);
        String messageListenerClassName = messageListener.getMessageListenerType();
        messageListenerType.setValue((Object)messageListenerClassName);
        messageListenerType.setReadOnly(true);
        BaseSingleValuedProperty jndiTarget = new BaseSingleValuedProperty(ACTIVATION_SPEC_JNDI_NAME, MessageResource.ACTIVATION_SPEC_JNDI_NAME_DISPLAY_NAME, MessageResource.ACTIVATION_SPEC_JNDI_NAME_DESCRIPTION, String.class, propertyGroup);
        jndiTarget.setRequired(true);
        jndiTarget.addPropertyChangeListener((IPropertyChangeListener)propertyGroup);
        BaseSingleValuedProperty authenticationAlias = new BaseSingleValuedProperty(JAAS_AUTHENTICATION_ALIAS, MessageResource.JAAS_AUTHENTICATION_ALIAS_DISPLAY_NAME, MessageResource.JAAS_AUTHENTICATION_ALIAS_DESCRIPTION, String.class, propertyGroup);
        authenticationAlias.addPropertyChangeListener((IPropertyChangeListener)propertyGroup);
        return propertyGroup;
    }

    public String[] getConfiguration() {
        return this.configuredCapabilities;
    }

    public String[] getSupportedConfiguration() {
        if (this.supportedCapabilities == null) {
            boolean supportsInbound = this.resourceAdapterDescriptor.getMessageListeners() != null && this.resourceAdapterDescriptor.getMessageListeners().length != 0;
            this.supportedCapabilities = supportsInbound ? new String[]{J2C_CAPABILITY_WID_BASED, MetadataConfigurationType.INBOUND_SERVICE.toString()} : new String[]{J2C_CAPABILITY_WID_BASED};
        }
        return this.supportedCapabilities;
    }

    public void setConfiguration(String[] capabilities) throws BaseException {
        this.configuredCapabilities = capabilities;
        this.isOutboundFlow = true;
        int i = 0;
        while (i < capabilities.length) {
            if (MetadataConfigurationType.INBOUND_SERVICE.toString().equals(capabilities[i])) {
                this.isOutboundFlow = false;
            }
            ++i;
        }
        this.initializeProperties = null;
    }
}

