/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.extension.properties;

import com.ibm.adapter.emd.extension.properties.PropertyVetoException;
import com.ibm.adapter.emd.extension.properties.SingleTypedPropertyImpl;
import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.properties.PropertyEvent;
import commonj.connector.metadata.discovery.properties.SingleValuedProperty;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SingleValuedPropertyImpl
extends SingleTypedPropertyImpl
implements SingleValuedProperty {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    protected Object value = null;

    public SingleValuedPropertyImpl(String propertyName, Class propertyType) throws MetadataException {
        super(propertyName, propertyType);
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
            LogFacility.traceLogger.log(Level.FINEST, "Name : " + propertyName);
            LogFacility.TrcExit();
        }
    }

    @Override
    public Object clone() {
        SingleValuedPropertyImpl prop = (SingleValuedPropertyImpl)super.clone();
        return prop;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueAsString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    public void setValue(Object newValue) throws MetadataException {
        if (!this.isEnabled()) {
            Status status = new Status(4, "com.ibm.adapter.emd", 4, MessageResource.ERR_PROPERTY_IS_DISABLED, null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new MetadataException(MessageResource.ERR_PROPERTY_IS_DISABLED);
        }
        if (newValue != this.value && (newValue != null && !newValue.equals(this.value) || this.value != null && !this.value.equals(newValue))) {
            if (this.propertyType.isPrimitive() && newValue == null) {
                Status status = new Status(4, "com.ibm.adapter.emd", 4, NLS.bind((String)MessageResource.ERR_PRIMITIVE_TYPE_CANNOT_BE_NULL, (Object)this.getDisplayName()), null);
                LogFacility.logErrorMessage((IStatus)status);
                throw new MetadataException(NLS.bind((String)MessageResource.ERR_PRIMITIVE_TYPE_CANNOT_BE_NULL, (Object)this.getDisplayName()));
            }
            if (newValue == null || this.propertyType.getType().isAssignableFrom(newValue.getClass())) {
                Object oldValue;
                block8: {
                    oldValue = this.getValue();
                    try {
                        this.vetoableChanges.fireVetoableChange(oldValue, newValue);
                    }
                    catch (PropertyVetoException ex) {
                        if (ex.getErrorCode() == 0) {
                            throw new MetadataException(ex.getLocalizedMessage(), (Throwable)ex);
                        }
                        if (ex.getErrorCode() != 1) break block8;
                        this.value = newValue;
                        this.setSet(true);
                        this.propertyChanges.firePropertyValueChange(oldValue, newValue);
                        throw new MetadataException(ex.getLocalizedMessage(), (Throwable)ex);
                    }
                }
                this.value = newValue;
                this.setSet(true);
                this.setValidNoNotify(true);
                this.propertyChanges.firePropertyValueChange(oldValue, newValue);
            } else {
                Status status = new Status(4, "com.ibm.adapter.emd", 4, MessageResource.ERR_INVALID_OBJECT_TYPE, null);
                LogFacility.logErrorMessage((IStatus)status);
                throw new MetadataException(MessageResource.ERR_INVALID_OBJECT_TYPE);
            }
        }
    }

    public void setValueAsString(String newValue) throws MetadataException {
        if (!this.isEnabled()) {
            throw new MetadataException(MessageResource.ERR_PROPERTY_IS_DISABLED);
        }
        if (this.propertyType.isPrimitive() && newValue == null) {
            throw new MetadataException(NLS.bind((String)MessageResource.ERR_PRIMITIVE_TYPE_CANNOT_BE_NULL, (Object)this.getDisplayName()));
        }
        switch (this.propertyType.getPropertyTypeIdentifier()) {
            case 1: {
                this.setValue(new Boolean(newValue));
                break;
            }
            case 2: {
                try {
                    this.setValue(new Byte(newValue));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException(MessageResource.ERR_INVALID_STRING);
                }
            }
            case 3: {
                if (newValue != null && newValue.length() >= 1) {
                    int charValue = UTF16.charAt((String)newValue, (int)0);
                    this.setValue(new Character(UCharacter.toChars((int)charValue)[0]));
                    break;
                }
                throw new MetadataException(MessageResource.ERR_INVALID_STRING);
            }
            case 4: {
                try {
                    this.setValue(new Double(newValue));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException(MessageResource.ERR_INVALID_STRING);
                }
            }
            case 5: {
                try {
                    this.setValue(new Float(newValue));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException(MessageResource.ERR_INVALID_STRING);
                }
            }
            case 6: {
                try {
                    this.setValue(new Integer(newValue));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException(MessageResource.ERR_INVALID_STRING);
                }
            }
            case 7: {
                try {
                    this.setValue(new Long(newValue));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException(MessageResource.ERR_INVALID_STRING);
                }
            }
            case 9: {
                try {
                    this.setValue(new Short(newValue));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MetadataException(MessageResource.ERR_INVALID_STRING);
                }
            }
            case 0: {
                this.setValue(newValue);
                break;
            }
            case 11: {
                this.setValue(new BigDecimal(newValue));
                break;
            }
            case 10: {
                this.setValue(new BigInteger(newValue));
                break;
            }
            default: {
                throw new MetadataException(MessageResource.ERR_SET_AS_STRING_NOT_SUPPORTED);
            }
        }
    }

    public void unSet() {
        try {
            this.setValue(this.getPropertyType().getDefaultValue());
        }
        catch (MetadataException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
        }
        this.setSet(false);
    }

    @Override
    public void vetoableChange(PropertyEvent evt) throws PropertyVetoException {
    }

    @Override
    public void propertyChange(PropertyEvent arg0) {
    }
}

