/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.extension.properties;

import com.ibm.adapter.emd.extension.properties.SingleValuedPropertyImpl;
import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.properties.extensions.SchemaTypeProperty;
import java.net.URI;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.eclipse.osgi.util.NLS;

public class SchemaTypePropertyImpl
extends SingleValuedPropertyImpl
implements SchemaTypeProperty {
    private URI location;
    protected boolean isType = false;

    public SchemaTypePropertyImpl(String name) throws MetadataException {
        super(name, QName.class);
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
            LogFacility.traceLogger.log(Level.FINEST, "Name : " + name);
            LogFacility.TrcExit();
        }
    }

    @Override
    public String getValueAsString() {
        if (this.getValue() == null) {
            return null;
        }
        return this.getValue().toString();
    }

    @Override
    public void setValueAsString(String newValue) throws MetadataException {
        if (newValue != null) {
            QName qname = QName.valueOf(newValue);
            this.setValue(qname);
        } else {
            this.setValue(newValue);
        }
    }

    public URI getLocation() {
        return this.location;
    }

    public void setLocation(URI uri) throws MetadataException {
        if (uri.isAbsolute()) {
            throw new MetadataException(NLS.bind((String)MessageResource.ERR_ONLY_RELATIVE_URI, (Object)uri));
        }
        this.location = uri;
    }

    public boolean isType() {
        return this.isType;
    }

    public void setType(boolean isType) {
        this.isType = isType;
    }
}

