/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.extension.properties;

import com.ibm.adapter.emd.extension.properties.PropertyDescriptorImpl;
import com.ibm.adapter.emd.extension.properties.PropertyVetoException;
import com.ibm.adapter.emd.internal.LogFacility;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.properties.PropertyDescriptor;
import commonj.connector.metadata.discovery.properties.PropertyEvent;
import commonj.connector.metadata.discovery.properties.PropertyGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PropertyGroupImpl
extends PropertyDescriptorImpl
implements PropertyGroup {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private ArrayList properties = new ArrayList();
    private Map propertyNames = new HashMap();

    public PropertyGroupImpl(String groupName) throws MetadataException {
        super(groupName);
    }

    public void addProperty(PropertyDescriptor property) {
        if (!this.properties.contains(property) && !this.propertyNames.keySet().contains(property.getName())) {
            this.properties.add(property);
            this.propertyNames.put(property.getName(), property);
            this.propertyChanges.firePropertyGroupAddChild(property);
        }
    }

    @Override
    public Object clone() {
        PropertyGroupImpl clone = (PropertyGroupImpl)super.clone();
        clone.properties = new ArrayList();
        clone.propertyNames = new HashMap();
        for (PropertyDescriptor property : this.properties) {
            clone.addProperty((PropertyDescriptor)property.clone());
        }
        return clone;
    }

    public PropertyDescriptor[] getProperties() {
        try {
            return Collections.unmodifiableList(this.properties).toArray(new PropertyDescriptor[0]);
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return new PropertyDescriptor[0];
        }
    }

    public PropertyDescriptor getProperty(String propertyName) {
        return (PropertyDescriptor)this.propertyNames.get(propertyName);
    }

    public void remove(PropertyDescriptor property) {
        if (property != null) {
            this.properties.remove(property);
            this.propertyNames.remove(property.getName());
            this.propertyChanges.firePropertyGroupRemoveChild(property);
        }
    }

    public void removeAll() {
        PropertyDescriptor[] oldProperties = this.properties.toArray(new PropertyDescriptor[0]);
        this.properties.clear();
        this.propertyNames.clear();
        this.propertyChanges.firePropertyGroupRemoveAll(oldProperties);
    }

    public void replaceAll(PropertyDescriptor[] newProperties) {
        PropertyDescriptor[] oldProperties = this.properties.toArray(new PropertyDescriptor[0]);
        this.properties.clear();
        this.propertyNames.clear();
        int size = newProperties.length;
        int i = 0;
        while (i < size) {
            this.properties.add(newProperties[i]);
            this.propertyNames.put(newProperties[i].getName(), newProperties[i]);
            ++i;
        }
        this.propertyChanges.firePropertyGroupReplaceAll(oldProperties, newProperties);
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (PropertyDescriptor property : this.properties) {
            if (!(property instanceof PropertyDescriptorImpl)) continue;
            ((PropertyDescriptorImpl)property).setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    @Override
    public void vetoableChange(PropertyEvent evt) throws PropertyVetoException {
    }

    @Override
    public void propertyChange(PropertyEvent arg0) {
    }

    public String convertToString() {
        return null;
    }

    public void populateFromString(String value) throws MetadataException {
    }
}

