/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.emd.extension.properties;

import com.ibm.adapter.emd.extension.properties.IVetoableChangeListenerInterface;
import com.ibm.adapter.emd.extension.properties.PropertyChangeSupport;
import com.ibm.adapter.emd.extension.properties.PropertyVetoException;
import com.ibm.adapter.emd.internal.LogFacility;
import com.ibm.adapter.emd.internal.MessageResource;
import commonj.connector.metadata.MetadataException;
import commonj.connector.metadata.discovery.properties.PropertyChangeListener;
import commonj.connector.metadata.discovery.properties.PropertyDescriptor;
import commonj.connector.metadata.discovery.properties.PropertyEvent;

public abstract class PropertyDescriptorImpl
implements PropertyDescriptor,
PropertyChangeListener,
IVetoableChangeListenerInterface {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private String description;
    private String displayName;
    private boolean isDescriptionSet = false;
    private boolean isDisplayNameSet = false;
    private boolean isNameSet = false;
    private String name;
    protected boolean enabled = true;
    protected PropertyChangeSupport propertyChanges;
    protected PropertyChangeSupport vetoableChanges;

    public PropertyDescriptorImpl(String propertyName) throws MetadataException {
        this.initialize(propertyName);
        this.setDisplayName(propertyName);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChanges.addPropertyChangeListener(listener);
    }

    public void addVetoablePropertyChangeListener(IVetoableChangeListenerInterface listener) {
        this.vetoableChanges.addVetoableChangeListener(listener);
    }

    public Object clone() {
        try {
            PropertyDescriptorImpl clone = (PropertyDescriptorImpl)super.clone();
            clone.propertyChanges = new PropertyChangeSupport(clone);
            clone.vetoableChanges = new PropertyChangeSupport(clone);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LogFacility.logErrorMessage((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChanges.removePropertyChangeListener(listener);
    }

    public void removeVetoablePropertyChangeListener(IVetoableChangeListenerInterface listener) {
        this.vetoableChanges.removeVetoableChangeListener(listener);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.propertyChanges.firePropertyEnabledChange(enabled);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setName(String name) {
        if (!this.isNameSet && name != null && !name.equals("")) {
            this.name = name;
            this.isNameSet = true;
        }
    }

    protected void initialize(String propertyName) throws MetadataException {
        if (propertyName == null) {
            throw new MetadataException(MessageResource.ERR_PROP_NAME_NULL);
        }
        this.setName(propertyName);
        this.propertyChanges = new PropertyChangeSupport(this);
        this.vetoableChanges = new PropertyChangeSupport(this);
    }

    public abstract void propertyChange(PropertyEvent var1);

    @Override
    public abstract void vetoableChange(PropertyEvent var1) throws PropertyVetoException;

    public String getID() {
        return null;
    }
}

