/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.c.common;

import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;

public class CCodepageHelper {
    public static final String copyright = "Licensed Material - Property of IBM\n com.ibm.adapter.c\n(C) Copyright IBM Corp. 2004 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static CCodepageHelper fieldInstance;

    public static synchronized CCodepageHelper getInstance() {
        if (fieldInstance == null) {
            fieldInstance = new CCodepageHelper();
        }
        return fieldInstance;
    }

    public String[] findCCodePages() {
        SortedMap<String, Charset> csMap = Charset.availableCharsets();
        Set keySet = csMap.keySet();
        Comparator<String> c = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int order = 0;
                order = o1.compareTo(o2);
                return order;
            }

            @Override
            public boolean equals(Object obj) {
                return super.equals(obj);
            }
        };
        TreeSet<String> allCodepages = new TreeSet<String>(c);
        allCodepages.addAll(keySet);
        for (String canonicalCP : keySet) {
            Charset aCs = Charset.forName(canonicalCP);
            Set<String> aliasSet = aCs.aliases();
            if (aliasSet.isEmpty()) continue;
            for (String aliasCP : aliasSet) {
                allCodepages.add(aliasCP);
            }
        }
        String[] strArray = new String[allCodepages.size()];
        int i = 0;
        Iterator it = allCodepages.iterator();
        while (it.hasNext()) {
            strArray[i++] = (String)it.next();
        }
        return strArray;
    }
}

