/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.binding.registry.internal;

import com.ibm.adapter.binding.registry.BindingConstants;
import com.ibm.adapter.binding.registry.IBinding;
import com.ibm.adapter.binding.registry.IBindingRegistry;
import com.ibm.adapter.binding.registry.IBindingRegistryListener;
import com.ibm.adapter.binding.registry.IBindingRegistrySPI;
import com.ibm.adapter.binding.registry.ServiceTypes;
import com.ibm.adapter.binding.registry.internal.Binding;
import com.ibm.adapter.binding.registry.internal.BindingRegistryActivator;
import com.ibm.adapter.binding.registry.internal.BindingRegistryConstants;
import com.ibm.adapter.binding.registry.internal.BindingRegistryPersistence;
import com.ibm.adapter.binding.registry.internal.FaultBinding;
import com.ibm.adapter.binding.registry.internal.LogFacility;
import com.ibm.adapter.binding.registry.internal.MessageResource;
import com.ibm.adapter.binding.registry.util.BindingRegistryHelper;
import com.ibm.adapter.binding.registry.util.QNameUtil;
import commonj.connector.metadata.BindingConfigurationEdit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class BindingRegistry
implements IBindingRegistry,
IBindingRegistrySPI,
BindingConstants,
BindingRegistryConstants {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2006 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private static BindingRegistry instance;
    private Map dataBindings = Collections.synchronizedMap(new HashMap());
    private Map dataHandlers = Collections.synchronizedMap(new HashMap());
    private Map dataBindingGenerators = Collections.synchronizedMap(new HashMap());
    private Map functionSelectors = Collections.synchronizedMap(new HashMap());
    private Map faultDataBindings = Collections.synchronizedMap(new HashMap());
    private Map faultSelectors = Collections.synchronizedMap(new HashMap());
    private Vector listeners = new Vector();

    public static BindingRegistry getRegistry() {
        if (instance == null) {
            instance = new BindingRegistry();
            BindingRegistryPersistence.primeRegistryFromPersistentStoreEntries();
        }
        return instance;
    }

    private BindingRegistry() {
        boolean hasBindings;
        IConfigurationElement[] bindingList = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.adapter.binding.registry.Bindings");
        boolean bl = hasBindings = bindingList != null && bindingList.length > 0;
        if (hasBindings) {
            int i = 0;
            while (i < bindingList.length) {
                IConfigurationElement[] faultList;
                Status status;
                IConfigurationElement bindingElement = bindingList[i];
                String description = bindingElement.getAttribute("description");
                String displayName = bindingElement.getAttribute("displayName");
                String className = bindingElement.getAttribute("className");
                String supportedTypes = bindingElement.getAttribute("supportedType");
                String dataTypes = bindingElement.getAttribute("supportedDataType");
                String dataCategories = bindingElement.getAttribute("dataCategory");
                String asiNSURIs = bindingElement.getAttribute("asiNamespaceURI");
                String type = bindingElement.getAttribute("type");
                String generatedType = bindingElement.getAttribute("generatedType");
                String serviceTypes = bindingElement.getAttribute("supportedServiceType");
                String tags = bindingElement.getAttribute("tag");
                String requireConfiguration = bindingElement.getAttribute("requireConfiguration");
                String configurationClassName = bindingElement.getAttribute("configurationClassName");
                String propertiesJavaBeanClassName = bindingElement.getAttribute("propertiesJavaBeanClassName");
                Object instance = null;
                BindingConfigurationEdit configuration = null;
                Object propertiesJavaBean = null;
                String extensionContributor = bindingElement.getContributor().getName();
                boolean invalidExtension = false;
                if (description == null) {
                    status = new Status(4, "com.ibm.adapter.binding.registry", 4, NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_REQUIRED_PROPERTY_NULL, (Object)"description", (Object)extensionContributor), null);
                    LogFacility.logErrorMessage((IStatus)status);
                    invalidExtension = true;
                }
                if (displayName == null) {
                    status = new Status(4, "com.ibm.adapter.binding.registry", 4, NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_REQUIRED_PROPERTY_NULL, (Object)"displayName", (Object)extensionContributor), null);
                    LogFacility.logErrorMessage((IStatus)status);
                    invalidExtension = true;
                }
                if (className == null) {
                    status = new Status(4, "com.ibm.adapter.binding.registry", 4, NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_REQUIRED_PROPERTY_NULL, (Object)"className", (Object)extensionContributor), null);
                    LogFacility.logErrorMessage((IStatus)status);
                    invalidExtension = true;
                } else {
                    try {
                        instance = bindingElement.createExecutableExtension("className");
                    }
                    catch (CoreException coreException) {}
                }
                if (serviceTypes == null) {
                    status = new Status(4, "com.ibm.adapter.binding.registry", 4, NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_REQUIRED_PROPERTY_NULL, (Object)"supportedServiceType", (Object)extensionContributor), null);
                    LogFacility.logErrorMessage((IStatus)status);
                    invalidExtension = true;
                }
                if (type == null) {
                    status = new Status(4, "com.ibm.adapter.binding.registry", 4, NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_REQUIRED_PROPERTY_NULL, (Object)"type", (Object)extensionContributor), null);
                    LogFacility.logErrorMessage((IStatus)status);
                    invalidExtension = true;
                } else if (!this.hasValidType(type)) {
                    status = new Status(4, "com.ibm.adapter.binding.registry", 4, NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_INVALID_PROPERTY_VALUE, (Object)"type"), null);
                    LogFacility.logErrorMessage((IStatus)status);
                    invalidExtension = true;
                } else if ("DataBindingGenerator".equals(type) && !this.hasValidGeneratedType(generatedType)) {
                    status = new Status(4, "com.ibm.adapter.binding.registry", 4, NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_INVALID_PROPERTY_VALUE, (Object)"generatedType"), null);
                    LogFacility.logErrorMessage((IStatus)status);
                    invalidExtension = true;
                }
                if (requireConfiguration != null && !requireConfiguration.equals("") && requireConfiguration.equals(Boolean.TRUE.toString())) {
                    if (propertiesJavaBeanClassName == null) {
                        status = new Status(4, "com.ibm.adapter.binding.registry", 4, NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_REQUIRED_PROPERTY_NULL, (Object)"propertiesJavaBeanClassName", (Object)extensionContributor), null);
                        LogFacility.logErrorMessage((IStatus)status);
                        invalidExtension = true;
                    } else {
                        try {
                            propertiesJavaBean = bindingElement.createExecutableExtension("propertiesJavaBeanClassName");
                        }
                        catch (CoreException e) {
                            LogFacility.logErrorMessage((IStatus)e.getStatus());
                            invalidExtension = true;
                        }
                    }
                    if (configurationClassName != null) {
                        try {
                            configuration = (BindingConfigurationEdit)bindingElement.createExecutableExtension("configurationClassName");
                        }
                        catch (CoreException e) {
                            LogFacility.logErrorMessage((IStatus)e.getStatus());
                            invalidExtension = true;
                        }
                    }
                }
                boolean hasFaults = (faultList = bindingElement.getChildren("SupportedFault")) != null && faultList.length > 0;
                HashMap<String, String> faultAttributeMap = new HashMap<String, String>();
                if (hasFaults) {
                    int j = 0;
                    while (j < faultList.length) {
                        IConfigurationElement faultElement = faultList[j];
                        String dataType = faultElement.getAttribute("dataType");
                        if (dataType == null) {
                            Status status2 = new Status(4, "com.ibm.adapter.binding.registry", 4, NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_REQUIRED_PROPERTY_NULL, (Object)"dataType", (Object)extensionContributor), null);
                            LogFacility.logErrorMessage((IStatus)status2);
                            invalidExtension = true;
                            break;
                        }
                        String nativeName = faultElement.getAttribute("nativeName");
                        if (nativeName == null) {
                            Status status3 = new Status(4, "com.ibm.adapter.binding.registry", 4, NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_REQUIRED_PROPERTY_NULL, (Object)"nativeName", (Object)extensionContributor), null);
                            LogFacility.logErrorMessage((IStatus)status3);
                            invalidExtension = true;
                            break;
                        }
                        faultAttributeMap.put(dataType, nativeName);
                        ++j;
                    }
                }
                if (!invalidExtension) {
                    Binding binding = new Binding();
                    binding.setDescription(description);
                    binding.setDisplayName(displayName);
                    binding.setClassName(className);
                    binding.setInstance(instance);
                    binding.setType(type);
                    binding.setGeneratedType(generatedType);
                    if (requireConfiguration != null) {
                        binding.setRequireConfiguration(Boolean.valueOf(requireConfiguration));
                        binding.setConfigurationClassName(configurationClassName);
                        binding.setConfiguration(configuration);
                        binding.setPropertiesJavaBeanClassName(propertiesJavaBeanClassName);
                        binding.setPropertiesJavaBean(propertiesJavaBean);
                    }
                    if (!faultAttributeMap.isEmpty()) {
                        for (Map.Entry entry : faultAttributeMap.entrySet()) {
                            FaultBinding fault = new FaultBinding();
                            fault.setDataType(QNameUtil.qnameFromString((String)entry.getKey()));
                            fault.setNativeName((String)entry.getValue());
                            binding.addSupportedFault(fault);
                        }
                    }
                    binding.setLinkage(0);
                    String[] serviceTypeTokens = serviceTypes.split(",");
                    ArrayList<String> serviceNames = new ArrayList<String>();
                    int j = 0;
                    while (j < serviceTypeTokens.length) {
                        QName serviceTypeQName = QNameUtil.qnameFromString(serviceTypeTokens[j].trim());
                        String serviceTag = (String)ServiceTypes.serviceQName2ServiceTagMap.get(serviceTypeQName);
                        if (serviceTag != null && !serviceNames.contains(serviceTag)) {
                            serviceNames.add(serviceTag);
                        }
                        ++j;
                    }
                    binding.setSupportedServiceTypes(serviceNames);
                    if (supportedTypes != null && !"".equals(supportedTypes)) {
                        String[] supportedTypeTokens = supportedTypes.split(",");
                        ArrayList<String> supportedTypeNames = new ArrayList<String>();
                        int j2 = 0;
                        while (j2 < supportedTypeTokens.length) {
                            supportedTypeNames.add(supportedTypeTokens[j2].trim());
                            ++j2;
                        }
                        binding.setSupportedTypes(supportedTypeNames);
                    }
                    if (dataTypes != null && !"".equals(dataTypes)) {
                        String[] dataTypeTokens = dataTypes.split(",");
                        ArrayList<QName> dataTypeQNames = new ArrayList<QName>();
                        int j3 = 0;
                        while (j3 < dataTypeTokens.length) {
                            dataTypeQNames.add(QNameUtil.qnameFromString(dataTypeTokens[j3].trim()));
                            ++j3;
                        }
                        binding.setSupportedDataTypes(dataTypeQNames);
                    }
                    if (asiNSURIs != null && !"".equals(asiNSURIs)) {
                        String[] asiNSURITokens = asiNSURIs.split(",");
                        ArrayList<String> asiNamespaces = new ArrayList<String>();
                        int j4 = 0;
                        while (j4 < asiNSURITokens.length) {
                            asiNamespaces.add(asiNSURITokens[j4].trim());
                            ++j4;
                        }
                        binding.setAsiNamespaces(asiNamespaces);
                    }
                    if (tags != null && !"".equals(tags)) {
                        String[] tagTokens = tags.split(",");
                        ArrayList<String> tagNames = new ArrayList<String>();
                        int j5 = 0;
                        while (j5 < tagTokens.length) {
                            tagNames.add(tagTokens[j5].trim());
                            ++j5;
                        }
                        binding.setTags(tagNames);
                    }
                    if (dataCategories != null && !"".equals(dataCategories)) {
                        String[] dataCategoryTokens = dataCategories.split(",");
                        ArrayList<String> dataCategoryNames = new ArrayList<String>();
                        int j6 = 0;
                        while (j6 < dataCategoryTokens.length) {
                            dataCategoryNames.add(dataCategoryTokens[j6].trim());
                            ++j6;
                        }
                        binding.setDataCategories(dataCategoryNames);
                    }
                    binding.setProviderDescription(extensionContributor);
                    this.addEntry(binding);
                }
                ++i;
            }
        }
    }

    private IBinding[] getSortedBindings(IBinding[] bindings) {
        SortedBindings sortedBindings = new SortedBindings();
        int i = 0;
        while (i < bindings.length) {
            sortedBindings.addDescend(bindings[i]);
            ++i;
        }
        return sortedBindings.getSortedElements();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public synchronized boolean addEntry(IBinding binding) {
        boolean added;
        block39: {
            block38: {
                int linkage;
                String className;
                String type;
                block44: {
                    block43: {
                        block42: {
                            block41: {
                                block40: {
                                    added = false;
                                    if (!this.isValidEntry(binding)) break block39;
                                    type = binding.getType();
                                    className = binding.getClassName();
                                    linkage = binding.getLinkage();
                                    if (!"DataBinding".equals(type)) break block40;
                                    if (!this.dataBindings.containsKey(className)) {
                                        ArrayList<IBinding> entries = new ArrayList<IBinding>();
                                        entries.add(binding);
                                        this.dataBindings.put(className, entries);
                                        added = true;
                                        break block38;
                                    } else {
                                        if (linkage == 0) {
                                            return false;
                                        }
                                        List entries = (List)this.dataBindings.get(className);
                                        if (!entries.contains(binding)) {
                                            entries.add(binding);
                                            added = true;
                                            break block38;
                                        } else {
                                            if (LogFacility.trace) {
                                                LogFacility.Trace((String)NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_ALREADY_EXISTS, (Object)binding.getClassName(), (Object)binding.getProject().getName()), (short)30);
                                            }
                                            return false;
                                        }
                                    }
                                }
                                if (!"DataHandler".equals(type)) break block41;
                                if (!this.dataHandlers.containsKey(className)) {
                                    ArrayList<IBinding> entries = new ArrayList<IBinding>();
                                    entries.add(binding);
                                    this.dataHandlers.put(className, entries);
                                    added = true;
                                    break block38;
                                } else {
                                    if (linkage == 0) {
                                        return false;
                                    }
                                    List entries = (List)this.dataHandlers.get(className);
                                    if (!entries.contains(binding)) {
                                        entries.add(binding);
                                        added = true;
                                        break block38;
                                    } else {
                                        if (LogFacility.trace) {
                                            LogFacility.Trace((String)NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_ALREADY_EXISTS, (Object)binding.getClassName(), (Object)binding.getProject().getName()), (short)30);
                                        }
                                        return false;
                                    }
                                }
                            }
                            if (!"DataBindingGenerator".equals(type)) break block42;
                            if (!this.dataBindingGenerators.containsKey(className)) {
                                ArrayList<IBinding> entries = new ArrayList<IBinding>();
                                entries.add(binding);
                                this.dataBindingGenerators.put(className, entries);
                                added = true;
                                break block38;
                            } else {
                                if (linkage == 0) {
                                    return false;
                                }
                                List entries = (List)this.dataBindingGenerators.get(className);
                                if (!entries.contains(binding)) {
                                    entries.add(binding);
                                    added = true;
                                    break block38;
                                } else {
                                    if (LogFacility.trace) {
                                        LogFacility.Trace((String)NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_ALREADY_EXISTS, (Object)binding.getClassName(), (Object)binding.getProject().getName()), (short)30);
                                    }
                                    return false;
                                }
                            }
                        }
                        if (!"FunctionSelector".equals(type)) break block43;
                        if (!this.functionSelectors.containsKey(className)) {
                            ArrayList<IBinding> entries = new ArrayList<IBinding>();
                            entries.add(binding);
                            this.functionSelectors.put(className, entries);
                            added = true;
                            break block38;
                        } else {
                            if (linkage == 0) {
                                return false;
                            }
                            List entries = (List)this.functionSelectors.get(className);
                            if (!entries.contains(binding)) {
                                entries.add(binding);
                                added = true;
                                break block38;
                            } else {
                                if (LogFacility.trace) {
                                    LogFacility.Trace((String)NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_ALREADY_EXISTS, (Object)binding.getClassName(), (Object)binding.getProject().getName()), (short)30);
                                }
                                return false;
                            }
                        }
                    }
                    if (!"FaultDataBinding".equals(type)) break block44;
                    if (!this.faultDataBindings.containsKey(className)) {
                        ArrayList<IBinding> entries = new ArrayList<IBinding>();
                        entries.add(binding);
                        this.faultDataBindings.put(className, entries);
                        added = true;
                        break block38;
                    } else {
                        if (linkage == 0) {
                            return false;
                        }
                        List entries = (List)this.faultDataBindings.get(className);
                        if (!entries.contains(binding)) {
                            entries.add(binding);
                            added = true;
                            break block38;
                        } else {
                            if (LogFacility.trace) {
                                LogFacility.Trace((String)NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_ALREADY_EXISTS, (Object)binding.getClassName(), (Object)binding.getProject().getName()), (short)30);
                            }
                            return false;
                        }
                    }
                }
                if ("FaultSelector".equals(type)) {
                    if (!this.faultSelectors.containsKey(className)) {
                        ArrayList<IBinding> entries = new ArrayList<IBinding>();
                        entries.add(binding);
                        this.faultSelectors.put(className, entries);
                        added = true;
                    } else {
                        if (linkage == 0) {
                            return false;
                        }
                        List entries = (List)this.faultSelectors.get(className);
                        if (!entries.contains(binding)) {
                            entries.add(binding);
                            added = true;
                        } else {
                            if (LogFacility.trace) {
                                LogFacility.Trace((String)NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_ALREADY_EXISTS, (Object)binding.getClassName(), (Object)binding.getProject().getName()), (short)30);
                            }
                            return false;
                        }
                    }
                }
            }
            if (added) {
                this.notifyListeners(binding, 0);
            }
        }
        return added;
    }

    @Override
    public boolean updateUserEntry(IBinding oldEntry, IBinding newEntry) {
        if (newEntry.equals(oldEntry)) {
            return false;
        }
        boolean updated = this.updateBinding(oldEntry, newEntry);
        boolean added = false;
        if (updated && (added = this.addEntry(newEntry))) {
            this.persistEntry(newEntry);
            this.notifyListeners(newEntry, 2);
        }
        return updated & added;
    }

    @Override
    public void persistEntry(IBinding binding) {
        BindingRegistryPersistence.save(binding);
    }

    @Override
    public void persistEntries(IBinding[] bindings) {
        BindingRegistryPersistence.save(bindings);
    }

    private boolean updateBinding(IBinding oldBinding, IBinding newBinding) {
        boolean updated15;
        int size13;
        int oldSize13;
        boolean updated8;
        int size1;
        boolean updated1 = !oldBinding.getDescription().equals(newBinding.getDescription());
        boolean updated2 = !oldBinding.getDisplayName().equals(newBinding.getDisplayName());
        boolean updated3 = !oldBinding.getClassName().equals(newBinding.getClassName());
        boolean updated4 = !oldBinding.getType().equals(newBinding.getType());
        int oldSize1 = oldBinding.getSupportedTypes().size();
        if (oldSize1 != (size1 = newBinding.getSupportedTypes().size())) {
            return true;
        }
        List newSupportedTypes = newBinding.getSupportedTypes();
        oldBinding.addSupportedTypes(newSupportedTypes);
        int newSize1 = oldBinding.getSupportedTypes().size();
        boolean updated5 = newSize1 > oldSize1;
        int oldSize2 = oldBinding.getAsiNamespaces().size();
        int size2 = newBinding.getAsiNamespaces().size();
        if (oldSize2 != size2) {
            return true;
        }
        List newAsiNamespaces = newBinding.getAsiNamespaces();
        oldBinding.addAsiNamespaces(newAsiNamespaces);
        int newSize2 = oldBinding.getAsiNamespaces().size();
        boolean updated6 = newSize2 > oldSize2;
        int oldSize3 = oldBinding.getSupportedServiceTypes().size();
        int size3 = newBinding.getSupportedServiceTypes().size();
        if (oldSize3 != size3) {
            return true;
        }
        List newSupportedServiceTypes = newBinding.getSupportedServiceTypes();
        oldBinding.addSupportedServiceTypes(newSupportedServiceTypes);
        int newSize3 = oldBinding.getSupportedServiceTypes().size();
        boolean updated7 = newSize3 > oldSize3;
        int oldSize4 = oldBinding.getTags().size();
        int size4 = newBinding.getTags().size();
        if (oldSize4 != size4) {
            return true;
        }
        List newTags = newBinding.getTags();
        oldBinding.addTags(newTags);
        int newSize4 = oldBinding.getTags().size();
        boolean bl = updated8 = newSize4 > oldSize4;
        boolean updated9 = oldBinding.getProjectPath() != null ? !oldBinding.getProjectPath().equals(newBinding.getProjectPath()) : false;
        boolean updated10 = !oldBinding.requireConfiguration() == newBinding.requireConfiguration();
        boolean updated11 = false;
        if (oldBinding.getConfigurationClassName() != null && newBinding.getConfigurationClassName() != null) {
            updated11 = !oldBinding.getConfigurationClassName().equals(newBinding.getConfigurationClassName());
        }
        boolean updated12 = false;
        if (oldBinding.getPropertiesJavaBeanClassName() != null && newBinding.getPropertiesJavaBeanClassName() != null) {
            boolean bl2 = updated12 = !oldBinding.getPropertiesJavaBeanClassName().equals(newBinding.getPropertiesJavaBeanClassName());
        }
        if ((oldSize13 = oldBinding.getSupportedDataTypes().size()) != (size13 = newBinding.getSupportedDataTypes().size())) {
            return true;
        }
        List newSupportedDataTypes = newBinding.getSupportedDataTypes();
        oldBinding.addSupportedDataTypes(newSupportedDataTypes);
        int newSize13 = oldBinding.getSupportedDataTypes().size();
        boolean updated13 = newSize13 > oldSize13;
        int oldSize14 = oldBinding.getSupportedFaults().size();
        int size14 = newBinding.getSupportedFaults().size();
        if (oldSize14 != size14) {
            return true;
        }
        List newSupportedFaults = newBinding.getSupportedFaults();
        oldBinding.addSupportedFaults(newSupportedFaults);
        int newSize14 = oldBinding.getSupportedFaults().size();
        boolean updated14 = newSize14 > oldSize14;
        int oldSize15 = oldBinding.getDataCategories().size();
        int size15 = newBinding.getDataCategories().size();
        if (oldSize15 != size15) {
            return true;
        }
        List newDataCategories = newBinding.getDataCategories();
        oldBinding.addDataCategories(newDataCategories);
        int newSize15 = oldBinding.getDataCategories().size();
        boolean bl3 = updated15 = newSize15 > oldSize15;
        return updated1 || updated2 || updated3 || updated4 || updated5 || updated6 || updated7 || updated8 || updated9 || updated10 || updated11 || updated12 || updated13 || updated14 || updated15;
    }

    @Override
    public void addEntries(IBinding[] bindings) {
        if (bindings != null && bindings.length > 0) {
            ArrayList<IBinding> entries = new ArrayList<IBinding>();
            int i = 0;
            while (i < bindings.length) {
                boolean added = this.addEntry(bindings[i]);
                if (added) {
                    entries.add(bindings[i]);
                }
                ++i;
            }
            if (!entries.isEmpty()) {
                this.persistEntries(entries.toArray(new Binding[0]));
            }
        }
    }

    @Override
    public List addUserEntries(String fileName) {
        List entries = BindingRegistryPersistence.load(fileName);
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (Binding entry : entries) {
            boolean added;
            try {
                Object propertiesJavaBean;
                Object instance = BindingRegistryHelper.getBindingConfiguartionObject(entry.getProject(), entry.getClassName(), entry.getLinkage());
                entry.setInstance(instance);
                BindingConfigurationEdit configuration = (BindingConfigurationEdit)BindingRegistryHelper.getBindingConfiguartionObject(entry.getProject(), entry.getConfigurationClassName(), entry.getLinkage());
                if (configuration != null) {
                    entry.setConfiguration(configuration);
                }
                if ((propertiesJavaBean = BindingRegistryHelper.getBindingConfiguartionObject(entry.getProject(), entry.getPropertiesJavaBeanClassName(), entry.getLinkage())) != null) {
                    entry.setPropertiesJavaBean(propertiesJavaBean);
                }
            }
            catch (CoreException e) {
                BindingRegistryActivator.logError(e, e.getLocalizedMessage());
            }
            if (!(added = this.addEntry(entry))) continue;
            this.persistEntry(entry);
            bindings.add(entry);
        }
        return bindings;
    }

    @Override
    public void saveUserEntries(String fileName) {
        BindingRegistryPersistence.save(fileName);
    }

    private boolean isValidEntry(IBinding binding) {
        List faults;
        Status status;
        if (binding == null) {
            return false;
        }
        boolean hasRequiredProperties = true;
        if (binding.getDescription() == null || "".equals(binding.getDescription())) {
            status = new Status(4, "com.ibm.adapter.binding.registry", 4, NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_INVALID_PROPERTY_VALUE, (Object)"description", (Object)binding.getProviderDescription()), null);
            LogFacility.logErrorMessage((IStatus)status);
            hasRequiredProperties = false;
        }
        if (binding.getDisplayName() == null || "".equals(binding.getDisplayName())) {
            status = new Status(4, "com.ibm.adapter.binding.registry", 4, NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_INVALID_PROPERTY_VALUE, (Object)"displayName", (Object)binding.getProviderDescription()), null);
            LogFacility.logErrorMessage((IStatus)status);
            hasRequiredProperties = false;
        }
        if (binding.getClassName() == null || "".equals(binding.getClassName())) {
            status = new Status(4, "com.ibm.adapter.binding.registry", 4, NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_INVALID_PROPERTY_VALUE, (Object)"className", (Object)binding.getProviderDescription()), null);
            LogFacility.logErrorMessage((IStatus)status);
            hasRequiredProperties = false;
        }
        if (binding.getType() == null || "".equals(binding.getType())) {
            status = new Status(4, "com.ibm.adapter.binding.registry", 4, NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_INVALID_PROPERTY_VALUE, (Object)"type", (Object)binding.getProviderDescription()), null);
            LogFacility.logErrorMessage((IStatus)status);
            hasRequiredProperties = false;
        } else if ("FaultSelector".equals(binding.getType()) && !(faults = binding.getSupportedFaults()).isEmpty()) {
            for (IBinding.IFault fault : faults) {
                String nativeName;
                QName dataType = fault.getDataType();
                if (dataType == null) {
                    Status status2 = new Status(4, "com.ibm.adapter.binding.registry", 4, NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_INVALID_PROPERTY_VALUE, (Object)"dataType", (Object)binding.getProviderDescription()), null);
                    LogFacility.logErrorMessage((IStatus)status2);
                    hasRequiredProperties = false;
                }
                if ((nativeName = fault.getNativeName()) != null && !"".equals(nativeName)) continue;
                Status status3 = new Status(4, "com.ibm.adapter.binding.registry", 4, NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_INVALID_PROPERTY_VALUE, (Object)"nativeName", (Object)binding.getProviderDescription()), null);
                LogFacility.logErrorMessage((IStatus)status3);
                hasRequiredProperties = false;
            }
        }
        if (binding.getSupportedServiceTypes() == null || binding.getSupportedServiceTypes().isEmpty()) {
            status = new Status(4, "com.ibm.adapter.binding.registry", 4, NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_INVALID_PROPERTY_VALUE, (Object)"supportedServiceType", (Object)binding.getProviderDescription()), null);
            LogFacility.logErrorMessage((IStatus)status);
            hasRequiredProperties = false;
        }
        if (binding.requireConfiguration() && binding.getPropertiesJavaBeanClassName() == null) {
            status = new Status(4, "com.ibm.adapter.binding.registry", 4, NLS.bind((String)MessageResource.ERR_BINDING_OBJECT_INVALID_PROPERTY_VALUE, (Object)"propertiesJavaBeanClassName", (Object)binding.getProviderDescription()), null);
            LogFacility.logErrorMessage((IStatus)status);
            hasRequiredProperties = false;
        }
        return hasRequiredProperties;
    }

    @Override
    public IBinding createEntry() {
        return new Binding();
    }

    @Override
    public synchronized boolean removeEntry(String bindingObjectClassName, String projectPath) {
        if (this.dataBindings.containsKey(bindingObjectClassName)) {
            return this.removeEntry(this.dataBindings, bindingObjectClassName, projectPath);
        }
        if (this.dataHandlers.containsKey(bindingObjectClassName)) {
            return this.removeEntry(this.dataHandlers, bindingObjectClassName, projectPath);
        }
        if (this.dataBindingGenerators.containsKey(bindingObjectClassName)) {
            return this.removeEntry(this.dataBindingGenerators, bindingObjectClassName, projectPath);
        }
        if (this.functionSelectors.containsKey(bindingObjectClassName)) {
            return this.removeEntry(this.functionSelectors, bindingObjectClassName, projectPath);
        }
        if (this.faultDataBindings.containsKey(bindingObjectClassName)) {
            return this.removeEntry(this.faultDataBindings, bindingObjectClassName, projectPath);
        }
        if (this.faultSelectors.containsKey(bindingObjectClassName)) {
            return this.removeEntry(this.faultSelectors, bindingObjectClassName, projectPath);
        }
        return false;
    }

    @Override
    public synchronized void removeEntries(IBinding[] bindings) {
        if (bindings != null && bindings.length > 0) {
            BindingRegistryPersistence.deletePersistentStoreEntries(bindings);
            Map bindingContainer = null;
            int i = 0;
            while (i < bindings.length) {
                IBinding entryToRemove = bindings[i];
                String className = entryToRemove.getClassName();
                if (this.dataBindings.containsKey(className)) {
                    bindingContainer = this.dataBindings;
                }
                if (this.dataHandlers.containsKey(className)) {
                    bindingContainer = this.dataHandlers;
                }
                if (this.dataBindingGenerators.containsKey(className)) {
                    bindingContainer = this.dataBindingGenerators;
                }
                if (this.functionSelectors.containsKey(className)) {
                    bindingContainer = this.functionSelectors;
                }
                if (this.faultDataBindings.containsKey(className)) {
                    bindingContainer = this.faultDataBindings;
                }
                if (this.faultSelectors.containsKey(className)) {
                    bindingContainer = this.faultSelectors;
                }
                List bindingList = (List)bindingContainer.get(className);
                bindingList.remove(entryToRemove);
                if (bindingList.isEmpty()) {
                    bindingContainer.remove(className);
                }
                ++i;
            }
            this.notifyListeners(bindings, 1);
        }
    }

    private boolean removeEntry(Map bindingContainer, String bindingObjectClassName, String projectPath) {
        int linkage;
        List bindings = (List)bindingContainer.get(bindingObjectClassName);
        boolean foundMatch = false;
        IBinding entryToRemove2 = null;
        for (IBinding entryToRemove2 : bindings) {
            String path = entryToRemove2.getProjectPath();
            if (!path.equals(projectPath)) continue;
            foundMatch = true;
            break;
        }
        if (foundMatch && (2 == (linkage = entryToRemove2.getLinkage()) || 1 == linkage)) {
            BindingRegistryPersistence.deletePersistentStoreEntry(bindingObjectClassName, projectPath);
            bindings.remove(entryToRemove2);
            this.notifyListeners(entryToRemove2, 1);
            if (bindings.isEmpty()) {
                bindingContainer.remove(bindingObjectClassName);
            }
            return true;
        }
        return false;
    }

    @Override
    public IBinding[] getAllDataBindings() {
        return this.getAllBindings(this.dataBindings);
    }

    @Override
    public IBinding[] getAllDataHandlers() {
        return this.getAllBindings(this.dataHandlers);
    }

    @Override
    public IBinding[] getAllDataBindingGenerators() {
        return this.getAllBindings(this.dataBindingGenerators);
    }

    @Override
    public IBinding[] getAllFunctionSelectors() {
        return this.getAllBindings(this.functionSelectors);
    }

    @Override
    public IBinding[] getAllFaultDataBindings() {
        return this.getAllBindings(this.faultDataBindings);
    }

    @Override
    public IBinding[] getAllFaultSelectors() {
        return this.getAllBindings(this.faultSelectors);
    }

    private IBinding[] getAllBindings(Map container) {
        Collection values = container.values();
        ArrayList allBindings = new ArrayList();
        for (List value : values) {
            if (value == null || value.isEmpty()) continue;
            allBindings.addAll(value);
        }
        return allBindings.toArray(new Binding[0]);
    }

    @Override
    public IBinding[] getDataBindings(String dataBindingClassName) {
        Object value;
        if (dataBindingClassName != null && (value = this.dataBindings.get(dataBindingClassName)) != null) {
            return ((List)value).toArray(new Binding[0]);
        }
        return null;
    }

    @Override
    public IBinding[] getDataHandlers(String dataHandlerClassName) {
        Object value;
        if (dataHandlerClassName != null && (value = this.dataHandlers.get(dataHandlerClassName)) != null) {
            return ((List)value).toArray(new Binding[0]);
        }
        return null;
    }

    @Override
    public IBinding[] getDataBindingGenerators(String dataBindingGeneratorClassName) {
        Object value;
        if (dataBindingGeneratorClassName != null && (value = this.dataBindingGenerators.get(dataBindingGeneratorClassName)) != null) {
            return ((List)value).toArray(new Binding[0]);
        }
        return null;
    }

    @Override
    public IBinding[] getFunctionSelectors(String functionSelectorClassName) {
        Object value;
        if (functionSelectorClassName != null && (value = this.functionSelectors.get(functionSelectorClassName)) != null) {
            return ((List)value).toArray(new Binding[0]);
        }
        return null;
    }

    @Override
    public IBinding[] getFaultDataBindings(String faultDataBindingClassName) {
        Object value;
        if (faultDataBindingClassName != null && (value = this.faultDataBindings.get(faultDataBindingClassName)) != null) {
            return ((List)value).toArray(new Binding[0]);
        }
        return null;
    }

    @Override
    public IBinding[] getFaultSelectors(String faultSelectorClassName) {
        Object value;
        if (faultSelectorClassName != null && (value = this.faultSelectors.get(faultSelectorClassName)) != null) {
            return ((List)value).toArray(new Binding[0]);
        }
        return null;
    }

    @Override
    public IBinding[] getDataBindingsByASINamespace(String[] asiNamespaces) {
        return this.getBindingsByASINamespace(this.dataBindings, asiNamespaces);
    }

    @Override
    public IBinding[] getDataHandlersByASINamespace(String[] asiNamespaces) {
        return this.getBindingsByASINamespace(this.dataHandlers, asiNamespaces);
    }

    @Override
    public IBinding[] getFunctionSelectorsByASINamespace(String[] asiNamespaces) {
        return this.getBindingsByASINamespace(this.functionSelectors, asiNamespaces);
    }

    @Override
    public IBinding[] getFaultDataBindingsByASINamespace(String[] asiNamespaces) {
        return this.getBindingsByASINamespace(this.faultDataBindings, asiNamespaces);
    }

    @Override
    public IBinding[] getFaultSelectorsByASINamespace(String[] asiNamespaces) {
        return this.getBindingsByASINamespace(this.faultSelectors, asiNamespaces);
    }

    private IBinding[] getBindingsByASINamespace(Map container, String[] asiNamespaces) {
        if (asiNamespaces != null) {
            Collection values = container.values();
            ArrayList<IBinding> bindingsByASINamespace = new ArrayList<IBinding>();
            for (List bindings : values) {
                for (IBinding binding : bindings) {
                    List asiNamespaceURIs = binding.getAsiNamespaces();
                    for (String asiNamespaceURI : asiNamespaceURIs) {
                        int i = 0;
                        while (i < asiNamespaces.length) {
                            String asiNamespace = asiNamespaces[i];
                            if (asiNamespaceURI.equals(asiNamespace) && !bindingsByASINamespace.contains(binding)) {
                                bindingsByASINamespace.add(binding);
                            }
                            ++i;
                        }
                    }
                }
            }
            return bindingsByASINamespace.toArray(new Binding[0]);
        }
        return null;
    }

    @Override
    public IBinding[] getDataBindingsBySupportedServiceType(String[] serviceTypes) {
        return this.getBindingsBySupportedServiceType(this.dataBindings, serviceTypes);
    }

    @Override
    public IBinding[] getDataBindingGeneratorsBySupportedServiceType(String[] serviceTypes) {
        return this.getBindingsBySupportedServiceType(this.dataBindingGenerators, serviceTypes);
    }

    @Override
    public IBinding[] getDataHandlersBySupportedServiceType(String[] serviceTypes) {
        return this.getBindingsBySupportedServiceType(this.dataHandlers, serviceTypes);
    }

    @Override
    public IBinding[] getFunctionSelectorsBySupportedServiceType(String[] serviceTypes) {
        return this.getBindingsBySupportedServiceType(this.functionSelectors, serviceTypes);
    }

    @Override
    public IBinding[] getFaultDataBindingsBySupportedServiceType(String[] serviceTypes) {
        return this.getBindingsBySupportedServiceType(this.faultDataBindings, serviceTypes);
    }

    @Override
    public IBinding[] getFaultSelectorsBySupportedServiceType(String[] serviceTypes) {
        return this.getBindingsBySupportedServiceType(this.faultSelectors, serviceTypes);
    }

    private IBinding[] getBindingsBySupportedServiceType(Map container, String[] serviceTypes) {
        if (serviceTypes != null) {
            Collection values = container.values();
            ArrayList<IBinding> bindingsByServiceType = new ArrayList<IBinding>();
            for (List bindings : values) {
                for (IBinding binding : bindings) {
                    List supportedServiceTypes = binding.getSupportedServiceTypes();
                    for (String supportedServiceType : supportedServiceTypes) {
                        int i = 0;
                        while (i < serviceTypes.length) {
                            String serviceBindingType = serviceTypes[i];
                            if (supportedServiceType.equals(serviceBindingType) && !bindingsByServiceType.contains(binding)) {
                                bindingsByServiceType.add(binding);
                            }
                            ++i;
                        }
                    }
                }
            }
            return bindingsByServiceType.toArray(new Binding[0]);
        }
        return null;
    }

    @Override
    public IBinding[] getDataBindingsByTag(String[] tags) {
        return this.getBindingsByTag(this.dataBindings, tags);
    }

    @Override
    public IBinding[] getDataHandlersByTag(String[] tags) {
        return this.getBindingsByTag(this.dataHandlers, tags);
    }

    @Override
    public IBinding[] getFunctionSelectorsByTag(String[] tags) {
        return this.getBindingsByTag(this.functionSelectors, tags);
    }

    @Override
    public IBinding[] getFaultDataBindingsByTag(String[] tags) {
        return this.getBindingsByTag(this.faultDataBindings, tags);
    }

    @Override
    public IBinding[] getFaultSelectorsByTag(String[] tags) {
        return this.getBindingsByTag(this.faultSelectors, tags);
    }

    private IBinding[] getBindingsByTag(Map container, String[] tags) {
        if (tags != null) {
            Collection values = container.values();
            ArrayList<IBinding> bindingsByTag = new ArrayList<IBinding>();
            for (List bindings : values) {
                for (IBinding binding : bindings) {
                    List tagNames = binding.getTags();
                    for (String tagName : tagNames) {
                        int i = 0;
                        while (i < tags.length) {
                            String tag = tags[i];
                            if (tagName.equals(tag) && !bindingsByTag.contains(binding)) {
                                bindingsByTag.add(binding);
                            }
                            ++i;
                        }
                    }
                }
            }
            return bindingsByTag.toArray(new Binding[0]);
        }
        return null;
    }

    @Override
    public IBinding[] getDataBindingGeneratorsByGeneratedType(String generatedType) {
        if (generatedType != null) {
            Collection values = this.dataBindingGenerators.values();
            ArrayList<IBinding> dataBindingGeneratorsByGeneratedObjectType = new ArrayList<IBinding>();
            for (List bindings : values) {
                for (IBinding dataBindingGenerator : bindings) {
                    String type = dataBindingGenerator.getGeneratedType();
                    if (!type.equals(generatedType)) continue;
                    dataBindingGeneratorsByGeneratedObjectType.add(dataBindingGenerator);
                }
            }
            return dataBindingGeneratorsByGeneratedObjectType.toArray(new Binding[0]);
        }
        return null;
    }

    @Override
    public IBinding[] getAllDataBindingsAndDataBindingGenerators() {
        List<IBinding> allDataBindings = Arrays.asList(this.getAllDataBindings());
        List<IBinding> allFaultDataBindings = Arrays.asList(this.getAllFaultDataBindings());
        List<IBinding> allDataBindingGenerators = Arrays.asList(this.getAllDataBindingGenerators());
        ArrayList<IBinding> combined = new ArrayList<IBinding>();
        combined.addAll(allDataBindings);
        combined.addAll(allFaultDataBindings);
        combined.addAll(allDataBindingGenerators);
        return combined.toArray(new Binding[0]);
    }

    @Override
    public IBinding[] getAllDataBindingsAndDataBindingGeneratorsBySupportedServiceType(String[] serviceTypes) {
        List<IBinding> allDataBindings = Arrays.asList(this.getDataBindingsBySupportedServiceType(serviceTypes));
        List<IBinding> allFaultDataBindings = Arrays.asList(this.getFaultDataBindingsBySupportedServiceType(serviceTypes));
        List<IBinding> allDataBindingGenerators = Arrays.asList(this.getDataBindingGeneratorsBySupportedServiceType(serviceTypes));
        ArrayList<IBinding> combined = new ArrayList<IBinding>();
        combined.addAll(allDataBindings);
        combined.addAll(allFaultDataBindings);
        combined.addAll(allDataBindingGenerators);
        return combined.toArray(new Binding[0]);
    }

    @Override
    public IBinding[] getPluginDefinedDataBindings() {
        return this.getBindingsByLinkage(this.dataBindings.values(), 0);
    }

    @Override
    public IBinding[] getPluginDefinedDataHandlers() {
        return this.getBindingsByLinkage(this.dataHandlers.values(), 0);
    }

    @Override
    public IBinding[] getPluginDefinedDataBindingGenerators() {
        return this.getBindingsByLinkage(this.dataBindingGenerators.values(), 0);
    }

    @Override
    public IBinding[] getPluginDefinedFunctionSelectors() {
        return this.getBindingsByLinkage(this.functionSelectors.values(), 0);
    }

    @Override
    public IBinding[] getPluginDefinedFaultDataBindings() {
        return this.getBindingsByLinkage(this.faultDataBindings.values(), 0);
    }

    @Override
    public IBinding[] getPluginDefinedFaultSelectors() {
        return this.getBindingsByLinkage(this.faultSelectors.values(), 0);
    }

    @Override
    public IBinding[] getResourceAdapterDefinedDataBindings() {
        return this.getBindingsByLinkage(this.dataBindings.values(), 1);
    }

    @Override
    public IBinding[] getResourceAdapterDefinedDataBindingGenerators() {
        return this.getBindingsByLinkage(this.dataBindingGenerators.values(), 1);
    }

    @Override
    public IBinding[] getResourceAdapterDefinedFunctionSelectors() {
        return this.getBindingsByLinkage(this.functionSelectors.values(), 1);
    }

    @Override
    public IBinding[] getResourceAdapterDefinedFaultDataBindings() {
        return this.getBindingsByLinkage(this.faultDataBindings.values(), 1);
    }

    @Override
    public IBinding[] getResourceAdapterDefinedFaultSelectors() {
        return this.getBindingsByLinkage(this.faultSelectors.values(), 1);
    }

    @Override
    public IBinding[] getUserDefinedDataBindings() {
        return this.getBindingsByLinkage(this.dataBindings.values(), 2);
    }

    @Override
    public IBinding[] getUserDefinedDataHandlers() {
        return this.getBindingsByLinkage(this.dataHandlers.values(), 2);
    }

    @Override
    public IBinding[] getUserDefinedFunctionSelectors() {
        return this.getBindingsByLinkage(this.functionSelectors.values(), 2);
    }

    @Override
    public IBinding[] getUserDefinedFaultDataBindings() {
        return this.getBindingsByLinkage(this.faultDataBindings.values(), 2);
    }

    @Override
    public IBinding[] getUserDefinedFaultSelectors() {
        return this.getBindingsByLinkage(this.faultSelectors.values(), 2);
    }

    @Override
    public IBinding[] getUserDefinedBindings() {
        IBinding[] db = this.getBindingsByLinkage(this.dataBindings.values(), 2);
        IBinding[] dh = this.getBindingsByLinkage(this.dataHandlers.values(), 2);
        IBinding[] fs = this.getBindingsByLinkage(this.functionSelectors.values(), 2);
        IBinding[] fdb = this.getBindingsByLinkage(this.faultDataBindings.values(), 2);
        IBinding[] fts = this.getBindingsByLinkage(this.faultSelectors.values(), 2);
        IBinding[] ub = new IBinding[db.length + dh.length + fs.length + fdb.length + fts.length];
        int i = 0;
        int j = 0;
        while (j < db.length) {
            ub[i] = db[j];
            ++j;
            ++i;
        }
        j = 0;
        while (j < dh.length) {
            ub[i] = dh[j];
            ++j;
            ++i;
        }
        j = 0;
        while (j < fs.length) {
            ub[i] = fs[j];
            ++j;
            ++i;
        }
        j = 0;
        while (j < fdb.length) {
            ub[i] = fdb[j];
            ++j;
            ++i;
        }
        j = 0;
        while (j < fts.length) {
            ub[i] = fts[j];
            ++j;
            ++i;
        }
        return ub;
    }

    private IBinding[] getBindingsByLinkage(Collection bindings, int linkage) {
        ArrayList<IBinding> bindingsByLinkage = new ArrayList<IBinding>();
        for (List list : bindings) {
            for (IBinding binding : list) {
                if (linkage != binding.getLinkage()) continue;
                bindingsByLinkage.add(binding);
            }
        }
        return bindingsByLinkage.toArray(new Binding[0]);
    }

    @Override
    public synchronized void addListener(IBindingRegistryListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public synchronized void removeListener(IBindingRegistryListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(final IBinding binding, final int eventType) {
        block9: {
            try {
                Vector targets = null;
                BindingRegistry bindingRegistry = this;
                synchronized (bindingRegistry) {
                    if (this.listeners != null) {
                        targets = (Vector)this.listeners.clone();
                    }
                }
                if (targets == null) break block9;
                int i = 0;
                while (i < targets.size()) {
                    final IBindingRegistryListener target = (IBindingRegistryListener)targets.elementAt(i);
                    try {
                        Thread listenerThread = new Thread(){

                            @Override
                            public void run() {
                                try {
                                    target.notifyRegistryChange(binding, eventType);
                                }
                                catch (Throwable e) {
                                    BindingRegistryActivator.logError(e, e.getLocalizedMessage());
                                }
                            }
                        };
                        listenerThread.start();
                    }
                    catch (Throwable e) {
                        BindingRegistryActivator.logError(e, e.getLocalizedMessage());
                    }
                    ++i;
                }
            }
            catch (RuntimeException e) {
                BindingRegistryActivator.logError(e, e.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(final IBinding[] bindings, final int eventType) {
        block9: {
            try {
                Vector targets = null;
                BindingRegistry bindingRegistry = this;
                synchronized (bindingRegistry) {
                    if (this.listeners != null) {
                        targets = (Vector)this.listeners.clone();
                    }
                }
                if (targets == null) break block9;
                int i = 0;
                while (i < targets.size()) {
                    final IBindingRegistryListener target = (IBindingRegistryListener)targets.elementAt(i);
                    try {
                        Thread listenerThread = new Thread(){

                            @Override
                            public void run() {
                                try {
                                    target.notifyRegistryChange(bindings, eventType);
                                }
                                catch (Throwable e) {
                                    BindingRegistryActivator.logError(e, e.getLocalizedMessage());
                                }
                            }
                        };
                        listenerThread.start();
                    }
                    catch (Throwable e) {
                        BindingRegistryActivator.logError(e, e.getLocalizedMessage());
                    }
                    ++i;
                }
            }
            catch (RuntimeException e) {
                BindingRegistryActivator.logError(e, e.getLocalizedMessage());
            }
        }
    }

    @Override
    public IBinding[] getDataBindingsWithNoConfiguration() {
        return this.getBindingsWithNoConfiguration(this.dataBindings);
    }

    @Override
    public IBinding[] getDataHandlersWithNoConfiguration() {
        return this.getBindingsWithNoConfiguration(this.dataHandlers);
    }

    @Override
    public IBinding[] getFunctionSelectorsWithNoConfiguration() {
        return this.getBindingsWithNoConfiguration(this.functionSelectors);
    }

    @Override
    public IBinding[] getFaultDataBindingsWithNoConfiguration() {
        return this.getBindingsWithNoConfiguration(this.faultDataBindings);
    }

    @Override
    public IBinding[] getFaultSelectorsWithNoConfiguration() {
        return this.getBindingsWithNoConfiguration(this.faultSelectors);
    }

    private IBinding[] getBindingsWithNoConfiguration(Map container) {
        Collection values = container.values();
        ArrayList<IBinding> bindingsWithNoConfiguration = new ArrayList<IBinding>();
        for (List bindings : values) {
            for (IBinding binding : bindings) {
                BindingConfigurationEdit configuration = binding.getConfiguration();
                if (configuration != null) continue;
                bindingsWithNoConfiguration.add(binding);
            }
        }
        return bindingsWithNoConfiguration.toArray(new Binding[0]);
    }

    @Override
    public IBinding[] getDataBindingsWithOptionalConfiguration() {
        return this.getBindingsWithOptionalConfiguration(this.dataBindings);
    }

    @Override
    public IBinding[] getDataHandlersWithOptionalConfiguration() {
        return this.getBindingsWithOptionalConfiguration(this.dataHandlers);
    }

    @Override
    public IBinding[] getFunctionSelectorsWithOptionalConfiguration() {
        return this.getBindingsWithOptionalConfiguration(this.functionSelectors);
    }

    @Override
    public IBinding[] getFaultDataBindingsWithOptionalConfiguration() {
        return this.getBindingsWithOptionalConfiguration(this.faultDataBindings);
    }

    @Override
    public IBinding[] getFaultSelectorsWithOptionalConfiguration() {
        return this.getBindingsWithOptionalConfiguration(this.faultSelectors);
    }

    private IBinding[] getBindingsWithOptionalConfiguration(Map container) {
        Collection values = container.values();
        ArrayList<IBinding> bindingsWithOptionalConfiguration = new ArrayList<IBinding>();
        for (List bindings : values) {
            for (IBinding binding : bindings) {
                BindingConfigurationEdit configuration;
                boolean requireConfiguration = binding.requireConfiguration();
                if (requireConfiguration || (configuration = binding.getConfiguration()) == null) continue;
                bindingsWithOptionalConfiguration.add(binding);
            }
        }
        return bindingsWithOptionalConfiguration.toArray(new Binding[0]);
    }

    @Override
    public IBinding[] getDataBindingsWithRequiredConfiguration() {
        return this.getBindingsWithRequiredConfiguration(this.dataBindings);
    }

    @Override
    public IBinding[] getDataHandlersWithRequiredConfiguration() {
        return this.getBindingsWithRequiredConfiguration(this.dataHandlers);
    }

    @Override
    public IBinding[] getFunctionSelectorsWithRequiredConfiguration() {
        return this.getBindingsWithRequiredConfiguration(this.functionSelectors);
    }

    @Override
    public IBinding[] getFaultDataBindingsWithRequiredConfiguration() {
        return this.getBindingsWithRequiredConfiguration(this.faultDataBindings);
    }

    @Override
    public IBinding[] getFaultSelectorsWithRequiredConfiguration() {
        return this.getBindingsWithRequiredConfiguration(this.faultSelectors);
    }

    public IBinding[] getBindingsWithRequiredConfiguration(Map container) {
        Collection values = container.values();
        ArrayList<IBinding> bindingsWithRequiredConfiguration = new ArrayList<IBinding>();
        for (List bindings : values) {
            for (IBinding binding : bindings) {
                boolean requireConfiguration = binding.requireConfiguration();
                if (!requireConfiguration) continue;
                bindingsWithRequiredConfiguration.add(binding);
            }
        }
        return bindingsWithRequiredConfiguration.toArray(new Binding[0]);
    }

    private IBinding[] getBindingsBySupportedServiceTypeWithConfigurationContext(String[] serviceTypes, Map container, IBinding[] configurationContextBindings) {
        IBinding[] supportedServiceTypeBindings = this.getBindingsBySupportedServiceType(container, serviceTypes);
        ArrayList<IBinding> filteredBindings = new ArrayList<IBinding>();
        int i = 0;
        while (i < supportedServiceTypeBindings.length) {
            IBinding binding1 = supportedServiceTypeBindings[i];
            int j = 0;
            while (j < configurationContextBindings.length) {
                IBinding binding2 = configurationContextBindings[j];
                if (binding1.equals(binding2)) {
                    filteredBindings.add(binding1);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return filteredBindings.toArray(new Binding[0]);
    }

    @Override
    public IBinding[] getDataBindingsBySupportedServiceTypeWithNoConfiguration(String[] serviceTypes) {
        IBinding[] noConfigurationBindings = this.getBindingsWithNoConfiguration(this.dataBindings);
        return this.getBindingsBySupportedServiceTypeWithConfigurationContext(serviceTypes, this.dataBindings, noConfigurationBindings);
    }

    @Override
    public IBinding[] getDataBindingsBySupportedServiceTypeWithOptionalConfiguration(String[] serviceTypes) {
        IBinding[] optionalConfigurationBindings = this.getBindingsWithOptionalConfiguration(this.dataBindings);
        return this.getBindingsBySupportedServiceTypeWithConfigurationContext(serviceTypes, this.dataBindings, optionalConfigurationBindings);
    }

    @Override
    public IBinding[] getDataBindingsBySupportedServiceTypeWithRequiredConfiguration(String[] serviceTypes) {
        IBinding[] requiredConfigurationBindings = this.getBindingsWithRequiredConfiguration(this.dataBindings);
        return this.getBindingsBySupportedServiceTypeWithConfigurationContext(serviceTypes, this.dataBindings, requiredConfigurationBindings);
    }

    @Override
    public IBinding[] getDataBindingsBySupportedServiceTypeWithNoOrOptionalConfiguration(String[] serviceTypes) {
        IBinding[] noConfigurationBindings = this.getDataBindingsBySupportedServiceTypeWithNoConfiguration(serviceTypes);
        IBinding[] optionalConfigurationBindings = this.getDataBindingsBySupportedServiceTypeWithOptionalConfiguration(serviceTypes);
        List<IBinding> list1 = Arrays.asList(noConfigurationBindings);
        List<IBinding> list2 = Arrays.asList(optionalConfigurationBindings);
        ArrayList<IBinding> combined = new ArrayList<IBinding>();
        combined.addAll(list1);
        combined.addAll(list2);
        return combined.toArray(new Binding[0]);
    }

    @Override
    public IBinding[] getDataHandlersBySupportedServiceTypeWithNoConfiguration(String[] serviceTypes) {
        IBinding[] noConfigurationBindings = this.getBindingsWithNoConfiguration(this.dataHandlers);
        return this.getBindingsBySupportedServiceTypeWithConfigurationContext(serviceTypes, this.dataHandlers, noConfigurationBindings);
    }

    @Override
    public IBinding[] getDataHandlersBySupportedServiceTypeWithOptionalConfiguration(String[] serviceTypes) {
        IBinding[] optionalConfigurationBindings = this.getBindingsWithOptionalConfiguration(this.dataHandlers);
        return this.getBindingsBySupportedServiceTypeWithConfigurationContext(serviceTypes, this.dataHandlers, optionalConfigurationBindings);
    }

    @Override
    public IBinding[] getDataHandlersBySupportedServiceTypeWithRequiredConfiguration(String[] serviceTypes) {
        IBinding[] requiredConfigurationBindings = this.getBindingsWithRequiredConfiguration(this.dataHandlers);
        return this.getBindingsBySupportedServiceTypeWithConfigurationContext(serviceTypes, this.dataHandlers, requiredConfigurationBindings);
    }

    @Override
    public IBinding[] getDataHandlersBySupportedServiceTypeWithNoOrOptionalConfiguration(String[] serviceTypes) {
        IBinding[] noConfigurationBindings = this.getDataHandlersBySupportedServiceTypeWithNoConfiguration(serviceTypes);
        IBinding[] optionalConfigurationBindings = this.getDataHandlersBySupportedServiceTypeWithOptionalConfiguration(serviceTypes);
        List<IBinding> list1 = Arrays.asList(noConfigurationBindings);
        List<IBinding> list2 = Arrays.asList(optionalConfigurationBindings);
        ArrayList<IBinding> combined = new ArrayList<IBinding>();
        combined.addAll(list1);
        combined.addAll(list2);
        return combined.toArray(new Binding[0]);
    }

    @Override
    public IBinding[] getFunctionSelectorsBySupportedServiceTypeWithNoConfiguration(String[] serviceTypes) {
        IBinding[] noConfigurationBindings = this.getBindingsWithNoConfiguration(this.functionSelectors);
        return this.getBindingsBySupportedServiceTypeWithConfigurationContext(serviceTypes, this.functionSelectors, noConfigurationBindings);
    }

    @Override
    public IBinding[] getFunctionSelectorsBySupportedServiceTypeWithOptionalConfiguration(String[] serviceTypes) {
        IBinding[] optionalConfigurationBindings = this.getBindingsWithOptionalConfiguration(this.functionSelectors);
        return this.getBindingsBySupportedServiceTypeWithConfigurationContext(serviceTypes, this.functionSelectors, optionalConfigurationBindings);
    }

    @Override
    public IBinding[] getFunctionSelectorsBySupportedServiceTypeWithRequiredConfiguration(String[] serviceTypes) {
        IBinding[] requiredConfigurationBindings = this.getBindingsWithRequiredConfiguration(this.functionSelectors);
        return this.getBindingsBySupportedServiceTypeWithConfigurationContext(serviceTypes, this.functionSelectors, requiredConfigurationBindings);
    }

    @Override
    public IBinding[] getFunctionSelectorsBySupportedServiceTypeWithNoOrOptionalConfiguration(String[] serviceTypes) {
        IBinding[] noConfigurationBindings = this.getFunctionSelectorsBySupportedServiceTypeWithNoConfiguration(serviceTypes);
        IBinding[] optionalConfigurationBindings = this.getFunctionSelectorsBySupportedServiceTypeWithOptionalConfiguration(serviceTypes);
        List<IBinding> list1 = Arrays.asList(noConfigurationBindings);
        List<IBinding> list2 = Arrays.asList(optionalConfigurationBindings);
        ArrayList<IBinding> combined = new ArrayList<IBinding>();
        combined.addAll(list1);
        combined.addAll(list2);
        return combined.toArray(new Binding[0]);
    }

    @Override
    public IBinding[] getFaultDataBindingsBySupportedServiceTypeWithNoConfiguration(String[] serviceTypes) {
        IBinding[] noConfigurationBindings = this.getBindingsWithNoConfiguration(this.faultDataBindings);
        return this.getBindingsBySupportedServiceTypeWithConfigurationContext(serviceTypes, this.faultDataBindings, noConfigurationBindings);
    }

    @Override
    public IBinding[] getFaultDataBindingsBySupportedServiceTypeWithOptionalConfiguration(String[] serviceTypes) {
        IBinding[] optionalConfigurationBindings = this.getBindingsWithOptionalConfiguration(this.faultDataBindings);
        return this.getBindingsBySupportedServiceTypeWithConfigurationContext(serviceTypes, this.faultDataBindings, optionalConfigurationBindings);
    }

    @Override
    public IBinding[] getFaultDataBindingsBySupportedServiceTypeWithRequiredConfiguration(String[] serviceTypes) {
        IBinding[] requiredConfigurationBindings = this.getBindingsWithRequiredConfiguration(this.faultDataBindings);
        return this.getBindingsBySupportedServiceTypeWithConfigurationContext(serviceTypes, this.faultDataBindings, requiredConfigurationBindings);
    }

    @Override
    public IBinding[] getFaultDataBindingsBySupportedServiceTypeWithNoOrOptionalConfiguration(String[] serviceTypes) {
        IBinding[] noConfigurationBindings = this.getFaultDataBindingsBySupportedServiceTypeWithNoConfiguration(serviceTypes);
        IBinding[] optionalConfigurationBindings = this.getFaultDataBindingsBySupportedServiceTypeWithOptionalConfiguration(serviceTypes);
        List<IBinding> list1 = Arrays.asList(noConfigurationBindings);
        List<IBinding> list2 = Arrays.asList(optionalConfigurationBindings);
        ArrayList<IBinding> combined = new ArrayList<IBinding>();
        combined.addAll(list1);
        combined.addAll(list2);
        return combined.toArray(new Binding[0]);
    }

    @Override
    public IBinding[] getFaultSelectorsBySupportedServiceTypeWithNoConfiguration(String[] serviceTypes) {
        IBinding[] noConfigurationBindings = this.getBindingsWithNoConfiguration(this.faultSelectors);
        return this.getBindingsBySupportedServiceTypeWithConfigurationContext(serviceTypes, this.faultSelectors, noConfigurationBindings);
    }

    @Override
    public IBinding[] getFaultSelectorsBySupportedServiceTypeWithOptionalConfiguration(String[] serviceTypes) {
        IBinding[] optionalConfigurationBindings = this.getBindingsWithOptionalConfiguration(this.faultSelectors);
        return this.getBindingsBySupportedServiceTypeWithConfigurationContext(serviceTypes, this.faultSelectors, optionalConfigurationBindings);
    }

    @Override
    public IBinding[] getFaultSelectorsBySupportedServiceTypeWithRequiredConfiguration(String[] serviceTypes) {
        IBinding[] requiredConfigurationBindings = this.getBindingsWithRequiredConfiguration(this.faultSelectors);
        return this.getBindingsBySupportedServiceTypeWithConfigurationContext(serviceTypes, this.faultSelectors, requiredConfigurationBindings);
    }

    @Override
    public IBinding[] getFaultSelectorsBySupportedServiceTypeWithNoOrOptionalConfiguration(String[] serviceTypes) {
        IBinding[] noConfigurationBindings = this.getFaultSelectorsBySupportedServiceTypeWithNoConfiguration(serviceTypes);
        IBinding[] optionalConfigurationBindings = this.getFaultSelectorsBySupportedServiceTypeWithOptionalConfiguration(serviceTypes);
        List<IBinding> list1 = Arrays.asList(noConfigurationBindings);
        List<IBinding> list2 = Arrays.asList(optionalConfigurationBindings);
        ArrayList<IBinding> combined = new ArrayList<IBinding>();
        combined.addAll(list1);
        combined.addAll(list2);
        return combined.toArray(new Binding[0]);
    }

    @Override
    public IBinding[] getDataBindingsBySupportedDataType(QName[] dataTypes) {
        return this.getBindingsBySupportedDataType(this.dataBindings, dataTypes, false);
    }

    @Override
    public IBinding[] getDataHandlersBySupportedDataType(QName[] dataTypes) {
        return this.getBindingsBySupportedDataType(this.dataHandlers, dataTypes, false);
    }

    @Override
    public IBinding[] getFaultDataBindingsBySupportedDataType(QName[] dataTypes) {
        return this.getBindingsBySupportedDataType(this.faultDataBindings, dataTypes, false);
    }

    @Override
    public IBinding[] getFaultSelectorsBySupportedFaultDataType(QName[] faultDataTypes) {
        return this.getBindingsBySupportedDataType(this.faultSelectors, faultDataTypes, true);
    }

    private IBinding[] getBindingsBySupportedDataType(Map container, QName[] dataTypes, boolean faultSelector) {
        if (dataTypes != null) {
            Collection values = container.values();
            ArrayList<IBinding> bindingsByDataType = new ArrayList<IBinding>();
            for (List bindings : values) {
                for (IBinding binding : bindings) {
                    List<QName> supportedDataTypes = new ArrayList();
                    if (faultSelector) {
                        List faults = binding.getSupportedFaults();
                        for (IBinding.IFault fault : faults) {
                            supportedDataTypes.add(fault.getDataType());
                        }
                    } else {
                        supportedDataTypes = binding.getSupportedDataTypes();
                    }
                    for (QName supportedDataType : supportedDataTypes) {
                        int i = 0;
                        while (i < dataTypes.length) {
                            QName dataType = dataTypes[i];
                            if (supportedDataType.equals(dataType) && !bindingsByDataType.contains(binding)) {
                                bindingsByDataType.add(binding);
                            }
                            ++i;
                        }
                    }
                }
            }
            return bindingsByDataType.toArray(new Binding[0]);
        }
        return null;
    }

    private boolean hasValidType(String type) {
        if (type == null || "".equals(type)) {
            return false;
        }
        String[] validTypes = new String[]{"DataBinding", "DataHandler", "DataBindingGenerator", "FunctionSelector", "FaultSelector", "FaultDataBinding"};
        List<String> list = Arrays.asList(validTypes);
        return list.indexOf(type) >= 0;
    }

    private boolean hasValidGeneratedType(String generatedType) {
        if (generatedType == null || "".equals(generatedType)) {
            return false;
        }
        String[] validGeneratedTypes = new String[]{"DataBinding", "Record"};
        List<String> list = Arrays.asList(validGeneratedTypes);
        return list.indexOf(generatedType) >= 0;
    }

    private boolean hasValidDataCategory(String dataCategories) {
        if (dataCategories == null || "".equals(dataCategories)) {
            return false;
        }
        String[] validDataCategories = new String[]{"Data", "Fault", "RuntimeException"};
        List<String> list = Arrays.asList(validDataCategories);
        String[] dataCategoryTokens = dataCategories.split(",");
        int i = 0;
        while (i < dataCategoryTokens.length) {
            if (list.indexOf(dataCategoryTokens[i].trim()) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public IBinding[] getDataBindingsByDataCategory(String[] dataCategories) {
        return this.getBindingsByDataCategory(this.dataBindings, dataCategories);
    }

    @Override
    public IBinding[] getDataHandlersByDataCategory(String[] dataCategories) {
        return this.getBindingsByDataCategory(this.dataHandlers, dataCategories);
    }

    @Override
    public IBinding[] getFaultDataBindingsByDataCategory(String[] dataCategories) {
        return this.getBindingsByDataCategory(this.faultDataBindings, dataCategories);
    }

    private IBinding[] getBindingsByDataCategory(Map container, String[] dataCategories) {
        if (dataCategories != null) {
            Collection values = container.values();
            ArrayList<IBinding> bindingsByDataCategory = new ArrayList<IBinding>();
            for (List bindings : values) {
                for (IBinding binding : bindings) {
                    List dataCategoryNames = binding.getDataCategories();
                    for (String dataCategoryName : dataCategoryNames) {
                        int i = 0;
                        while (i < dataCategories.length) {
                            String dataCategory = dataCategories[i];
                            if (dataCategoryName.equals(dataCategory) && !bindingsByDataCategory.contains(binding)) {
                                bindingsByDataCategory.add(binding);
                            }
                            ++i;
                        }
                    }
                }
            }
            return bindingsByDataCategory.toArray(new Binding[0]);
        }
        return null;
    }

    class SortedBindings
    implements Comparator {
        TreeMap bindingSetDescend = new TreeMap(this);

        SortedBindings() {
        }

        public synchronized void addDescend(IBinding binding) {
            this.bindingSetDescend.put(binding, binding);
        }

        public int compare(Object binding1, Object binding2) {
            String displayName1 = ((IBinding)binding1).getDisplayName().trim();
            String displayName2 = ((IBinding)binding2).getDisplayName().trim();
            return displayName2.compareTo(displayName1);
        }

        public IBinding[] getSortedElements() {
            Binding[] elements = new Binding[this.bindingSetDescend.size()];
            return this.bindingSetDescend.values().toArray(elements);
        }
    }
}

