/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.asi.internal.registry;

import com.ibm.adapter.asi.internal.ASIPlugin;
import com.ibm.adapter.asi.internal.LogFacility;
import com.ibm.adapter.asi.internal.registry.ApplicationSpecificSchemaConstants;
import com.ibm.adapter.asi.internal.registry.ApplicationSpecificSchemaRegistry;
import com.ibm.adapter.asi.registry.ApplicationSpecificSchemaProperties;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ApplicationSpecificSchemaRegistryPersistence
implements ApplicationSpecificSchemaConstants {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005, 2006 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private static String persistentStore = ASIPlugin.getDefault().getStateLocation().append("asi.registry").toOSString();
    private static ApplicationSpecificSchemaRegistry asiRegistry = null;
    private static PersistentStoreContentHandler persistentStoreContentHandler = new PersistentStoreContentHandler();
    private static UserEntriesContentHandler userEntriesContentHandler = new UserEntriesContentHandler();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void save(ApplicationSpecificSchemaProperties asiProperties) {
        block18: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            file = new File(ApplicationSpecificSchemaRegistryPersistence.persistentStore);
            outputStream = null;
            try {
                block19: {
                    if (file.exists()) break block19;
                    file.createNewFile();
                    ** GOTO lbl47
                }
                ApplicationSpecificSchemaRegistryPersistence.load();
                asi = ApplicationSpecificSchemaRegistryPersistence.persistentStoreContentHandler.getContent();
                if (asi == null) ** GOTO lbl47
                asiit = asi.iterator();
                ** GOTO lbl-1000
            }
            catch (Exception e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    break block18;
                }
                catch (Exception e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                }
                break block18;
            }
            catch (Throwable var6_11) {
                try {
                    if (outputStream == null) throw var6_11;
                    outputStream.close();
                    throw var6_11;
                }
                catch (Exception e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                }
                throw var6_11;
            }
lbl34:
            // 1 sources

            while (true) {
                try {
                    if (outputStream == null) return;
                    outputStream.close();
                    return;
                }
                catch (Exception e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                }
                return;
            }
lbl-1000:
            // 2 sources

            {
                while (asiit.hasNext()) {
                    persistentStoreASI = (ApplicationSpecificSchemaProperties)asiit.next();
                    if (!persistentStoreASI.getNamespaceURI().equals(asiProperties.getNamespaceURI()) || !persistentStoreASI.getXSDFileURL().equals(asiProperties.getXSDFileURL())) continue;
                    ** continue;
lbl46:
                    // 1 sources

                    ** GOTO lbl34
                }
lbl47:
                // 3 sources

                outputStream = new FileOutputStream(file, true);
                ApplicationSpecificSchemaRegistryPersistence.save(asiProperties, outputStream);
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            }
        }
        if (LogFacility.trace == false) return;
        LogFacility.TrcExit();
    }

    public static void save(String fileName) {
        File file = new File(fileName);
        OutputStream outputStream = null;
        try {
            try {
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                outputStream = new FileOutputStream(file, true);
                if (asiRegistry == null) {
                    asiRegistry = ApplicationSpecificSchemaRegistry.getRegistry();
                }
                ApplicationSpecificSchemaProperties[] asiUserEntries = asiRegistry.getUserDefinedApplicationSpecificSchemaProperties();
                int i = 0;
                while (i < asiUserEntries.length) {
                    ApplicationSpecificSchemaRegistryPersistence.save(asiUserEntries[i], outputStream);
                    ++i;
                }
            }
            catch (Exception e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (Exception e2) {
                    LogFacility.logErrorMessage(e2.getLocalizedMessage(), e2);
                }
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            }
        }
    }

    private static void save(ApplicationSpecificSchemaProperties asiProperties, OutputStream outputStream) {
        URL xsdFileURL;
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        if (asiProperties != null && (xsdFileURL = asiProperties.getXSDFileURL()) != null) {
            String description = asiProperties.getDescription();
            String displayName = asiProperties.getDisplayName();
            String asiSchemaLocationURI = xsdFileURL.toExternalForm();
            String namespaceURI = asiProperties.getNamespaceURI();
            int linkage = asiProperties.getLinkage();
            int indent = 0;
            PrintStream out = new PrintStream(outputStream);
            ApplicationSpecificSchemaRegistryPersistence.printIndented(out, indent, "<ApplicationSpecificSchemaProperties");
            ApplicationSpecificSchemaRegistryPersistence.printIndented(out, indent += 2, "description=" + ApplicationSpecificSchemaRegistryPersistence.quote(description));
            ApplicationSpecificSchemaRegistryPersistence.printIndented(out, indent, "displayName=" + ApplicationSpecificSchemaRegistryPersistence.quote(displayName));
            ApplicationSpecificSchemaRegistryPersistence.printIndented(out, indent, "namespaceURI=" + ApplicationSpecificSchemaRegistryPersistence.quote(namespaceURI));
            ApplicationSpecificSchemaRegistryPersistence.printIndented(out, indent, "xsdFileURL=" + ApplicationSpecificSchemaRegistryPersistence.quote(asiSchemaLocationURI));
            ApplicationSpecificSchemaRegistryPersistence.printIndented(out, indent, "linkage=" + ApplicationSpecificSchemaRegistryPersistence.quote(new Integer(linkage).toString()));
            indent = 0;
            ApplicationSpecificSchemaRegistryPersistence.printIndented(out, indent, "/>");
            out.flush();
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    public static void load() {
        block17: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            FileInputStream inputStream = null;
            try {
                try {
                    File file = new File(persistentStore);
                    if (file.exists()) {
                        inputStream = new FileInputStream(persistentStore);
                        ApplicationSpecificSchemaRegistryPersistence.load(inputStream, true);
                    }
                }
                catch (Exception e) {
                    LogFacility.logInfoMessage(e.getLocalizedMessage());
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block17;
                    }
                    catch (Exception e2) {
                        LogFacility.logErrorMessage(e2.getLocalizedMessage(), e2);
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                }
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            }
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    public static List load(String fileName) {
        block15: {
            FileInputStream inputStream = null;
            try {
                try {
                    File file = new File(fileName);
                    if (file.exists()) {
                        inputStream = new FileInputStream(fileName);
                        ApplicationSpecificSchemaRegistryPersistence.load(inputStream, false);
                    }
                }
                catch (Exception e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block15;
                    }
                    catch (Exception e2) {
                        LogFacility.logErrorMessage(e2.getLocalizedMessage(), e2);
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                }
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            }
        }
        return userEntriesContentHandler.getContent();
    }

    private static void load(FileInputStream inputStream, boolean isPersitentStoreContentHandler) throws Exception {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ApplicationSpecificSchemaRegistryPersistence.class.getClassLoader());
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DocumentRoot>\n");
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String line = reader.readLine();
            while (line != null) {
                sb.append(line);
                line = reader.readLine();
            }
            reader.close();
            sb.append("</DocumentRoot>");
            String xmlString = sb.toString();
            xmlString = xmlString.replaceAll("&#xD;", "");
            xmlString = xmlString.replaceAll("&#xA;", "\n");
            ByteArrayInputStream is = new ByteArrayInputStream(xmlString.getBytes());
            if (isPersitentStoreContentHandler) {
                parser.parse(new InputSource(is), (DefaultHandler)persistentStoreContentHandler);
            } else {
                parser.parse(new InputSource(is), (DefaultHandler)userEntriesContentHandler);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevClassLoader);
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    private static String quote(String string) {
        return "\"" + string + "\"";
    }

    private static void printIndented(PrintStream out, int indent, String string) {
        int i = 0;
        while (i < indent) {
            out.print(" ");
            ++i;
        }
        out.println(string);
    }

    public static void addPersistentStoreEntries(ApplicationSpecificSchemaRegistry registry) {
        asiRegistry = registry;
        ApplicationSpecificSchemaRegistryPersistence.addPersistentStoreEntries();
    }

    public static void addPersistentStoreEntries() {
        ApplicationSpecificSchemaRegistryPersistence.load();
        List asiList = persistentStoreContentHandler.getContent();
        if (asiList != null) {
            for (ApplicationSpecificSchemaProperties asi : asiList) {
                if (asiRegistry == null) {
                    asiRegistry = ApplicationSpecificSchemaRegistry.getRegistry();
                }
                asiRegistry.addEntry(asi, false);
            }
        }
    }

    public static void deletePersistentStoreEntry(String namespaceURI, URL xsdFileURL) {
        ApplicationSpecificSchemaRegistryPersistence.load();
        List asiList = persistentStoreContentHandler.getContent();
        if (asiList != null) {
            ApplicationSpecificSchemaProperties asi2 = null;
            boolean matched = false;
            for (ApplicationSpecificSchemaProperties asi2 : asiList) {
                String nsURI = asi2.getNamespaceURI();
                URL url = asi2.getXSDFileURL();
                if (!nsURI.equals(namespaceURI) || !url.equals(xsdFileURL)) continue;
                matched = true;
                break;
            }
            if (matched) {
                asiList.remove(asi2);
                File file = new File(persistentStore);
                if (file.exists()) {
                    file.delete();
                }
                ArrayList<ApplicationSpecificSchemaProperties> clones = new ArrayList<ApplicationSpecificSchemaProperties>();
                Iterator asiit = asiList.iterator();
                while (asiit.hasNext()) {
                    ApplicationSpecificSchemaProperties asiClone = (ApplicationSpecificSchemaProperties)((ApplicationSpecificSchemaProperties)asiit.next()).clone();
                    if (clones.contains(asiClone)) continue;
                    clones.add(asiClone);
                }
                asiList.clear();
                Iterator cit = clones.iterator();
                while (cit.hasNext()) {
                    ApplicationSpecificSchemaRegistryPersistence.save((ApplicationSpecificSchemaProperties)cit.next());
                }
            }
        }
    }

    private static class BaseContentHandler
    extends DefaultHandler {
        private List content;

        public BaseContentHandler(List newContent) {
            this.content = newContent;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            if (localName.equals("ApplicationSpecificSchemaProperties")) {
                String asiSchemaLocationURI = attributes.getValue("", "xsdFileURL");
                ApplicationSpecificSchemaProperties asiProperties = asiRegistry.createEntry();
                String description = attributes.getValue("", "description");
                String displayName = attributes.getValue("", "displayName");
                String namespaceURI = attributes.getValue("", "namespaceURI");
                String linkage = attributes.getValue("", "linkage");
                asiProperties.setDescription(description);
                asiProperties.setDisplayName(displayName);
                asiProperties.setNamespaceURI(namespaceURI);
                try {
                    asiProperties.setXSDFileURL(new URL(asiSchemaLocationURI));
                }
                catch (MalformedURLException e) {
                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                }
                asiProperties.setLinkage(new Integer(linkage));
                if (!this.content.contains(asiProperties)) {
                    this.content.add(asiProperties);
                }
            }
            if (LogFacility.trace) {
                LogFacility.TrcExit();
            }
        }

        public List getContent() {
            return this.content;
        }

        public void clearContent() {
            this.content.clear();
        }
    }

    private static class PersistentStoreContentHandler
    extends BaseContentHandler {
        public PersistentStoreContentHandler() {
            super(new ArrayList());
        }
    }

    private static class UserEntriesContentHandler
    extends BaseContentHandler {
        public UserEntriesContentHandler() {
            super(new ArrayList());
        }
    }
}

