/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.asi.internal.registry;

import com.ibm.adapter.asi.internal.LogFacility;
import com.ibm.adapter.asi.internal.registry.ApplicationSpecificSchemaConstants;
import com.ibm.adapter.asi.internal.registry.ApplicationSpecificSchemaRegistryPersistence;
import com.ibm.adapter.asi.registry.ApplicationSpecificSchemaProperties;
import com.ibm.adapter.asi.registry.IApplicationSpecificSchemaRegistry;
import com.ibm.adapter.asi.registry.IApplicationSpecificSchemaRegistryListener;
import com.ibm.adapter.asi.registry.IApplicationSpecificSchemaRegistrySPI;
import com.ibm.adapter.asi.registry.util.URIHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogElement;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.osgi.framework.Bundle;

public class ApplicationSpecificSchemaRegistry
implements IApplicationSpecificSchemaRegistry,
IApplicationSpecificSchemaRegistrySPI,
ApplicationSpecificSchemaConstants {
    private static final String copyright = "Licensed Material - Property of IBM  5724-I66 (C) Copyright IBM Corporation 2005, 2006 - All Rights Reserved. Note to U.S. Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private static ApplicationSpecificSchemaRegistry _instance;
    private ICatalog _xmlCatalog;
    private Map _asiPropertiesRegistry = Collections.synchronizedMap(new HashMap());
    private Vector _listeners = new Vector();

    public static ApplicationSpecificSchemaRegistry getRegistry() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        if (_instance == null) {
            ApplicationSpecificSchemaRegistry.initializeInstance();
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return _instance;
    }

    private static synchronized void initializeInstance() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        if (_instance == null) {
            _instance = new ApplicationSpecificSchemaRegistry();
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    private ApplicationSpecificSchemaRegistry() {
        boolean hasASIProperties;
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        ICatalog defaultCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        INextCatalog[] nextCatalogs = defaultCatalog.getNextCatalogs();
        int i = 0;
        while (i < nextCatalogs.length) {
            INextCatalog catalog = nextCatalogs[i];
            ICatalog referencedCatalog = catalog.getReferencedCatalog();
            if (referencedCatalog != null && "user_catalog".equals(referencedCatalog.getId())) {
                this._xmlCatalog = referencedCatalog;
                break;
            }
            ++i;
        }
        IConfigurationElement[] asiPropertiesList = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.adapter.asi.ApplicationSpecificSchemaDescription");
        boolean bl = hasASIProperties = asiPropertiesList != null && asiPropertiesList.length > 0;
        if (hasASIProperties) {
            int i2 = 0;
            while (i2 < asiPropertiesList.length) {
                IConfigurationElement asiPropertiesElement = asiPropertiesList[i2];
                String description = asiPropertiesElement.getAttribute("description");
                String displayName = asiPropertiesElement.getAttribute("displayName");
                String namespaceURI = asiPropertiesElement.getAttribute("namespaceURI");
                String xsdFileURL = asiPropertiesElement.getAttribute("xsdFileURL");
                if (description != null && displayName != null && namespaceURI != null && xsdFileURL != null) {
                    URL fileURL = null;
                    try {
                        fileURL = new URL(xsdFileURL);
                    }
                    catch (MalformedURLException malformedURLException) {
                        try {
                            String plugin = asiPropertiesElement.getDeclaringExtension().getNamespaceIdentifier();
                            Bundle bundle = Platform.getBundle((String)plugin);
                            if (bundle != null) {
                                fileURL = bundle.getEntry(xsdFileURL);
                                if (fileURL == null) {
                                    fileURL = bundle.getResource(xsdFileURL);
                                }
                                if (fileURL != null) {
                                    fileURL = FileLocator.toFileURL((URL)fileURL);
                                }
                            }
                        }
                        catch (Exception ex) {
                            LogFacility.logErrorMessage(ex.getLocalizedMessage(), ex);
                        }
                    }
                    if (fileURL != null) {
                        ApplicationSpecificSchemaProperties asiProperties = this.createEntry();
                        asiProperties.setDescription(description);
                        asiProperties.setDisplayName(displayName);
                        asiProperties.setNamespaceURI(namespaceURI);
                        asiProperties.setXSDFileURL(fileURL);
                        asiProperties.setLinkage(0);
                        this.addEntry(asiProperties, false);
                    }
                }
                ++i2;
            }
        }
        ApplicationSpecificSchemaRegistryPersistence.addPersistentStoreEntries(this);
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    @Override
    public ApplicationSpecificSchemaProperties createEntry() {
        return new ApplicationSpecificSchemaProperties();
    }

    synchronized boolean addEntry(ApplicationSpecificSchemaProperties asiProperties, boolean persist) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        boolean added = false;
        if (asiProperties != null) {
            String namespaceURI = asiProperties.getNamespaceURI();
            URL xsdFileURL = asiProperties.getXSDFileURL();
            String asiSchemaLocationURI = xsdFileURL.toExternalForm();
            if (namespaceURI != null && asiSchemaLocationURI != null) {
                if (this._asiPropertiesRegistry.containsKey(namespaceURI)) {
                    List entries = (List)this._asiPropertiesRegistry.get(namespaceURI);
                    if (!entries.contains(asiProperties)) {
                        entries.add(asiProperties);
                        added = true;
                        if (persist) {
                            ApplicationSpecificSchemaRegistryPersistence.save(asiProperties);
                        }
                        this.notifyListeners(asiProperties, 0);
                    }
                } else {
                    ArrayList<ApplicationSpecificSchemaProperties> entries = new ArrayList<ApplicationSpecificSchemaProperties>();
                    entries.add(asiProperties);
                    this._asiPropertiesRegistry.put(namespaceURI, entries);
                    added = true;
                    ICatalogEntry[] catalogEntries = this._xmlCatalog.getCatalogEntries();
                    boolean entryExist = false;
                    String inLocation = this.normalizePath(asiSchemaLocationURI);
                    int i = 0;
                    while (i < catalogEntries.length) {
                        ICatalogEntry catalogEntry = catalogEntries[i];
                        String key = catalogEntry.getKey();
                        String uri = catalogEntry.getURI();
                        String outLocation = this.normalizePath(uri);
                        if (key.equals(namespaceURI) && outLocation.equals(inLocation)) {
                            entryExist = true;
                        }
                        if (entryExist) break;
                        ++i;
                    }
                    if (!entryExist) {
                        ICatalogEntry asiSchemaEntry = (ICatalogEntry)this._xmlCatalog.createCatalogElement(1);
                        asiSchemaEntry.setKey(namespaceURI);
                        asiSchemaEntry.setURI(asiSchemaLocationURI);
                        asiSchemaEntry.setEntryType(2);
                        this._xmlCatalog.addCatalogElement((ICatalogElement)asiSchemaEntry);
                    }
                    if (persist) {
                        ApplicationSpecificSchemaRegistryPersistence.save(asiProperties);
                    }
                    this.notifyListeners(asiProperties, 0);
                }
            }
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return added;
    }

    @Override
    public void addEntry(ApplicationSpecificSchemaProperties asiProperties) {
        this.addEntry(asiProperties, true);
    }

    @Override
    public List addUserEntries(String fileName) {
        List entries = ApplicationSpecificSchemaRegistryPersistence.load(fileName);
        ArrayList<ApplicationSpecificSchemaProperties> asi = new ArrayList<ApplicationSpecificSchemaProperties>();
        for (ApplicationSpecificSchemaProperties entry : entries) {
            boolean added = this.addEntry(entry, true);
            if (!added) continue;
            asi.add(entry);
        }
        return asi;
    }

    @Override
    public void removeEntry(ApplicationSpecificSchemaProperties asiProperties) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        if (asiProperties != null) {
            int linkage;
            List entries;
            String namespaceURI = asiProperties.getNamespaceURI();
            URL xsdFileURL = asiProperties.getXSDFileURL();
            String asiSchemaLocationURI = xsdFileURL.toExternalForm();
            if (namespaceURI != null && asiSchemaLocationURI != null && this._asiPropertiesRegistry.containsKey(namespaceURI) && (entries = (List)this._asiPropertiesRegistry.get(namespaceURI)).contains(asiProperties) && (2 == (linkage = asiProperties.getLinkage()) || 1 == linkage)) {
                entries.remove(asiProperties);
                ApplicationSpecificSchemaRegistryPersistence.deletePersistentStoreEntry(namespaceURI, xsdFileURL);
                ICatalogEntry[] catalogEntries = this._xmlCatalog.getCatalogEntries();
                boolean entryExist = false;
                ICatalogEntry orphanedCatalogEntry = null;
                String inLocation = this.normalizePath(asiSchemaLocationURI);
                int i = 0;
                while (i < catalogEntries.length) {
                    ICatalogEntry catalogEntry = catalogEntries[i];
                    String key = catalogEntry.getKey();
                    String uri = catalogEntry.getURI();
                    String outLocation = this.normalizePath(uri);
                    int type = catalogEntry.getEntryType();
                    if (key.equals(namespaceURI) && outLocation.equals(inLocation) && 1 == type) {
                        entryExist = true;
                        orphanedCatalogEntry = catalogEntry;
                    }
                    if (entryExist) break;
                    ++i;
                }
                if (entryExist) {
                    this._xmlCatalog.removeCatalogElement(orphanedCatalogEntry);
                }
                if (entries.isEmpty()) {
                    this._asiPropertiesRegistry.remove(namespaceURI);
                } else {
                    ApplicationSpecificSchemaProperties asi = (ApplicationSpecificSchemaProperties)entries.get(0);
                    String nsURI = asi.getNamespaceURI();
                    URL url = asi.getXSDFileURL();
                    String asiXSDLocationURI = url.toExternalForm();
                    ICatalogEntry asiSchemaEntry = (ICatalogEntry)this._xmlCatalog.createCatalogElement(1);
                    asiSchemaEntry.setKey(nsURI);
                    asiSchemaEntry.setURI(asiXSDLocationURI);
                    asiSchemaEntry.setEntryType(2);
                    this._xmlCatalog.addCatalogElement((ICatalogElement)asiSchemaEntry);
                }
                this.notifyListeners(asiProperties, 1);
            }
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    @Override
    public ApplicationSpecificSchemaProperties[] getAllApplicationSpecificSchemaProperties() {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        Collection values = this._asiPropertiesRegistry.values();
        ArrayList allASI = new ArrayList();
        for (List value : values) {
            if (value == null || value.isEmpty()) continue;
            allASI.addAll(value);
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return allASI.toArray(new ApplicationSpecificSchemaProperties[0]);
    }

    @Override
    public ApplicationSpecificSchemaProperties[] getApplicationSpecificSchemaProperties(String namespaceURI) {
        if (LogFacility.trace) {
            LogFacility.TrcEntry();
        }
        if (namespaceURI != null && this._asiPropertiesRegistry.containsKey(namespaceURI)) {
            List nsURIProperties = (List)this._asiPropertiesRegistry.get(namespaceURI);
            return nsURIProperties.toArray(new ApplicationSpecificSchemaProperties[0]);
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
        return null;
    }

    @Override
    public synchronized void addApplicationSpecificSchemaListener(IApplicationSpecificSchemaRegistryListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    @Override
    public synchronized void removeApplicationSpecificSchemaListener(IApplicationSpecificSchemaRegistryListener listener) {
        this._listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(final ApplicationSpecificSchemaProperties asi, final int eventType) {
        block12: {
            if (LogFacility.trace) {
                LogFacility.TrcEntry();
            }
            try {
                Vector targets = null;
                ApplicationSpecificSchemaRegistry applicationSpecificSchemaRegistry = this;
                synchronized (applicationSpecificSchemaRegistry) {
                    if (this._listeners != null) {
                        targets = (Vector)this._listeners.clone();
                    }
                }
                if (targets == null) break block12;
                int i = 0;
                while (i < targets.size()) {
                    if (LogFacility.trace) {
                        LogFacility.Trace(new StringBuffer("Notifying listener: ").append(targets.elementAt(i)).toString(), (short)10);
                    }
                    final IApplicationSpecificSchemaRegistryListener target = (IApplicationSpecificSchemaRegistryListener)targets.elementAt(i);
                    try {
                        Thread listenerThread = new Thread(){

                            @Override
                            public void run() {
                                try {
                                    target.notifyRegistryChange(asi, eventType);
                                }
                                catch (Throwable e) {
                                    LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                                }
                            }
                        };
                        listenerThread.start();
                    }
                    catch (Throwable e) {
                        LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
                    }
                    ++i;
                }
            }
            catch (RuntimeException e) {
                LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            }
        }
        if (LogFacility.trace) {
            LogFacility.TrcExit();
        }
    }

    @Override
    public ApplicationSpecificSchemaProperties[] getPluginDefinedApplicationSpecificSchemaProperties() {
        return this.getASIByLinkage(this._asiPropertiesRegistry.values(), 0);
    }

    @Override
    public ApplicationSpecificSchemaProperties[] getResourceAdapterDefinedApplicationSpecificSchemaProperties() {
        return this.getASIByLinkage(this._asiPropertiesRegistry.values(), 1);
    }

    @Override
    public ApplicationSpecificSchemaProperties[] getUserDefinedApplicationSpecificSchemaProperties() {
        return this.getASIByLinkage(this._asiPropertiesRegistry.values(), 2);
    }

    private ApplicationSpecificSchemaProperties[] getASIByLinkage(Collection asiProperties, int linkage) {
        ArrayList<ApplicationSpecificSchemaProperties> asiByLinkage = new ArrayList<ApplicationSpecificSchemaProperties>();
        for (List asiList : asiProperties) {
            for (ApplicationSpecificSchemaProperties asi : asiList) {
                if (linkage != asi.getLinkage()) continue;
                asiByLinkage.add(asi);
            }
        }
        return asiByLinkage.toArray(new ApplicationSpecificSchemaProperties[0]);
    }

    @Override
    public void saveUserEntries(String fileName) {
        ApplicationSpecificSchemaRegistryPersistence.save(fileName);
    }

    private String normalizePath(String asiSchemaLocationURI) {
        String location = "";
        if (URIHelper.isFileProtocol(asiSchemaLocationURI)) {
            location = URIHelper.removeProtocol(asiSchemaLocationURI);
            while (location.startsWith("/") || location.startsWith("\\")) {
                location = location.substring(1);
            }
        }
        return location;
    }
}

