/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.license.manager.ui.internal;

import com.businessobjects.license.manager.ui.LicenseMessages;
import com.businessobjects.license.manager.ui.internal.ValidationException;
import com.crystaldecisions.common.keycode.KeyDecoderV2;
import com.crystaldecisions.common.keycode.KeycodeDecoderFactory;
import com.crystaldecisions.common.keycode.KeycodeException;

public class KeycodeValidator {
    private static final int MIN_PRODUCT_VERSION = 110;
    private static final int MAX_PRODUCT_VERSION = 115;
    private static final String KC_PRODUCT_VERSION = "KC.ProductVersion";
    private static final String KC_OLD_PRODUCT_ENUM = "KC.OldProductEnum";
    private static final String KC_ENABLE_JRC = "JRC.EnableJRC";

    public static void validateKeycode(String string) throws ValidationException {
        KeyDecoderV2 keyDecoderV2 = KeycodeDecoderFactory.getKeycodeDecoderV2();
        try {
            keyDecoderV2.SetKey(string);
            int n = KeycodeValidator.getProperty(keyDecoderV2, KC_PRODUCT_VERSION);
            boolean bl = false;
            if (n < 115) {
                int n2 = KeycodeValidator.getProperty(keyDecoderV2, KC_OLD_PRODUCT_ENUM);
                if (n2 == 34 || n2 == 6 || n2 == 27) {
                    bl = true;
                }
            } else if (KeycodeValidator.getProperty(keyDecoderV2, KC_ENABLE_JRC) > 0) {
                bl = true;
            }
            if (n < 110 || 115 < n || !bl) {
                throw new ValidationException(LicenseMessages.invalid_keycode);
            }
            try {
                if (keyDecoderV2.IsExpired()) {
                    throw new ValidationException(LicenseMessages.keycodeUtils_keycode_expired);
                }
            }
            catch (KeycodeException keycodeException) {}
        }
        catch (KeycodeException keycodeException) {
            throw new ValidationException(keycodeException.getMessage());
        }
    }

    private static int getProperty(KeyDecoderV2 keyDecoderV2, String string) {
        try {
            return (int)keyDecoderV2.GetProperty(string);
        }
        catch (KeycodeException keycodeException) {
            return -1;
        }
    }
}

