/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.web.jsf.crviewer.internal;

import com.businessobjects.integration.capabilities.librarycomponents.ILibraryComponentIDEAdaptor;
import com.businessobjects.integration.capabilities.librarycomponents.crystalreports.exceptions.ReportLocationException;
import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.rad.web.jsf.crviewer.NLSResourceManager;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.BrowseDialog;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.BrowseReportFileValidator;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.BrowseTreeContentProvider;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.BrowseTreeLabelProvider;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.FacesViewerLibraryIDEAdaptor;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.ReportLocationUtils;
import com.businessobjects.integration.rad.web.jsf.crviewer.internal.TagLibraryUtils;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;

public class BrowseActionHandler
extends SelectionAdapter {
    private Text m_fileNameField;

    public BrowseActionHandler(Text text) {
        this.m_fileNameField = text;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        Object object = selectionEvent.getSource();
        if (object instanceof Button) {
            Button button = (Button)object;
            FacesViewerLibraryIDEAdaptor facesViewerLibraryIDEAdaptor = new FacesViewerLibraryIDEAdaptor();
            if (TagLibraryUtils.checkAndPromptJRCLibraryInstall(facesViewerLibraryIDEAdaptor)) {
                try {
                    String string = ReportLocationUtils.getReportDirectoryCanonicalPath((ILibraryComponentIDEAdaptor)facesViewerLibraryIDEAdaptor);
                    BrowseDialog browseDialog = new BrowseDialog(button.getShell(), (ILabelProvider)new BrowseTreeLabelProvider(), new BrowseTreeContentProvider(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), false));
                    browseDialog.setInput(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile());
                    File file = new File(string);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    browseDialog.setInitialSelection(file);
                    browseDialog.setTitle(NLSResourceManager.page1_browse_button_tooltip);
                    browseDialog.setMessage(NLSResourceManager.page1_browse_button_tooltip);
                    browseDialog.setValidator(new BrowseReportFileValidator());
                    browseDialog.setBlockOnOpen(true);
                    browseDialog.setAllowMultiple(false);
                    browseDialog.open();
                    if (browseDialog.getFirstResult() != null) {
                        Path path = new Path(browseDialog.getFirstResult() + "");
                        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                        String string2 = iFile.getFullPath().makeAbsolute().toString();
                        if (this.m_fileNameField != null && string2 != null) {
                            this.m_fileNameField.setText(string2);
                        }
                    }
                }
                catch (ReportLocationException reportLocationException) {
                    LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.jsf.crviewer", (Exception)((Object)reportLocationException));
                }
            }
        }
    }
}

