package businessobjects;

import com.crystaldecisions.sdk.exception.SDKException;
import com.crystaldecisions.sdk.occa.infostore.IInfoObject;
import com.crystaldecisions.sdk.occa.infostore.IInfoObjects;
import com.crystaldecisions.sdk.occa.infostore.IInfoStore;
import com.crystaldecisions.sdk.properties.IProperty;

public class EnterpriseItemLastInstanceWrapper extends EnterpriseItemBean {
	
	/**
	 * Retrieve the last successful instance of the Info object, and use that to populate the
	 * EnterpriseItem bean instead.  If an instance does not exist, or if there is an error 
	 * retrieving the latest instance, the original ID will be returned, so a viewer backed
	 * by this bean will have "view on demand" as fall back.
	 * 
	 * While you are free to extend or modify this, any such extensions are not supported 
	 * by Business Objects.
	 */
	public String getItemID() {

		String origItemId = super.getItemID();
		if (origItemId != null && getIdentity() != null) {
			StringBuffer query = new StringBuffer().append("SELECT SI_ID, SI_LAST_SUCCESSFUL_INSTANCE_ID FROM CI_INFOOBJECTS WHERE ");
			if (isId(origItemId)) {
				query.append("SI_ID = ").append(origItemId);
			} else {
				query.append("SI_CUID = '").append(origItemId).append("'");
			}
			try {
				IInfoStore store = getIdentity().getInfoStore();
				IInfoObjects iObjs = store.query(query.toString());
				if (iObjs.size() > 0) {
					IInfoObject iObj = (IInfoObject)iObjs.get(0);
					IProperty prop = iObj.properties().getProperty("SI_LAST_SUCCESSFUL_INSTANCE_ID");
					if (prop != null) {
						Integer lastInstanceId = (Integer)prop.getValue();
						if (lastInstanceId != null) {
							return lastInstanceId.toString();
						}
					}
				}
			} catch (SDKException e) {
				// TODO handle exception
			}
		}
		return origItemId;
    }
	
	
	private boolean isId(String itemID) {
		try {
			Integer.valueOf(itemID);
			return true;
		} catch (NumberFormatException ex) {
			return false;
		}
	}


}
