/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.model;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.eclipse.shared.ITreeItemWithDescription;
import com.businessobjects.integration.rad.enterprise.objects.ObjectTypeManager;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionException;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfo;
import com.businessobjects.integration.rad.enterprise.sdkconnection.EnterpriseFunctionAccessor;
import com.businessobjects.integration.rad.enterprise.view.PropertySource;
import com.businessobjects.integration.rad.enterprise.view.model.TreeParent;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;

public class TreeObject
implements IAdaptable,
ITreeItemWithDescription,
Serializable {
    private int id;
    private String name;
    private ConnectionInfo connInfo;
    private TreeParent parent;
    private String description;
    private String progId;
    private boolean readOnly;

    protected TreeObject(ConnectionInfo connectionInfo, int n, String string, String string2, String string3, TreeParent treeParent) {
        this.id = n;
        this.name = string;
        this.connInfo = connectionInfo;
        this.description = string2;
        this.progId = string3;
        this.parent = treeParent;
        this.readOnly = false;
    }

    protected TreeObject(ConnectionInfo connectionInfo, int n, String string, String string2, String string3, TreeParent treeParent, boolean bl) {
        this(connectionInfo, n, string, string2, string3, treeParent);
        this.readOnly = bl;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    protected boolean isEqual(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public boolean equals(Object object) {
        TreeObject treeObject;
        if (object instanceof TreeObject && (treeObject = (TreeObject)object).getId() == this.getId()) {
            return this.isEqual(this.getConnInfo(), treeObject.getConnInfo()) && this.isEqual(this.getParent(), treeObject.getParent());
        }
        return false;
    }

    public int hashCode() {
        if (this.getConnInfo() == null) {
            return this.id;
        }
        return this.getConnInfo().hashCode() * 10000 + this.id;
    }

    public void rename(String string) throws ConnectionException {
        EnterpriseFunctionAccessor.getInstance((int)this.getConnInfo().getVersion()).rename(this.getConnInfo(), this.getId(), string);
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public TreeParent getParent() {
        return this.parent;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.getName();
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IPropertySource.class && this.connInfo != null && this.id >= 0) {
            try {
                List list = EnterpriseFunctionAccessor.getInstance((int)this.connInfo.getVersion()).query(this.connInfo, this.getPropertyQuery(this.id));
                if (list.size() == 1) {
                    Map map = (Map)list.get(0);
                    return new PropertySource(this, map, null);
                }
            }
            catch (ConnectionException connectionException) {
                LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)connectionException));
            }
        }
        return null;
    }

    protected String getPropertyQuery(int n) {
        return "SELECT * FROM CI_INFOOBJECTS,CI_APPOBJECTS,CI_SYSTEMOBJECTS WHERE SI_ID=" + n;
    }

    public ConnectionInfo getConnInfo() {
        return this.connInfo;
    }

    public String getDescription() {
        return this.description;
    }

    public String getProgId() {
        return this.progId;
    }

    public Image getImage() {
        if (this.progId != null) {
            return ObjectTypeManager.getIcon((String)this.progId);
        }
        return null;
    }

    public boolean hasParent(TreeParent treeParent) {
        if (this.parent == null) {
            return false;
        }
        return this.parent.equals(treeParent) || this.parent.hasParent(treeParent);
    }

    public void remove() throws ConnectionException {
        EnterpriseFunctionAccessor.getInstance((int)this.getConnInfo().getVersion()).remove(this.getConnInfo(), this.getId());
    }
}

