/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.dnd.internal;

import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.rad.enterprise.view.NLSResourceManager;
import com.businessobjects.integration.rad.enterprise.view.dnd.internal.ExportErrorRecord;
import com.businessobjects.integration.shared.CommonStrings;
import com.businessobjects.integration.shared.ResourceManager;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class ExportErrorDialog
extends TitleAreaDialog {
    private ExportErrorRecord[] errors;

    public ExportErrorDialog(Shell shell, List<ExportErrorRecord> list) {
        super(shell);
        this.errors = (ExportErrorRecord[])list.toArray();
    }

    protected void configureShell(Shell shell) {
        shell.setText(NLSResourceManager.export_error_dialog_title);
        super.configureShell(shell);
    }

    protected Point getInitialSize() {
        return new Point(450, 400);
    }

    protected Control createDialogArea(Composite composite) {
        int n;
        this.setTitle(NLSResourceManager.export_error_title);
        this.setErrorMessage(NLSResourceManager.export_error_message);
        Composite composite2 = new Composite(composite, 2048);
        composite2.setLayout((Layout)new FillLayout());
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        final TableViewer tableViewer = new TableViewer(composite2, 65538);
        final Table table = tableViewer.getTable();
        table.setLinesVisible(false);
        table.setHeaderVisible(true);
        String[] stringArray = new String[]{ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.NAME)};
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn tableColumn = table.getSortColumn();
                TableColumn tableColumn2 = (TableColumn)event.widget;
                int n = table.getSortDirection();
                if (tableColumn == tableColumn2) {
                    n = n == 128 ? 1024 : 128;
                } else {
                    table.setSortColumn(tableColumn2);
                    n = 128;
                }
                final int n2 = n;
                Arrays.sort(ExportErrorDialog.this.errors, new Comparator<ExportErrorRecord>(){

                    @Override
                    public int compare(ExportErrorRecord exportErrorRecord, ExportErrorRecord exportErrorRecord2) {
                        if (exportErrorRecord.getPath() == null || exportErrorRecord2.getPath() == null) {
                            return 0;
                        }
                        if (n2 == 128) {
                            return exportErrorRecord.getPath().compareTo(exportErrorRecord2.getPath());
                        }
                        return exportErrorRecord2.getPath().compareTo(exportErrorRecord.getPath());
                    }
                });
                table.setSortDirection(n);
                tableViewer.refresh();
            }
        };
        for (n = 0; n < stringArray.length; ++n) {
            TableColumn tableColumn = new TableColumn(table, 0);
            tableColumn.setText(stringArray[n]);
            tableColumn.addListener(13, listener);
        }
        table.setSortColumn(table.getColumn(0));
        table.setSortDirection(128);
        tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object object) {
                if (object instanceof Object[]) {
                    return ExportErrorDialog.this.errors;
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object object, int n) {
                return null;
            }

            public String getColumnText(Object object, int n) {
                ExportErrorRecord exportErrorRecord = (ExportErrorRecord)object;
                switch (n) {
                    case 0: {
                        return exportErrorRecord.getPath();
                    }
                }
                return null;
            }

            public void addListener(ILabelProviderListener iLabelProviderListener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object object, String string) {
                return true;
            }

            public void removeListener(ILabelProviderListener iLabelProviderListener) {
            }
        });
        tableViewer.setInput((Object)this.errors);
        for (n = 0; n < stringArray.length; ++n) {
            table.getColumn(n).pack();
        }
        table.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Table table = tableViewer.getTable();
                table.getColumn(0).setWidth(table.getClientArea().width);
            }
        });
        IWorkbenchHelpSystem iWorkbenchHelpSystem = UIUtilities.getHelpSystem();
        if (iWorkbenchHelpSystem != null) {
            iWorkbenchHelpSystem.setHelp((Control)composite2, "com.businessobjects.integration.rad.enterprise.view.docroot");
        }
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
    }
}

