/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.dnd;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.rad.enterprise.view.model.TreeObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class TreeObjectTransfer
extends ByteArrayTransfer {
    private static TreeObjectTransfer instance = new TreeObjectTransfer();
    private static final String TYPE_NAME = "enterprise-object-transfer-format";
    private static final int TYPEID = TreeObjectTransfer.registerType((String)"enterprise-object-transfer-format");

    public static TreeObjectTransfer getInstance() {
        return instance;
    }

    private TreeObjectTransfer() {
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        byte[] byArray = this.toByteArray((TreeObject[])object);
        if (byArray != null) {
            super.javaToNative((Object)byArray, transferData);
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] byArray = (byte[])super.nativeToJava(transferData);
        return this.fromByteArray(byArray);
    }

    public TreeObject[] fromByteArray(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            TreeObject[] treeObjectArray = (TreeObject[])objectInputStream.readObject();
            String[] stringArray = (String[])objectInputStream.readObject();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                treeObjectArray[i].getConnInfo().setPassword(stringArray[i]);
            }
            return treeObjectArray;
        }
        catch (Exception exception) {
            LogManager.getInstance().message(100, "com.businessobjects.integration.rad.enterprise.view", exception);
            return new TreeObject[0];
        }
    }

    public byte[] toByteArray(TreeObject[] treeObjectArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(treeObjectArray);
            String[] stringArray = new String[treeObjectArray.length];
            for (int i = 0; i < treeObjectArray.length; ++i) {
                if (treeObjectArray[i].getConnInfo() == null) continue;
                stringArray[i] = treeObjectArray[i].getConnInfo().getPassword();
            }
            objectOutputStream.writeObject(stringArray);
            objectOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            LogManager.getInstance().message(100, "com.businessobjects.integration.rad.enterprise.view", (Exception)iOException);
            return new byte[0];
        }
    }
}

