/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.dnd;

import com.businessobjects.integration.capabilities.filesystem.FileSystemManager;
import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.rad.enterprise.objects.IObjectTypeHandler;
import com.businessobjects.integration.rad.enterprise.objects.ObjectTypeManager;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionException;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfo;
import com.businessobjects.integration.rad.enterprise.sdkconnection.EnterpriseUtilities;
import com.businessobjects.integration.rad.enterprise.view.EnterpriseView;
import com.businessobjects.integration.rad.enterprise.view.actions.PasteFromClipboardAction;
import com.businessobjects.integration.rad.enterprise.view.dnd.TreeObjectTransfer;
import com.businessobjects.integration.rad.enterprise.view.dnd.internal.ExportErrorDialog;
import com.businessobjects.integration.rad.enterprise.view.dnd.internal.ExportErrorRecord;
import com.businessobjects.integration.rad.enterprise.view.model.BOEObjectsTreeParent;
import com.businessobjects.integration.rad.enterprise.view.model.RootParent;
import com.businessobjects.integration.rad.enterprise.view.model.TreeObject;
import com.businessobjects.integration.rad.enterprise.view.model.TreeParent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.part.PluginDropAdapter;
import org.eclipse.ui.part.ResourceTransfer;

public class TreeObjectDropListener
extends PluginDropAdapter {
    public TreeObjectDropListener(TreeViewer treeViewer) {
        super((StructuredViewer)treeViewer);
    }

    public boolean performDrop(Object object) {
        if (!(this.getCurrentTarget() instanceof TreeObject)) {
            return false;
        }
        BOEObjectsTreeParent bOEObjectsTreeParent = null;
        TreeObject treeObject = (TreeObject)this.getCurrentTarget();
        if (treeObject instanceof BOEObjectsTreeParent) {
            bOEObjectsTreeParent = (BOEObjectsTreeParent)treeObject;
        } else if (treeObject.getParent() instanceof BOEObjectsTreeParent) {
            bOEObjectsTreeParent = (BOEObjectsTreeParent)treeObject.getParent();
        }
        if (bOEObjectsTreeParent == null) {
            bOEObjectsTreeParent = (BOEObjectsTreeParent)this.getViewer().getInput();
        }
        int n = this.getCurrentOperation();
        if (object instanceof IResource[]) {
            return PasteFromClipboardAction.handleResourceTransfer((TreeViewer)this.getViewer(), (IResource[])object, bOEObjectsTreeParent, n);
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            return this.handleFileTransfer(stringArray, bOEObjectsTreeParent, n);
        }
        if (object instanceof TreeObject[]) {
            return PasteFromClipboardAction.handleTreeObjectTransfer((TreeViewer)this.getViewer(), (TreeObject[])object, bOEObjectsTreeParent, n);
        }
        if (object instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)object;
            ArrayList<IResource> arrayList = new ArrayList<IResource>();
            for (Object e : iStructuredSelection) {
                IResource iResource = null;
                if (e instanceof IResource) {
                    iResource = (IResource)e;
                } else if (e instanceof IAdaptable) {
                    iResource = (IResource)((IAdaptable)e).getAdapter(IResource.class);
                }
                if (iResource == null) continue;
                arrayList.add(iResource);
            }
            return PasteFromClipboardAction.handleResourceTransfer((TreeViewer)this.getViewer(), arrayList.toArray(new IResource[arrayList.size()]), bOEObjectsTreeParent, n);
        }
        super.performDrop(object);
        return true;
    }

    private boolean handleFileTransfer(String[] stringArray, BOEObjectsTreeParent bOEObjectsTreeParent, int n) {
        return TreeObjectDropListener.handleFileTransfer((TreeViewer)this.getViewer(), stringArray, bOEObjectsTreeParent);
    }

    public boolean validateDrop(Object object, int n, TransferData transferData) {
        if (object instanceof RootParent || object instanceof TreeParent && !(object instanceof BOEObjectsTreeParent)) {
            return false;
        }
        if (object instanceof IFile && !(object instanceof IContainer)) {
            return false;
        }
        return TreeObjectTransfer.getInstance().isSupportedType(transferData) || FileTransfer.getInstance().isSupportedType(transferData) || ResourceTransfer.getInstance().isSupportedType(transferData) || LocalSelectionTransfer.getTransfer().isSupportedType(transferData) || super.validateDrop(object, n, transferData);
    }

    private static void getAllFilesRecursively(BOEObjectsTreeParent bOEObjectsTreeParent, String[] stringArray, Map<String, Map<Integer, List<File>>> map, List<ExportErrorRecord> list) throws ConnectionException {
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            Object object2;
            Object object3;
            String string;
            File file = new File(stringArray[i]);
            if (!file.exists()) {
                list.add(new ExportErrorRecord(file.getAbsolutePath()));
                continue;
            }
            if (file.isDirectory()) {
                string = file.getName();
                string = EnterpriseUtilities.generateUniqueNameOnEnterprise((int)bOEObjectsTreeParent.getId(), (ConnectionInfo)bOEObjectsTreeParent.getConnInfo(), (String)string);
                int n = bOEObjectsTreeParent.createFolder(string);
                object3 = (BOEObjectsTreeParent)bOEObjectsTreeParent.getChild(n);
                object2 = file.listFiles();
                object = new String[((File[])object2).length];
                for (int j = 0; j < stringArray.length; ++j) {
                    object[i] = object2[i].getAbsolutePath();
                }
                TreeObjectDropListener.getAllFilesRecursively((BOEObjectsTreeParent)object3, (String[])object, map, list);
                continue;
            }
            string = FileSystemManager.getFileExtension((String)file.getName());
            if (string == null) {
                list.add(new ExportErrorRecord(file.getAbsolutePath()));
                continue;
            }
            String string2 = ObjectTypeManager.getProgramId((String)string);
            if (string2 == null) {
                list.add(new ExportErrorRecord(file.getAbsolutePath()));
                continue;
            }
            object3 = ObjectTypeManager.getHandler((String)string2);
            if (object3 == null) {
                list.add(new ExportErrorRecord(file.getAbsolutePath()));
                continue;
            }
            if (object3.isPublishable(bOEObjectsTreeParent.getConnInfo(), bOEObjectsTreeParent.getId())) {
                object2 = map.get(string2);
                if (object2 == null) {
                    object2 = new HashMap();
                }
                if ((object = (List)object2.get(new Integer(bOEObjectsTreeParent.getId()))) == null) {
                    object = new ArrayList();
                }
                object.add(file);
                object2.put(new Integer(bOEObjectsTreeParent.getId()), object);
                map.put(string2, (Map<Integer, List<File>>)object2);
                continue;
            }
            list.add(new ExportErrorRecord(file.getAbsolutePath()));
        }
    }

    public static boolean handleFileTransfer(final TreeViewer treeViewer, String[] stringArray, final BOEObjectsTreeParent bOEObjectsTreeParent) {
        ArrayList<ExportErrorRecord> arrayList = new ArrayList<ExportErrorRecord>();
        HashMap<String, Map<Integer, List<File>>> hashMap = new HashMap<String, Map<Integer, List<File>>>();
        try {
            TreeObjectDropListener.getAllFilesRecursively(bOEObjectsTreeParent, stringArray, hashMap, arrayList);
            final ArrayList arrayList2 = new ArrayList();
            for (Object object : hashMap.entrySet()) {
                String string = (String)object.getKey();
                Map map = (Map)object.getValue();
                IObjectTypeHandler iObjectTypeHandler = ObjectTypeManager.getHandler((String)string);
                if (iObjectTypeHandler == null) continue;
                ArrayList arrayList3 = new ArrayList();
                arrayList2.addAll(iObjectTypeHandler.publish(bOEObjectsTreeParent.getConnInfo(), map, arrayList3));
                for (File file : arrayList3) {
                    arrayList.add(new ExportErrorRecord(file.getAbsolutePath()));
                }
            }
            if (treeViewer != null) {
                UIUtilities.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        treeViewer.refresh((Object)bOEObjectsTreeParent);
                        EnterpriseView enterpriseView = EnterpriseView.getView();
                        if (enterpriseView != null) {
                            enterpriseView.getHelper().selectItemsInView(bOEObjectsTreeParent.getConnInfo(), arrayList2);
                        }
                    }
                });
            }
            if (!arrayList.isEmpty()) {
                Object object;
                object = new ExportErrorDialog(UIUtilities.getShell(), arrayList);
                object.open();
            }
        }
        catch (ConnectionException connectionException) {
            LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)connectionException));
        }
        return false;
    }
}

