/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.actions.internal;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionException;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfo;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfoManager;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionStore;
import com.businessobjects.integration.rad.enterprise.sdkconnection.EnterpriseFunctionAccessor;
import com.businessobjects.integration.rad.enterprise.sdkconnection.IConnectionStore;
import com.businessobjects.integration.rad.enterprise.view.EnterpriseViewPlugin;
import com.businessobjects.integration.rad.enterprise.view.NLSResourceManager;
import com.businessobjects.integration.rad.enterprise.view.actions.internal.NewConnectionWizard;
import com.businessobjects.integration.shared.CommonStrings;
import com.businessobjects.integration.shared.ResourceManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class NewConnectionWizardPage1
extends WizardPage
implements ModifyListener,
SelectionListener {
    private List names = new ArrayList();
    private String[] authIds;
    private String displayName;
    private String serverName;
    private String userId;
    private String password;
    private String authMethod;
    private boolean savePassword;
    private boolean useDefaultNaming = true;
    private String initialDisplayName = "";
    private String initialServerName = "";
    private String initialUserId = "";
    private String initialPassword = "";
    private String initialAuthMethod = "secEnterprise";
    private boolean initialSavePassword = false;
    private boolean isFirstShown = true;
    private boolean isEdit;
    private Text connectionNameText;
    private Text systemNameText;
    private Text userNameText;
    private Text passwordText;
    private Combo authentication;
    private Button savePasswordBtn;
    private NewConnectionWizard wizard;
    private Button useDefaultNamingBtn;

    public NewConnectionWizardPage1() {
        super(NewConnectionWizardPage1.class.getName());
        this.setMessage(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.BOE_LOGON_DESCRIPTION));
        this.setImageDescriptor(EnterpriseViewPlugin.getImageDescriptor("icons/logon.gif"));
        try {
            this.authIds = EnterpriseFunctionAccessor.getInstanceWithOldestSDK().getAuthenticationMethodsId();
        }
        catch (ConnectionException connectionException) {
            this.authIds = new String[0];
            LogManager.getInstance().message(1000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)connectionException));
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public boolean isModified() {
        return !this.displayName.equals(this.initialDisplayName) || !this.serverName.equals(this.initialServerName) || !this.userId.equals(this.initialUserId) || !this.password.equals(this.initialPassword) || !this.authMethod.equals(this.initialAuthMethod) || this.savePassword != this.initialSavePassword;
    }

    public void commitChanges() {
        this.initialDisplayName = this.displayName;
        this.initialServerName = this.serverName;
        this.initialUserId = this.userId;
        this.initialPassword = this.password;
        this.initialAuthMethod = this.authMethod;
        this.initialSavePassword = this.savePassword;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.wizard = (NewConnectionWizard)this.getWizard();
            this.isEdit = this.wizard.isEdit();
            ConnectionInfo connectionInfo = this.wizard.getConnectionInfo();
            String string = connectionInfo != null ? (connectionInfo.getDisplayName() == null ? "" : connectionInfo.getDisplayName()) : (this.displayName = this.initialDisplayName);
            String string2 = connectionInfo != null ? (connectionInfo.getServerName() == null ? "" : connectionInfo.getServerName()) : (this.serverName = this.initialServerName);
            String string3 = connectionInfo != null ? (connectionInfo.getUserId() == null ? "" : connectionInfo.getUserId()) : (this.userId = this.initialUserId);
            String string4 = connectionInfo != null ? (connectionInfo.getPassword() == null || !this.initialSavePassword ? "" : connectionInfo.getPassword()) : (this.password = this.initialPassword);
            final String string5 = this.authMethod = connectionInfo != null ? (connectionInfo.getAuthMethod() == null ? "" : connectionInfo.getAuthMethod()) : this.initialAuthMethod;
            this.savePassword = connectionInfo != null ? connectionInfo.isSavePassword() : this.initialSavePassword;
            UIUtilities.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    NewConnectionWizardPage1.this.connectionNameText.setText(NewConnectionWizardPage1.this.displayName);
                    NewConnectionWizardPage1.this.systemNameText.setText(NewConnectionWizardPage1.this.serverName);
                    NewConnectionWizardPage1.this.userNameText.setText(NewConnectionWizardPage1.this.userId);
                    NewConnectionWizardPage1.this.passwordText.setText(NewConnectionWizardPage1.this.password);
                    int n = 0;
                    for (int i = 0; i < NewConnectionWizardPage1.this.authIds.length; ++i) {
                        if (NewConnectionWizardPage1.this.authIds[i].equals(string5)) {
                            n = i;
                        }
                        try {
                            NewConnectionWizardPage1.this.authentication.add(EnterpriseFunctionAccessor.getInstanceWithOldestSDK().getAuthenticationMethodName(NewConnectionWizardPage1.this.authIds[i]), i);
                            continue;
                        }
                        catch (ConnectionException connectionException) {
                            LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)connectionException));
                        }
                    }
                    NewConnectionWizardPage1.this.authentication.select(n);
                    NewConnectionWizardPage1.this.savePasswordBtn.setSelection(NewConnectionWizardPage1.this.savePassword);
                    if (NewConnectionWizardPage1.this.isFirstShown) {
                        NewConnectionWizardPage1.this.isFirstShown = false;
                        NewConnectionWizardPage1.this.setPageComplete(NewConnectionWizardPage1.this.isEdit);
                        ConnectionInfo[] connectionInfoArray = ConnectionInfoManager.getInstance().getConnections((IConnectionStore)ConnectionStore.getInstance());
                        for (int i = 0; i < connectionInfoArray.length; ++i) {
                            NewConnectionWizardPage1.this.names.add(connectionInfoArray[i].getDisplayName());
                        }
                        if (NewConnectionWizardPage1.this.isEdit) {
                            NewConnectionWizardPage1.this.names.remove(NewConnectionWizardPage1.this.initialDisplayName);
                            NewConnectionWizardPage1.this.useDefaultNaming = false;
                            NewConnectionWizardPage1.this.useDefaultNamingBtn.setSelection(false);
                            NewConnectionWizardPage1.this.connectionNameText.setEnabled(true);
                        }
                        NewConnectionWizardPage1.this.connectionNameText.addModifyListener((ModifyListener)NewConnectionWizardPage1.this);
                        NewConnectionWizardPage1.this.systemNameText.addModifyListener((ModifyListener)NewConnectionWizardPage1.this);
                        NewConnectionWizardPage1.this.userNameText.addModifyListener((ModifyListener)NewConnectionWizardPage1.this);
                        NewConnectionWizardPage1.this.passwordText.addModifyListener((ModifyListener)NewConnectionWizardPage1.this);
                        NewConnectionWizardPage1.this.authentication.addSelectionListener((SelectionListener)NewConnectionWizardPage1.this);
                        NewConnectionWizardPage1.this.savePasswordBtn.addSelectionListener((SelectionListener)NewConnectionWizardPage1.this);
                    }
                }
            });
            this.systemNameText.forceFocus();
        }
        super.setVisible(bl);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        FormLayout formLayout = new FormLayout();
        composite2.setLayout((Layout)formLayout);
        Group group = new Group(composite2, 0);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 15);
        formData.right = new FormAttachment(100, -15);
        formData.top = new FormAttachment(0, 10);
        group.setLayoutData((Object)formData);
        group.setLayout((Layout)new FormLayout());
        group.setText(NLSResourceManager.connection_id_group_name);
        this.useDefaultNamingBtn = new Button((Composite)group, 32);
        this.useDefaultNamingBtn.setText(NLSResourceManager.connection_use_default);
        this.useDefaultNamingBtn.setSelection(true);
        formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        formData.top = new FormAttachment(0, 5);
        this.useDefaultNamingBtn.setLayoutData((Object)formData);
        this.useDefaultNamingBtn.addSelectionListener((SelectionListener)this);
        formData = new Label((Composite)group, 0);
        formData.setText(NLSResourceManager.connection_name);
        FormData formData2 = new FormData();
        formData2.left = new FormAttachment(0, 5);
        formData2.top = new FormAttachment((Control)this.useDefaultNamingBtn, 5);
        formData2.right = new FormAttachment(25, 0);
        formData.setLayoutData((Object)formData2);
        this.connectionNameText = new Text((Composite)group, 2048);
        formData2 = new FormData();
        formData2.left = new FormAttachment(25, 0);
        formData2.right = new FormAttachment(100, -5);
        formData2.top = new FormAttachment((Control)this.useDefaultNamingBtn, 5);
        formData2.bottom = new FormAttachment(100, -5);
        this.connectionNameText.setLayoutData((Object)formData2);
        this.connectionNameText.setEnabled(false);
        formData2 = new Group(composite2, 0);
        formData2.setText(NLSResourceManager.connection_details_group_name);
        formData2.setLayout((Layout)new FormLayout());
        FormData formData3 = new FormData();
        formData3.left = new FormAttachment(0, 15);
        formData3.right = new FormAttachment(100, -15);
        formData3.top = new FormAttachment((Control)group, 5);
        formData2.setLayoutData((Object)formData3);
        formData3 = new Label((Composite)formData2, 0);
        this.systemNameText = new Text((Composite)formData2, 2048);
        Label label = new Label((Composite)formData2, 0);
        this.userNameText = new Text((Composite)formData2, 2048);
        Label label2 = new Label((Composite)formData2, 0);
        this.passwordText = new Text((Composite)formData2, 0x400800);
        Label label3 = new Label((Composite)formData2, 0);
        int n = 8;
        if (this.authIds.length == 0) {
            n = 0;
        }
        this.authentication = new Combo((Composite)formData2, n);
        this.savePasswordBtn = new Button((Composite)formData2, 32);
        this.savePasswordBtn.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.BOE_LOGON_SAVE_PASSWORD));
        Label label4 = new Label((Composite)formData2, 64);
        label4.setImage(EnterpriseViewPlugin.getImage("icons/warning.gif"));
        Label label5 = new Label((Composite)formData2, 64);
        label5.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.BOE_LOGON_SAVE_PASSWORD_WARNING));
        formData3.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.BOE_LOGON_SYSTEM));
        label.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.BOE_LOGON_USERNAME));
        label2.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.BOE_LOGON_PASSWORD));
        label3.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.BOE_LOGON_AUTHENTICATION));
        try {
            this.authIds = EnterpriseFunctionAccessor.getInstanceWithOldestSDK().getAuthenticationMethodsId();
        }
        catch (ConnectionException connectionException) {
            LogManager.getInstance().message(1000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)connectionException));
        }
        FormData formData4 = new FormData();
        formData4.left = new FormAttachment(0, 5);
        formData4.right = new FormAttachment(25, 0);
        formData4.top = new FormAttachment(0, 5);
        formData3.setLayoutData((Object)formData4);
        FormData formData5 = new FormData();
        formData5.left = new FormAttachment((Control)formData3, 5);
        formData5.right = new FormAttachment(100, -5);
        formData5.top = new FormAttachment(0, 5);
        this.systemNameText.setLayoutData((Object)formData5);
        FormData formData6 = new FormData();
        formData6.left = new FormAttachment(0, 5);
        formData6.right = new FormAttachment(25, 0);
        formData6.top = new FormAttachment((Control)this.systemNameText, 5);
        label.setLayoutData((Object)formData6);
        FormData formData7 = new FormData();
        formData7.left = new FormAttachment((Control)label, 5);
        formData7.right = new FormAttachment(100, -5);
        formData7.top = new FormAttachment((Control)this.systemNameText, 5);
        this.userNameText.setLayoutData((Object)formData7);
        FormData formData8 = new FormData();
        formData8.left = new FormAttachment(0, 5);
        formData8.right = new FormAttachment(25, 0);
        formData8.top = new FormAttachment((Control)this.userNameText, 5);
        label2.setLayoutData((Object)formData8);
        FormData formData9 = new FormData();
        formData9.left = new FormAttachment((Control)label2, 5);
        formData9.right = new FormAttachment(100, -5);
        formData9.top = new FormAttachment((Control)this.userNameText, 5);
        this.passwordText.setLayoutData((Object)formData9);
        FormData formData10 = new FormData();
        formData10.left = new FormAttachment(0, 5);
        formData10.right = new FormAttachment(25, 0);
        formData10.top = new FormAttachment((Control)this.passwordText, 5);
        label3.setLayoutData((Object)formData10);
        FormData formData11 = new FormData();
        formData11.left = new FormAttachment((Control)label3, 5);
        formData11.right = new FormAttachment(100, -5);
        formData11.top = new FormAttachment((Control)this.passwordText, 5);
        this.authentication.setLayoutData((Object)formData11);
        FormData formData12 = new FormData();
        formData12.left = new FormAttachment(0, 5);
        formData12.right = new FormAttachment(100, -5);
        formData12.top = new FormAttachment((Control)this.authentication, 5);
        this.savePasswordBtn.setLayoutData((Object)formData12);
        FormData formData13 = new FormData();
        formData13.left = new FormAttachment(0, 5);
        formData13.top = new FormAttachment((Control)this.savePasswordBtn, 5);
        label4.setLayoutData((Object)formData13);
        FormData formData14 = new FormData();
        formData14.left = new FormAttachment((Control)label4, 5);
        formData14.right = new FormAttachment(100, -5);
        formData14.top = new FormAttachment((Control)this.savePasswordBtn, 5);
        formData14.bottom = new FormAttachment(100, -5);
        label5.setLayoutData((Object)formData14);
        IWorkbenchHelpSystem iWorkbenchHelpSystem = UIUtilities.getHelpSystem();
        if (iWorkbenchHelpSystem != null) {
            iWorkbenchHelpSystem.setHelp((Control)composite2, "com.businessobjects.integration.rad.enterprise.view.docroot");
        }
        this.setControl((Control)composite2);
    }

    public void performHelp() {
        IWorkbenchHelpSystem iWorkbenchHelpSystem = UIUtilities.getHelpSystem();
        if (iWorkbenchHelpSystem != null) {
            iWorkbenchHelpSystem.displayHelp("com.businessobjects.integration.rad.enterprise.view.docroot");
        }
    }

    private void setError(String string) {
        if (string == null) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(string);
            this.setPageComplete(false);
        }
    }

    private void validate() {
        this.useDefaultNaming = this.useDefaultNamingBtn.getSelection();
        this.connectionNameText.setEnabled(!this.useDefaultNaming);
        if (!this.useDefaultNaming) {
            this.displayName = this.connectionNameText.getText().trim();
            if (this.displayName.length() == 0) {
                this.setError(NLSResourceManager.err_display_name_missing);
                return;
            }
        }
        this.serverName = this.systemNameText.getText().trim();
        if (this.useDefaultNaming) {
            String string = this.displayName;
            int n = 2;
            String string2 = this.serverName;
            while (this.names.contains(string2)) {
                string2 = this.serverName + "_" + n;
                ++n;
            }
            this.displayName = string2;
            if (!this.displayName.equals(string)) {
                this.displayName = string2;
                UIUtilities.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        NewConnectionWizardPage1.this.connectionNameText.setText(NewConnectionWizardPage1.this.displayName);
                    }
                });
            }
        }
        if (this.serverName.length() == 0) {
            this.setError(NLSResourceManager.err_server_name_missing);
            return;
        }
        if (this.names.contains(this.displayName)) {
            this.setError(NLS.bind((String)NLSResourceManager.err_display_name_not_unique, (Object)this.displayName));
            return;
        }
        this.userId = this.userNameText.getText().trim();
        if (this.userId.length() == 0) {
            this.setError(NLSResourceManager.err_user_id_missing);
            return;
        }
        this.password = this.passwordText.getText().trim();
        this.authMethod = this.authIds.length == 0 || this.authentication.getSelectionIndex() < 0 ? this.authentication.getText().trim() : this.authIds[this.authentication.getSelectionIndex()];
        if (this.authMethod.length() == 0) {
            this.setError(NLSResourceManager.err_auth_method_missing);
            return;
        }
        this.savePassword = this.savePasswordBtn.getSelection();
        this.setError(null);
    }

    public void modifyText(ModifyEvent modifyEvent) {
        this.validate();
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.validate();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.validate();
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setInitialAuthMethod(String string) {
        this.initialAuthMethod = string == null ? "" : string;
    }

    public void setInitialDisplayName(String string) {
        this.initialDisplayName = string == null ? "" : string;
    }

    public void setInitialPassword(String string) {
        this.initialPassword = string == null ? "" : string;
    }

    public void setInitialSavePassword(boolean bl) {
        this.initialSavePassword = bl;
    }

    public void setInitialServerName(String string) {
        this.initialServerName = string == null ? "" : string;
    }

    public void setInitialUserId(String string) {
        this.initialUserId = string == null ? "" : string;
    }
}

