/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.actions.internal;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionException;
import com.businessobjects.integration.rad.enterprise.sdkconnection.EnterpriseFunctionAccessor;
import com.businessobjects.integration.shared.CommonStrings;
import com.businessobjects.integration.shared.ResourceManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class LogonDialog
extends Dialog {
    private static final String DEFAULT_AUTH_METHOD = "secEnterprise";
    private String[] authIds;
    protected String authenticationVal;
    private String userNameVal = "";
    private String passwordVal = "";

    public String getAuthentication() {
        return this.authenticationVal.trim();
    }

    public String getPassword() {
        return this.passwordVal;
    }

    public String getUserName() {
        return this.userNameVal.trim();
    }

    public LogonDialog(Shell shell, String string, String string2, String string3) {
        super(shell);
        this.userNameVal = string == null ? "" : string;
        this.passwordVal = string2 == null ? "" : string2;
        this.authenticationVal = string3 == null ? DEFAULT_AUTH_METHOD : string3;
    }

    protected Control createDialogArea(Composite composite) {
        this.getShell().setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.BOE_LOGON_TITLE));
        Composite composite2 = new Composite(composite, 0);
        FormLayout formLayout = new FormLayout();
        composite2.setLayout((Layout)formLayout);
        Label label = new Label(composite2, 0);
        final Text text = new Text(composite2, 2048);
        text.setText(this.userNameVal);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                LogonDialog.this.userNameVal = text.getText();
                LogonDialog.this.validate();
            }
        });
        Label label2 = new Label(composite2, 0);
        final Text text2 = new Text(composite2, 0x400800);
        text2.setText(this.passwordVal);
        text2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                LogonDialog.this.passwordVal = text2.getText();
                LogonDialog.this.validate();
            }
        });
        Label label3 = new Label(composite2, 0);
        final Combo combo = new Combo(composite2, 8);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LogonDialog.this.authenticationVal = LogonDialog.this.authIds[combo.getSelectionIndex()];
                LogonDialog.this.validate();
            }
        });
        label.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.BOE_LOGON_USERNAME));
        label2.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.BOE_LOGON_PASSWORD));
        label3.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.BOE_LOGON_AUTHENTICATION));
        try {
            this.authIds = EnterpriseFunctionAccessor.getInstanceWithOldestSDK().getAuthenticationMethodsId();
            int n = 0;
            for (int i = 0; i < this.authIds.length; ++i) {
                if (this.authIds[i].equals(this.authenticationVal)) {
                    n = i;
                }
                combo.add(EnterpriseFunctionAccessor.getInstanceWithOldestSDK().getAuthenticationMethodName(this.authIds[i]), i);
            }
            combo.select(n);
        }
        catch (ConnectionException connectionException) {
            LogManager.getInstance().message(1000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)connectionException));
        }
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 15);
        formData.right = new FormAttachment(25, 0);
        formData.top = new FormAttachment(0, 10);
        label.setLayoutData((Object)formData);
        FormData formData2 = new FormData();
        formData2.left = new FormAttachment((Control)label, 5);
        formData2.right = new FormAttachment(100, -15);
        formData2.top = new FormAttachment(0, 10);
        text.setLayoutData((Object)formData2);
        FormData formData3 = new FormData();
        formData3.left = new FormAttachment(0, 15);
        formData3.right = new FormAttachment(25, 0);
        formData3.top = new FormAttachment((Control)text, 10);
        label2.setLayoutData((Object)formData3);
        FormData formData4 = new FormData();
        formData4.left = new FormAttachment((Control)label2, 5);
        formData4.right = new FormAttachment(100, -15);
        formData4.top = new FormAttachment((Control)text, 10);
        text2.setLayoutData((Object)formData4);
        FormData formData5 = new FormData();
        formData5.left = new FormAttachment(0, 15);
        formData5.right = new FormAttachment(25, 0);
        formData5.top = new FormAttachment((Control)text2, 10);
        label3.setLayoutData((Object)formData5);
        FormData formData6 = new FormData();
        formData6.left = new FormAttachment((Control)label3, 5);
        formData6.right = new FormAttachment(100, -15);
        formData6.top = new FormAttachment((Control)text2, 10);
        combo.setLayoutData((Object)formData6);
        return composite2;
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.validate();
        IWorkbenchHelpSystem iWorkbenchHelpSystem = UIUtilities.getHelpSystem();
        if (iWorkbenchHelpSystem != null) {
            iWorkbenchHelpSystem.setHelp(control, "com.businessobjects.integration.rad.enterprise.view.docroot");
        }
        return control;
    }

    private void validate() {
        boolean bl = this.getAuthentication().length() != 0 && this.getUserName().length() != 0;
        this.getButton(0).setEnabled(bl);
    }
}

