/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.actions;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.eclipse.shared.Selection;
import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.rad.enterprise.objects.IObjectTypeHandler;
import com.businessobjects.integration.rad.enterprise.objects.ObjectTypeManager;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionException;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfo;
import com.businessobjects.integration.rad.enterprise.sdkconnection.EnterpriseFunctionAccessor;
import com.businessobjects.integration.rad.enterprise.sdkconnection.EnterpriseUtilities;
import com.businessobjects.integration.rad.enterprise.view.EnterpriseView;
import com.businessobjects.integration.rad.enterprise.view.NLSResourceManager;
import com.businessobjects.integration.rad.enterprise.view.actions.ExportToBIARContextAction;
import com.businessobjects.integration.rad.enterprise.view.dnd.TreeObjectTransfer;
import com.businessobjects.integration.rad.enterprise.view.dnd.internal.ExportErrorDialog;
import com.businessobjects.integration.rad.enterprise.view.dnd.internal.ExportErrorRecord;
import com.businessobjects.integration.rad.enterprise.view.model.BOEObjectsTreeParent;
import com.businessobjects.integration.rad.enterprise.view.model.TreeObject;
import com.businessobjects.integration.rad.enterprise.view.model.TreeParent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ResourceTransfer;

public class PasteFromClipboardAction
extends Action {
    private int operation;

    public int getOperation() {
        return this.operation;
    }

    public void setOperation(int n) {
        this.operation = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Clipboard clipboard = new Clipboard(UIUtilities.getDisplay());
        try {
            TransferData[] transferDataArray = clipboard.getAvailableTypes();
            for (int i = 0; i < transferDataArray.length; ++i) {
                Object object;
                IStructuredSelection iStructuredSelection;
                EnterpriseView enterpriseView;
                TreeViewer treeViewer;
                Object[] objectArray;
                if (ResourceTransfer.getInstance().isSupportedType(transferDataArray[i])) {
                    objectArray = (IResource[])clipboard.getContents((Transfer)ResourceTransfer.getInstance());
                    treeViewer = null;
                    enterpriseView = EnterpriseView.getView();
                    if (enterpriseView != null) {
                        treeViewer = enterpriseView.getViewer();
                    }
                    if ((iStructuredSelection = (IStructuredSelection)treeViewer.getSelection()) != null) {
                        object = iStructuredSelection.getFirstElement();
                        if (!(object instanceof BOEObjectsTreeParent)) {
                            LogManager.getInstance().message(100, "com.businessobjects.integration.rad.enterprise.view", "Attempted to paste into an object that is not a container...");
                            return;
                        }
                        PasteFromClipboardAction.handleResourceTransfer(treeViewer, objectArray, (BOEObjectsTreeParent)object, 1);
                        continue;
                    }
                    LogManager.getInstance().message(100, "com.businessobjects.integration.rad.enterprise.view", "Attempted to paste into no selection...");
                    return;
                }
                if (!TreeObjectTransfer.getInstance().isSupportedType(transferDataArray[i])) continue;
                objectArray = (TreeObject[])clipboard.getContents((Transfer)TreeObjectTransfer.getInstance());
                treeViewer = null;
                enterpriseView = EnterpriseView.getView();
                if (enterpriseView != null) {
                    treeViewer = enterpriseView.getViewer();
                }
                if ((iStructuredSelection = (IStructuredSelection)treeViewer.getSelection()) != null) {
                    object = iStructuredSelection.getFirstElement();
                    if (!(object instanceof BOEObjectsTreeParent)) {
                        LogManager.getInstance().message(100, "com.businessobjects.integration.rad.enterprise.view", "Attempted to paste into an object that is not a container...");
                        return;
                    }
                    PasteFromClipboardAction.handleTreeObjectTransfer(treeViewer, (TreeObject[])objectArray, (BOEObjectsTreeParent)object, this.operation);
                    continue;
                }
                LogManager.getInstance().message(100, "com.businessobjects.integration.rad.enterprise.view", "Attempted to paste into no selection...");
                return;
            }
        }
        finally {
            clipboard.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Clipboard clipboard = new Clipboard(UIUtilities.getDisplay());
        try {
            int n;
            int n2 = 0;
            TransferData[] transferDataArray = clipboard.getAvailableTypes();
            for (n = 0; n < transferDataArray.length; ++n) {
                TreeViewer treeViewer;
                EnterpriseView enterpriseView;
                if (!ResourceTransfer.getInstance().isSupportedType(transferDataArray[n]) && !TreeObjectTransfer.getInstance().isSupportedType(transferDataArray[n]) && !FileTransfer.getInstance().isSupportedType(transferDataArray[n]) || (enterpriseView = EnterpriseView.getView()) == null || (treeViewer = enterpriseView.getViewer()) == null) continue;
                IStructuredSelection iStructuredSelection = (IStructuredSelection)treeViewer.getSelection();
                n2 = iStructuredSelection.getFirstElement() instanceof BOEObjectsTreeParent;
            }
            n = n2;
            return n != 0;
        }
        finally {
            clipboard.dispose();
        }
    }

    private static void getAllResourcesRecursively(BOEObjectsTreeParent bOEObjectsTreeParent, IResource[] iResourceArray, Map<String, Map<Integer, List<File>>> map, List<ExportErrorRecord> list) throws CoreException, ConnectionException {
        for (int i = 0; i < iResourceArray.length; ++i) {
            Object object;
            Object object2;
            Object object3;
            String string;
            if (!iResourceArray[i].isAccessible()) {
                list.add(new ExportErrorRecord(iResourceArray[i].getFullPath().toString()));
                continue;
            }
            if (iResourceArray[i] instanceof IContainer) {
                string = iResourceArray[i].getName();
                string = EnterpriseUtilities.generateUniqueNameOnEnterprise((int)bOEObjectsTreeParent.getId(), (ConnectionInfo)bOEObjectsTreeParent.getConnInfo(), (String)string);
                int n = bOEObjectsTreeParent.createFolder(string);
                object3 = (BOEObjectsTreeParent)bOEObjectsTreeParent.getChild(n);
                object2 = (IContainer)iResourceArray[i];
                object = object2.members();
                PasteFromClipboardAction.getAllResourcesRecursively((BOEObjectsTreeParent)object3, (IResource[])object, map, list);
                continue;
            }
            string = iResourceArray[i].getFileExtension();
            if (string == null) {
                list.add(new ExportErrorRecord(iResourceArray[i].getFullPath().toString()));
                continue;
            }
            String string2 = ObjectTypeManager.getProgramId((String)string);
            if (string2 == null) {
                list.add(new ExportErrorRecord(iResourceArray[i].getFullPath().toString()));
                continue;
            }
            object3 = ObjectTypeManager.getHandler((String)string2);
            if (object3 == null) {
                list.add(new ExportErrorRecord(iResourceArray[i].getFullPath().toString()));
                continue;
            }
            if (object3.isPublishable(bOEObjectsTreeParent.getConnInfo(), bOEObjectsTreeParent.getId())) {
                object2 = map.get(string2);
                if (object2 == null) {
                    object2 = new HashMap();
                }
                if ((object = (List)object2.get(new Integer(bOEObjectsTreeParent.getId()))) == null) {
                    object = new ArrayList();
                }
                File file = new File(iResourceArray[i].getLocation().toOSString());
                object.add(file);
                object2.put(new Integer(bOEObjectsTreeParent.getId()), object);
                map.put(string2, (Map<Integer, List<File>>)object2);
                continue;
            }
            list.add(new ExportErrorRecord(iResourceArray[i].getFullPath().toString()));
        }
    }

    public static boolean handleResourceTransfer(final TreeViewer treeViewer, IResource[] iResourceArray, final BOEObjectsTreeParent bOEObjectsTreeParent, int n) {
        ArrayList<ExportErrorRecord> arrayList = new ArrayList<ExportErrorRecord>();
        HashMap<String, Map<Integer, List<File>>> hashMap = new HashMap<String, Map<Integer, List<File>>>();
        try {
            PasteFromClipboardAction.getAllResourcesRecursively(bOEObjectsTreeParent, iResourceArray, hashMap, arrayList);
            final ArrayList arrayList2 = new ArrayList();
            for (Object object : hashMap.entrySet()) {
                String string = (String)object.getKey();
                Map map = (Map)object.getValue();
                IObjectTypeHandler iObjectTypeHandler = ObjectTypeManager.getHandler((String)string);
                if (iObjectTypeHandler == null) continue;
                ArrayList arrayList3 = new ArrayList();
                arrayList2.addAll(iObjectTypeHandler.publish(bOEObjectsTreeParent.getConnInfo(), map, arrayList3));
                for (File file : arrayList3) {
                    IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(file.getAbsolutePath()));
                    arrayList.add(new ExportErrorRecord(iFile.getFullPath().toString()));
                }
            }
            if (treeViewer != null) {
                UIUtilities.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        treeViewer.refresh((Object)bOEObjectsTreeParent);
                        EnterpriseView enterpriseView = EnterpriseView.getView();
                        if (enterpriseView != null) {
                            enterpriseView.getHelper().selectItemsInView(bOEObjectsTreeParent.getConnInfo(), arrayList2);
                        }
                    }
                });
            }
            if (!arrayList.isEmpty()) {
                Object object;
                object = new ExportErrorDialog(UIUtilities.getShell(), arrayList);
                object.open();
            }
        }
        catch (CoreException coreException) {
            LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)coreException));
        }
        catch (ConnectionException connectionException) {
            LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)connectionException));
        }
        return false;
    }

    public static boolean handleTreeObjectTransfer(final TreeViewer treeViewer, final TreeObject[] treeObjectArray, TreeParent treeParent, int n) {
        for (int i = 0; i < treeObjectArray.length; ++i) {
            if (treeObjectArray[i].equals(treeParent) && (PasteFromClipboardAction.isMove(n) || PasteFromClipboardAction.isCopy(n)) || treeObjectArray[i] instanceof TreeParent && treeParent.hasParent((TreeParent)treeObjectArray[i])) {
                UIUtilities.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)treeViewer.getControl().getShell(), (String)NLSResourceManager.move_item_under_itself_error_title, (String)NLSResourceManager.move_item_under_itself_error_message);
                    }
                });
                return false;
            }
            if (treeParent.getConnInfo() == null || treeParent.getConnInfo().getId() == treeObjectArray[i].getConnInfo().getId()) continue;
            UIUtilities.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Selection selection = new Selection();
                    for (int i = 0; i < treeObjectArray.length; ++i) {
                        selection.addItem((Object)treeObjectArray[i]);
                    }
                    ExportToBIARContextAction exportToBIARContextAction = new ExportToBIARContextAction();
                    exportToBIARContextAction.setSelection((IStructuredSelection)selection);
                    if (exportToBIARContextAction.isEnabled()) {
                        boolean bl = MessageDialog.openQuestion((Shell)treeViewer.getControl().getShell(), (String)NLSResourceManager.obj_transfer_across_systems_title, (String)NLSResourceManager.obj_transfer_across_systems_biar);
                        if (bl) {
                            exportToBIARContextAction.run();
                        }
                    } else {
                        MessageDialog.openError((Shell)treeViewer.getControl().getShell(), (String)NLSResourceManager.obj_transfer_across_systems_title, (String)NLSResourceManager.obj_transfer_across_systems_import_wiz);
                    }
                }
            });
            return false;
        }
        int[] nArray = new int[treeObjectArray.length];
        int n2 = 0;
        for (int i = 0; i < treeObjectArray.length; ++i) {
            if (PasteFromClipboardAction.isMove(n) && treeParent.equals(treeObjectArray[i].getParent())) continue;
            nArray[n2] = treeObjectArray[i].getId();
            ++n2;
        }
        if (PasteFromClipboardAction.isMove(n)) {
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            if (nArray2.length > 0) {
                try {
                    EnterpriseFunctionAccessor.getInstance((int)treeParent.getConnInfo().getVersion()).moveObjects(treeParent.getConnInfo(), nArray2, treeParent.getId());
                }
                catch (ConnectionException connectionException) {
                    LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)connectionException));
                    return false;
                }
                treeViewer.refresh((Object)treeParent, false);
                for (int i = 0; i < treeObjectArray.length; ++i) {
                    TreeParent treeParent2 = treeObjectArray[i].getParent();
                    if (treeParent2 == null) continue;
                    treeViewer.refresh((Object)treeParent2, false);
                }
            }
        } else {
            try {
                if (PasteFromClipboardAction.isCopy(n)) {
                    EnterpriseFunctionAccessor.getInstance((int)treeParent.getConnInfo().getVersion()).copyObjects(treeParent.getConnInfo(), nArray, treeParent.getId());
                } else if (PasteFromClipboardAction.isLink(n)) {
                    EnterpriseFunctionAccessor.getInstance((int)treeParent.getConnInfo().getVersion()).linkObjects(treeParent.getConnInfo(), nArray, treeParent.getId());
                }
            }
            catch (ConnectionException connectionException) {
                LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)connectionException));
                return false;
            }
            treeViewer.refresh((Object)treeParent);
        }
        return true;
    }

    private static boolean isMove(int n) {
        return (n & 2) > 0;
    }

    private static boolean isCopy(int n) {
        return (n & 1) > 0;
    }

    private static boolean isLink(int n) {
        return (n & 4) > 0;
    }
}

