/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.actions;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.rad.enterprise.view.EnterpriseViewPlugin;
import com.businessobjects.integration.rad.enterprise.view.actions.IEnterpriseViewAction;
import com.businessobjects.integration.rad.enterprise.view.model.RootParent;
import com.businessobjects.integration.rad.enterprise.view.model.TreeObject;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class LaunchCMCContextAction
extends Action
implements IEnterpriseViewAction {
    private IStructuredSelection selection;

    @Override
    public void setSelection(IStructuredSelection iStructuredSelection) {
        this.selection = iStructuredSelection;
        this.setEnabled(this.isEnabledBasedOnState());
    }

    @Override
    public boolean isVisible() {
        return this.isEnabled();
    }

    public boolean isEnabledBasedOnState() {
        if (this.selection != null && this.selection.size() == 1) {
            TreeObject treeObject = (TreeObject)this.selection.getFirstElement();
            boolean bl = !(treeObject instanceof RootParent);
            return bl;
        }
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return EnterpriseViewPlugin.getImageDescriptor("icons/cmc.gif");
    }

    public void run() {
        TreeObject treeObject = (TreeObject)this.selection.getFirstElement();
        if (treeObject.getConnInfo() == null) {
            throw new IllegalStateException();
        }
        String string = treeObject.getConnInfo().getCMCLocation();
        LogManager.getInstance().message(100, "com.businessobjects.integration.rad.enterprise.view", "Launching URL:" + string);
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        if (iWorkbench != null) {
            IWorkbenchBrowserSupport iWorkbenchBrowserSupport = iWorkbench.getBrowserSupport();
            try {
                iWorkbenchBrowserSupport.createBrowser(8, string, this.getText(), this.getText()).openURL(new URL(string));
            }
            catch (PartInitException partInitException) {
                LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)partInitException));
            }
            catch (MalformedURLException malformedURLException) {
                LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.enterprise.view", (Exception)malformedURLException);
            }
        }
    }
}

