/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.actions;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.eclipse.shared.Selection;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionException;
import com.businessobjects.integration.rad.enterprise.view.EnterpriseView;
import com.businessobjects.integration.rad.enterprise.view.NLSResourceManager;
import com.businessobjects.integration.rad.enterprise.view.model.TreeObject;
import com.businessobjects.integration.rad.enterprise.view.model.TreeParent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class DeleteFromClipboardAction
extends Action {
    public void run() {
        EnterpriseView enterpriseView = EnterpriseView.getView();
        TreeViewer treeViewer = enterpriseView.getViewer();
        if (treeViewer != null) {
            if (this.getSelection().size() == 0) {
                LogManager.getInstance().message(100, "com.businessobjects.integration.rad.enterprise.view", "RemoveAction selection size = 0!");
                return;
            }
            String string = this.getSelection().size() == 1 ? NLS.bind((String)NLSResourceManager.delete_confirm_prompt_single, (Object)String.valueOf(this.getSelection().getFirstElement())) : NLS.bind((String)NLSResourceManager.delete_confirm_prompt_multiple, (Object)String.valueOf(this.getSelection().size()));
            boolean bl = MessageDialog.openConfirm((Shell)treeViewer.getControl().getShell(), (String)NLSResourceManager.delete_confirm_title, (String)string);
            if (bl) {
                Selection selection = new Selection();
                for (TreeObject treeObject : this.getSelection()) {
                    TreeParent treeParent = treeObject.getParent();
                    try {
                        treeObject.remove();
                        treeViewer.refresh((Object)treeParent);
                        selection.addItem((Object)treeParent);
                    }
                    catch (ConnectionException connectionException) {
                        LogManager.getInstance().message(10000, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)connectionException));
                    }
                }
                treeViewer.setSelection((ISelection)selection, true);
            }
        }
    }

    public IStructuredSelection getSelection() {
        TreeViewer treeViewer;
        EnterpriseView enterpriseView = EnterpriseView.getView();
        if (enterpriseView != null && (treeViewer = enterpriseView.getViewer()) != null) {
            return (IStructuredSelection)treeViewer.getSelection();
        }
        return null;
    }
}

