/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.view.actions;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.rad.enterprise.view.actions.IEnterpriseViewAction;
import com.businessobjects.integration.rad.enterprise.view.actions.internal.EnterpriseViewActionContribution;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ActionsManager {
    private static final String POINT_ID = "com.businessobjects.integration.rad.enterprise.view.actions";
    private static final String TOOLBAR = "toolbar";
    private static final String CONTEXT = "context";
    private static List<EnterpriseViewActionContribution> toolbarActions = new ArrayList<EnterpriseViewActionContribution>();
    private static List<EnterpriseViewActionContribution> otherToolbarMenuActions = new ArrayList<EnterpriseViewActionContribution>();
    private static List<EnterpriseViewActionContribution> contextMenuActions = new ArrayList<EnterpriseViewActionContribution>();
    private static List<EnterpriseViewActionContribution> otherContextMenuActions = new ArrayList<EnterpriseViewActionContribution>();

    public static List<EnterpriseViewActionContribution> getContextMenuActions() {
        ArrayList<EnterpriseViewActionContribution> arrayList = new ArrayList<EnterpriseViewActionContribution>(contextMenuActions);
        arrayList.addAll(otherContextMenuActions);
        return arrayList;
    }

    public static List<EnterpriseViewActionContribution> getToolbarActions() {
        ArrayList<EnterpriseViewActionContribution> arrayList = new ArrayList<EnterpriseViewActionContribution>(toolbarActions);
        arrayList.addAll(otherToolbarMenuActions);
        return arrayList;
    }

    public static void setSelection(IStructuredSelection iStructuredSelection) {
        ActionsManager.setSelectionList(toolbarActions.iterator(), iStructuredSelection);
        ActionsManager.setSelectionList(otherToolbarMenuActions.iterator(), iStructuredSelection);
        ActionsManager.setSelectionList(contextMenuActions.iterator(), iStructuredSelection);
        ActionsManager.setSelectionList(otherContextMenuActions.iterator(), iStructuredSelection);
    }

    private static void setSelectionList(Iterator iterator, IStructuredSelection iStructuredSelection) {
        while (iterator.hasNext()) {
            EnterpriseViewActionContribution enterpriseViewActionContribution = (EnterpriseViewActionContribution)iterator.next();
            IEnterpriseViewAction iEnterpriseViewAction = enterpriseViewActionContribution.getAction();
            if (iEnterpriseViewAction == null) continue;
            iEnterpriseViewAction.setSelection(iStructuredSelection);
        }
    }

    static {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(POINT_ID);
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        for (int i = 0; i < iExtensionArray.length; ++i) {
            if (!iExtensionArray[i].isValid()) continue;
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[i].getConfigurationElements();
            for (int j = 0; j < iConfigurationElementArray.length; ++j) {
                EnterpriseViewActionContribution enterpriseViewActionContribution;
                String string;
                String string2 = iConfigurationElementArray[j].getAttribute("path");
                String string3 = iConfigurationElementArray[j].getAttribute("type");
                String string4 = iConfigurationElementArray[j].getAttribute("name");
                String string5 = iExtensionArray[i].getContributor().getName();
                if (iConfigurationElementArray[j].getName().equals("separator")) {
                    string = iConfigurationElementArray[j].getAttribute("menu");
                    enterpriseViewActionContribution = new EnterpriseViewActionContribution(string4, string2, Boolean.valueOf(string));
                } else {
                    String string6;
                    string = iConfigurationElementArray[j].getAttribute("description");
                    IEnterpriseViewAction iEnterpriseViewAction = null;
                    if (iConfigurationElementArray[j].getAttribute("actionClass") != null) {
                        try {
                            iEnterpriseViewAction = (IEnterpriseViewAction)iConfigurationElementArray[j].createExecutableExtension("actionClass");
                        }
                        catch (CoreException coreException) {
                            LogManager.getInstance().message(100, "com.businessobjects.integration.rad.enterprise.view", (Exception)((Object)coreException));
                        }
                    }
                    if ((string6 = iConfigurationElementArray[j].getAttribute("icon")) != null) {
                        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)string5, (String)string6);
                        iEnterpriseViewAction.setImageDescriptor(imageDescriptor);
                    }
                    iEnterpriseViewAction.setText(string4);
                    iEnterpriseViewAction.setDescription(string);
                    iEnterpriseViewAction.setToolTipText(string);
                    enterpriseViewActionContribution = new EnterpriseViewActionContribution(string2, iEnterpriseViewAction);
                }
                if (TOOLBAR.equals(string3)) {
                    if ("com.businessobjects.integration.rad.enterprise.view".equals(string5)) {
                        toolbarActions.add(enterpriseViewActionContribution);
                        continue;
                    }
                    otherToolbarMenuActions.add(enterpriseViewActionContribution);
                    continue;
                }
                if (!CONTEXT.equals(string3)) continue;
                if ("com.businessobjects.integration.rad.enterprise.view".equals(string5)) {
                    contextMenuActions.add(enterpriseViewActionContribution);
                    continue;
                }
                otherContextMenuActions.add(enterpriseViewActionContribution);
            }
        }
    }
}

