/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.preference.internal.tableview;

import com.businessobjects.integration.rad.enterprise.preference.NLSResourceManager;
import com.businessobjects.integration.rad.enterprise.preference.internal.tableview.IPropertyList;
import com.businessobjects.integration.rad.enterprise.preference.internal.tableview.PropertyTableCellModifier;
import com.businessobjects.integration.rad.enterprise.preference.internal.tableview.PropertyTableContentProvider;
import com.businessobjects.integration.rad.enterprise.preference.internal.tableview.PropertyTableLabelProvider;
import com.businessobjects.integration.shared.CommonStrings;
import com.businessobjects.integration.shared.ResourceManager;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class PropertyTableViewer {
    private IPropertyList m_propertyList;
    private Table m_table;
    private TableViewer m_tableViewer;
    private String[] columnNames = new String[]{"", ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.DESCRIPTION)};

    public PropertyTableViewer(Composite composite, IPropertyList iPropertyList) {
        this.m_propertyList = iPropertyList;
        this.addChildControls(composite);
    }

    public void setEnabled(boolean bl) {
        this.m_table.setEnabled(bl);
    }

    public void dispose() {
        this.m_tableViewer.getLabelProvider().dispose();
    }

    private void addChildControls(Composite composite) {
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 4;
        composite.setLayout((Layout)gridLayout);
        this.createTable(composite);
        this.createTableViewer();
        this.m_tableViewer.setContentProvider((IContentProvider)new PropertyTableContentProvider(this.m_propertyList, this.m_tableViewer));
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)new PropertyTableLabelProvider());
        this.m_tableViewer.setInput((Object)this.m_propertyList);
        this.createButtons(composite);
    }

    private void createTable(Composite composite) {
        int n = 101124;
        this.m_table = new Table(composite, n);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        this.m_table.setLayoutData((Object)gridData);
        this.m_table.setLinesVisible(true);
        this.m_table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.m_table, 0x1000000, 0);
        tableColumn.setText(this.columnNames[0]);
        tableColumn.setWidth(20);
        TableColumn tableColumn2 = new TableColumn(this.m_table, 16384, 1);
        tableColumn2.setText(this.columnNames[1]);
        this.m_table.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                if (event.widget instanceof Table) {
                    Table table = (Table)event.widget;
                    table.removeListener(11, (Listener)this);
                    table.getColumn(1).setWidth(table.getClientArea().width - 20 - table.getGridLineWidth());
                    table.addListener(11, (Listener)this);
                }
            }
        });
        this.m_table.pack();
    }

    private void createTableViewer() {
        this.m_tableViewer = new TableViewer(this.m_table);
        this.m_tableViewer.setUseHashlookup(true);
        this.m_tableViewer.setColumnProperties(this.columnNames);
        CellEditor[] cellEditorArray = new CellEditor[this.columnNames.length];
        cellEditorArray[0] = new CheckboxCellEditor((Composite)this.m_table);
        TextCellEditor textCellEditor = new TextCellEditor((Composite)this.m_table);
        cellEditorArray[1] = textCellEditor;
        this.m_tableViewer.setCellEditors(cellEditorArray);
        this.m_tableViewer.setCellModifier((ICellModifier)new PropertyTableCellModifier(this));
    }

    public List getColumnNames() {
        return Arrays.asList(this.columnNames);
    }

    public ISelection getSelection() {
        return this.m_tableViewer.getSelection();
    }

    public IPropertyList getPropertyList() {
        return this.m_propertyList;
    }

    public Control getControl() {
        return this.m_table.getParent();
    }

    private void createButtons(Composite composite) {
        Button button = new Button(composite, 0x1000008);
        button.setText(NLSResourceManager.add_custom);
        GridData gridData = new GridData(128);
        gridData.widthHint = 300;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PropertyTableViewer.this.m_propertyList.addProperty();
            }
        });
    }
}

