/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.preference.internal.tableview;

import com.businessobjects.integration.rad.enterprise.preference.NLSResourceManager;
import com.businessobjects.integration.rad.enterprise.preference.internal.tableview.IPropertyList;
import com.businessobjects.integration.rad.enterprise.preference.internal.tableview.IPropertyListViewer;
import com.businessobjects.integration.rad.enterprise.preference.internal.tableview.PropertyRow;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class AbstractPropertyList
implements IPropertyList {
    private List<PropertyRow> m_properties = new ArrayList<PropertyRow>();
    private Set<IPropertyListViewer> m_changeListeners = new HashSet<IPropertyListViewer>();

    protected abstract void initData();

    public AbstractPropertyList() {
        this.initData();
    }

    @Override
    public void addProperty() {
        this.addPropertyHelper(NLSResourceManager.wizard_enterpriseItems_new_item);
    }

    @Override
    public List<PropertyRow> getProperties() {
        return this.m_properties;
    }

    @Override
    public void addProperty(String string) {
        for (int i = 0; i < this.m_properties.size(); ++i) {
            PropertyRow propertyRow = this.m_properties.get(i);
            if (!propertyRow.getDescription().equals(string)) continue;
            propertyRow.setChecked(true);
            return;
        }
        this.addPropertyHelper(string);
    }

    private void addPropertyHelper(String string) {
        PropertyRow propertyRow = new PropertyRow(string);
        propertyRow.setChecked(true);
        this.m_properties.add(propertyRow);
        Iterator<IPropertyListViewer> iterator = this.m_changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().propertyAdded(propertyRow);
        }
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.m_properties.size(); ++i) {
            Iterator<IPropertyListViewer> iterator = this.m_changeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().propertyRemoved(this.m_properties.get(i));
            }
        }
        this.m_properties.clear();
    }

    @Override
    public void propertyChanged(PropertyRow propertyRow) {
        Iterator<IPropertyListViewer> iterator = this.m_changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().propertyChanged(propertyRow);
        }
    }

    @Override
    public void removeChangeListener(IPropertyListViewer iPropertyListViewer) {
        this.m_changeListeners.remove(iPropertyListViewer);
    }

    @Override
    public void addChangeListener(IPropertyListViewer iPropertyListViewer) {
        this.m_changeListeners.add(iPropertyListViewer);
    }
}

