/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.preference;

import com.businessobjects.integration.capabilities.librarycomponents.jsf.enterprise.models.beans.IdentityBean;
import com.businessobjects.integration.capabilities.librarycomponents.jsf.model.spi.IManagedBean;
import com.businessobjects.integration.capabilities.librarycomponents.model.Property;
import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.rad.enterprise.preference.Activator;
import com.businessobjects.integration.rad.enterprise.preference.EnterprisePreferenceCore;
import com.businessobjects.integration.rad.enterprise.preference.NLSResourceManager;
import com.businessobjects.integration.rad.enterprise.preference.internal.DisplayHelpContextAction;
import com.businessobjects.integration.shared.CommonStrings;
import com.businessobjects.integration.shared.ResourceManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class LogonPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Map<String, Widget> m_GUIcontrols = new HashMap<String, Widget>();
    private Composite m_pane;
    private IManagedBean m_identityBean = new IdentityBean();
    private FocusListener listener = new FocusListener(){

        public void focusGained(final FocusEvent focusEvent) {
            UIUtilities.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (focusEvent.widget instanceof Text) {
                        Text text = (Text)focusEvent.widget;
                        int n = text.getCharCount();
                        text.setSelection(0, n);
                    }
                }
            });
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    };

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public void performHelp() {
        Display.getDefault().asyncExec((Runnable)new DisplayHelpContextAction());
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    protected Control createContents(Composite composite) {
        this.m_pane = new Composite(composite, 0);
        IWorkbenchHelpSystem iWorkbenchHelpSystem = UIUtilities.getHelpSystem();
        if (iWorkbenchHelpSystem != null) {
            iWorkbenchHelpSystem.setHelp((Control)this.m_pane, "com.businessobjects.integration.rad.enterprise.preference.docroot");
        }
        this.m_pane.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(34);
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        this.m_pane.setLayoutData((Object)gridData);
        StyledText styledText = new StyledText(this.m_pane, 8);
        String string = NLSResourceManager.taglib_preference_title;
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = string.length();
        styleRange.fontStyle = 1;
        styledText.setText(string);
        styledText.setStyleRange(styleRange);
        styledText.setBackground(Display.getCurrent().getSystemColor(22));
        styledText.setEditable(false);
        styledText.setEnabled(false);
        StyledText styledText2 = new StyledText(this.m_pane, 72);
        String string2 = NLSResourceManager.logon_preference_instruction;
        styledText2.setText(string2);
        styledText2.setBackground(Display.getCurrent().getSystemColor(22));
        styledText2.setEditable(false);
        styledText2.setEnabled(false);
        GridData gridData2 = new GridData(768);
        gridData2.widthHint = 400;
        styledText2.setLayoutData((Object)gridData2);
        Composite composite2 = new Composite(this.m_pane, 131072);
        composite2.setLayout((Layout)new FormLayout());
        GridData gridData3 = new GridData(256);
        gridData3.grabExcessHorizontalSpace = true;
        composite2.setLayoutData((Object)gridData3);
        Label label = new Label(composite2, 0);
        label.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.BOE_LOGON_SYSTEM));
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 10);
        formData.top = new FormAttachment(0, 10);
        label.setLayoutData((Object)formData);
        formData = new Text(composite2, 2048);
        FormData formData2 = new FormData();
        formData2.left = new FormAttachment(25, 10);
        formData2.right = new FormAttachment(100, -10);
        formData2.top = new FormAttachment(0, 10);
        formData.setLayoutData((Object)formData2);
        formData.addFocusListener(this.listener);
        this.m_GUIcontrols.put("system", (Widget)formData);
        formData2 = new Label(composite2, 0);
        formData2.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.BOE_LOGON_USERNAME));
        FormData formData3 = new FormData();
        formData3.left = new FormAttachment(0, 10);
        formData3.top = new FormAttachment((Control)formData, 5);
        formData2.setLayoutData((Object)formData3);
        formData3 = new Text(composite2, 2048);
        formData3.setLayoutData((Object)new GridData(256));
        FormData formData4 = new FormData();
        formData4.left = new FormAttachment(25, 10);
        formData4.right = new FormAttachment(100, -10);
        formData4.top = new FormAttachment((Control)formData, 5);
        formData3.setLayoutData((Object)formData4);
        formData3.addFocusListener(this.listener);
        formData4 = new Label(composite2, 0);
        formData4.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.BOE_LOGON_AUTHENTICATION));
        FormData formData5 = new FormData();
        formData5.left = new FormAttachment(0, 10);
        formData5.top = new FormAttachment((Control)formData3, 5);
        formData4.setLayoutData((Object)formData5);
        formData5 = new Text(composite2, 2048);
        formData5.setLayoutData((Object)new GridData(256));
        FormData formData6 = new FormData();
        formData6.left = new FormAttachment(25, 10);
        formData6.right = new FormAttachment(100, -10);
        formData6.top = new FormAttachment((Control)formData3, 5);
        formData5.setLayoutData((Object)formData6);
        formData5.addFocusListener(this.listener);
        this.m_GUIcontrols.put("selectedAuthentication", (Widget)formData5);
        this.m_GUIcontrols.put("userName", (Widget)formData3);
        this.populateCurrentValue();
        formData6 = UIUtilities.getHelpSystem();
        if (formData6 != null) {
            formData6.setHelp((Control)this.m_pane, "com.businessobjects.integration.rad.enterprise.preference.docroot");
        }
        return this.m_pane;
    }

    private void populateCurrentValue() {
        EnterprisePreferenceCore.populateModelFromPreference(this.m_identityBean);
        Set set = this.m_identityBean.getPropertiesMap().keySet();
        for (String string : set) {
            Property property = (Property)this.m_identityBean.getPropertiesMap().get(string);
            Widget widget = this.m_GUIcontrols.get(string);
            if (!(widget instanceof Text)) continue;
            Text text = (Text)widget;
            text.setText(String.valueOf(property.getCurrentValue()));
        }
    }

    protected void performDefaults() {
        EnterprisePreferenceCore.populateModelFromPreference(this.m_identityBean);
        Set set = this.m_identityBean.getPropertiesMap().keySet();
        for (String string : set) {
            Property property = (Property)this.m_identityBean.getPropertiesMap().get(string);
            Widget widget = this.m_GUIcontrols.get(string);
            if (!(widget instanceof Text)) continue;
            Text text = (Text)widget;
            text.setText(String.valueOf(property.getDefaultValue()));
        }
    }

    public void performApply() {
        Map map = this.m_identityBean.getPropertiesMap();
        Set set = map.keySet();
        for (String string : set) {
            Property property = (Property)map.get(string);
            Widget widget = this.m_GUIcontrols.get(string);
            if (!(widget instanceof Text)) continue;
            Text text = (Text)widget;
            this.getPreferenceStore().setValue(property.getName(), text.getText());
        }
    }
}

