/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.preference;

import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.rad.enterprise.preference.Activator;
import com.businessobjects.integration.rad.enterprise.preference.NLSResourceManager;
import com.businessobjects.integration.rad.enterprise.preference.internal.Constants;
import com.businessobjects.integration.rad.enterprise.preference.internal.DisplayHelpContextAction;
import com.businessobjects.integration.rad.enterprise.preference.internal.tableview.ItemsGridPreferencePropertyList;
import com.businessobjects.integration.rad.enterprise.preference.internal.tableview.PropertyRow;
import com.businessobjects.integration.rad.enterprise.preference.internal.tableview.PropertyTableViewer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class ItemsGridPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private PropertyTableViewer m_table;

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        IWorkbenchHelpSystem iWorkbenchHelpSystem = UIUtilities.getHelpSystem();
        if (iWorkbenchHelpSystem != null) {
            iWorkbenchHelpSystem.setHelp((Control)composite2, "com.businessobjects.integration.rad.enterprise.preference.docroot");
        }
        composite2.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(34);
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        composite2.setLayoutData((Object)gridData);
        StyledText styledText = new StyledText(composite2, 8);
        String string = NLSResourceManager.taglib_preference_title;
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = string.length();
        styleRange.fontStyle = 1;
        styledText.setText(string);
        styledText.setStyleRange(styleRange);
        styledText.setBackground(Display.getCurrent().getSystemColor(22));
        styledText.setEditable(false);
        styledText.setEnabled(false);
        StyledText styledText2 = new StyledText(composite2, 72);
        String string2 = NLSResourceManager.itemsgrid_preference_instruction;
        styledText2.setText(string2);
        styledText2.setBackground(Display.getCurrent().getSystemColor(22));
        styledText2.setEditable(false);
        styledText2.setEnabled(false);
        GridData gridData2 = new GridData(768);
        gridData2.widthHint = 400;
        styledText2.setLayoutData((Object)gridData2);
        Composite composite3 = new Composite(composite2, 131072);
        this.m_table = new PropertyTableViewer(composite3, new ItemsGridPreferencePropertyList());
        IWorkbenchHelpSystem iWorkbenchHelpSystem2 = UIUtilities.getHelpSystem();
        if (iWorkbenchHelpSystem2 != null) {
            iWorkbenchHelpSystem2.setHelp((Control)composite2, "com.businessobjects.integration.rad.enterprise.preference.docroot");
        }
        return composite2;
    }

    protected void performApply() {
        List<PropertyRow> list = this.m_table.getPropertyList().getProperties();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PropertyRow propertyRow : list) {
            if (!propertyRow.isChecked()) continue;
            arrayList.add(propertyRow.getDescription());
        }
        this.setDefault(arrayList.toArray(new String[arrayList.size()]));
    }

    public void performHelp() {
        Display.getDefault().asyncExec((Runnable)new DisplayHelpContextAction());
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    protected void performDefaults() {
        String[] stringArray = Constants.ITEMSGRID_INITIAL_ITEMSCOLUMNS;
        this.m_table.getPropertyList().clear();
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_table.getPropertyList().addProperty(stringArray[i]);
        }
    }

    private void setDefault(String[] stringArray) {
        int n = 0;
        String string = null;
        do {
            if ((string = this.getPreferenceStore().getDefaultString("ITEMSGRID_ITEMSCOLUMN_COLLECTION_PREFIX." + n)) != null && string.length() > 0) {
                this.getPreferenceStore().setValue("ITEMSGRID_ITEMSCOLUMN_COLLECTION_PREFIX." + n, "");
            }
            ++n;
        } while (string != null && string.length() > 0);
        for (n = 0; n < stringArray.length; ++n) {
            this.getPreferenceStore().setValue("ITEMSGRID_ITEMSCOLUMN_COLLECTION_PREFIX." + n, stringArray[n]);
        }
    }
}

