/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.enterprise.objects;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.rad.enterprise.objects.IObjectTypeHandler;
import com.businessobjects.integration.rad.enterprise.objects.ObjectTypesPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ObjectTypeManager {
    private static final String POINT_ID = "com.businessobjects.integration.rad.enterprise.objects.types";
    private static final String SHORTCUT_PREFIX = "shortcut";
    private static final String ICON_PREFIX = "icon";
    private static Map<String, IObjectTypeHandler> idToHandlerMap = new TreeMap<String, IObjectTypeHandler>();
    private static Map<String, String> extensionToIdMap = new TreeMap<String, String>();
    private static List<String> filterableProgIds = new ArrayList<String>();
    private static Map<String, String> progIdToNameMap = new TreeMap<String, String>();
    private static List<String> alwaysPassProgIds = new ArrayList<String>();

    public static IObjectTypeHandler getHandler(String string) {
        return idToHandlerMap.get(string);
    }

    public static String getProgramId(String string) {
        return extensionToIdMap.get(string);
    }

    public static String[] getExtensions(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (extensionToIdMap.containsValue(string)) {
            Set<Map.Entry<String, String>> set = extensionToIdMap.entrySet();
            for (Map.Entry<String, String> entry : set) {
                if (!entry.getValue().equals(string)) continue;
                arrayList.add(entry.getKey());
            }
        }
        Collections.sort(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static Image getIcon(String string) {
        return ObjectTypesPlugin.getDefault().getImageRegistry().get(ICON_PREFIX + string);
    }

    public static Image getShortcutIcon(String string) {
        return ObjectTypesPlugin.getDefault().getImageRegistry().get(SHORTCUT_PREFIX + string);
    }

    public static Set<IObjectTypeHandler> getAllHandlers() {
        return new HashSet<IObjectTypeHandler>(idToHandlerMap.values());
    }

    public static String getNameForProgId(String string) {
        return progIdToNameMap.get(string);
    }

    public static List<String> getFilterableProgIds() {
        return new ArrayList<String>(filterableProgIds);
    }

    public static List<String> getAlwaysPassProgIds() {
        return new ArrayList<String>(alwaysPassProgIds);
    }

    static {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(POINT_ID);
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        Image image = ObjectTypesPlugin.getImage("icons/shortcut.gif");
        for (int i = 0; i < iExtensionArray.length; ++i) {
            if (!iExtensionArray[i].isValid()) continue;
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[i].getConfigurationElements();
            for (int j = 0; j < iConfigurationElementArray.length; ++j) {
                String string;
                String string2 = iConfigurationElementArray[j].getAttribute("progId");
                if (string2 == null) continue;
                String string3 = iConfigurationElementArray[j].getAttribute("name");
                if (string3 != null) {
                    progIdToNameMap.put(string2, string3);
                }
                if (Boolean.valueOf(iConfigurationElementArray[j].getAttribute("isFilterable")).booleanValue()) {
                    filterableProgIds.add(string2);
                }
                if (Boolean.valueOf(iConfigurationElementArray[j].getAttribute("isAlwaysPassFilter")).booleanValue()) {
                    alwaysPassProgIds.add(string2);
                }
                String string4 = iConfigurationElementArray[j].getAttribute("extensions");
                String[] stringArray = null;
                if (string4 != null) {
                    stringArray = string4.split(",");
                }
                if (stringArray != null) {
                    for (int k = 0; k < stringArray.length; ++k) {
                        extensionToIdMap.put(stringArray[k], string2);
                    }
                }
                IObjectTypeHandler iObjectTypeHandler = null;
                if (iConfigurationElementArray[j].getAttribute("actionHandler") != null) {
                    try {
                        iObjectTypeHandler = (IObjectTypeHandler)iConfigurationElementArray[j].createExecutableExtension("actionHandler");
                    }
                    catch (CoreException coreException) {
                        LogManager.getInstance().message(100, "com.businessobjects.integration.rad.enterprise.objects", (Exception)((Object)coreException));
                    }
                }
                if (iObjectTypeHandler != null) {
                    idToHandlerMap.put(string2, iObjectTypeHandler);
                }
                if ((string = iConfigurationElementArray[j].getAttribute(ICON_PREFIX)) == null) continue;
                ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)iExtensionArray[i].getContributor().getName(), (String)string);
                Image image2 = null;
                if (imageDescriptor == null) continue;
                image2 = imageDescriptor.createImage();
                Image image3 = new Image((Device)UIUtilities.getDisplay(), imageDescriptor.getImageData());
                GC gC = new GC((Drawable)image3);
                Rectangle rectangle = image3.getBounds();
                gC.drawImage(image, rectangle.width - image.getImageData().width, rectangle.height - image.getImageData().height);
                ObjectTypesPlugin.getDefault().getImageRegistry().put(ICON_PREFIX + string2, image2);
                ObjectTypesPlugin.getDefault().getImageRegistry().put(SHORTCUT_PREFIX + string2, image3);
                gC.dispose();
            }
        }
        image.dispose();
    }
}

