/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.crviewer.jsps.vct.attrview;

import com.businessobjects.integration.capabilities.librarycomponents.crystalreports.exceptions.ReportLocationException;
import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.rad.crviewer.JSPViewerController;
import com.businessobjects.integration.rad.crviewer.NLSResourceManager;
import com.businessobjects.integration.rad.crviewer.internal.BrowseDialog;
import com.businessobjects.integration.rad.crviewer.internal.BrowseReportFileValidator;
import com.businessobjects.integration.rad.crviewer.internal.BrowseTreeContentProvider;
import com.businessobjects.integration.rad.crviewer.internal.BrowseTreeLabelProvider;
import com.businessobjects.integration.rad.crviewer.internal.InsertViewerUtils;
import com.businessobjects.integration.rad.crviewer.internal.WebSphereViewerLibraryIDEAdaptor;
import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class FileUtil {
    private static JSPViewerController controller = new JSPViewerController();
    private static WebSphereViewerLibraryIDEAdaptor adaptor = new WebSphereViewerLibraryIDEAdaptor();

    public static String importFile(Shell shell) {
        String string = adaptor.getResourceLocation().getAbsolutePath();
        FileDialog fileDialog = new FileDialog(shell);
        fileDialog.setFilterNames(new String[]{"Crystal Reports"});
        fileDialog.setFilterExtensions(new String[]{"*.rpt"});
        fileDialog.setFilterPath(string);
        String string2 = fileDialog.open();
        if (string2 == null) {
            return null;
        }
        try {
            File file = new File(string2);
            String string3 = InsertViewerUtils.getNewReportLocation(file, controller, adaptor);
            if (string3 != null) {
                return string3;
            }
        }
        catch (ReportLocationException reportLocationException) {
            MessageDialog.openError((Shell)shell, (String)NLSResourceManager.warning_dialog_title, (String)reportLocationException.getLocalizedMessage());
        }
        catch (Exception exception) {
            LogManager.getInstance().message(10000, FileUtil.class.getName(), exception);
        }
        return null;
    }

    public static String selectFile(Shell shell) {
        try {
            String string;
            String string2 = controller.getReportDirectoryCanonicalPath(adaptor);
            BrowseDialog browseDialog = new BrowseDialog(shell, (ILabelProvider)new BrowseTreeLabelProvider(), new BrowseTreeContentProvider(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), false));
            browseDialog.setInput(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile());
            File file = new File(string2);
            if (!file.exists()) {
                file.mkdirs();
            }
            browseDialog.setInitialSelection(file);
            browseDialog.setTitle(NLSResourceManager.page1_browse_button_tooltip);
            browseDialog.setMessage(NLSResourceManager.page1_browse_button_tooltip);
            browseDialog.setValidator(new BrowseReportFileValidator());
            browseDialog.setBlockOnOpen(true);
            browseDialog.setAllowMultiple(false);
            browseDialog.open();
            if (browseDialog.getFirstResult() != null && (string = InsertViewerUtils.getNewReportLocation((File)browseDialog.getFirstResult(), controller, adaptor)) != null) {
                return string;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

