/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.crviewer.jsps;

import com.businessobjects.integration.capabilities.librarycomponents.crystalreports.exceptions.ReportLocationException;
import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.rad.crviewer.JSPViewerController;
import com.businessobjects.integration.rad.crviewer.NLSResourceManager;
import com.businessobjects.integration.rad.crviewer.internal.BrowseActionHandler;
import com.businessobjects.integration.rad.crviewer.internal.DisplayHelpContextAction;
import com.businessobjects.integration.rad.crviewer.internal.ImportFileChangeListener;
import com.businessobjects.integration.rad.crviewer.internal.InsertViewerUtils;
import com.businessobjects.integration.rad.crviewer.internal.WebSphereViewerLibraryIDEAdaptor;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.wizards.datatransfer.FileSystemImportWizard;

public class InsertViewerWizardPage1
extends WizardPage
implements Listener,
ModifyListener {
    private boolean m_hasValidatedReportLocation = false;
    private String m_newLocation;
    private WebSphereViewerLibraryIDEAdaptor m_adaptor;
    private Text m_filePathTextBox;
    private Text m_viewerNameTextBox;
    private String m_filePathValue;
    private String m_viewerNameValue;

    public InsertViewerWizardPage1(String string) {
        super(string);
        this.setTitle(NLSResourceManager.page1_title);
        this.setDescription(NLSResourceManager.page1_instructions);
        this.m_adaptor = new WebSphereViewerLibraryIDEAdaptor();
    }

    public String getNewLocation() {
        return this.m_newLocation;
    }

    public String getViewerName() {
        return this.m_viewerNameValue;
    }

    public IWizardPage getNextPage() {
        if (this.isOKtoEndPage1()) {
            return super.getNextPage();
        }
        return this;
    }

    public void performHelp() {
        Display.getDefault().asyncExec((Runnable)new DisplayHelpContextAction());
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public boolean isOKtoEndPage1() {
        if (this.m_hasValidatedReportLocation) {
            return true;
        }
        WebSphereViewerLibraryIDEAdaptor webSphereViewerLibraryIDEAdaptor = new WebSphereViewerLibraryIDEAdaptor();
        JSPViewerController jSPViewerController = new JSPViewerController();
        try {
            File file = new File(this.m_filePathValue);
            String string = InsertViewerUtils.getNewReportLocation(file, jSPViewerController, webSphereViewerLibraryIDEAdaptor);
            if (string != null) {
                this.m_newLocation = string;
                this.m_hasValidatedReportLocation = true;
                return true;
            }
        }
        catch (ReportLocationException reportLocationException) {
            MessageDialog.openError((Shell)UIUtilities.getShell(), (String)NLSResourceManager.warning_dialog_title, (String)reportLocationException.getLocalizedMessage());
        }
        return false;
    }

    public void createControl(final Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        IWorkbenchHelpSystem iWorkbenchHelpSystem = UIUtilities.getHelpSystem();
        if (iWorkbenchHelpSystem != null) {
            iWorkbenchHelpSystem.setHelp((Control)composite2, DisplayHelpContextAction.HELP_CONTEXT_ID);
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(770);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 3;
        composite3.setLayout((Layout)gridLayout2);
        composite3.setLayoutData((Object)new GridData(2));
        Label label = new Label(composite3, 0);
        label.setText(NLSResourceManager.page1_viewer_name_label);
        this.m_viewerNameTextBox = new Text(composite3, 2048);
        GridData gridData2 = new GridData(512);
        gridData2.widthHint = 300;
        gridData2.horizontalSpan = 2;
        this.m_viewerNameTextBox.setLayoutData((Object)gridData2);
        Label label2 = new Label(composite3, 0);
        label2.setText(NLSResourceManager.page1_report_name_label);
        this.m_filePathTextBox = new Text(composite3, 2048);
        GridData gridData3 = new GridData();
        gridData3.widthHint = 175;
        this.m_filePathTextBox.setLayoutData((Object)gridData3);
        Button button = new Button(composite3, 0);
        GridData gridData4 = new GridData(128);
        gridData4.widthHint = 125;
        button.setLayoutData((Object)gridData4);
        button.setText(NLSResourceManager.browse_button_text);
        button.setToolTipText(NLSResourceManager.page1_browse_button_tooltip);
        new Label(composite3, 0);
        new Label(composite3, 0);
        Button button2 = new Button(composite3, 0);
        GridData gridData5 = new GridData(128);
        gridData5.widthHint = 125;
        button2.setLayoutData((Object)gridData5);
        button2.setText(NLSResourceManager.viewer_import_button_text);
        button2.setToolTipText(NLSResourceManager.viewer_import_tooltip);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileSystemImportWizard fileSystemImportWizard = new FileSystemImportWizard();
                fileSystemImportWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection(new Object[0]));
                WizardDialog wizardDialog = new WizardDialog(composite.getShell(), (IWizard)fileSystemImportWizard);
                ImportFileChangeListener importFileChangeListener = new ImportFileChangeListener();
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)importFileChangeListener);
                int n = wizardDialog.open();
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)importFileChangeListener);
                if (n == 0 && importFileChangeListener.getLastFileAdded() != null) {
                    InsertViewerWizardPage1.this.m_filePathTextBox.setText(importFileChangeListener.getLastFileAdded());
                    if (InsertViewerWizardPage1.this.m_viewerNameTextBox != null && InsertViewerWizardPage1.this.m_viewerNameTextBox.getText().trim().length() == 0) {
                        String string = new File(importFileChangeListener.getLastFileAdded()).getName();
                        if (string.endsWith(".rpt")) {
                            string = string.substring(0, string.lastIndexOf(".rpt"));
                        }
                        InsertViewerWizardPage1.this.m_viewerNameTextBox.setText(string);
                    }
                }
            }
        });
        composite2.pack();
        this.setControl((Control)composite2);
        this.setPageComplete(false);
        try {
            JSPViewerController jSPViewerController = new JSPViewerController();
            jSPViewerController.getReportDirectoryCanonicalPath(new WebSphereViewerLibraryIDEAdaptor());
            this.m_viewerNameTextBox.addModifyListener((ModifyListener)this);
            this.m_filePathTextBox.addModifyListener((ModifyListener)this);
            button.addSelectionListener((SelectionListener)new BrowseActionHandler(this.m_viewerNameTextBox, this.m_filePathTextBox));
        }
        catch (ReportLocationException reportLocationException) {
            this.setPageValidationErrorMessage(reportLocationException.getLocalizedMessage());
            this.m_viewerNameTextBox.setEnabled(false);
            this.m_filePathTextBox.setEnabled(false);
            button.setEnabled(false);
        }
    }

    public void handleEvent(Event event) {
        this.getWizard().getContainer().updateButtons();
    }

    private void setPageValidationErrorMessage(String string) {
        if (string == null) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(string);
            this.setPageComplete(false);
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (modifyEvent.widget == this.m_filePathTextBox) {
            this.m_hasValidatedReportLocation = false;
        }
        String string = this.m_filePathTextBox.getText();
        try {
            if (this.m_viewerNameTextBox.getText().trim().length() == 0) {
                this.setPageValidationErrorMessage(NLSResourceManager.errors_insert_viewer_wizard_viewername_not_entered);
                return;
            }
            this.m_viewerNameValue = this.m_viewerNameTextBox.getText();
            if (this.m_filePathTextBox == null || string.trim().length() == 0) {
                this.setPageValidationErrorMessage(NLSResourceManager.errors_insert_viewer_wizard_file_path_not_entered);
            } else {
                IFile iFile;
                if (string.indexOf("*") != -1) {
                    this.setPageValidationErrorMessage(NLSResourceManager.bind((String)NLSResourceManager.errors_new_report_wizard_filename_invalid, (Object[])new String[]{"*"}));
                    return;
                }
                if (string.indexOf("|") != -1) {
                    this.setPageValidationErrorMessage(NLSResourceManager.bind((String)NLSResourceManager.errors_new_report_wizard_filename_invalid, (Object[])new String[]{"|"}));
                    return;
                }
                if (string.indexOf(">") != -1) {
                    this.setPageValidationErrorMessage(NLSResourceManager.bind((String)NLSResourceManager.errors_new_report_wizard_filename_invalid, (Object[])new String[]{">"}));
                    return;
                }
                if (string.indexOf("<") != -1) {
                    this.setPageValidationErrorMessage(NLSResourceManager.bind((String)NLSResourceManager.errors_new_report_wizard_filename_invalid, (Object[])new String[]{"<"}));
                    return;
                }
                if (string.indexOf(":") != -1) {
                    this.setPageValidationErrorMessage(NLSResourceManager.bind((String)NLSResourceManager.errors_new_report_wizard_filename_invalid, (Object[])new String[]{":"}));
                    return;
                }
                if (string.indexOf("\"") != -1) {
                    this.setPageValidationErrorMessage(NLSResourceManager.bind((String)NLSResourceManager.errors_new_report_wizard_filename_invalid, (Object[])new String[]{"\""}));
                    return;
                }
                Path path = new Path(string);
                if (!path.isAbsolute()) {
                    iFile = this.m_adaptor.getActiveFile().getParent().getFile((IPath)path);
                    if (iFile == null) {
                        this.setPageValidationErrorMessage(NLSResourceManager.bind((String)NLSResourceManager.errors_insert_viewer_wizard_file_not_exist, (Object[])new String[]{string}));
                        return;
                    }
                    path = iFile.getFullPath().makeAbsolute();
                }
                iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                File file = iFile.getLocation().toFile();
                if (iFile == null || !file.exists()) {
                    this.setPageValidationErrorMessage(NLSResourceManager.bind((String)NLSResourceManager.errors_insert_viewer_wizard_file_not_exist, (Object[])new String[]{string}));
                    return;
                }
                if (!file.isFile() || !file.getName().endsWith(".rpt")) {
                    this.setPageValidationErrorMessage(NLSResourceManager.errors_browse_not_report_file);
                    return;
                }
                this.m_filePathValue = iFile.getLocation().toOSString();
                this.setPageValidationErrorMessage(null);
            }
        }
        catch (Exception exception) {
            this.setPageValidationErrorMessage(NLSResourceManager.bind((String)NLSResourceManager.errors_insert_viewer_wizard_file_not_exist, (Object[])new String[]{string}));
            return;
        }
    }
}

