/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.crviewer.internal;

import com.businessobjects.integration.capabilities.librarycomponents.crystalreports.exceptions.ReportLocationException;
import com.businessobjects.integration.rad.crviewer.JSPViewerController;
import com.businessobjects.integration.rad.crviewer.NLSResourceManager;
import com.businessobjects.integration.rad.crviewer.internal.BrowseDialog;
import com.businessobjects.integration.rad.crviewer.internal.BrowseReportFileValidator;
import com.businessobjects.integration.rad.crviewer.internal.BrowseTreeContentProvider;
import com.businessobjects.integration.rad.crviewer.internal.BrowseTreeLabelProvider;
import com.businessobjects.integration.rad.crviewer.internal.InsertViewerUtils;
import com.businessobjects.integration.rad.crviewer.internal.WebSphereViewerLibraryIDEAdaptor;
import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PropertyReportBrowseActionHandler
extends SelectionAdapter {
    private Text m_filePathTextField;

    public PropertyReportBrowseActionHandler(Text text) {
        this.m_filePathTextField = text;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        Object object = selectionEvent.getSource();
        if (object instanceof Button) {
            Button button = (Button)object;
            WebSphereViewerLibraryIDEAdaptor webSphereViewerLibraryIDEAdaptor = new WebSphereViewerLibraryIDEAdaptor();
            JSPViewerController jSPViewerController = new JSPViewerController();
            try {
                String string = jSPViewerController.getReportDirectoryCanonicalPath(webSphereViewerLibraryIDEAdaptor);
                BrowseDialog browseDialog = new BrowseDialog(button.getShell(), (ILabelProvider)new BrowseTreeLabelProvider(), new BrowseTreeContentProvider(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), false));
                browseDialog.setInput(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile());
                File file = new File(string + File.separator + this.m_filePathTextField.getText());
                if (!file.exists() && !(file = new File(string)).exists()) {
                    file.mkdirs();
                }
                browseDialog.setInitialSelection(file);
                browseDialog.setTitle(NLSResourceManager.page1_browse_button_tooltip);
                browseDialog.setMessage(NLSResourceManager.page1_browse_button_tooltip);
                browseDialog.setValidator(new BrowseReportFileValidator());
                browseDialog.setBlockOnOpen(true);
                browseDialog.setAllowMultiple(false);
                browseDialog.open();
                if (browseDialog.getResult() != null) {
                    File file2;
                    String string2;
                    String string3 = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(browseDialog.getResult()[0] + "")).getLocation().toOSString();
                    if (this.m_filePathTextField != null && string3 != null && (string2 = InsertViewerUtils.getNewReportLocation(file2 = new File(string3), jSPViewerController, webSphereViewerLibraryIDEAdaptor)) != null) {
                        this.m_filePathTextField.setText(string2);
                    }
                }
            }
            catch (ReportLocationException reportLocationException) {
                MessageDialog.openError((Shell)button.getShell(), (String)NLSResourceManager.warning_dialog_title, (String)reportLocationException.getLocalizedMessage());
            }
        }
    }
}

