/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.crviewer.internal;

import com.businessobjects.integration.capabilities.librarycomponents.crystalreports.exceptions.ReportLocationException;
import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.eclipse.web.properties.PropertiesPlugin;
import com.businessobjects.integration.rad.crviewer.CrystalReportsViewerPlugin;
import com.businessobjects.integration.rad.crviewer.JSPViewerController;
import com.businessobjects.integration.rad.crviewer.NLSResourceManager;
import com.businessobjects.integration.rad.crviewer.internal.MoveReportDialogUserResponse;
import com.businessobjects.integration.rad.crviewer.internal.ReportNotInSpecifiedLocationDialog;
import com.businessobjects.integration.rad.crviewer.internal.WebSphereViewerLibraryIDEAdaptor;
import com.ibm.etools.webedit.common.commands.utils.HeadElementModifier;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import com.ibm.etools.webedit.common.utils.EncodingUtil;
import com.ibm.etools.webedit.utils.FindNodeUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocumentType;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InsertViewerUtils {
    private static final int UNIQUE_NAME_START_COUNTER = 2;
    private static final String FACET_ID = "com.businessobjects.sdks.jrc";
    private static final String ENTERPRISE_FACET_ID = "com.businessobjects.integration.eclipse.enterprise.facet";
    protected static final String TAGLIB_DIRECTIVE_ELEMENT_NAME = "jsp:directive.taglib";
    private static final String HTML = "HTML";
    private static final String DTD_PUBLIC_ID = "-//W3C//DTD HTML 4.01 Transitional//EN";
    private static final String DTD_SYSTEM_ID = null;

    private InsertViewerUtils() {
    }

    public static void setDocType() {
        IDOMDocument iDOMDocument;
        IDOMModel iDOMModel;
        HTMLEditDomain hTMLEditDomain = ActionUtil.getActiveHTMLEditDomain();
        if (hTMLEditDomain != null && (iDOMModel = hTMLEditDomain.getActiveModel()) != null && (iDOMDocument = iDOMModel.getDocument()) != null) {
            InsertViewerUtils.setDocType(iDOMDocument);
        }
    }

    public static void setDocType(IDOMDocument iDOMDocument) {
        DocumentType documentType = iDOMDocument.getDoctype();
        if (documentType != null) {
            InsertViewerUtils.updateDoctype(documentType);
        } else {
            DocumentType documentType2 = InsertViewerUtils.createDoctype((Document)iDOMDocument);
            if (documentType2 != null) {
                InsertViewerUtils.insertDoctype(documentType2, (Document)iDOMDocument);
            }
        }
    }

    private static void updateDoctype(DocumentType documentType) {
        if (documentType instanceof IDOMDocumentType) {
            IDOMDocumentType iDOMDocumentType = (IDOMDocumentType)documentType;
            if (iDOMDocumentType != null && HTML.equals(iDOMDocumentType.getName())) {
                ILog iLog;
                if (!DTD_PUBLIC_ID.equals(iDOMDocumentType.getPublicId())) {
                    try {
                        iDOMDocumentType.setPublicId(DTD_PUBLIC_ID);
                    }
                    catch (DOMException dOMException) {
                        iLog = CrystalReportsViewerPlugin.getDefault().getLog();
                        iLog.log((IStatus)new Status(2, CrystalReportsViewerPlugin.PLUGIN_ID, 2, "Cannot set DTD declaration to -//W3C//DTD HTML 4.01 Transitional//EN", null));
                    }
                }
                if (iDOMDocumentType.getSystemId() != null) {
                    try {
                        iDOMDocumentType.setSystemId(DTD_SYSTEM_ID);
                    }
                    catch (DOMException dOMException) {
                        iLog = CrystalReportsViewerPlugin.getDefault().getLog();
                        iLog.log((IStatus)new Status(2, CrystalReportsViewerPlugin.PLUGIN_ID, 2, "Cannot set DTD declaration to -//W3C//DTD HTML 4.01 Transitional//EN", null));
                    }
                }
            } else {
                Document document = documentType.getOwnerDocument();
                if (document != null) {
                    DocumentType documentType2 = InsertViewerUtils.createDoctype(document);
                    document.insertBefore(documentType2, documentType);
                    document.removeChild(documentType);
                }
            }
        }
    }

    private static DocumentType createDoctype(Document document) {
        IDOMDocumentType iDOMDocumentType = null;
        if (document instanceof DocumentImpl) {
            IDOMDocument iDOMDocument = (IDOMDocument)document;
            IDOMDocumentType iDOMDocumentType2 = (IDOMDocumentType)iDOMDocument.createDoctype(HTML);
            iDOMDocumentType2.setPublicId(DTD_PUBLIC_ID);
            iDOMDocumentType2.setSystemId(DTD_SYSTEM_ID);
            iDOMDocumentType = iDOMDocumentType2;
        }
        return iDOMDocumentType;
    }

    private static void insertDoctype(DocumentType documentType, Document document) {
        Node node = null;
        NodeList nodeList = document.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 7 || node2.getNodeType() == 8) continue;
            node = node2;
            break;
        }
        document.insertBefore(documentType, node);
    }

    public static String getRelativePath(String string, String string2) {
        if (string.startsWith(string2 + File.separator)) {
            return string.substring(string2.length()).replace(File.separatorChar, '/');
        }
        return string;
    }

    private static String relocateReport(File file, JSPViewerController jSPViewerController, WebSphereViewerLibraryIDEAdaptor webSphereViewerLibraryIDEAdaptor, MoveReportDialogUserResponse moveReportDialogUserResponse, String string) throws ReportLocationException {
        File file2 = new File(jSPViewerController.getReportDirectoryCanonicalPath(webSphereViewerLibraryIDEAdaptor) + "/" + moveReportDialogUserResponse.getNewLocation(), string);
        if (file2.exists()) {
            boolean bl = !InsertViewerUtils.isFileReadOnly(file2);
            String[] stringArray = bl ? new String[]{NLSResourceManager.warning_report_exists_in_new_location_overwrite, NLSResourceManager.warning_report_exists_in_new_location_rename, NLSResourceManager.warning_report_exists_in_new_location_cancel} : new String[]{NLSResourceManager.warning_report_exists_in_new_location_rename, NLSResourceManager.warning_report_exists_in_new_location_cancel};
            MessageDialog messageDialog = new MessageDialog(UIUtilities.getShell(), NLSResourceManager.warning_report_exists_in_new_location_title, null, NLSResourceManager.warning_report_exists_in_new_location_message, 4, stringArray, 0);
            int n = messageDialog.open();
            if (n == 0 && bl) {
                return InsertViewerUtils.copyReportToSpecifiedLocation(file, string, jSPViewerController, webSphereViewerLibraryIDEAdaptor, moveReportDialogUserResponse);
            }
            if (n == 0 && !bl || n == 1 && bl) {
                InputDialog inputDialog = new InputDialog(UIUtilities.getShell(), NLSResourceManager.warning_report_exists_in_new_location_new_name_title, NLSResourceManager.warning_report_exists_in_new_location_new_name_message, file.getName(), null);
                if (inputDialog.open() == 0) {
                    String string2 = inputDialog.getValue();
                    return InsertViewerUtils.relocateReport(file, jSPViewerController, webSphereViewerLibraryIDEAdaptor, moveReportDialogUserResponse, string2);
                }
                return null;
            }
            return null;
        }
        return InsertViewerUtils.copyReportToSpecifiedLocation(file, string, jSPViewerController, webSphereViewerLibraryIDEAdaptor, moveReportDialogUserResponse);
    }

    public static String getNewReportLocation(File file, JSPViewerController jSPViewerController, WebSphereViewerLibraryIDEAdaptor webSphereViewerLibraryIDEAdaptor) throws ReportLocationException {
        InsertViewerUtils.ensureReportDirectoryExists(jSPViewerController, webSphereViewerLibraryIDEAdaptor);
        try {
            if (!jSPViewerController.isReportInConfigLocation(file, webSphereViewerLibraryIDEAdaptor)) {
                MoveReportDialogUserResponse moveReportDialogUserResponse = InsertViewerUtils.askAboutMovingReport(file, jSPViewerController, webSphereViewerLibraryIDEAdaptor);
                if (moveReportDialogUserResponse.isConfirmed()) {
                    return InsertViewerUtils.relocateReport(file, jSPViewerController, webSphereViewerLibraryIDEAdaptor, moveReportDialogUserResponse, file.getName());
                }
                return null;
            }
            try {
                return InsertViewerUtils.getRelativePath(file.getCanonicalPath(), jSPViewerController.getReportDirectoryCanonicalPath(webSphereViewerLibraryIDEAdaptor));
            }
            catch (IOException iOException) {
                throw new ReportLocationException(iOException.getLocalizedMessage());
            }
        }
        catch (ReportLocationException reportLocationException) {
            throw new ReportLocationException(reportLocationException.getLocalizedMessage());
        }
    }

    private static void ensureReportDirectoryExists(JSPViewerController jSPViewerController, WebSphereViewerLibraryIDEAdaptor webSphereViewerLibraryIDEAdaptor) throws ReportLocationException {
        String string = jSPViewerController.getReportDirectoryCanonicalPath(webSphereViewerLibraryIDEAdaptor);
        File file = new File(string);
        if (!file.exists()) {
            if (!file.mkdirs()) {
                throw new ReportLocationException(NLSResourceManager.report_location_retrieval_error);
            }
            IContainer iContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(string));
            try {
                if (iContainer != null) {
                    iContainer.refreshLocal(1, null);
                }
            }
            catch (CoreException coreException) {
                LogManager.getInstance().message(10000, InsertViewerUtils.class.getName(), (Exception)((Object)coreException));
            }
        } else if (!file.isDirectory()) {
            throw new ReportLocationException(NLSResourceManager.report_location_retrieval_error);
        }
    }

    private static String copyReportToSpecifiedLocation(File file, String string, JSPViewerController jSPViewerController, WebSphereViewerLibraryIDEAdaptor webSphereViewerLibraryIDEAdaptor, MoveReportDialogUserResponse moveReportDialogUserResponse) throws ReportLocationException {
        IContainer iContainer;
        String string2 = null;
        try {
            string2 = string == null ? jSPViewerController.copyReportFile(file.getAbsolutePath(), moveReportDialogUserResponse.getNewLocation(), moveReportDialogUserResponse.isMove(), webSphereViewerLibraryIDEAdaptor, true) : jSPViewerController.copyReportFile(file.getAbsolutePath(), moveReportDialogUserResponse.getNewLocation(), string, moveReportDialogUserResponse.isMove(), webSphereViewerLibraryIDEAdaptor, true);
        }
        catch (IOException iOException) {
            throw new ReportLocationException((Throwable)iOException);
        }
        if (moveReportDialogUserResponse.isMove() && file.exists()) {
            MessageDialog.openWarning((Shell)UIUtilities.getShell(), (String)NLSResourceManager.err_file_cannot_be_moved_title, (String)NLS.bind((String)NLSResourceManager.err_file_cannot_be_moved_message, (Object)file.getAbsolutePath()));
        }
        String string3 = jSPViewerController.getReportDirectoryCanonicalPath(webSphereViewerLibraryIDEAdaptor) + "/" + moveReportDialogUserResponse.getNewLocation();
        IContainer iContainer2 = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(string3));
        if (iContainer2 != null) {
            try {
                iContainer2.refreshLocal(1, null);
            }
            catch (CoreException coreException) {
                LogManager.getInstance().message(100, CrystalReportsViewerPlugin.PLUGIN_ID, (Exception)((Object)coreException));
            }
        }
        if (moveReportDialogUserResponse.isMove() && (iContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(file.getParentFile().getAbsolutePath()))) != null) {
            try {
                iContainer.refreshLocal(1, null);
            }
            catch (Exception exception) {
                LogManager.getInstance().message(100, CrystalReportsViewerPlugin.PLUGIN_ID, exception);
            }
        }
        return string2;
    }

    private static MoveReportDialogUserResponse askAboutMovingReport(File file, JSPViewerController jSPViewerController, WebSphereViewerLibraryIDEAdaptor webSphereViewerLibraryIDEAdaptor) throws ReportLocationException {
        String string = jSPViewerController.getReportDirectoryCanonicalPath(webSphereViewerLibraryIDEAdaptor);
        File file2 = new File(string);
        ReportNotInSpecifiedLocationDialog reportNotInSpecifiedLocationDialog = new ReportNotInSpecifiedLocationDialog(UIUtilities.getShell(), file2, InsertViewerUtils.isFileReadOnly(file));
        reportNotInSpecifiedLocationDialog.create();
        reportNotInSpecifiedLocationDialog.setBlockOnOpen(true);
        int n = reportNotInSpecifiedLocationDialog.open();
        return new MoveReportDialogUserResponse(n == 0, reportNotInSpecifiedLocationDialog.getNewLocation(), reportNotInSpecifiedLocationDialog.isMove());
    }

    public static String getUniqueViewerName(String string, IDOMDocument iDOMDocument, WebSphereViewerLibraryIDEAdaptor webSphereViewerLibraryIDEAdaptor) {
        int n;
        String string2 = InsertViewerUtils.getTaglibPrefix(webSphereViewerLibraryIDEAdaptor);
        if (string2 == null) {
            return null;
        }
        NodeList nodeList = iDOMDocument.getDocumentElement().getElementsByTagName(string2 + ":viewer");
        int n2 = nodeList.getLength();
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (n = 0; n < n2; ++n) {
            Element element = (Element)nodeList.item(n);
            arrayList.add(element.getAttribute("viewerName"));
        }
        if (!arrayList.contains(string)) {
            return string;
        }
        n = 2;
        for (int i = 0; i < n2 + 1; ++i) {
            if (!arrayList.contains(string + n)) {
                return string + n;
            }
            ++n;
        }
        return null;
    }

    public static boolean checkAndPromptCrystalLibraryInstall(WebSphereViewerLibraryIDEAdaptor webSphereViewerLibraryIDEAdaptor) {
        block8: {
            IProject iProject = webSphereViewerLibraryIDEAdaptor.getProject();
            try {
                String string;
                IFacetedProject iFacetedProject = ProjectFacetsManager.create((IProject)iProject);
                for (IProjectFacetVersion iProjectFacetVersion : iFacetedProject.getProjectFacets()) {
                    string = iProjectFacetVersion.getProjectFacet().getId();
                    if (FACET_ID.equals(string)) {
                        return true;
                    }
                    if (!ENTERPRISE_FACET_ID.equals(string)) continue;
                    UIUtilities.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)UIUtilities.getShell(), (String)NLSResourceManager.err_enterprise_facet_installed_title, (String)NLSResourceManager.err_enterprise_facet_installed_message);
                        }
                    });
                    return false;
                }
                boolean bl = MessageDialog.openConfirm((Shell)UIUtilities.getShell(), (String)NLSResourceManager.taglib_need_import_title, (String)NLSResourceManager.taglib_need_import_message);
                if (!bl) {
                    return false;
                }
                string = ProjectFacetsManager.getProjectFacet((String)FACET_ID);
                if (string == null) break block8;
                String string2 = PropertiesPlugin.getDefaultVersion();
                IProjectFacetVersion iProjectFacetVersion = null;
                try {
                    iProjectFacetVersion = string.getVersion(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LogManager.getInstance().message(100, CrystalReportsViewerPlugin.PLUGIN_ID, (Exception)illegalArgumentException);
                }
                if (iProjectFacetVersion != null) {
                    IDataModel iDataModel = (IDataModel)iProjectFacetVersion.createActionConfig(IFacetedProject.Action.Type.VERSION_CHANGE, iProject.getName());
                    iDataModel.setStringProperty("IFacetDataModelProperties.FACET_ID", string.getId());
                    iDataModel.setStringProperty("IFacetDataModelProperties.FACET_VERSION_STR", string2);
                    iDataModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)iProjectFacetVersion);
                    iFacetedProject.installProjectFacet(iProjectFacetVersion, (Object)iDataModel, null);
                    break block8;
                }
                MessageDialog.openError((Shell)UIUtilities.getShell(), (String)NLSResourceManager.version_not_valid_title, (String)NLSResourceManager.version_not_valid_message);
                return false;
            }
            catch (CoreException coreException) {
                LogManager.getInstance().message(10000, CrystalReportsViewerPlugin.PLUGIN_ID, (Exception)((Object)coreException));
                return false;
            }
        }
        return true;
    }

    private static IDOMDocument getActiveHTMLDocument(WebSphereViewerLibraryIDEAdaptor webSphereViewerLibraryIDEAdaptor) {
        if (webSphereViewerLibraryIDEAdaptor.getActiveHTMLEditDomain() != null && webSphereViewerLibraryIDEAdaptor.getActiveHTMLEditDomain().getModel() != null && webSphereViewerLibraryIDEAdaptor.getActiveHTMLEditDomain().getModel().getDocument() != null) {
            return webSphereViewerLibraryIDEAdaptor.getActiveHTMLEditDomain().getModel().getDocument();
        }
        return null;
    }

    public static String getTaglibPrefix(WebSphereViewerLibraryIDEAdaptor webSphereViewerLibraryIDEAdaptor) {
        NodeList nodeList;
        IDOMDocument iDOMDocument = InsertViewerUtils.getActiveHTMLDocument(webSphereViewerLibraryIDEAdaptor);
        if (iDOMDocument != null && (nodeList = iDOMDocument.getElementsByTagName(TAGLIB_DIRECTIVE_ELEMENT_NAME)) != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!(nodeList.item(i) instanceof Element)) continue;
                Attr attr = ((Element)nodeList.item(i)).getAttributeNode("uri");
                Attr attr2 = ((Element)nodeList.item(i)).getAttributeNode("prefix");
                if (attr == null || attr2 == null) continue;
                String string = attr.getValue();
                String string2 = attr2.getValue();
                if (!"/crystal-tags-reportviewer.tld".equals(string)) continue;
                return string2;
            }
        }
        return null;
    }

    private static boolean isFileReadOnly(File file) {
        return !file.canWrite();
    }

    public static final void setEncoding(String string) {
        if (ActionUtil.getActiveHTMLEditDomain() == null || ActionUtil.getActiveHTMLEditDomain().getActiveModel() == null || ActionUtil.getActiveHTMLEditDomain().getActiveModel().getDocument() == null) {
            return;
        }
        NodeList nodeList = InsertViewerUtils.getEncodingNodes((Document)ActionUtil.getActiveHTMLEditDomain().getActiveModel().getDocument());
        boolean bl = false;
        int n = nodeList != null ? nodeList.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            ILog iLog;
            Element element;
            Node node = nodeList.item(i);
            if (EncodingUtil.hasXmlEncoding((Node)node)) {
                if (!InsertViewerUtils.setXmlEncoding(node, string)) continue;
                bl = true;
                continue;
            }
            if (EncodingUtil.isMetaContentType((Node)node)) {
                element = (Element)node;
                try {
                    if (!"text/html;charset=UTF-8".equals(element.getAttribute("content"))) {
                        element.setAttribute("content", "text/html;charset=UTF-8");
                    }
                }
                catch (DOMException dOMException) {
                    iLog = CrystalReportsViewerPlugin.getDefault().getLog();
                    iLog.log((IStatus)new Status(2, CrystalReportsViewerPlugin.PLUGIN_ID, 2, "Cannot set page encoding to UTF-8: META tag.", null));
                }
                bl = true;
                continue;
            }
            if (!EncodingUtil.isJSPPageDirective((Node)node)) continue;
            element = (Element)node;
            try {
                if (!"text/html;charset=UTF-8".equals(element.getAttribute("contentType"))) {
                    element.setAttribute("contentType", "text/html;charset=UTF-8");
                }
            }
            catch (DOMException dOMException) {
                iLog = CrystalReportsViewerPlugin.getDefault().getLog();
                iLog.log((IStatus)new Status(2, CrystalReportsViewerPlugin.PLUGIN_ID, 2, "Cannot set page encoding to UTF-8: page directive.", null));
            }
            bl = true;
        }
        if (!bl) {
            InsertViewerUtils.addMetaEncoding(string);
        }
    }

    private static final boolean setXmlEncoding(Node node, String string) {
        String string2;
        String string3 = EncodingUtil.getXmlEncoding((Node)node);
        String string4 = null;
        if (string3 != null) {
            string4 = node.getNodeValue();
        }
        if (string4 != null && (string2 = EncodingUtil.replaceXMLEncoding((String)string4, (String)string)) != null && !string2.equalsIgnoreCase(string4)) {
            try {
                node.setNodeValue(string2);
            }
            catch (DOMException dOMException) {
                ILog iLog = CrystalReportsViewerPlugin.getDefault().getLog();
                iLog.log((IStatus)new Status(2, CrystalReportsViewerPlugin.PLUGIN_ID, 2, "Cannot set page encoding to UTF-8.", null));
            }
            return true;
        }
        return false;
    }

    private static final boolean addMetaEncoding(String string) {
        IDOMDocument iDOMDocument = ActionUtil.getActiveHTMLEditDomain().getActiveModel().getDocument();
        if (iDOMDocument == null) {
            return false;
        }
        HeadElementModifier headElementModifier = new HeadElementModifier();
        String string2 = "charset=" + string;
        HeadElementModifier.MetaEquivFilter metaEquivFilter = headElementModifier.getMetaEquivFilter((Document)iDOMDocument, "Content-Type", string2);
        if (metaEquivFilter == null) {
            return false;
        }
        return metaEquivFilter.addElement() != null;
    }

    private static final NodeList getEncodingNodes(Document document) {
        class NodeTester
        implements FindNodeUtil.Tester {
            NodeTester() {
            }

            public boolean isTarget(Node node) {
                if (node != null) {
                    if (node.getNodeType() == 1) {
                        return EncodingUtil.isJSPPageDirective((Node)node) || EncodingUtil.isMetaContentType((Node)node);
                    }
                    if (node.getNodeType() == 7) {
                        return EncodingUtil.hasXmlEncoding((Node)node);
                    }
                }
                return false;
            }

            public boolean isEnd(Node node) {
                return false;
            }
        }
        return FindNodeUtil.findDescendant((Node)document, (FindNodeUtil.Tester)new NodeTester());
    }
}

